/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.DefaultInventoryRepositoryFolderNode;
import com.sas.wadmin.model.tree.DefaultNodeFactory;
import com.sas.wadmin.model.tree.InventoryFolderNode;
import com.sas.wadmin.model.tree.InventoryLogicalObjectsFolderNode;
import com.sas.wadmin.model.tree.InventoryMetadataObjectsFolderNode;
import com.sas.wadmin.model.tree.InventoryNodeFactory;
import com.sas.wadmin.model.tree.LibrariesInventoryFolderNode;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;

public class DefaultInventoryNodeFactory
extends DefaultNodeFactory
implements InventoryNodeFactory {
    public DefaultInventoryNodeFactory() {
        this.setCreateTypeNodes(true);
    }

    @Override
    public WsTreeNode createRepositoryFolderNode(Root mdo, WsTreeNode nodeParent) {
        return new DefaultInventoryRepositoryFolderNode(mdo);
    }

    @Override
    public WsTreeNode createInventoryNode(TypeInterface type, String sRepositoryFQID) {
        if (type.getMetadataType().equals("SASLibrary")) {
            return new LibrariesInventoryFolderNode(type, sRepositoryFQID);
        }
        return new InventoryLogicalObjectsFolderNode(type, sRepositoryFQID);
    }

    @Override
    public WsTreeNode createInventoryNode(String sName, String sType, String sRepositoryFQID) {
        InventoryMetadataObjectsFolderNode node = new InventoryMetadataObjectsFolderNode(sName, sType, sRepositoryFQID);
        if (sType.equals("OLAPSchema")) {
            node.setAllowsGrandChildren(true);
        }
        return node;
    }

    @Override
    public WsTreeNode createObjectNode(LogicalObjectInterface lobData, WsTreeNode nodeParent) throws MdException, RemoteException {
        WsTreeNode node = super.createObjectNode(lobData, nodeParent);
        if (nodeParent instanceof InventoryFolderNode) {
            node.setAllowsChildren(((InventoryFolderNode)nodeParent).allowsGrandChildren());
        }
        return node;
    }

    @Override
    public WsTreeNode createObjectNode(Root mdo, WsTreeNode nodeParent) throws MdException, RemoteException {
        WsTreeNode node = super.createObjectNode(mdo, nodeParent);
        if (nodeParent instanceof InventoryFolderNode) {
            node.setAllowsChildren(((InventoryFolderNode)nodeParent).allowsGrandChildren());
        }
        return node;
    }
}

