/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.model.tree.DefaultLogicalObjectNode;
import com.sas.wadmin.model.tree.FolderNode;
import com.sas.wadmin.model.tree.ViewFactory;
import com.sas.wadmin.visuals.FolderPropertiesView;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import com.sas.workspace.tree.WsTreeModel;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class DefaultFolderNode
extends DefaultLogicalObjectNode
implements FolderNode {
    private static WAdminResource bundle = new WAdminResource(DefaultFolderNode.class);
    private FolderInterface m_lobFolder;

    public DefaultFolderNode(FolderInterface lob, Root mdoTree) {
        super((LogicalObjectInterface)lob, mdoTree);
        this.m_lobFolder = lob;
        this.setDropTarget(true);
    }

    @Override
    public FolderInterface getFolder() {
        return this.m_lobFolder;
    }

    public Icon getIcon(boolean bExpanded) {
        return this.getLogicalObject().getIcon();
    }

    public void doDefaultAction() {
    }

    @Override
    public boolean isDeleteable() {
        return super.isDeleteable();
    }

    public boolean isReallyDeleteable() {
        this.expand();
        if (this.getChildCount() == 0) {
            return true;
        }
        String sMessage = bundle.formatString("DefaultFolderNode.Warning.CanNotDeleteNonEmptyFolder.fmt.txt", (Object)this.getName());
        MessageUtil.displayMessage((String)sMessage, (int)2);
        return false;
    }

    @Override
    public void delete(OperationUserInteractionInterface op) {
        super.delete(op);
    }

    @Override
    public boolean isCheckOutable() {
        return super.isCheckOutable() && !this.m_lobFolder.isContentMapped();
    }

    public boolean isDragSource() {
        return super.isDragSource() && !this.m_lobFolder.isContentMapped() && !this.m_lobFolder.isTopLevel();
    }

    public boolean isDropTarget(DropTargetDragEvent ev) {
        if (!super.isDropTarget()) {
            return false;
        }
        List lDraggedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors());
        if (lDraggedObjects == null) {
            return false;
        }
        return this.validateDraggedObjects(lDraggedObjects);
    }

    public boolean isDropTarget(DropTargetDropEvent e) {
        if (!super.isDropTarget()) {
            return false;
        }
        List lDraggedObjects = this.getDraggedObjects(e.getCurrentDataFlavors());
        if (lDraggedObjects == null) {
            return false;
        }
        return this.validateDraggedObjects(lDraggedObjects);
    }

    private List getDraggedObjects(DataFlavor[] aFlavors) {
        for (int iFlavor = 0; iFlavor < aFlavors.length; ++iFlavor) {
            if (!(aFlavors[iFlavor] instanceof DNDObject.DNDObjectFlavor)) continue;
            return ((DNDObject.DNDObjectFlavor)aFlavors[iFlavor]).getData().getObjects();
        }
        return null;
    }

    private boolean validateDraggedObjects(List lObjects) {
        try {
            String sRepository = this.getFQID().substring(0, 8);
            int nObjects = lObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                String sMessage;
                Object obj = lObjects.get(iObject);
                if (!(obj instanceof Root)) {
                    String sMessage2 = bundle.getString("DefaultFolderNode.NonMetadataObjectsMessage.txt");
                    Workspace.getWorkspace().setStatusText(sMessage2);
                    return false;
                }
                Root mdoData = (Root)obj;
                String sFQID = mdoData.getFQID();
                if (!mdoData.getRepositoryID().equals(sRepository)) {
                    sMessage = bundle.getString("DefaultFolderNode.CrossRepositoriesMessage.txt");
                    Workspace.getWorkspace().setStatusText(sMessage);
                    return false;
                }
                if (sFQID.equals(this.getFQID())) {
                    sMessage = bundle.getString("DefaultFolderNode.DropOnSelf.txt");
                    Workspace.getWorkspace().setStatusText(sMessage);
                    return false;
                }
                if (!mdoData.getCMetadataType().equals("Tree")) continue;
                if (this.m_lobFolder.isContentMapped()) {
                    sMessage = bundle.getString("DefaultFolderNode.MoveFolderIntoContentMappedFolder.txt");
                    Workspace.getWorkspace().setStatusText(sMessage);
                    return false;
                }
                for (WsTreeNode nodeParent = (WsTreeNode)this.getParent(); nodeParent != null; nodeParent = (WsTreeNode)nodeParent.getParent()) {
                    String sParentFQID = nodeParent.getFQID();
                    if (!sFQID.equals(sParentFQID)) continue;
                    String sMessage3 = bundle.getString("DefaultFolderNode.DropOnChild.txt");
                    Workspace.getWorkspace().setStatusText(sMessage3);
                    return false;
                }
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent ev) {
        block8: {
            try {
                List lDragObjects = this.getDraggedObjects(ev.getCurrentDataFlavors());
                int nDragObjects = lDragObjects.size();
                if (nDragObjects < 0) break block8;
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "DefaultFolderNode:drop");
                try {
                    Tree mdoFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.getName(), this.getType(), this.getFQID());
                    for (int iDragObject = 0; iDragObject < nDragObjects; ++iDragObject) {
                        Root mdoSimple = (Root)lDragObjects.get(iDragObject);
                        Root mdoDrag = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)mdoSimple);
                        CustomTreeModel.moveToFolder(mdoFolder, mdoDrag);
                    }
                    store.updatedMetadataAll();
                    ev.dropComplete(true);
                }
                catch (MdException ex) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                finally {
                    store.dispose();
                    Workspace.getWorkspace().setCursor(null);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildren() {
        WsTreeModel model = this.getTreeModel();
        WsNodeFilter filter = model.getNodeFilter();
        WsNodeFactory factory = model.getNodeFactory();
        Tree mdoTree = (Tree)model.acquireComplexObject((Root)this.getMetadata());
        try {
            ArrayList<String> lAssociations = new ArrayList<String>();
            lAssociations.add("Members");
            lAssociations.add("SubTrees");
            lAssociations.add("ParentTree");
            String sTemplate = "<Templates><Tree><ParentTree/></Tree></Templates>";
            int fFlags = 524556;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoTree, null, lAssociations, sTemplate, fFlags);
            AssociationList lMembers = mdoTree.getMembers();
            for (int iMember = 0; iMember < lMembers.size(); ++iMember) {
                WsTreeNode nodeMember;
                Root mdoMember = (Root)lMembers.get(iMember);
                if (filter != null && !filter.accept(mdoMember, (WsTreeNode)this) || (nodeMember = factory.createObjectNode(mdoMember, (WsTreeNode)this)) == null) continue;
                this.addChild(nodeMember);
            }
            AssociationList lFolders = mdoTree.getSubTrees();
            for (int iFolder = 0; iFolder < lFolders.size(); ++iFolder) {
                WsTreeNode nodeFolder;
                Root mdoFolder = (Root)lFolders.get(iFolder);
                if (filter != null && !filter.accept(mdoFolder, (WsTreeNode)this) || (nodeFolder = factory.createFolderNode(mdoFolder, (WsTreeNode)this)) == null) continue;
                this.addChild(nodeFolder);
            }
        }
        catch (MdException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            model.disposeComplexObject((Root)mdoTree);
        }
    }

    @Override
    public WsOMAView onProperties() {
        return (WsOMAView)ViewFactory.showView(this.getLogicalObject(), FolderPropertiesView.class);
    }

    @Override
    public void updateMetadata(CMetadata mdo) {
        try {
            super.updateMetadata(mdo);
            for (int iChild = 0; iChild < this.getChildCount(); ++iChild) {
                TreeNode nodeChild = this.getChildAt(iChild);
                if (!(nodeChild instanceof FolderNode)) continue;
                FolderNode nodeFolder = (FolderNode)((Object)nodeChild);
                FolderInterface lobFolder = nodeFolder.getFolder();
                CMetadata mdoFolder = Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)mdo.getObjectStore(), lobFolder.getName(), lobFolder.getTypeInterface().getMetadataType(), lobFolder.getID());
                nodeFolder.updateMetadata(mdoFolder);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }
}

