/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.wadmin.model.tree.InventoryFolderNode;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import javax.swing.Icon;

public abstract class AbstractInventoryFolderNode
extends WsTreeNode
implements InventoryFolderNode {
    private String m_sRepositoryFQID;
    private boolean m_bAllowsGrandChildren;

    public AbstractInventoryFolderNode(String sName, String sRepositoryFQID) {
        super(sName);
        this.m_sRepositoryFQID = sRepositoryFQID;
        this.setDragSource(false);
    }

    @Override
    public void setRepositoryFQID(String sRepositoryFQID) {
        this.m_sRepositoryFQID = sRepositoryFQID;
    }

    @Override
    public String getRepositoryFQID() {
        return this.m_sRepositoryFQID;
    }

    @Override
    public void setAllowsGrandChildren(boolean bAllowsGrandChildren) {
        this.m_bAllowsGrandChildren = bAllowsGrandChildren;
        for (int iChild = 0; iChild < this.getChildCount(); ++iChild) {
            ((WsTreeNode)this.getChildAt(iChild)).setAllowsChildren(bAllowsGrandChildren);
        }
    }

    @Override
    public boolean allowsGrandChildren() {
        return this.m_bAllowsGrandChildren;
    }

    public boolean isValidAncestorFor(CMetadata mdo) {
        try {
            return this.m_bAllowsGrandChildren && this.m_sRepositoryFQID.substring(9).equals(mdo.getRepositoryID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public Icon getIcon(boolean bExpanded) {
        return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
    }
}

