/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.DataTable;
import com.sas.query.Query;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.Table;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class WAdminSqlLogic
extends SqlLogic {
    public WAdminSqlLogic() {
    }

    public WAdminSqlLogic(Query query, Hashtable passwordList) {
        super(query, passwordList);
    }

    public WAdminSqlLogic(SqlProperties sqlProperties) {
        super(sqlProperties);
    }

    public String genColumnName(Column column) {
        try {
            String strColumn = "";
            if (this.m_fMultipleTables) {
                String strTableName = column.getParent().getCorrelationName();
                if (strTableName == null || strTableName.length() == 0) {
                    strTableName = ((DataTable)column.getParent().getDataSourceTable().getUnderlyingTable()).getTableName();
                }
                strColumn = strColumn + this.genIdentifier(strTableName) + ".";
            }
            strColumn = strColumn + this.genIdentifier(column.getName());
            return strColumn;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    protected String genSQLForTable(Table table) {
        try {
            String sqlString = "";
            if (table == null) {
                return "";
            }
            if (table.getDataSourceTable().getDataSource().getHasMultipleLayers()) {
                DataSourceContainer parent = table.getDataSourceTable().getParent();
                String schemaName = null;
                if (parent != null) {
                    schemaName = parent.getName();
                }
                if (schemaName != null && schemaName.length() > 0) {
                    sqlString = sqlString + this.genIdentifier(schemaName) + ".";
                }
            }
            sqlString = sqlString + this.genIdentifier(((DataTable)table.getDataSourceTable().getUnderlyingTable()).getTableName());
            String strName = table.getCorrelationName();
            if (strName != null && strName.length() > 0) {
                sqlString = sqlString + " AS " + this.genIdentifier(strName);
            }
            return sqlString;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }
}

