/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class TransformationSourceColumnsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformationSourceColumnsTableModel.class);
    protected static final boolean g_bGotoServer = true;
    public static final int COLUMNNAME_COLUMN = 0;
    public static final int COLUMNDESCR_COLUMN = 1;
    public static final int TABLENAME_COLUMN = 2;
    public static final int TABLEDESCR_COLUMN = 3;
    public static final int TYPE_COLUMN = 4;
    public static final int LENGTH_COLUMN = 5;
    public static final int INFORMAT_COLUMN = 6;
    public static final int FORMAT_COLUMN = 7;
    public static final int COLUMN_COLUMN = 8;
    public static final int TABLENAME_WIDTH = 100;
    public static final int TABLEDESCR_WIDTH = 110;
    public static final int COLUMNNAME_WIDTH = 100;
    public static final int COLUMNDESCR_WIDTH = 110;
    public static final int TYPE_WIDTH = 75;
    public static final int LENGTH_WIDTH = 50;
    private static final int INFORMAT_WIDTH = 75;
    private static final int FORMAT_WIDTH = 75;
    protected static final int VISIBLE_COLUMNS = 8;
    protected static final int HIDDEN_COLUMNS = 1;
    protected TransformationStep m_oTS;
    protected List m_lDataTables;
    protected List m_lDataColumns;
    protected int[] m_aRowMappings;
    protected boolean m_bTableProvided = false;
    protected boolean m_bOnlyLoadFirstTable = false;

    public TransformationSourceColumnsTableModel() {
        this.createColumnDefinitions();
        this.m_lDataTables = new ArrayList();
        this.m_lDataColumns = new ArrayList();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = WsColumnMetadataUtil.getViewTypes();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("TransformationSourceColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("TransformationSourceColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[2] = new WsEnumeratedTableColumn(2, bundle.getString("TransformationSourceColumnsTableModel.Table.txt"), 100);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("TransformationSourceColumnsTableModel.TableDescr.txt"), 110);
        this.m_aColumns[4] = new WsEnumeratedTableColumn(4, bundle.getString("TransformationSourceColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[5] = new WsIntegerTableColumn(5, bundle.getString("TransformationSourceColumnsTableModel.Length.txt"), 50, 8, 1, Short.MAX_VALUE);
        this.m_aColumns[6] = new WsStringTableColumn(6, bundle.getString("TransformationSourceColumnsTableModel.Informat.txt"), 75);
        this.m_aColumns[7] = new WsStringTableColumn(7, bundle.getString("TransformationSourceColumnsTableModel.Format.txt"), 75);
        this.m_aColumns[8] = new WsMetadataTableColumn();
    }

    public void setTransformationStep(TransformationStep oTS) {
        this.m_oTS = oTS;
    }

    public TransformationStep getTransformationStep() {
        return this.m_oTS;
    }

    public void setTable(DataTable oTable) {
        this.m_lDataTables.clear();
        if (oTable != null) {
            this.m_lDataTables.add(oTable);
        }
        this.m_bTableProvided = true;
    }

    public void setTables(List lTables) {
        this.m_lDataTables.clear();
        this.m_lDataTables.addAll(lTables);
        this.m_bTableProvided = true;
    }

    public void setOnlyLoadFirstTable(boolean bOnlyLoadFirstTable) {
        this.m_bOnlyLoadFirstTable = bOnlyLoadFirstTable;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public List getDataTables() {
        return this.m_lDataTables;
    }

    public List getDataColumns() {
        return this.m_lDataColumns;
    }

    public int getColumnCount() {
        return 8;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        String sNone = WsColumnMetadataUtil.NONE;
        this.clear();
        if (!this.m_bTableProvided) {
            this.m_lDataTables.clear();
            AssociationList alCMs = this.m_oTS.getTransformations();
            int nCMs = alCMs.size();
            for (int iCM = 0; iCM < nCMs; ++iCM) {
                ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                AssociationList alSources = oCM.getClassifierSources();
                int nSources = alSources.size();
                for (int iSource = 0; iSource < nSources; ++iSource) {
                    Root oSource = (Root)alSources.get(iSource);
                    if (!(oSource instanceof DataTable) || this.m_lDataTables.contains(oSource)) continue;
                    this.m_lDataTables.add(oSource);
                }
            }
        }
        this.m_lDataColumns.clear();
        for (int iSource = 0; iSource < this.m_lDataTables.size(); ++iSource) {
            DataTable oSource = (DataTable)this.m_lDataTables.get(iSource);
            AssociationList alColumns = oSource.getColumns();
            String sName = this.getDisplayName(iSource);
            int nColumns = alColumns.size();
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                Column oColumn = (Column)alColumns.get(iColumn);
                String sInformat = oColumn.getSASInformat();
                String sFormat = oColumn.getSASFormat();
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                alRow.add(oColumn.getSASColumnName());
                alRow.add(oColumn.getDesc());
                alRow.add(sName);
                alRow.add(oSource.getDesc());
                alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn));
                alRow.add(new Integer(oColumn.getSASColumnLength()));
                alRow.add(sInformat.length() == 0 ? sNone : sInformat);
                alRow.add(sFormat.length() == 0 ? sNone : sFormat);
                alRow.add(oColumn);
                this.m_lDataColumns.add(oColumn);
                this.m_lData.add(alRow);
            }
            if (this.m_bOnlyLoadFirstTable) break;
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    protected String getDisplayName(int index) {
        return TransformationTargetColumnsTableModel.getDataTableDisplayName((DataTable)this.m_lDataTables.get(index));
    }
}

