/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class NotesTableModel
extends WATableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(NotesTableModel.class);
    public static final int NAME_COL = 0;
    static final int TOTAL_COLS = 1;
    private Root m_mdoObject;
    private List m_lNonNotes;

    public NotesTableModel() {
        this.columnNames.add(bundle.getString("NotesTableModel.note.txt"));
        this.m_lNonNotes = new ArrayList();
    }

    public NotesTableModel(Root mdoObject) {
        this();
        this.setObject(mdoObject);
    }

    public void setObject(Root mdoObject) {
        this.m_mdoObject = mdoObject;
    }

    public Root getObject() {
        return this.m_mdoObject;
    }

    public void setupModel(CMetadata metadata) {
        this.clear();
        try {
            this.m_mdoObject = (Root)metadata;
            this.moveDataToModel();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        this.m_lNonNotes.clear();
        ArrayList<String> lAttrs = new ArrayList<String>(1);
        lAttrs.add("Notes");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_mdoObject, null, lAttrs, null, 12, true);
        AssociationList lNotes = this.m_mdoObject.getNotes(false);
        for (int i = 0; i < lNotes.size(); ++i) {
            TextStore ts = (TextStore)lNotes.get(i);
            if (!ts.getTextRole().equals("Note")) {
                this.m_lNonNotes.add(ts);
                continue;
            }
            ArrayList<String> lRowValues = new ArrayList<String>(2);
            lRowValues.add(ts.getName());
            lRowValues.add((String)ts);
            this.data.add(lRowValues);
            ++this.instanceCount;
        }
        this.fireTableRowsInserted(0, this.data.size() - 1);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        AssociationList lNotes = this.m_mdoObject.getNotes(false);
        lNotes.clear();
        lNotes.addAll(this.m_lNonNotes);
        int nNotes = this.getRowCount();
        for (int iNote = 0; iNote < nNotes; ++iNote) {
            lNotes.add(this.getValueAt(iNote, 1));
        }
    }

    public void clear() {
        int nRows = this.data.size();
        if (nRows > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
    }

    public void localSetup(CMetadata metadata) {
        try {
            ArrayList<String> member = null;
            AssociationList notesList = ((Root)metadata).getNotes(false);
            for (int i = 0; i < notesList.size(); ++i) {
                member = new ArrayList<String>();
                TextStore ts = (TextStore)notesList.elementAt(i);
                member.add(ts.getName());
                member.add((String)ts);
                this.data.add(i, member);
                ++this.instanceCount;
            }
            this.fireTableRowsInserted(0, notesList.size() - 1);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
    }

    public Object getRowValue(int row) {
        if (this.data != null) {
            return this.data.get(row);
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public Object getValueAt(int row) {
        if (this.data != null) {
            return this.data.get(row);
        }
        return null;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public String[] getColumnChoices(int col) {
        return new String[0];
    }

    public void setValueAt(Object a, int row, int col) {
        this.undoableSet = true;
        this.resetPersistedUndo();
        if (col == 0) {
            boolean OK = false;
            String c = ((String)a).trim();
            if (c.length() > 0) {
                OK = true;
            }
            if (!OK) {
                return;
            }
        }
        super.setValueAt(a, row, col);
    }

    public boolean insertRow(TextStore _note) {
        try {
            ArrayList<String> member = new ArrayList<String>();
            member.add(_note.getName());
            member.add((String)_note);
            this.data.add(member);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            ++this.instanceCount;
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public WAUndoable undoableInsertRow(TextStore _note) {
        try {
            ArrayList<String> member = new ArrayList<String>();
            member.add(_note.getName());
            member.add((String)_note);
            this.data.add(member);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            ++this.instanceCount;
            NotesUndoableInsert nui = new NotesUndoableInsert(_note, this.data.size() - 1);
            return nui;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    class NotesUndoableInsert
    extends WAUndoable {
        TextStore n;
        int index;

        NotesUndoableInsert(TextStore not, int i) {
            this.n = not;
            this.index = i;
        }

        public void undo() {
            super.undo();
            NotesTableModel.this.data.remove(this.index);
            NotesTableModel.this.fireTableRowsDeleted(this.index, this.index);
        }

        public void redo() {
            try {
                super.redo();
                ArrayList<String> member = new ArrayList<String>();
                member.add(this.n.getName());
                member.add((String)this.n);
                NotesTableModel.this.data.add(this.index, member);
                NotesTableModel.this.fireTableRowsInserted(this.index, this.index);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

