/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AnalyticColumn;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MiningResult;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MiningModelColumnsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningModelColumnsTableModel.class);
    public static final int COLUMNNAME_COLUMN = 0;
    public static final int COLUMNDESCR_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int LENGTH_COLUMN = 3;
    public static final int LEVEL_COLUMN = 4;
    public static final int COLUMN_COLUMN = 5;
    public static final int COLUMNNAME_WIDTH = 100;
    public static final int COLUMNDESCR_WIDTH = 110;
    public static final int TYPE_WIDTH = 75;
    public static final int LENGTH_WIDTH = 50;
    public static final int LEVEL_WIDTH = 75;
    protected static final int VISIBLE_COLUMNS = 5;
    protected static final int HIDDEN_COLUMNS = 1;
    protected MiningResult m_result = null;
    protected DataTable m_dataTable;
    protected List m_inputColumnList;
    protected static String g_sDataCharacterType = WsColumnMetadataUtil.getDataCharacterType();
    protected static String g_sViewCharacterType = WsColumnMetadataUtil.getViewCharacterType();
    protected static String g_sViewNumericType = WsColumnMetadataUtil.getViewNumericType();

    public MiningModelColumnsTableModel() {
        this.createColumnDefinitions();
        this.m_inputColumnList = new ArrayList();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = this.loadTypeValues();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("MiningModelColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("MiningModelColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[2] = new WsEnumeratedTableColumn(2, bundle.getString("MiningModelColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[3] = new WsIntegerTableColumn(3, bundle.getString("MiningModelColumnsTableModel.Length.txt"), 50, 8, 1, Short.MAX_VALUE);
        this.m_aColumns[4] = new WsIntegerTableColumn(4, bundle.getString("MiningModelColumnsTableModel.Level.txt"), 75, 32);
        this.m_aColumns[5] = new WsMetadataTableColumn();
    }

    protected String[] loadTypeValues() {
        String[] saTypes = new String[]{g_sViewCharacterType, g_sViewNumericType};
        return saTypes;
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void setDataTable(DataTable table) {
        this.m_dataTable = table;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        this.m_inputColumnList.clear();
        if (this.m_dataTable == null) {
            return;
        }
        AssociationList columnList = this.m_dataTable.getColumns();
        for (int i = 0; i < columnList.size(); ++i) {
            Column column = (Column)columnList.get(i);
            String sType = column.getSASColumnType();
            String sLevel = "";
            AssociationList analyticList = column.getAnalyticColumns();
            if (!analyticList.isEmpty()) {
                AnalyticColumn aColumn = (AnalyticColumn)analyticList.get(0);
                sLevel = aColumn.getLevel();
            }
            ArrayList<Object> rowArray = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            rowArray.add(column.getSASColumnName());
            rowArray.add(column.getDesc());
            rowArray.add(sType.equals(g_sDataCharacterType) ? g_sViewCharacterType : g_sViewNumericType);
            rowArray.add(new Integer(column.getSASColumnLength()));
            rowArray.add(sLevel);
            rowArray.add(column);
            this.m_inputColumnList.add(column);
            this.m_lData.add(rowArray);
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }
}

