/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellEditor;

public class JOMADocumentTableModel
extends WsAbstractTableModel {
    boolean[] baColumnsEditable = new boolean[]{false, true};
    private static WAdminResource bundle = WAdminResource.getBundle(JOMADocumentTableModel.class);
    public static final int NAME_COL = 0;
    public static final int URL_COL = 1;
    public static final int DOC_COL = 2;
    static final int TOTAL_COLS = 2;
    static final int HIDDEN_COLS = 1;
    private Root m_oMetadata;

    public JOMADocumentTableModel(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.createColumns();
    }

    private void createColumns() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("DocumentsTableModel.Name.txt"), 1000);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DocumentsTableModel.Path.txt"), 1000);
        this.m_aColumns[2] = new WsObjectTableColumn();
        this.m_aColumns[1].setCellEditor((TableCellEditor)new WsDialogTableCellEditor());
    }

    public void moveDataToStore() {
    }

    public void moveDataToModel() {
        this.clear();
        try {
            AssociationList alDocuments = this.m_oMetadata.getDocuments();
            for (int iDocument = 0; iDocument < alDocuments.size(); ++iDocument) {
                Document oDoc = (Document)alDocuments.get(iDocument);
                if (!oDoc.getPublicType().equalsIgnoreCase("Document")) continue;
                this.insertRow(oDoc);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            e.printStackTrace();
        }
    }

    public void populateStore() {
        try {
            String sTemplate = "<Templates><Documents/></Templates>";
            Vector<String> vAssociations = new Vector<String>();
            vAssociations.add("Documents");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oMetadata, null, vAssociations, sTemplate, 12, true);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public boolean isCellEditable(int row, int col) {
        if (!this.baColumnsEditable[col]) {
            return false;
        }
        Document doc = (Document)this.getValueAt(row, 2);
        return Workspace.getWorkspace().isObjectEditable((CMetadata)doc);
    }

    public void setValueAt(Object a, int row, int col) {
        List lValues = (List)this.m_lData.get(row);
        Document oDoc = (Document)lValues.get(2);
        try {
            if (col == 0) {
                oDoc.setName((String)a);
            } else if (col == 1) {
                oDoc.setURI((String)a);
            }
            super.setValueAt(a, row, col);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public boolean validateName(String newName, int row) {
        ArrayList m = null;
        if (newName.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            m = (ArrayList)this.m_lData.get(i);
            String name = (String)m.get(0);
            if (!name.equals(newName) || i == row) continue;
            return false;
        }
        return true;
    }

    public boolean insertRow(Document doc) {
        try {
            ArrayList<String> lValues = new ArrayList<String>();
            lValues.add(doc.getName());
            lValues.add(doc.getURI());
            lValues.add((String)doc);
            this.insertRow(this.getRowCount() - 1, lValues);
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public void setURLEditorDialogAdapter(WsDialogTableCellEditorInterface dialogAdapter) {
        WsDialogTableCellEditor editor = (WsDialogTableCellEditor)this.m_aColumns[1].getCellEditor();
        editor.setDialog(dialogAdapter);
    }
}

