/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.FileSelectionInfo;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidationInfo;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidator;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class FolderValidator
extends FileSelectionValidator {
    private static WAdminResource bundle = WAdminResource.getBundle(FolderValidator.class);
    private SimpleObject[] aSimpleObjects;

    public FolderValidator(SimpleObject[] aObjects) {
        this.aSimpleObjects = aObjects;
    }

    public FileSelectionValidationInfo validate(FileSelectionInfo selectionInfo) {
        FileSelectionValidationInfo info = super.validate(selectionInfo);
        try {
            if (info.getValidationResult() == 1) {
                String path;
                List selections = selectionInfo.getSelections();
                if (selections != null && selections.size() > 0) {
                    RemoteFileMetadataInterface node = (RemoteFileMetadataInterface)selections.get(0);
                    path = node.getLocation().toString();
                } else {
                    BaseRemoteFileSelectorPanel rfsPanel = selectionInfo.getPanel();
                    RemoteFileModel2Interface rfsModel = (RemoteFileModel2Interface)selectionInfo.getPanel().getModel();
                    path = RemoteFileVisualsUtil.getFileLocationInformation((String)selectionInfo.getNameFieldText(), null, (BaseRemoteFileSelectorPanel)rfsPanel, (RemoteFileModel2Interface)rfsModel);
                }
                PathUrl pathUrl = null;
                if (path != null) {
                    pathUrl = new PathUrl(path);
                }
                Root targetTree = null;
                if (pathUrl != null) {
                    MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                    targetTree = (Root)metadataObject.getRepositoryEntity();
                }
                LogicalObjectInterface targetFolder = null;
                if (targetTree != null) {
                    targetFolder = ObjectConverter.getInstance().convertToLogicalObject(targetTree);
                }
                if (targetFolder != null) {
                    LogicalObjectInterface[] aLogicalObjects = ObjectConverter.getInstance().convertToLogicalObjects(this.aSimpleObjects);
                    int iNumberOfInvalidObjects = 0;
                    ArrayList<String> lInvalidObjectNames = new ArrayList<String>();
                    ArrayList<MoveDisallowedCause> lMoveDisallowedObjects = new ArrayList<MoveDisallowedCause>();
                    for (int iSelectedObject = 0; iSelectedObject < aLogicalObjects.length; ++iSelectedObject) {
                        LogicalObjectInterface oLogical = aLogicalObjects[iSelectedObject];
                        MoveDisallowedCause mdc = ((LogicalObject)oLogical).checkMoveAllowed((FolderInterface)targetFolder);
                        if (mdc == null) continue;
                        ++iNumberOfInvalidObjects;
                        lInvalidObjectNames.add(oLogical.getName());
                        lMoveDisallowedObjects.add(mdc);
                        break;
                    }
                    if (iNumberOfInvalidObjects > 0) {
                        ArrayList<String> msgList = new ArrayList<String>();
                        msgList.add(bundle.formatString("FolderValidator.InvalidFolderForObject.fmt", (Object)targetFolder.getName(), lInvalidObjectNames.get(0)));
                        MoveDisallowedCause mdc1 = (MoveDisallowedCause)lMoveDisallowedObjects.get(0);
                        msgList.add(mdc1.toString());
                        info.setValidationResult(2);
                        info.setMessagesType(1);
                        info.setMessages(msgList);
                        info.setCloseDialog(false);
                    }
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)"Accessing");
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        return info;
    }
}

