/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WAInternalFrameDialog
extends WAStandardInternalFrame {
    private static final WAdminResource bundle = WAdminResource.getBundle(WAInternalFrameDialog.class);
    private boolean m_bShownPreviously;
    private boolean m_bOKButtonVisible;
    private boolean m_bCancelButtonVisible;
    private boolean m_bCloseButtonVisible;
    private boolean m_bApplyButtonVisible;
    private boolean m_bHelpButtonVisible;
    private String m_sSettingsName;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected String m_sHelpTopic;
    protected String m_sHelpProduct;
    protected String docsetVersion;

    public WAInternalFrameDialog() {
        super("");
    }

    public WAInternalFrameDialog(String frameTitle) {
        super(frameTitle);
    }

    public WAInternalFrameDialog(String frameTitle, boolean bResizable) {
        super(frameTitle);
    }

    public WAInternalFrameDialog(String frameTitle, boolean bResizable, boolean bClosable) {
        super(frameTitle);
    }

    public WAInternalFrameDialog(String frameTitle, boolean bResizable, boolean bClosable, boolean bMaximizable) {
        super(frameTitle);
    }

    public WAInternalFrameDialog(String frameTitle, boolean bResizable, boolean bClosable, boolean bMaximizable, boolean bIconifiable) {
        super(frameTitle);
    }

    protected JRootPane createRootPane() {
        return new WARootPane();
    }

    protected void initialize() {
        super.initialize();
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                if (WAInternalFrameDialog.this.onCancel()) {
                    WAInternalFrameDialog.this.dispose();
                }
            }
        });
        this.m_bInitialized = true;
    }

    public void setMainPanel(WAPanel pnlMain) {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setDefaultAction(null);
            this.m_pnlMain.removePropertyChangeListener("DataChanged", this.m_lsnrPanelDataChanged);
            this.removeKeyListeners((Container)this.m_pnlMain, this.m_KeyHandler);
            this.getContentPane().remove((Component)this.m_pnlMain);
            this.restoreMainPanelBorder();
        }
        this.m_pnlMain = pnlMain;
        if (this.m_pnlMain != null) {
            this.getContentPane().add((Component)this.m_pnlMain, "Center");
            this.addKeyListeners((Container)this.m_pnlMain, this.m_KeyHandler);
            this.m_pnlMain.addPropertyChangeListener("DataChanged", this.m_lsnrPanelDataChanged);
            this.m_pnlMain.setEditable(this.m_bEditable);
            this.createMainPanelBorder();
        }
    }

    public void setEditable(boolean bEditable) {
    }

    public WAPanel getMainPanel() {
        return this.m_pnlMain;
    }

    protected void createMainPanelBorder() {
        Border brdrOuter = BorderFactory.createEmptyBorder(7, 7, 7, 7);
        Border brdrInner = this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder((Border)BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    protected void restoreMainPanelBorder() {
        CompoundBorder brdrCompound = (CompoundBorder)this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(brdrCompound.getInsideBorder());
    }

    protected void updateInputMap() {
        this.m_mapInput = this.getLayeredPane().getInputMap(1);
        this.m_mapInput.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.m_mapInput.put(KeyStroke.getKeyStroke(112, 1), "help");
        this.m_mapInput.put(KeyStroke.getKeyStroke(112, 0), "help");
        this.m_mapInput.put(KeyStroke.getKeyStroke(90, 2), "undo");
        this.m_mapInput.put(KeyStroke.getKeyStroke(89, 2), "redo");
    }

    protected void cleanupInputMap() {
        if (this.m_mapInput != null) {
            this.m_mapInput.remove(KeyStroke.getKeyStroke(27, 0));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(112, 1));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(112, 0));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(90, 2));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(89, 2));
        }
    }

    protected void layoutWidgets() {
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(3, 7, 7, 7));
        Container paneContents = this.getContentPane();
        if (this.m_pnlMain != null) {
            paneContents.add((Component)this.m_pnlMain, "Center");
        }
        this.updateButtonsPanel();
        paneContents.add((Component)this.m_pnlButtons, "South");
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setNextFocusableComponentOnLastFocusableComponent(this.m_pnlButtons.getComponent(0));
        }
    }

    public void show() {
        if (!this.m_bShownPreviously) {
            if (!this.m_bInitialized) {
                this.initialize();
            }
            this.layoutWidgets();
            this.pack();
            if (this.m_sSettingsName != null) {
                Dimension dimScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
                int cx = appDefaults.getPropertyInt(this.m_sSettingsName + ".cx", -1);
                int cy = appDefaults.getPropertyInt(this.m_sSettingsName + ".cy", -1);
                if (cx != -1 && cy != -1) {
                    cx = Math.min(Math.max(cx, 150), dimScreenSize.width - 100);
                    cy = Math.min(Math.max(cy, 150), dimScreenSize.height - 100);
                    this.setSize(cx, cy);
                }
                this.getX();
                this.getY();
            }
            this.center();
            this.onShow();
            this.m_bShownPreviously = true;
        }
        super.show();
    }

    protected void center() {
        Dimension szDialog = this.getSize();
        Dimension szParent = this.getParent().getSize();
        Point ptParent = this.getParent().getLocation();
        int x = ptParent.x + (szParent.width - szDialog.width) / 2;
        int y = ptParent.y + (szParent.height - szDialog.height) / 2;
        Rectangle rVirtualScreen = WsUIUtilities.getVirtualScreenExtent();
        x = Math.max(rVirtualScreen.x, Math.min(x, rVirtualScreen.width - szDialog.width));
        y = Math.max(rVirtualScreen.y, Math.min(y, rVirtualScreen.height - szDialog.height));
        this.setLocation(100, 100);
    }

    public final void setSettingsName(String name) {
        this.m_sSettingsName = name;
    }

    public final String getSettingsName() {
        return this.m_sSettingsName;
    }

    protected void onShow() {
        this.doDataExchange(false);
    }

    protected void updateButtonsPanel() {
        super.updateButtonsPanel();
        this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout());
    }

    public void close() {
        if (this.onCancel()) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.m_sSettingsName != null) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            appDefaults.setPropertyInt(this.m_sSettingsName + ".cx", Math.max(this.getWidth(), 150));
            appDefaults.setPropertyInt(this.m_sSettingsName + ".cy", Math.max(this.getHeight(), 150));
        }
        if (this.m_pnlMain != null) {
            try {
                this.m_pnlMain.saveSettingsAndCleanUp();
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)"Exception during main panel clean up", (Throwable)ex);
            }
            this.m_pnlMain = null;
        }
        super.dispose();
        SwingUtilities.replaceUIInputMap(this.getRootPane(), 2, null);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnOk) {
            if (this.onOK()) {
                this.dispose();
            }
        } else if (src == this.m_btnCancel) {
            if (this.onCancel()) {
                this.dispose();
            }
        } else if (src == this.m_btnApply) {
            this.onApply();
        } else if (src == this.m_btnHelp) {
            this.onHelp();
        }
    }

    public boolean isOKButtonVisible() {
        return this.m_bOKButtonVisible;
    }

    public void setOKButtonVisible(boolean visible) {
        this.m_bOKButtonVisible = visible;
    }

    public boolean isCancelButtonVisible() {
        return this.m_bCancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean visible) {
        this.m_bCancelButtonVisible = visible;
    }

    public boolean isCloseButtonVisible() {
        return this.m_bCloseButtonVisible;
    }

    public void setCloseButtonVisible(boolean visible) {
        this.m_bCloseButtonVisible = visible;
    }

    public boolean isApplyButtonVisible() {
        return this.m_bApplyButtonVisible;
    }

    public void setApplyButtonVisible(boolean visible) {
        this.m_bApplyButtonVisible = visible;
    }

    public boolean isHelpButtonVisible() {
        return this.m_bHelpButtonVisible;
    }

    public void setHelpButtonVisible(boolean visible) {
        this.m_bHelpButtonVisible = visible;
    }

    private boolean onClose() {
        return this.onCancel();
    }

    protected boolean onApply() {
        if (this.validateData()) {
            this.doDataExchange(true);
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentApply();
            }
            return true;
        }
        return false;
    }

    protected void onHelp() {
        Workspace.getWorkspace().showHelp(this.getHelpProduct(), this.getHelpTopic(), null, this.getHelpClassLoader(), this.getDocsetVersion());
    }

    protected boolean onOK() {
        return super.onOK();
    }

    protected boolean onCancel() {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.onParentCancel();
        }
        if (!this.isEditable()) {
            this.m_eReturnValue = 2;
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentCancel();
            }
            return true;
        }
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        this.m_eReturnValue = 2;
        return true;
    }

    public ClassLoader getHelpClassLoader() {
        return this.m_pnlMain != null ? this.m_pnlMain.getHelpClassLoader() : null;
    }

    public void setHelpTopic(String sHelpTopic) {
        this.m_sHelpTopic = sHelpTopic;
    }

    public String getHelpTopic() {
        String sHelpTopic = null;
        if (this.m_pnlMain != null) {
            sHelpTopic = this.m_pnlMain.getHelpTopic();
        }
        if (sHelpTopic == null) {
            sHelpTopic = this.m_sHelpTopic;
        }
        return sHelpTopic;
    }

    public void setHelpProduct(String sHelpProduct) {
        this.m_sHelpProduct = sHelpProduct;
    }

    public String getHelpProduct() {
        String sHelpProduct = null;
        if (this.m_pnlMain != null) {
            sHelpProduct = this.m_pnlMain.getHelpProduct();
        }
        if (sHelpProduct == null) {
            sHelpProduct = this.m_sHelpProduct;
        }
        return sHelpProduct;
    }

    public String getDocsetVersion() {
        return this.docsetVersion;
    }

    public void setDocsetVersion(String docsetVersion) {
        this.docsetVersion = docsetVersion;
    }

    protected boolean validateData() {
        if (this.m_pnlMain != null) {
            return this.m_pnlMain.validateData();
        }
        return true;
    }

    protected boolean doDataExchange(boolean bSaveToModel) {
        if (this.m_pnlMain != null) {
            try {
                if (!bSaveToModel) {
                    this.m_pnlMain.populateStore();
                    this.m_pnlMain.moveDataToView();
                } else {
                    this.m_pnlMain.moveDataToStore();
                }
                return true;
            }
            catch (MdException e) {
                if (!e.getMessage().equalsIgnoreCase("Undisplayable")) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                return false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                return false;
            }
        }
        return true;
    }
}

