/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import com.sas.dmv.relationship.ox.RelationshipModelTracker;
import com.sas.dmv.relationship.ox.RelationshipNode;
import com.sas.dmv.relationship.ox.RelationshipType;
import com.sas.dmv.relationship.ox.RelationshipWorkUnit;
import com.sas.dmv.relationship.ox.Resource;
import com.sas.dmv.relationship.ox.UserDefinedResourceAttributes;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.properties.BrowseObjectUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class LineageHelpers {
    protected static Resource addJobToWorkUnit(RelationshipWorkUnit wu, BrowseMetadataInterface browseSimpleJob) {
        String id = LineageHelpers.getIDForObject(browseSimpleJob);
        String objectType = LineageHelpers.getObjectType(browseSimpleJob);
        Resource resJob = wu.getResource(id, objectType);
        resJob.setLabel(browseSimpleJob.getName());
        LineageHelpers.addDescToResource(wu, browseSimpleJob, resJob);
        RelationshipModelTracker trackerJob = wu.getRelationshipModelTrackerForResource(resJob);
        return resJob;
    }

    protected static Resource addTransformationStepToWorkUnit(RelationshipWorkUnit wu, BrowseMetadataInterface transStep) {
        String stepId = LineageHelpers.getIDForObject(transStep);
        String objectType = LineageHelpers.getObjectType(transStep);
        Resource resStep = wu.getResource(stepId, objectType);
        resStep.setLabel(transStep.getName());
        LineageHelpers.addDescToResource(wu, transStep, resStep);
        RelationshipModelTracker trackerTS = wu.getRelationshipModelTrackerForResource(resStep);
        return resStep;
    }

    protected static RelationshipNode addTransformationStepToJob(RelationshipWorkUnit wu, Resource job, Resource step) {
        RelationshipModelTracker trackerJob = wu.getRelationshipModelTrackerForResource(job);
        RelationshipNode resNodeJobTS = wu.getRelationshipNode(trackerJob, step, RelationshipType.I);
        return resNodeJobTS;
    }

    protected static RelationshipNode addTargetTableToStep(RelationshipWorkUnit wu, BrowseMetadataInterface table, Resource transStep, Resource job) {
        String tableId = LineageHelpers.getIDForObject(table);
        String tableType = LineageHelpers.getObjectType(table);
        Resource resTable = wu.getResource(tableId, tableType);
        if (tableType.equalsIgnoreCase("ExternalFile")) {
            resTable.setLabel(table.getName());
        } else {
            resTable.setLabel((String)table.get("SASTableName"));
        }
        LineageHelpers.addResourceDescForTable(wu, table, resTable);
        LineageHelpers.addDescToResource(wu, table, resTable);
        RelationshipModelTracker trackerResTable = wu.getRelationshipModelTrackerForResource(resTable);
        RelationshipNode resNodeTSTable = wu.getRelationshipNode(trackerResTable, transStep, RelationshipType.D);
        if (tableType.equalsIgnoreCase("WorkTable")) {
            RelationshipModelTracker trackerJob = wu.getRelationshipModelTrackerForResource(job);
            RelationshipNode relationshipNode = wu.getRelationshipNode(trackerJob, resTable, RelationshipType.I);
        }
        return resNodeTSTable;
    }

    protected static RelationshipNode addDependentObjectToStep(RelationshipWorkUnit wu, BrowseMetadataInterface object, Resource transStep) {
        String objectId = LineageHelpers.getIDForObject(object);
        String objectType = LineageHelpers.getObjectType(object);
        Resource resObject = wu.getResource(objectId, objectType);
        resObject.setLabel((String)object.get("Name"));
        LineageHelpers.addDescToResource(wu, object, resObject);
        RelationshipModelTracker trackerResObject = wu.getRelationshipModelTrackerForResource(resObject);
        RelationshipNode resNodeTSObject = wu.getRelationshipNode(trackerResObject, transStep, RelationshipType.D);
        return resNodeTSObject;
    }

    protected static RelationshipNode addStepAsDependentObject(RelationshipWorkUnit wu, BrowseMetadataInterface object, Resource transStep) {
        String objectId = LineageHelpers.getIDForObject(object);
        String objectType = LineageHelpers.getObjectType(object);
        Resource resObject = wu.getResource(objectId, objectType);
        resObject.setLabel((String)object.get("Name"));
        LineageHelpers.addDescToResource(wu, object, resObject);
        RelationshipModelTracker trackerTransStep = wu.getRelationshipModelTrackerForResource(transStep);
        RelationshipNode resNodeTSObject = wu.getRelationshipNode(trackerTransStep, resObject, RelationshipType.D);
        return resNodeTSObject;
    }

    protected static RelationshipNode addSourceTableToStep(RelationshipWorkUnit wu, BrowseMetadataInterface table, Resource transStep) {
        String tableId = LineageHelpers.getIDForObject(table);
        String tableType = LineageHelpers.getObjectType(table);
        Resource resTable = wu.getResource(tableId, tableType);
        if (tableType.equalsIgnoreCase("ExternalFile")) {
            resTable.setLabel(table.getName());
        } else {
            resTable.setLabel((String)table.get("SASTableName"));
        }
        LineageHelpers.addResourceDescForTable(wu, table, resTable);
        LineageHelpers.addDescToResource(wu, table, resTable);
        RelationshipModelTracker trackerTransStep = wu.getRelationshipModelTrackerForResource(transStep);
        RelationshipNode resNodeTSTable = wu.getRelationshipNode(trackerTransStep, resTable, RelationshipType.D);
        return resNodeTSTable;
    }

    protected static RelationshipNode addBusinessRuleToStep(RelationshipWorkUnit wu, BrowseMetadataInterface table, Resource transStep, String sVersion) {
        String tableId = LineageHelpers.getIDForObject(table);
        String objectType = LineageHelpers.getObjectType(table);
        Resource resTable = wu.getResource(tableId, objectType);
        resTable.setLabel(table.getName());
        LineageHelpers.addResourceDescForTable(wu, table, resTable);
        LineageHelpers.addDescToResource(wu, table, resTable);
        LineageHelpers.addBusinessRuleVersion(wu, resTable, sVersion);
        RelationshipModelTracker trackerTransStep = wu.getRelationshipModelTrackerForResource(transStep);
        RelationshipNode resNodeTSTable = wu.getRelationshipNode(trackerTransStep, resTable, RelationshipType.D);
        return resNodeTSTable;
    }

    protected static RelationshipNode addMiningModelToStep(RelationshipWorkUnit wu, BrowseMetadataInterface table, Resource transStep) {
        String tableId = LineageHelpers.getIDForObject(table);
        String objectType = LineageHelpers.getObjectType(table);
        Resource resTable = wu.getResource(tableId, objectType);
        resTable.setLabel(table.getName());
        LineageHelpers.addDescToResource(wu, table, resTable);
        RelationshipModelTracker trackerTransStep = wu.getRelationshipModelTrackerForResource(transStep);
        RelationshipNode resNodeTSTable = wu.getRelationshipNode(trackerTransStep, resTable, RelationshipType.D);
        return resNodeTSTable;
    }

    protected static Resource addJFJobToWorkUnit(RelationshipWorkUnit wu, BrowseMetadataInterface jfjob) {
        String jfjobId = LineageHelpers.getIDForObject(jfjob);
        String objectType = LineageHelpers.getObjectType(jfjob);
        Resource resjfjob = wu.getResource(jfjobId, objectType);
        resjfjob.setLabel(jfjob.getName());
        LineageHelpers.addDescToResource(wu, jfjob, resjfjob);
        RelationshipModelTracker trackerjfjob = wu.getRelationshipModelTrackerForResource(resjfjob);
        return resjfjob;
    }

    protected static RelationshipNode addJFJobAsDependentOnJob(RelationshipWorkUnit wu, Resource job, Resource jfjob) {
        RelationshipModelTracker trackerJob = wu.getRelationshipModelTrackerForResource(jfjob);
        RelationshipNode resNodeJobJFJob = wu.getRelationshipNode(trackerJob, job, RelationshipType.D);
        return resNodeJobJFJob;
    }

    public static BrowseMetadataInterface findLibraryForTable(List tablePackages) throws MdException, RemoteException {
        BrowseMetadataInterface lib = null;
        if (tablePackages != null) {
            for (int i = 0; i < tablePackages.size(); ++i) {
                List dbLibList;
                BrowseMetadataInterface tablePackage = (BrowseMetadataInterface)tablePackages.get(i);
                if ("SASLibrary".equals(tablePackage.getNativeType())) {
                    lib = tablePackage;
                    return lib;
                }
                if (!"DatabaseSchema".equals(tablePackage.getNativeType()) || (lib = LineageHelpers.findLibraryForTable(dbLibList = (List)tablePackage.get("UsedByPackages"))) == null) continue;
                return lib;
            }
        }
        return lib;
    }

    public static String generateLibRef(BrowseMetadataInterface library) {
        StringBuffer libref = new StringBuffer();
        libref.append(library.get("Libref"));
        BrowseMetadataInterface schema = LineageHelpers.getSchemaForLibrary(library);
        if (schema != null) {
            libref.append('.');
            libref.append(schema.get("SchemaName"));
        }
        String libRef = libref.toString();
        return libRef;
    }

    public static BrowseMetadataInterface getSchemaForLibrary(BrowseMetadataInterface library) {
        BrowseMetadataInterface schema;
        if (library == null) {
            return null;
        }
        List schemaList = (List)library.get("UsingPackages");
        if (schemaList != null && schemaList.size() > 0 && "DatabaseSchema".equals((schema = (BrowseMetadataInterface)schemaList.get(0)).getNativeType())) {
            return schema;
        }
        return null;
    }

    protected static void addResourceDescForTable(RelationshipWorkUnit wu, BrowseMetadataInterface table, Resource resTable) {
        if (table.getNativeType().equals("PhysicalTable") || table.getNativeType().equals("WorkTable")) {
            try {
                BrowseMetadataInterface library = BrowseObjectUtil.findLibraryForTable((List)table.get("TablePackage"));
                if (library != null) {
                    String libRef = BrowseObjectUtil.generateLibRef(library);
                    wu.addResourceAttribute(resTable, UserDefinedResourceAttributes.RESOURCE_ATTRIBUTE_NAME_DATA_PATH, libRef);
                }
            }
            catch (MdException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
    }

    protected static void addDescToResource(RelationshipWorkUnit wu, BrowseMetadataInterface browseObject, Resource res) {
        String desc = browseObject.getDescription();
        if (desc.length() != 0) {
            wu.addResourceAttribute(res, UserDefinedResourceAttributes.RESOURCE_ATTRIBUTE_NAME_DESC, desc);
        }
    }

    protected static void addBusinessRuleVersion(RelationshipWorkUnit wu, Resource businessRule, String sVersion) {
        if (sVersion.length() != 0) {
            wu.addResourceAttribute(businessRule, UserDefinedResourceAttributes.RESOURCE_ATTRIBUTE_NAME_VERSION, sVersion);
        }
    }

    protected static String getPublicType(BrowseMetadataInterface browseObject) {
        String sPublicType = (String)browseObject.get("PublicType");
        if (sPublicType == null) {
            sPublicType = "";
        }
        return sPublicType;
    }

    protected static String getIDForObject(BrowseMetadataInterface browseObject) {
        return (String)browseObject.get("Id") + "/" + browseObject.getNativeType();
    }

    protected static String getIDForFeatureObject(BrowseMetadataInterface parentObject, BrowseMetadataInterface browseObject, String sDisplayName) {
        StringBuffer sb = new StringBuffer();
        sb.append((String)parentObject.get("Id"));
        sb.append("/");
        sb.append(parentObject.getNativeType());
        String desc = browseObject.getDescription();
        desc = desc.replaceAll(" ", "");
        sb.append("?").append(desc);
        if (sDisplayName.length() > 0) {
            sb.append("=").append(sDisplayName);
        } else {
            sb.append("=").append(browseObject.getName());
        }
        return sb.toString();
    }

    protected static String getObjectType(BrowseMetadataInterface browseObject) {
        String sPublicType = LineageHelpers.getPublicType(browseObject);
        return sPublicType.length() == 0 ? browseObject.getNativeType() : sPublicType;
    }

    protected static String getFeatureObjectType(BrowseMetadataInterface browseObject, BrowseMetadataInterface parentObject, String sDisplayName) {
        StringBuffer sb = new StringBuffer();
        String sPublicType = LineageHelpers.getPublicType(parentObject);
        sb.append(sPublicType.length() == 0 ? parentObject.getNativeType() : sPublicType);
        sb.append(".").append(browseObject.getDescription().replaceAll(" ", ""));
        return sb.toString();
    }

    protected static void addColumsFromTable(RelationshipWorkUnit wu, BrowseMetadataInterface table, Resource transStep) {
        String tableId = LineageHelpers.getIDForObject(table);
        String objectType = LineageHelpers.getObjectType(table);
        Resource resTable = wu.getResource(tableId, objectType);
        RelationshipModelTracker trackerResTable = wu.getRelationshipModelTrackerForResource(resTable);
        List lColumns = (List)table.get("Columns");
        if (lColumns != null && lColumns.size() > 0) {
            for (int m = 0; m < lColumns.size(); ++m) {
                BrowseMetadataInterface column = (BrowseMetadataInterface)lColumns.get(m);
                String columnId = LineageHelpers.getIDForObject(column);
                String objectTypeForColumn = LineageHelpers.getObjectType(column);
                Resource resColumn = wu.getResource(columnId, objectTypeForColumn);
                resColumn.setLabel((String)column.get("SASColumnName"));
                RelationshipNode relationshipNode = wu.getRelationshipNode(trackerResTable, resColumn, RelationshipType.I);
            }
        }
    }

    protected static void addRelationshipToTargetColumn(RelationshipWorkUnit wu, BrowseMetadataInterface column, List alFSources) {
        String targetColId = LineageHelpers.getIDForObject(column);
        String targetColType = LineageHelpers.getObjectType(column);
        Resource resTargetColumn = wu.getResource(targetColId, targetColType);
        RelationshipModelTracker trackerResTargetColumn = wu.getRelationshipModelTrackerForResource(resTargetColumn);
        for (int s = 0; s < alFSources.size(); ++s) {
            BrowseMetadataInterface sourceColumn = (BrowseMetadataInterface)alFSources.get(s);
            String sourceColId = LineageHelpers.getIDForObject(sourceColumn);
            String sourceColType = LineageHelpers.getObjectType(sourceColumn);
            Resource resSourceColumn = wu.getResource(sourceColId, sourceColType);
            RelationshipNode relationshipNode = wu.getRelationshipNode(trackerResTargetColumn, resSourceColumn, RelationshipType.D);
        }
    }

    protected static void addDependentObject(RelationshipWorkUnit wu, BrowseMetadataInterface object, BrowseMetadataInterface depObject) {
        String objectId = LineageHelpers.getIDForObject(object);
        String objectType = LineageHelpers.getObjectType(object);
        Resource resObject = wu.getResource(objectId, objectType);
        String depId = LineageHelpers.getIDForObject(depObject);
        String depType = LineageHelpers.getObjectType(depObject);
        Resource resDep = wu.getResource(depId, depType);
        resDep.setLabel(depObject.getName());
        RelationshipModelTracker trackerResDep = wu.getRelationshipModelTrackerForResource(resDep);
        RelationshipNode resNode = wu.getRelationshipNode(trackerResDep, resObject, RelationshipType.D);
    }

    protected static void addFeatureAsIncludedObject(RelationshipWorkUnit wu, BrowseMetadataInterface object, BrowseMetadataInterface depObject, String sDisplayName) {
        String objectType;
        String objectId = LineageHelpers.getIDForObject(object);
        Resource resObject = wu.getResource(objectId, objectType = LineageHelpers.getObjectType(object));
        if (resObject.getLabel().length() == 0) {
            resObject.setLabel(object.getName());
        }
        String depId = LineageHelpers.getIDForFeatureObject(object, depObject, sDisplayName);
        String depType = LineageHelpers.getFeatureObjectType(depObject, object, sDisplayName);
        Resource resDep = wu.getResource(depId, depType);
        resDep.setLabel(depObject.getName());
        RelationshipModelTracker trackerResDep = wu.getRelationshipModelTrackerForResource(resObject);
        RelationshipNode resNode = wu.getRelationshipNode(trackerResDep, resDep, RelationshipType.I);
    }

    protected static void addFeatureAsDependentObject(RelationshipWorkUnit wu, BrowseMetadataInterface object, BrowseMetadataInterface depObject, String sDisplayName, BrowseMetadataInterface realParent) {
        String objectType;
        String objectId = LineageHelpers.getIDForObject(object);
        Resource resObject = wu.getResource(objectId, objectType = LineageHelpers.getObjectType(object));
        if (resObject.getLabel().length() == 0) {
            resObject.setLabel(object.getName());
        }
        String depId = LineageHelpers.getIDForFeatureObject(realParent, depObject, sDisplayName);
        String depType = LineageHelpers.getFeatureObjectType(depObject, realParent, sDisplayName);
        Resource resDep = wu.getResource(depId, depType);
        resDep.setLabel(depObject.getName());
        RelationshipModelTracker trackerResDep = wu.getRelationshipModelTrackerForResource(resDep);
        RelationshipNode resNode = wu.getRelationshipNode(trackerResDep, resObject, RelationshipType.D);
    }

    protected static void addFeatureAsDependentObjectOfFeature(RelationshipWorkUnit wu, BrowseMetadataInterface object, BrowseMetadataInterface realobject, BrowseMetadataInterface depObject, BrowseMetadataInterface depRealObject, String sDisplayName, String sDisplayName2) {
        String objectType;
        String objectId = LineageHelpers.getIDForFeatureObject(realobject, object, sDisplayName);
        Resource resObject = wu.getResource(objectId, objectType = LineageHelpers.getFeatureObjectType(object, realobject, sDisplayName));
        if (resObject.getLabel().length() == 0) {
            resObject.setLabel(object.getName());
        }
        String depId = LineageHelpers.getIDForFeatureObject(depRealObject, depObject, sDisplayName2);
        String depType = LineageHelpers.getFeatureObjectType(depObject, depRealObject, sDisplayName2);
        Resource resDep = wu.getResource(depId, depType);
        resDep.setLabel(depObject.getName());
        RelationshipModelTracker trackerResDep = wu.getRelationshipModelTrackerForResource(resDep);
        RelationshipNode resNode = wu.getRelationshipNode(trackerResDep, resObject, RelationshipType.D);
    }
}

