/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.util.Util;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.wadmin.lineage.DirectorySelectorDialog;
import com.sas.wadmin.lineage.FileExtensionFilter;
import com.sas.wadmin.lineage.GenericListDialogPanel;
import com.sas.wadmin.lineage.LineageExporterWorker;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class LineageExporterPanel
extends WAPanel {
    protected static WorkspaceFile wadef = Workspace.getWorkspace().getAppDefaultsFile();
    protected static WAdminResource bundle = new WAdminResource(LineageExporterPanel.class);
    private ObjectsSelectorPanel m_objectSelectorPanel = null;
    private JLabel m_lblDate = null;
    private DatePicker m_dtpPicker = null;
    private JLabel m_lblLineageFileName = null;
    private WAComboBox m_cboFileSelector = null;
    private JProgressBar m_progressBar = null;
    private JButton m_btnBrowseLocal = null;
    private JButton m_btnBrowseRemote = null;
    private JButton m_btnStart = null;
    private JButton m_btnStop = null;
    private JCheckBox m_chkExportToWeb;
    private JLabel m_lblUsername = null;
    private JTextField m_txtUsername = null;
    private JLabel m_lblPassword = null;
    private JPasswordField m_txtPassword = null;
    private SimpleObject[] m_selectedObjects;
    private LineageExporterWorker m_worker = new LineageExporterWorker();
    private boolean m_writeLocal = true;

    public LineageExporterPanel() {
        boolean bSecondURL = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("ShowSecondLineageURLField", false);
        this.m_worker.setUseSecondURL(bSecondURL);
        this.initialize();
    }

    protected void initialize() {
        this.m_objectSelectorPanel = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 1);
        this.add((Component)this.m_objectSelectorPanel);
        this.m_dtpPicker = new DatePicker(DateTypes.DATE, Locale.getDefault());
        this.m_lblDate = WsUIUtilities.createLabelForComponent((JComponent)this.m_dtpPicker, (String)bundle.getString("LineageExporterPanel.DateSelectorLabel.txt"));
        this.m_cboFileSelector = new WAComboBox();
        this.m_cboFileSelector.setToolTipText(bundle.getString("LineageExporterPanel.LineageFileName.tip"));
        this.m_cboFileSelector.setEditable(true);
        this.m_lblLineageFileName = WsUIUtilities.createLabelForComponent((JComponent)this.m_cboFileSelector, (String)bundle.getString("LineageExporterPanel.LineageFileName.txt"));
        this.m_chkExportToWeb = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"LineageExporterPanel.ExportToWebCheckbox");
        this.m_chkExportToWeb.addItemListener(new ExportCheckboxListener());
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setVisible(true);
        this.m_progressBar.setStringPainted(true);
        this.m_btnBrowseLocal = WsUIUtilities.createTextButton((WsAbstractAction)new BrowseAction("Local"));
        this.m_btnBrowseRemote = WsUIUtilities.createTextButton((WsAbstractAction)new BrowseAction("Remote"));
        this.m_btnStart = WsUIUtilities.createTextButton((WsAbstractAction)new ExportAction(true));
        this.m_btnStop = WsUIUtilities.createTextButton((WsAbstractAction)new ExportAction(false));
        this.m_btnStop.setVisible(false);
        this.m_txtUsername = new JTextField();
        this.m_lblUsername = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtUsername, (String)bundle.getString("LineageExporterPanel.WebUsernameLabel.txt"));
        this.m_lblUsername.setVisible(false);
        this.m_txtUsername.setVisible(false);
        this.m_txtUsername.setEnabled(false);
        this.m_txtPassword = new JPasswordField();
        this.m_lblPassword = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtPassword, (String)bundle.getString("LineageExporterPanel.WebPasswordLabel.txt"));
        this.m_lblPassword.setVisible(false);
        this.m_txtPassword.setVisible(false);
        this.m_txtPassword.setEnabled(false);
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add((Component)this.m_objectSelectorPanel, new GridBagConstraints(0, row++, 6, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblDate, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_dtpPicker, new GridBagConstraints(1, row++, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblLineageFileName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_cboFileSelector, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_btnBrowseLocal, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_btnBrowseRemote, new GridBagConstraints(4, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_chkExportToWeb, new GridBagConstraints(5, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblUsername, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_txtUsername, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblPassword, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_txtPassword, new GridBagConstraints(4, row++, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_progressBar, new GridBagConstraints(0, row, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_btnStart, new GridBagConstraints(5, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_btnStop, new GridBagConstraints(5, row++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
    }

    public boolean load() {
        this.m_cboFileSelector.loadItems("LineageExporterPanel.FileSelectorList", 4);
        return true;
    }

    public boolean save() {
        this.m_cboFileSelector.saveItems("LineageExporterPanel.FileSelectorList", 4);
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.load();
        this.m_objectSelectorPanel.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_objectSelectorPanel.moveDataToStore();
        this.save();
    }

    protected void doShowFileSelectorDialog(String defaultPath) {
        DirectorySelectorDialog fsd = new DirectorySelectorDialog((Component)((Object)this), defaultPath, 0, 1);
        FileExtensionFilter xmlFilter = new FileExtensionFilter(bundle.getString("LineageExporterPanel.FileTypes.XML.txt"), "xml");
        fsd.setFileFilter(xmlFilter);
        if (fsd.showSelectDialog()) {
            this.addItemToTop(fsd.getFilePath());
        }
    }

    private void addItemToTop(Object item) {
        this.m_cboFileSelector.addItem(item);
        for (int i = 0; i <= this.m_cboFileSelector.getItemCount() - 2; ++i) {
            Object tempItem = this.m_cboFileSelector.getItemAt(0);
            this.m_cboFileSelector.removeItemAt(0);
            this.m_cboFileSelector.addItem(tempItem);
        }
        this.m_cboFileSelector.setSelectedIndex(0);
    }

    public boolean validateData() {
        String errorMessage = "";
        boolean validData = true;
        if (!this.areObjectsSelected()) {
            validData = false;
            errorMessage = errorMessage + bundle.getString("LineageExporterPanel.Errors.NoObjectsSelected.txt") + "\n";
        }
        if (!this.isOutputFileValid()) {
            validData = false;
            errorMessage = errorMessage + bundle.getString("LineageExporterPanel.Errors.InvalidOutputFile.txt") + "\n";
        }
        if (!validData) {
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("LineageExporterPanel.Errors.MissingFields.txt") + "\n" + errorMessage, bundle.getString("LineageExporterPanel.Errors.MissingFields.Title.txt"), 1);
        }
        return validData;
    }

    private boolean isOutputFileValid() {
        return this.m_cboFileSelector.getSelectedItem() != null;
    }

    private boolean areObjectsSelected() {
        try {
            this.m_objectSelectorPanel.moveDataToStore();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        SimpleObject[] selectedObjects = this.m_objectSelectorPanel.getSelectedObjects();
        return selectedObjects != null && selectedObjects.length > 0;
    }

    private boolean isSelectedDateValid() {
        return this.m_dtpPicker.getDate() != null;
    }

    public boolean canClose() {
        return !this.m_worker.isProcessing() || this.m_worker.isCanceled();
    }

    public void onParentOK() {
        this.start();
    }

    private void start() {
        if (!this.validateData()) {
            return;
        }
        if (this.m_worker.isProcessing()) {
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("LineageExporterPanel.Errors.ExportRunning.txt"), bundle.getString("LineageExporterPanel.Errors.ExportRunning.Title.txt"), 1);
            return;
        }
        this.enablePanel(false);
        DatePeriod date = (DatePeriod)this.m_dtpPicker.getDate();
        this.m_selectedObjects = this.m_objectSelectorPanel.getSelectedObjects();
        this.m_worker.doShowProgressBar(this.m_selectedObjects, (Date)date, this.m_progressBar, this.m_cboFileSelector.getSelectedItem().toString(), this.m_writeLocal, this.m_chkExportToWeb.isSelected(), new Runnable(){

            @Override
            public void run() {
                LineageExporterPanel.this.enablePanel(true);
                if (LineageExporterPanel.this.m_worker.getFailedObjects() != null && !LineageExporterPanel.this.m_worker.getFailedObjects().isEmpty()) {
                    GenericListDialogPanel pnlFailures = new GenericListDialogPanel(bundle.getString("LineageExporterPanel.Errors.FailedExports.txt"), LineageExporterPanel.this.m_worker.getFailedObjects());
                    WAStandardDialog dlgFailures = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("LineageExporterPanel.Errors.FailedExports.Title.txt"), true, (WAPanel)pnlFailures);
                    dlgFailures.setResizable(true);
                    dlgFailures.setCancelButtonVisible(false);
                    dlgFailures.setHelpButtonVisible(false);
                    dlgFailures.show();
                }
            }
        }, this.m_txtUsername.getText(), new String(this.m_txtPassword.getPassword()));
    }

    private void enablePanel(boolean enabled) {
        this.m_objectSelectorPanel.setEditable(enabled);
        this.m_dtpPicker.setEnabled(enabled);
        this.m_btnBrowseLocal.setEnabled(enabled);
        this.m_btnBrowseRemote.setEnabled(enabled);
        this.m_cboFileSelector.setEnabled(enabled);
        this.m_btnStop.setVisible(!enabled);
        this.m_btnStart.setVisible(enabled);
        this.m_chkExportToWeb.setEnabled(enabled);
        this.m_txtUsername.setEnabled(enabled && this.m_chkExportToWeb.isSelected());
        this.m_txtPassword.setEnabled(enabled && this.m_chkExportToWeb.isSelected());
    }

    private void stop() {
        this.m_worker.setCanceled(true);
        this.enablePanel(true);
    }

    public void onParentCancel() {
        int returnCode;
        if (this.m_worker.isProcessing() && (returnCode = JOptionPane.showConfirmDialog((Component)((Object)this), bundle.getString("LineageExporterPanel.Errors.OnCancel.txt"), bundle.getString("LineageExporterPanel.Errors.OnCancel.Title.txt"), 2)) != 0) {
            return;
        }
        this.stop();
    }

    public class ExportCheckboxListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                LineageExporterPanel.this.m_lblUsername.setVisible(true);
                LineageExporterPanel.this.m_lblPassword.setVisible(true);
                LineageExporterPanel.this.m_txtUsername.setVisible(true);
                LineageExporterPanel.this.m_txtPassword.setVisible(true);
                LineageExporterPanel.this.m_txtUsername.setEnabled(true);
                LineageExporterPanel.this.m_txtPassword.setEnabled(true);
            } else if (e.getStateChange() == 2) {
                LineageExporterPanel.this.m_lblUsername.setVisible(false);
                LineageExporterPanel.this.m_lblPassword.setVisible(false);
                LineageExporterPanel.this.m_txtUsername.setVisible(false);
                LineageExporterPanel.this.m_txtPassword.setVisible(false);
                LineageExporterPanel.this.m_txtUsername.setEnabled(false);
                LineageExporterPanel.this.m_txtPassword.setEnabled(false);
            }
        }
    }

    public class BrowseAction
    extends WsAbstractAction {
        public BrowseAction(String location) {
            super(bundle, "LineageExporterPanel.Action.Browse" + location, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                LineageExporterPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                String sName = (String)LineageExporterPanel.this.m_cboFileSelector.getSelectedItem();
                if (sName == null) {
                    sName = "";
                }
                if (((JButton)e.getSource()).getText().equals(Util.getLabelWithoutMnemonic((String)bundle.getString("LineageExporterPanel.Action.BrowseLocal.txt")))) {
                    LineageExporterPanel.this.doShowFileSelectorDialog(sName);
                    LineageExporterPanel.this.m_writeLocal = true;
                } else if (((JButton)e.getSource()).getText().equals(Util.getLabelWithoutMnemonic((String)bundle.getString("LineageExporterPanel.Action.BrowseRemote.txt")))) {
                    WsAppServer appServer = WsAppServer.createDefaultAppServer();
                    if (appServer == null) {
                        return;
                    }
                    LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                    mapFileTypes.put(bundle.getString("LineageExporterPanel.FileTypes.XML.txt"), "xml");
                    mapFileTypes.put(bundle.getString("LineageExporterPanel.FileTypes.AllFileTypes.txt"), "*");
                    String filename = appServer.promptForFilename(bundle.getString("LineageExporterPanel.RemoteFileSelector.Title.txt"), sName, mapFileTypes);
                    if (filename != null) {
                        LineageExporterPanel.this.addItemToTop(filename);
                        LineageExporterPanel.this.m_writeLocal = false;
                    }
                }
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            finally {
                LineageExporterPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public class ExportAction
    extends WsAbstractAction {
        private boolean m_starting;

        public ExportAction(boolean starting) {
            super(bundle, "LineageExporterPanel.Action.Export" + (starting ? "Start" : "Stop"), 0);
            this.m_starting = starting;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.m_starting) {
                LineageExporterPanel.this.start();
            } else {
                LineageExporterPanel.this.stop();
            }
        }
    }
}

