/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import com.sas.iom.SAS.IWorkspace;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.promotion.AbstractPromotionDriver;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.impl.JobImpl;
import com.sas.metadata.remote.impl.TreeImpl;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.lineage.LineageExporterOptions;
import com.sas.wadmin.lineage.LineageExporterWorker;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;

public class LineageExporterCommandLine
extends AbstractPromotionDriver {
    private static WAdminResource m_bundle = new WAdminResource(LineageExporterCommandLine.class);
    private String m_metaMachine;
    private String m_metaPort;
    private String m_metaUser;
    private String m_metaPassword;
    private String m_serverUser;
    private String m_serverPassword;
    private String m_serverMachine;
    private int m_serverPort;
    private static String m_manifestFile;
    private IWorkspace m_workspace;
    private String m_webUsername;
    private String m_webPassword;
    private String m_webURL;
    private Date m_selectedDate;
    private String m_outputFile;
    private boolean m_writeLocal = true;
    private boolean m_pushToWeb = false;
    private static String LINE_SEPARATOR;
    private static String REGEX_CHARS;
    private static int m_rc;
    private LineageExporterWorker m_worker;
    private ObjectConverter m_conv;

    private LineageExporterCommandLine() {
        this.setLogFilePrefix("LineageExporterCommandLine");
        this.m_worker = new LineageExporterWorker();
        this.m_worker.initializeWorkers();
        this.m_conv = ObjectConverter.getInstance();
    }

    public LineageExporterCommandLine(String[] args) {
        this();
    }

    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        super.initialize();
        IWorkspaceServer iworkserver = null;
        try {
            MdFactoryImpl factory = new MdFactoryImpl();
            factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
            iworkserver = new IWorkspaceServer((ServerContext)null, "440196D4-90F0-11D0-9F41-00A024BB830C", this.m_serverMachine, this.m_serverPort);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)m_bundle.getString("LineageExporterCommandLine.MetadataInitError.txt"), (Throwable)e);
            System.exit(99);
        }
        try {
            this.m_workspace = null;
            if (iworkserver.makeConnection(this.m_serverUser, this.m_serverPassword)) {
                this.m_workspace = iworkserver.getWorkspace();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)m_bundle.getString("LineageExporterCommandLine.WorkspaceInitError.txt"), (Throwable)e);
            System.exit(99);
        }
    }

    public static void main(String[] args) {
        m_rc = 0;
        LineageExporterCommandLine exporter = new LineageExporterCommandLine(args);
        try {
            exporter.parse(args);
            exporter.initialize();
            exporter.validateSetup();
            String[] paths = exporter.readFromLocalFile(m_manifestFile);
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].contains(" -r")) {
                    exporter.processParentPath(exporter._server, paths[i].substring(0, paths[i].lastIndexOf(" -r")).trim(), true);
                    continue;
                }
                exporter.processParentPath(exporter._server, paths[i].trim(), false);
            }
            exporter.serializeAndWrite();
            exporter.getLogger().info(m_bundle.getString("LineageExporterCommandLine.ExecutionCompleteTag.txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
            exporter.getLogger().error(m_bundle.getString("LineageExporterCommandLine.GenericErrorExportingJobs.txt"), (Throwable)e);
            System.exit(99);
        }
        System.exit(m_rc |= exporter.getReturnCode());
    }

    private void serializeAndWrite() {
        String serializedLineage = this.m_worker.getSerializedLineage();
        try {
            Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.WritingFile.txt") + " " + this.m_outputFile));
            if (this.m_writeLocal) {
                this.m_worker.writeLocalFile(this.m_outputFile, serializedLineage, this.m_pushToWeb);
            } else {
                this.m_worker.writeRemoteFile(this.m_outputFile, serializedLineage, this.m_pushToWeb);
            }
            if (this.m_pushToWeb) {
                Workspace.getDefaultLogger().info((Object)m_bundle.getString("LineageExporterCommandLine.PushingToWeb.txt"));
                this.m_worker.pushFileToWebService(this.m_worker.getCompressedFileName(this.m_outputFile), this.m_pushToWeb, this.m_webUsername, this.m_webPassword, this.m_webURL);
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)m_bundle.getString("LineageExporterWorker.Errors.FileWriteError.txt"), (Throwable)e);
        }
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new LineageExporterOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        this.m_metaMachine = this._commandLine.getOptionValue("host");
        this.m_metaPort = this._commandLine.getOptionValue("port");
        this.m_metaUser = this._commandLine.getOptionValue("metauser");
        this.m_metaPassword = this._commandLine.getOptionValue("metapass");
        m_manifestFile = this._commandLine.getOptionValue("manifest");
        this.m_serverUser = this._commandLine.getOptionValue("user");
        this.m_serverPassword = this._commandLine.getOptionValue("password");
        this.m_serverMachine = this._commandLine.getOptionValue("servermachine");
        this.m_serverPort = this._commandLine.getOptionValue("serverport") != null ? Integer.parseInt(this._commandLine.getOptionValue("serverport")) : 0;
        this.m_webUsername = this._commandLine.getOptionValue("webusername");
        this.m_webPassword = this._commandLine.getOptionValue("webpassword");
        this.m_webURL = this._commandLine.getOptionValue("weburl");
        if (this._commandLine.hasOption("date")) {
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            Date date = null;
            try {
                date = df.parse(this._commandLine.getOptionValue("date"));
            }
            catch (java.text.ParseException e) {
                Workspace.getDefaultLogger().error((Object)"Invalid date format", (Throwable)e);
            }
            this.m_selectedDate = date;
        }
        this.m_outputFile = this._commandLine.getOptionValue("outputfile");
        this.m_pushToWeb = this._commandLine.hasOption("pushtoweb") ? this._commandLine.getOptionValue("pushtoweb").equalsIgnoreCase("true") : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readFromLocalFile(String inFile) {
        ArrayList<String> args = new ArrayList<String>();
        try {
            String curLine;
            BufferedReader br = new BufferedReader(new FileReader(new File(inFile)));
            while ((curLine = br.readLine()) != null) {
                args.add(curLine);
            }
            br.close();
        }
        catch (IOException e) {
            Workspace.getDefaultLogger().error((Object)m_bundle.getString("LineageExporterCommandLine.FileReadError.txt"), (Throwable)e);
        }
        finally {
            return args.toArray(new String[args.size()]);
        }
    }

    private void processParentPath(ServerInterface server, String path, boolean recursive) throws ServiceException, RemoteException {
        String parentPath = path.substring(0, path.lastIndexOf("/") + 1);
        List lChildren = this.getChildren(server, parentPath);
        if (lChildren != null) {
            for (Object child : lChildren) {
                JobImpl job;
                Metadata md;
                String metadataID;
                String name;
                if (child instanceof Folder) {
                    Folder folder = (Folder)child;
                    TreeImpl treeNode = (TreeImpl)folder.getRepositoryEntity();
                    name = treeNode.getName();
                    if (!name.equals(path.substring(path.lastIndexOf("/") + 1))) continue;
                    metadataID = treeNode.getFQID();
                    Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.FolderTag.txt") + name + ":" + metadataID));
                    this.processPath(server, path, recursive);
                    break;
                }
                if (!(child instanceof Metadata) || !((md = (Metadata)child).getRepositoryEntity() instanceof JobImpl) || !(name = (job = (JobImpl)md.getRepositoryEntity()).getName()).equals(path.substring(path.lastIndexOf("/") + 1))) continue;
                metadataID = job.getFQID();
                Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.ProcessingTag.txt") + name + ":" + metadataID));
                this.m_worker.getLineageFor(this.m_conv.convertToSimpleObject((PrimaryType)job), this.m_selectedDate);
                if (!recursive) break;
                for (Object innerChild : lChildren) {
                    if (!(innerChild instanceof Folder)) continue;
                    Folder folder = (Folder)innerChild;
                    TreeImpl treeNode = (TreeImpl)folder.getRepositoryEntity();
                    String innerName = treeNode.getName();
                    String newPath = path.substring(0, path.lastIndexOf("/") + 1) + innerName + "/" + name;
                    Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.FolderTag.txt") + name + ":" + metadataID));
                    this.processParentPath(server, newPath, recursive);
                }
            }
            boolean bRegex = false;
            String regexString = path.substring(path.lastIndexOf("/") + 1);
            for (int i = 0; i < REGEX_CHARS.length(); ++i) {
                if (!regexString.contains(REGEX_CHARS.substring(i, i + 1))) continue;
                bRegex = true;
                break;
            }
            if (bRegex) {
                Pattern p = Pattern.compile(regexString);
                for (Object child : lChildren) {
                    if (!(child instanceof Metadata)) continue;
                    Metadata md = (Metadata)child;
                    if (md.getRepositoryEntity() instanceof JobImpl) {
                        JobImpl job = (JobImpl)md.getRepositoryEntity();
                        String name = job.getName();
                        Matcher matcher = p.matcher(name);
                        if (!matcher.matches()) continue;
                        String metadataID = job.getFQID();
                        Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.ProcessingTag.txt") + name + ":" + metadataID));
                        this.m_worker.getLineageFor(this.m_conv.convertToSimpleObject((PrimaryType)job), this.m_selectedDate);
                        continue;
                    }
                    if (!recursive || !(child instanceof Folder)) continue;
                    Folder folder = (Folder)child;
                    TreeImpl treeNode = (TreeImpl)folder.getRepositoryEntity();
                    String metadataID = treeNode.getFQID();
                    String name = treeNode.getName();
                    String newPath = path.substring(0, path.lastIndexOf("/")) + "/" + name + "/" + regexString;
                    Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.FolderTag.txt") + name + ":" + metadataID));
                    this.processParentPath(server, newPath, recursive);
                }
            }
        }
    }

    private void processPath(ServerInterface server, String path, boolean recursive) throws ServiceException, RemoteException {
        if (path == null) {
            throw new ServiceException(RB.getStringResource((String)"BatchExporter.NoObjects.txt"));
        }
        List lChildren = this.getChildren(server, path);
        if (lChildren != null) {
            for (int j = 0; j < lChildren.size(); ++j) {
                Metadata md;
                String name;
                String metadataID;
                Object child = lChildren.get(j);
                if (child instanceof Folder) {
                    Folder folder = (Folder)child;
                    TreeImpl treeNode = (TreeImpl)folder.getRepositoryEntity();
                    metadataID = treeNode.getFQID();
                    name = treeNode.getName();
                    Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.FolderTag.txt") + name + ":" + metadataID));
                    String newPath = path + "/" + name;
                    if (!recursive) continue;
                    this.processPath(server, newPath, recursive);
                    continue;
                }
                if (!(child instanceof Metadata) || !((md = (Metadata)child).getRepositoryEntity() instanceof JobImpl)) continue;
                JobImpl job = (JobImpl)md.getRepositoryEntity();
                metadataID = job.getFQID();
                name = job.getName();
                Workspace.getDefaultLogger().info((Object)(m_bundle.getString("LineageExporterCommandLine.ProcessingTag.txt") + name + ":" + metadataID));
                this.m_worker.getLineageFor(this.m_conv.convertToSimpleObject((PrimaryType)job), this.m_selectedDate);
            }
        }
    }

    private List getChildren(ServerInterface server, String path) throws ServiceException, RemoteException {
        MetadataInterface mi;
        PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
        if (url.getType() == null) {
            url.setType("Folder");
        }
        if ((mi = server.getObjectByPath(url)) == null) {
            Workspace.getDefaultLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.ObjectNotFound.fmt.txt", (Object)path));
            m_rc |= 4;
            return null;
        }
        return ((FolderInterface)mi).getChildren();
    }

    static {
        LINE_SEPARATOR = m_bundle.getString("LineageExporterCommandLine.LineSeparator.txt");
        REGEX_CHARS = m_bundle.getString("LineageExporterCommandLine.RegexChars.txt");
    }
}

