/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import com.sas.dmv.relationship.ox.RelationshipNode;
import com.sas.dmv.relationship.ox.RelationshipWorkUnit;
import com.sas.dmv.relationship.ox.Resource;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.lineage.LineageHelpers;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JobLineage {
    protected RelationshipWorkUnit m_wu;
    String m_BIReposID;
    boolean m_doesBILineageRepositoryExist;
    Map<String, BrowseMetadataInterface> m_realObjects = new HashMap<String, BrowseMetadataInterface>();
    Map<String, BrowseMetadataInterface> m_features = new HashMap<String, BrowseMetadataInterface>();
    Map<String, BrowseMetadataInterface> m_featureMaps = new HashMap<String, BrowseMetadataInterface>();
    Map<String, BrowseMetadataInterface> m_groups = new HashMap<String, BrowseMetadataInterface>();
    Map<String, BrowseMetadataInterface> m_tables = new HashMap<String, BrowseMetadataInterface>();
    Map<String, BrowseMetadataInterface> m_BItables = new HashMap<String, BrowseMetadataInterface>();
    Map<String, BrowseMetadataInterface> m_jobs = new HashMap<String, BrowseMetadataInterface>();
    protected List m_lPopulatedJobs;

    public JobLineage(RelationshipWorkUnit wu) {
        this.m_wu = wu;
        this.m_lPopulatedJobs = new ArrayList();
    }

    protected void getJobLineage(SimpleObject simpleJob, Date afterDate) {
        List alActivities;
        Date updateDate;
        BrowseMetadataInterface browseJob = this.getJobMetadata(simpleJob);
        if (browseJob == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Job \"");
            sb.append(simpleJob.getName());
            sb.append("\" was not processed because metadata could not be retrieved");
            Workspace.getDefaultLogger().debug((Object)sb.toString());
            return;
        }
        if (this.m_lPopulatedJobs.contains(simpleJob.getID())) {
            return;
        }
        this.m_lPopulatedJobs.add(simpleJob.getID());
        if (afterDate != null && afterDate.compareTo(updateDate = browseJob.getModifyDateAsDate()) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Job \"");
            sb.append(browseJob.getName());
            sb.append("\" was not processed because it has not been modified since the selected date");
            Workspace.getDefaultLogger().debug((Object)sb.toString());
            return;
        }
        Resource wu_Job = LineageHelpers.addJobToWorkUnit(this.m_wu, browseJob);
        this.findBILineageRepository();
        List alJFJobs = (List)browseJob.get("JFJobs");
        if (alJFJobs != null) {
            for (int j = 0; j < alJFJobs.size(); ++j) {
                BrowseMetadataInterface jfjob = (BrowseMetadataInterface)alJFJobs.get(j);
                Resource jfjobResource = LineageHelpers.addJFJobToWorkUnit(this.m_wu, jfjob);
                RelationshipNode relationshipNode = LineageHelpers.addJFJobAsDependentOnJob(this.m_wu, wu_Job, jfjobResource);
            }
        }
        if ((alActivities = (List)browseJob.get("JobActivities")) != null) {
            for (int i = 0; i < alActivities.size(); ++i) {
                List alSteps;
                BrowseMetadataInterface activity = (BrowseMetadataInterface)alActivities.get(i);
                if (activity == null || (alSteps = (List)activity.get("Steps")) == null) continue;
                for (int j = 0; j < alSteps.size(); ++j) {
                    List lDocs;
                    String sTransformRoleOfStep;
                    BrowseMetadataInterface cmap;
                    BrowseMetadataInterface step = (BrowseMetadataInterface)alSteps.get(j);
                    if (step == null) continue;
                    Resource transStep = LineageHelpers.addTransformationStepToWorkUnit(this.m_wu, step);
                    RelationshipNode nodeJobTS = LineageHelpers.addTransformationStepToJob(this.m_wu, wu_Job, transStep);
                    List alTransformations = (List)step.get("Transformations");
                    if (alTransformations != null) {
                        for (int k = 0; k < alTransformations.size(); ++k) {
                            BrowseMetadataInterface sourceSpec;
                            List alSourceSpecs;
                            String sTransformRole;
                            cmap = (BrowseMetadataInterface)alTransformations.get(k);
                            if ("ClassifierMap".equals(cmap.getNativeType()) || "Select".equals(cmap.getNativeType())) {
                                List alSources;
                                List alTargets = (List)cmap.get("ClassifierTargets");
                                if (alTargets != null) {
                                    for (int m = 0; m < alTargets.size(); ++m) {
                                        BrowseMetadataInterface group;
                                        BrowseMetadataInterface target = (BrowseMetadataInterface)alTargets.get(m);
                                        if (target == null || !target.getNativeType().equals("PhysicalTable") && !target.getNativeType().equals("ExternalTable") && !target.getNativeType().equals("WorkTable")) continue;
                                        target = this.getTableMetadata(target);
                                        RelationshipNode nodeTSTable = LineageHelpers.addTargetTableToStep(this.m_wu, target, transStep, wu_Job);
                                        LineageHelpers.addColumsFromTable(this.m_wu, target, transStep);
                                        if (!this.m_doesBILineageRepositoryExist || (group = this.findActualObject(target)) == null) continue;
                                        this.findSourceTransformationsForBI(group, target);
                                    }
                                } else {
                                    List lSourceTrans;
                                    String sTransformRole2 = (String)step.get("TransformRole");
                                    if (sTransformRole2 != null && (sTransformRole2.equalsIgnoreCase("QueueWriter:HIDE") || sTransformRole2.equalsIgnoreCase("IBMWSQWriter:HIDE")) && (lSourceTrans = (List)step.get("SourceTransformations")) != null && lSourceTrans.size() > 0) {
                                        BrowseMetadataInterface queueObject = (BrowseMetadataInterface)lSourceTrans.get(0);
                                        LineageHelpers.addDependentObjectToStep(this.m_wu, queueObject, transStep);
                                    }
                                }
                                if ((alSources = (List)cmap.get("ClassifierSources")) != null) {
                                    for (int m = 0; m < alSources.size(); ++m) {
                                        BrowseMetadataInterface group;
                                        BrowseMetadataInterface source = (BrowseMetadataInterface)alSources.get(m);
                                        if (source == null || !source.getNativeType().equals("PhysicalTable") && !source.getNativeType().equals("ExternalTable") && !source.getNativeType().equals("WorkTable")) continue;
                                        source = this.getTableMetadata(source);
                                        RelationshipNode nodeTSTable = LineageHelpers.addSourceTableToStep(this.m_wu, source, transStep);
                                        LineageHelpers.addColumsFromTable(this.m_wu, source, transStep);
                                        if (!this.m_doesBILineageRepositoryExist || (group = this.findActualObject(source)) == null) continue;
                                        this.findSourceTransformationsForBI(group, source);
                                        this.findBILineageItemsForColumns(source, group);
                                    }
                                } else {
                                    List lTargetTrans;
                                    String sTransformRole3 = (String)step.get("TransformRole");
                                    if (sTransformRole3 != null && (sTransformRole3.equalsIgnoreCase("QueueReader:HIDE") || sTransformRole3.equalsIgnoreCase("IBMWSQReader:HIDE")) && (lTargetTrans = (List)step.get("TargetTransformations")) != null && lTargetTrans.size() > 0) {
                                        BrowseMetadataInterface queueObject = (BrowseMetadataInterface)lTargetTrans.get(0);
                                        LineageHelpers.addStepAsDependentObject(this.m_wu, queueObject, transStep);
                                    }
                                }
                            }
                            if ((sTransformRole = (String)cmap.get("TransformRole")) != null && sTransformRole.equalsIgnoreCase("BusinessRule")) {
                                alSourceSpecs = (List)cmap.get("SourceSpecifications");
                                if (alSourceSpecs != null) {
                                    for (int m = 0; m < alSourceSpecs.size(); ++m) {
                                        sourceSpec = (BrowseMetadataInterface)alSourceSpecs.get(m);
                                        String sVersion = this.findBusinessRuleVersion(step);
                                        LineageHelpers.addBusinessRuleToStep(this.m_wu, sourceSpec, transStep, sVersion);
                                    }
                                }
                            } else if (sTransformRole != null && (sTransformRole.equalsIgnoreCase("ModelScoring") || sTransformRole.equalsIgnoreCase("MiningResults")) && (alSourceSpecs = (List)cmap.get("SourceSpecifications")) != null) {
                                for (int m = 0; m < alSourceSpecs.size(); ++m) {
                                    sourceSpec = (BrowseMetadataInterface)alSourceSpecs.get(m);
                                    LineageHelpers.addMiningModelToStep(this.m_wu, sourceSpec, transStep);
                                }
                            }
                            if (sTransformRole.equalsIgnoreCase("MiningResults") || sTransformRole.equalsIgnoreCase("ModelScoring")) continue;
                            this.processFeatureMaps(cmap);
                        }
                    }
                    if ((sTransformRoleOfStep = (String)step.get("TransformRole")) != null && sTransformRoleOfStep.equalsIgnoreCase("HPF") && (lDocs = (List)step.get("Documents")) != null) {
                        for (int d = 0; d < lDocs.size(); ++d) {
                            BrowseMetadataInterface doc = (BrowseMetadataInterface)lDocs.get(d);
                            String sTextRole = (String)doc.get("TextRole");
                            if (null == sTextRole || !sTextRole.equalsIgnoreCase("HPFOUTPUT")) continue;
                            LineageHelpers.addDependentObjectToStep(this.m_wu, doc, transStep);
                            break;
                        }
                    }
                    if (sTransformRoleOfStep == null || !sTransformRoleOfStep.equalsIgnoreCase("com.sas.wadmin.visuals.sasJob") || alTransformations == null || (cmap = (BrowseMetadataInterface)alTransformations.get(0)) == null || !cmap.getNativeType().equalsIgnoreCase("Job")) continue;
                    LineageHelpers.addStepAsDependentObject(this.m_wu, cmap, transStep);
                    SimpleObjectImpl simple = new SimpleObjectImpl(cmap.getName(), cmap.getReposId(), cmap.getNativeType(), "Job");
                    if (null == simple) continue;
                    this.getJobLineage((SimpleObject)simple, afterDate);
                }
            }
        }
    }

    protected void getJobLineage(SimpleObject simpleJob) {
        this.getJobLineage(simpleJob, null);
    }

    protected BrowseMetadataInterface getJobMetadata(SimpleObject simpleJob) {
        BrowseMetadataInterface root = null;
        String sObjectID = simpleJob.getID();
        root = this.m_jobs.get(sObjectID);
        if (null == root) {
            try {
                StringBuffer sbTemplate = new StringBuffer();
                sbTemplate.append("<Templates>");
                String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(simpleJob.getMetadataType(), simpleJob.getID(), null, this.getJobPopulateAttributes());
                sbTemplate.append(objectXML);
                sbTemplate.append(this.getJobPopulateTemplate());
                sbTemplate.append("</Templates>");
                String template = sbTemplate.toString();
                int mdFlags = -2080350180;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setExplicitSearchString("", objectXML);
                filter.setOMRTemplate(template);
                filter.setOMRFlags(mdFlags);
                String sKey = simpleJob.getID() + "/" + simpleJob.getMetadataType();
                root = server.browseFetch(sKey, (FilterInterface)filter);
                this.m_jobs.put(sObjectID, root);
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
        return root;
    }

    protected BrowseMetadataInterface getTableMetadata(BrowseMetadataInterface simpleTable) {
        BrowseMetadataInterface root = null;
        String sObjectID = simpleTable.getReposId();
        root = this.m_tables.get(sObjectID);
        if (null == root) {
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            try {
                String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(simpleTable.getNativeType(), simpleTable.getReposId(), null, this.getTablePopulateAttributes());
                sbTemplate.append(objectXML);
                sbTemplate.append(this.getTablePopulateTemplate());
                sbTemplate.append("</Templates>");
                String template = sbTemplate.toString();
                int mdFlags = -2080350180;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setExplicitSearchString("", objectXML);
                filter.setOMRTemplate(template);
                filter.setOMRFlags(mdFlags);
                String sKey = simpleTable.getReposId() + "/" + simpleTable.getNativeType();
                root = server.browseFetch(sKey, (FilterInterface)filter);
                this.m_tables.put(sObjectID, root);
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
        return root;
    }

    protected String getJobPopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<ClassifierMap><ClassifierTargets/><ClassifierSources/><FeatureMaps/><SourceSpecifications/></ClassifierMap>");
            template.append("<Select><ClassifierTargets/><ClassifierSources/><FeatureMaps/></Select>");
            template.append("<SyncStep><Transformations/></SyncStep>");
            template.append("<TransformationActivity><Steps/></TransformationActivity>");
            template.append("<TransformationStep><Transformations/><SourceTransformations/><TargetTransformations/><PropertySets/><Documents/></TransformationStep>");
            template.append("<FeatureMap><FeatureSources/><FeatureTargets/></FeatureMap>");
            s_strTemplate = template.toString();
        }
        return this.getPopulateTemplate() + s_strTemplate;
    }

    protected String getPopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<PropertySet><Properties/><SetProperties/></PropertySet>");
            s_strTemplate = template.toString();
        }
        return s_strTemplate;
    }

    protected String getTablePopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<DataTable><Columns/><TablePackage/></DataTable>");
            template.append("<SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary>");
            template.append("<DatabaseSchema><DeployedComponents/><UsedByPackages/></DatabaseSchema>");
            s_strTemplate = template.toString();
        }
        return this.getPopulateTemplate() + s_strTemplate;
    }

    protected String getBILineageTablePopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<DataTable><Columns/><TablePackage/></DataTable>");
            template.append("<SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary>");
            template.append("<DatabaseSchema><DeployedComponents/><UsedByPackages/></DatabaseSchema>");
            s_strTemplate = template.toString();
        }
        return this.getPopulateTemplate() + s_strTemplate;
    }

    protected List getJobPopulateAttributes() {
        ArrayList<String> s_lAttributes = null;
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList<String>();
            s_lAttributes.addAll(this.getPopulateAttributes());
            s_lAttributes.add("JobActivities");
            s_lAttributes.add("JFJobs");
        }
        return s_lAttributes;
    }

    protected List getPopulateAttributes() {
        ArrayList<String> s_lAttributes = null;
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList<String>();
            s_lAttributes.add("PropertySets");
        }
        return s_lAttributes;
    }

    protected List getTablePopulateAttributes() {
        ArrayList<String> s_lAttributes = null;
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList<String>();
            s_lAttributes.addAll(this.getPopulateAttributes());
            s_lAttributes.add("TablePackage");
            s_lAttributes.add("Columns");
        }
        return s_lAttributes;
    }

    protected void processFeatureMaps(BrowseMetadataInterface cmap) {
        List alFMaps = (List)cmap.get("FeatureMaps");
        if (alFMaps == null) {
            return;
        }
        for (int m = 0; m < alFMaps.size(); ++m) {
            BrowseMetadataInterface featureMap = (BrowseMetadataInterface)alFMaps.get(m);
            List alFTargets = (List)featureMap.get("FeatureTargets");
            List alFSources = (List)featureMap.get("FeatureSources");
            if (alFTargets == null) continue;
            for (int t = 0; t < alFTargets.size(); ++t) {
                BrowseMetadataInterface targetColumn = (BrowseMetadataInterface)alFTargets.get(t);
                if (alFSources == null || alFSources.size() <= 0) continue;
                LineageHelpers.addRelationshipToTargetColumn(this.m_wu, targetColumn, alFSources);
            }
        }
    }

    protected String findBusinessRuleVersion(BrowseMetadataInterface step) {
        List sets = (List)step.get("PropertySets");
        BrowseMetadataInterface set = null;
        if (sets != null) {
            List properties;
            Iterator iterator = sets.iterator();
            while (iterator.hasNext() && !"Options".equals((set = (BrowseMetadataInterface)iterator.next()).get("PropertySetName"))) {
            }
            if (set != null && (properties = (List)set.get("SetProperties")) != null) {
                for (BrowseMetadataInterface property : properties) {
                    if (!"BusinessRuleVersion".equals(property.get("PropertyName"))) continue;
                    String value = (String)property.get("DefaultValue");
                    return value;
                }
            }
        }
        return "";
    }

    protected BrowseMetadataInterface getTableMetadataForBILineage(BrowseMetadataInterface simpleTable) {
        BrowseMetadataInterface root = null;
        String sObjectID = simpleTable.getReposId();
        root = this.m_BItables.get(sObjectID);
        if (null == root) {
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            try {
                String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(simpleTable.getNativeType(), simpleTable.getReposId(), null, this.getTablePopulateAttributes());
                sbTemplate.append(objectXML);
                sbTemplate.append(this.getTablePopulateTemplate());
                sbTemplate.append("</Templates>");
                String template = sbTemplate.toString();
                int mdFlags = -2080350180;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setExplicitSearchString("", objectXML);
                filter.setOMRTemplate(template);
                filter.setOMRFlags(mdFlags);
                String sKey = simpleTable.getReposId() + "/" + simpleTable.getNativeType();
                root = server.browseFetch(sKey, (FilterInterface)filter);
                this.m_BItables.put(sObjectID, root);
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
        return root;
    }

    protected BrowseMetadataInterface findActualObject(BrowseMetadataInterface object) {
        try {
            Filter filter = new Filter("Desc", 0, object.getReposId());
            filter.setType("Property");
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            sbTemplate.append("<Property Name=\"\" Desc=\"\"><AssociatedObject/></Property>");
            sbTemplate.append("<Group><Members/><Properties/><SourceTransformations/></Group>");
            sbTemplate.append("<ClassifierMap><TransformationTargets/></ClassifierMap>");
            sbTemplate.append("<Feature Name=\"\" Desc=\"\"></Feature>");
            sbTemplate.append("</Templates>");
            filter.setOMRTemplate(sbTemplate.toString());
            filter.setOMRFlags(-2147475052);
            filter.setOMRRepository(this.m_BIReposID);
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            List lObjects = server.browseSearch((FilterInterface)filter);
            BrowseMetadataInterface assocObject = null;
            for (BrowseMetadataInterface browseObj : lObjects) {
                List lAssoObjects = (List)browseObj.get("AssociatedObject");
                if (lAssoObjects == null) continue;
                assocObject = (BrowseMetadataInterface)lAssoObjects.get(0);
                break;
            }
            return assocObject;
        }
        catch (ServiceException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        return null;
    }

    protected void findSourceTransformationsForBI(BrowseMetadataInterface group, BrowseMetadataInterface source) {
        List alTransformations = (List)group.get("SourceTransformations");
        if (alTransformations == null) {
            return;
        }
        for (int k = 0; k < alTransformations.size(); ++k) {
            BrowseMetadataInterface cmap = (BrowseMetadataInterface)alTransformations.get(k);
            List alTargets = (List)cmap.get("TransformationTargets");
            if (alTargets == null) continue;
            for (int m = 0; m < alTargets.size(); ++m) {
                BrowseMetadataInterface target = (BrowseMetadataInterface)alTargets.get(m);
                if (target == null) continue;
                List lProperties = (List)target.get("Properties");
                for (int p = 0; p < lProperties.size(); ++p) {
                    String sActualID;
                    BrowseMetadataInterface realObject;
                    BrowseMetadataInterface property = (BrowseMetadataInterface)lProperties.get(p);
                    if (!property.getName().equalsIgnoreCase("ActualObject") || (realObject = this.findRealObject(sActualID = (String)property.get("Desc"))) == null) continue;
                    LineageHelpers.addDependentObject(this.m_wu, source, realObject);
                    this.findSourceTransformationsForBI(target, realObject);
                }
            }
        }
    }

    protected BrowseMetadataInterface findRealObject(String sID) {
        BrowseMetadataInterface realObject = null;
        realObject = this.m_realObjects.get(sID);
        if (null == realObject) {
            try {
                Filter filter = new Filter("Id", 0, sID);
                StringBuffer sbTemplate = new StringBuffer();
                sbTemplate.append("<Templates>");
                sbTemplate.append("<Root Name=\"\" Desc=\"\" PublicType=\"\"></Root>");
                sbTemplate.append("</Templates>");
                filter.setOMRTemplate(sbTemplate.toString());
                filter.setOMRFlags(-2147475052);
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                List lObjects = server.browseSearch((FilterInterface)filter);
                if (lObjects != null && lObjects.size() > 0) {
                    realObject = (BrowseMetadataInterface)lObjects.get(0);
                    return realObject;
                }
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        } else {
            return realObject;
        }
        return null;
    }

    protected void findBILineageRepository() {
        try {
            int i;
            List lRepositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
            HashMap<String, String> m_lRepositories = new HashMap<String, String>();
            for (i = 0; i < lRepositories.size(); ++i) {
                CMetadata repos = (CMetadata)lRepositories.get(i);
                String sFQID = repos.getFQID();
                String sReposName = repos.getName();
                m_lRepositories.put(sFQID.substring(9), sReposName);
            }
            this.m_BIReposID = "";
            for (i = 0; i < lRepositories.size(); ++i) {
                CMetadata tmpMetadata = (CMetadata)lRepositories.get(i);
                if (!tmpMetadata.getName().equalsIgnoreCase("BILineage")) continue;
                this.m_BIReposID = tmpMetadata.getFQID();
                this.m_doesBILineageRepositoryExist = true;
                break;
            }
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    protected void findBILineageItemsForColumns(BrowseMetadataInterface table, BrowseMetadataInterface group) {
        List lColumns = (List)table.get("Columns");
        List lProxyColumns = (List)group.get("Members");
        if (lColumns != null && lColumns.size() > 0) {
            block0: for (int m = 0; m < lColumns.size(); ++m) {
                BrowseMetadataInterface column = (BrowseMetadataInterface)lColumns.get(m);
                for (int p = 0; p < lProxyColumns.size(); ++p) {
                    BrowseMetadataInterface proxyColumn = (BrowseMetadataInterface)lProxyColumns.get(p);
                    if (!proxyColumn.getName().equals(column.getName())) continue;
                    this.processFeature(proxyColumn, column);
                    continue block0;
                }
            }
        }
    }

    protected void processFeature(BrowseMetadataInterface proxyColumn, BrowseMetadataInterface includeObject) {
        List lFMs = (List)(proxyColumn = this.getFeatureMetadata(proxyColumn)).get("SourceFeatureMaps");
        if (lFMs == null || lFMs.size() == 0) {
            return;
        }
        for (int fm = 0; fm < lFMs.size(); ++fm) {
            BrowseMetadataInterface featureMap = (BrowseMetadataInterface)lFMs.get(fm);
            featureMap = this.getFeatureMapMetadata(featureMap);
            this.processFeatureTargets(featureMap, includeObject);
        }
    }

    protected void processFeatureTargets(BrowseMetadataInterface featureMap, BrowseMetadataInterface object) {
        List lFTs = (List)featureMap.get("FeatureTargets");
        if (lFTs == null || lFTs.size() == 0) {
            return;
        }
        for (int f = 0; f < lFTs.size(); ++f) {
            BrowseMetadataInterface feature = (BrowseMetadataInterface)lFTs.get(f);
            feature = this.getFeatureMetadata(feature);
            this.processAsIncludedObject(feature);
            this.processAsDependentObject(feature, object);
            this.processFeature(feature, feature);
        }
    }

    protected BrowseMetadataInterface getFeatureMetadata(BrowseMetadataInterface object) {
        BrowseMetadataInterface root = null;
        String sObjectID = object.getReposId();
        root = this.m_features.get(sObjectID);
        if (null == root) {
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            try {
                String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(object.getNativeType(), object.getReposId(), null, this.getFeaturePopulateAttributes());
                sbTemplate.append(objectXML);
                sbTemplate.append(this.getFeaturePopulateTemplate());
                sbTemplate.append("</Templates>");
                String template = sbTemplate.toString();
                int mdFlags = -2080350180;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setExplicitSearchString("", objectXML);
                filter.setOMRTemplate(template);
                filter.setOMRFlags(mdFlags);
                String sKey = object.getReposId() + "/" + object.getNativeType();
                root = server.browseFetch(sKey, (FilterInterface)filter);
                this.m_features.put(sObjectID, root);
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
        return root;
    }

    protected String getFeaturePopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            s_strTemplate = template.toString();
        }
        return this.getPopulateTemplate() + s_strTemplate;
    }

    protected List getFeaturePopulateAttributes() {
        ArrayList<String> s_lAttributes = null;
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList<String>();
            s_lAttributes.addAll(this.getPopulateAttributes());
            s_lAttributes.add("SourceFeatureMaps");
            s_lAttributes.add("Properties");
            s_lAttributes.add("Groups");
        }
        return s_lAttributes;
    }

    protected BrowseMetadataInterface getGroupMetadata(BrowseMetadataInterface object) {
        BrowseMetadataInterface root = null;
        String sObjectID = object.getReposId();
        root = this.m_groups.get(sObjectID);
        if (null == root) {
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            try {
                String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(object.getNativeType(), object.getReposId(), null, this.getGroupPopulateAttributes());
                sbTemplate.append(objectXML);
                sbTemplate.append(this.getGroupPopulateTemplate());
                sbTemplate.append("</Templates>");
                String template = sbTemplate.toString();
                int mdFlags = -2080350180;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setExplicitSearchString("", objectXML);
                filter.setOMRTemplate(template);
                filter.setOMRFlags(mdFlags);
                String sKey = object.getReposId() + "/" + object.getNativeType();
                root = server.browseFetch(sKey, (FilterInterface)filter);
                this.m_groups.put(sObjectID, root);
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
        return root;
    }

    protected String getGroupPopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            s_strTemplate = template.toString();
        }
        return this.getPopulateTemplate() + s_strTemplate;
    }

    protected List getGroupPopulateAttributes() {
        ArrayList<String> s_lAttributes = null;
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList<String>();
            s_lAttributes.addAll(this.getPopulateAttributes());
            s_lAttributes.add("Properties");
        }
        return s_lAttributes;
    }

    protected BrowseMetadataInterface getFeatureMapMetadata(BrowseMetadataInterface object) {
        BrowseMetadataInterface root = null;
        String sObjectID = object.getReposId();
        root = this.m_featureMaps.get(sObjectID);
        if (null == root) {
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            try {
                String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(object.getNativeType(), object.getReposId(), null, this.getFeatureMapPopulateAttributes());
                sbTemplate.append(objectXML);
                sbTemplate.append(this.getFeatureMapPopulateTemplate());
                sbTemplate.append("</Templates>");
                String template = sbTemplate.toString();
                int mdFlags = -2080350180;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                Filter filter = new Filter();
                filter.setExplicitSearchString("", objectXML);
                filter.setOMRTemplate(template);
                filter.setOMRFlags(mdFlags);
                String sKey = object.getReposId() + "/" + object.getNativeType();
                root = server.browseFetch(sKey, (FilterInterface)filter);
                this.m_featureMaps.put(sObjectID, root);
            }
            catch (ServiceException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
        return root;
    }

    protected String getFeatureMapPopulateTemplate() {
        String s_strTemplate = null;
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            s_strTemplate = template.toString();
        }
        return this.getPopulateTemplate() + s_strTemplate;
    }

    protected List getFeatureMapPopulateAttributes() {
        ArrayList<String> s_lAttributes = null;
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList<String>();
            s_lAttributes.addAll(this.getPopulateAttributes());
            s_lAttributes.add("FeatureSources");
            s_lAttributes.add("FeatureTargets");
        }
        return s_lAttributes;
    }

    protected String getDisplayNamePropertyValue(BrowseMetadataInterface browseObject) {
        String sDisplayName = "";
        List lProperties = (List)browseObject.get("Properties");
        if (lProperties != null) {
            for (int p = 0; p < lProperties.size(); ++p) {
                BrowseMetadataInterface property = (BrowseMetadataInterface)lProperties.get(p);
                if (property == null || !property.getName().equalsIgnoreCase("DisplayName")) continue;
                sDisplayName = (String)property.get("Desc");
                break;
            }
        }
        sDisplayName = sDisplayName.replaceAll(" ", "");
        return sDisplayName;
    }

    protected void processAsIncludedObject(BrowseMetadataInterface includedObject) {
        List lAssocObjects = (List)includedObject.get("Groups");
        for (int g = 0; g < lAssocObjects.size(); ++g) {
            List lProperties;
            BrowseMetadataInterface assocObject = (BrowseMetadataInterface)lAssocObjects.get(g);
            if (assocObject == null || (lProperties = (List)(assocObject = this.getGroupMetadata(assocObject)).get("Properties")) == null) continue;
            for (int p = 0; p < lProperties.size(); ++p) {
                String sActualID;
                BrowseMetadataInterface realObject;
                BrowseMetadataInterface property = (BrowseMetadataInterface)lProperties.get(p);
                if (!property.getName().equalsIgnoreCase("ActualObject") || (realObject = this.findRealObject(sActualID = (String)property.get("Desc"))) == null) continue;
                String sDisplayName = this.getDisplayNamePropertyValue(includedObject);
                LineageHelpers.addFeatureAsIncludedObject(this.m_wu, realObject, includedObject, sDisplayName);
            }
        }
    }

    protected void processAsDependentObject(BrowseMetadataInterface includedObject, BrowseMetadataInterface parentObject) {
        if (this.isBILineageObject(parentObject)) {
            String sDisplayName = this.getDisplayNamePropertyValue(includedObject);
            BrowseMetadataInterface dependentRealObject = this.getRealAssociatedObject(includedObject);
            String sDisplayName2 = this.getDisplayNamePropertyValue(parentObject);
            BrowseMetadataInterface dependentRealParentObject = this.getRealAssociatedObject(parentObject);
            LineageHelpers.addFeatureAsDependentObjectOfFeature(this.m_wu, parentObject, dependentRealParentObject, includedObject, dependentRealObject, sDisplayName2, sDisplayName);
        } else {
            String sDisplayName = this.getDisplayNamePropertyValue(includedObject);
            BrowseMetadataInterface dependentRealObject = this.getRealAssociatedObject(includedObject);
            LineageHelpers.addFeatureAsDependentObject(this.m_wu, parentObject, includedObject, sDisplayName, dependentRealObject);
        }
    }

    protected boolean isBILineageObject(BrowseMetadataInterface object) {
        String sBILrepos = this.m_BIReposID.substring(9);
        return sBILrepos.equals(object.getReposId().substring(0, 8));
    }

    protected BrowseMetadataInterface getRealAssociatedObject(BrowseMetadataInterface object) {
        List lProperties;
        BrowseMetadataInterface realObject = null;
        List lAssocObjects = (List)object.get("Groups");
        BrowseMetadataInterface assocObject = (BrowseMetadataInterface)lAssocObjects.get(0);
        if (assocObject != null && (lProperties = (List)(assocObject = this.getGroupMetadata(assocObject)).get("Properties")) != null) {
            for (int p = 0; p < lProperties.size(); ++p) {
                BrowseMetadataInterface property = (BrowseMetadataInterface)lProperties.get(p);
                if (!property.getName().equalsIgnoreCase("ActualObject")) continue;
                String sActualID = (String)property.get("Desc");
                realObject = this.findRealObject(sActualID);
                break;
            }
        }
        return realObject;
    }
}

