/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.runtimedetails.RuntimeDetailsTab;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.run.RunResults;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.wadmin.validate.ValidateResults;
import com.sas.workspace.WATextPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class WarningsAndErrorsTab
extends RuntimeDetailsTab {
    private static WAdminResource bundle = WAdminResource.getBundle(WarningsAndErrorsTab.class);
    public static final int DEFAULT_MAX_MESSAGES_PER_STEP = 20;
    public static final String MAX_MESSAGES_KEY = "WarningsAndErrorsTab.MaxMessagesPerStep";
    public static final String LINKACTION_CODE = "CODE";
    public static final String LINKACTION_LOG = "LOG";
    public static final String LINKACTION_PROPERTIES = "PROPERTIES";
    public static final String LINKACTION_SELECT = "SELECT";
    private RunModelListener m_lsrRun;
    private ValidateModelListener m_lsrValidate;
    private JToolBar m_toolbar;
    private WATextPane m_txtWarningsErrors;
    private JScrollPane m_scrWarningsErrors;
    private StringBuffer m_sbWarningsErrors;
    private boolean m_bCurrentRunSuccessful;
    private boolean m_bCurrentValidateSuccessful;
    private int m_iWarnings;
    private int m_iErrors;
    private int m_iLogLength;
    private boolean m_bShowCodeLinks;
    private boolean m_bShowLogLinks;

    public WarningsAndErrorsTab(RunModel runModel, boolean bShowCodeLinks, boolean bShowLogLinks) {
        this(runModel, null, bShowCodeLinks, bShowLogLinks);
    }

    public WarningsAndErrorsTab(RunModel runModel, ValidateModel validateModel, boolean bShowCodeLinks, boolean bShowLogLinks) {
        super(runModel, validateModel);
        this.setName(bundle.getString("WarningsAndErrorsTab.Name.txt"));
        this.m_bShowCodeLinks = bShowCodeLinks;
        this.m_bShowLogLinks = bShowLogLinks;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_lsrRun = this.createRunModelListener();
        this.m_mdlRun.addListener(this.m_lsrRun);
        if (this.m_mdlValidate != null) {
            this.m_lsrValidate = this.createValidateModelListener();
            this.m_mdlValidate.addListener(this.m_lsrValidate);
        }
        this.m_txtWarningsErrors = new WATextPane();
        this.m_txtWarningsErrors.setAutoSelect(false);
        this.m_txtWarningsErrors.setEditable(false);
        this.m_txtWarningsErrors.setEditorKit((EditorKit)new HTMLEditorKit());
        this.m_scrWarningsErrors = new JScrollPane((Component)this.m_txtWarningsErrors);
        this.m_scrWarningsErrors.setPreferredSize(new Dimension(200, 100));
        this.m_toolbar = WsUIUtilities.createToolBar();
        this.m_btnPrint = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.createPrintAction());
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_toolbar.add(this.m_btnPrint);
        this.add(this.m_toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_barCommon, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add(this.m_scrWarningsErrors, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlRun.removeListener(this.m_lsrRun);
        this.m_txtWarningsErrors.setEditorKit((EditorKit)new StyledEditorKit());
    }

    @Override
    public void setSelectedModelObjects(IObject[] aObjects) {
        this.setSelectionInProgress(true);
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] == null) continue;
            String key = String.valueOf(aObjects[iObject].hashCode());
            this.m_txtWarningsErrors.scrollToReference(key);
        }
        this.setSelectionInProgress(false);
    }

    public void clear() {
        this.m_sbWarningsErrors = new StringBuffer();
        this.m_txtWarningsErrors.setText("");
    }

    @Override
    protected void printTab() {
        String affiliateName = "";
        SimpleObject affiliate = this.m_mdlRun.getAffiliate();
        if (affiliate != null) {
            affiliateName = affiliate.getName();
        }
        String printTitle = bundle.formatString("WarningsAndErrorsTab.PrintTitle.fmt", (Object)affiliateName);
        this.printImpl((JComponent)this.m_txtWarningsErrors, printTitle);
    }

    public int getWarningCount() {
        return this.m_iWarnings;
    }

    public int getErrorCount() {
        return this.m_iErrors;
    }

    public void addHyperlinkListener(HyperlinkListener l) {
        this.m_txtWarningsErrors.addHyperlinkListener(l);
    }

    protected RunModelListener createRunModelListener() {
        return new cRunModelListener();
    }

    protected ValidateModelListener createValidateModelListener() {
        return new cValidateModelListener();
    }

    public void updateWarningsAndErrorsText() {
        if (this.m_bCurrentRunSuccessful) {
            this.m_txtWarningsErrors.setText(bundle.getString("WarningsAndErrorsTab.RunSuccessful.txt"));
        } else if (this.m_bCurrentValidateSuccessful) {
            this.m_txtWarningsErrors.setText(bundle.getString("WarningsAndErrorsTab.ValidateSuccessful.txt"));
        } else {
            this.m_txtWarningsErrors.setText(this.m_sbWarningsErrors.toString());
        }
        this.m_txtWarningsErrors.setCaretPosition(0);
    }

    private String buildFormattedMessage(String runObjectName, IObject runObject, String[] warningAndErrorMessages, int[] warningAndErrorStartLineNumbers, int[] warningAndErrorStartIndexes, int[] warningAndErrorEndIndexes) {
        URL transformIconURL;
        int maxMessages = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(MAX_MESSAGES_KEY, 20);
        String runObjectID = String.valueOf(runObject.hashCode());
        StringBuffer sb = new StringBuffer();
        sb.append("<a name=\"");
        sb.append(runObjectID);
        sb.append("\"");
        if (runObject instanceof ITransform && (transformIconURL = AppIconFactory.getAppInstance().getIconURLForTransformation(((ITransform)runObject).getType())) != null) {
            sb.append("<img src=\"");
            sb.append(transformIconURL);
            sb.append("\">&nbsp;");
        }
        sb.append("<a href=\"");
        sb.append("SCROLL");
        sb.append(":");
        sb.append(runObjectID);
        sb.append("\">");
        sb.append(runObjectName);
        sb.append("</a><br>");
        if (warningAndErrorMessages != null) {
            for (int i = 0; i < warningAndErrorMessages.length; ++i) {
                String message = warningAndErrorMessages[i];
                if (message.indexOf(RunResults.ERRORS_TAG) == 0 || message.indexOf(RunResults.ERRORS_TAG2) == 0) {
                    ++this.m_iErrors;
                    if (i < maxMessages) {
                        sb.append("<img src=\"");
                        sb.append(ERROR_ICON_URL);
                        sb.append("\">&nbsp;");
                    }
                } else if (message.indexOf(RunResults.WARNINGS_TAG) == 0 || message.indexOf(RunResults.WARNINGS_TAG2) == 0) {
                    ++this.m_iWarnings;
                    if (i < maxMessages) {
                        sb.append("<img src=\"");
                        sb.append(WARNING_ICON_URL);
                        sb.append("\">&nbsp;");
                    }
                }
                if (i < maxMessages) {
                    if (this.m_bShowLogLinks) {
                        sb.append("<a href=\"");
                        sb.append(LINKACTION_SELECT);
                        sb.append(":");
                        sb.append((Object)(warningAndErrorStartIndexes[i] + this.m_iLogLength));
                        sb.append(":");
                        sb.append((Object)(warningAndErrorEndIndexes[i] + this.m_iLogLength));
                        sb.append("\">");
                        sb.append(bundle.formatString("WarningsAndErrorsTab.LineNumber.fmt", (Object)warningAndErrorStartLineNumbers[i]));
                        sb.append("</a> ");
                    }
                    sb.append(message);
                    sb.append("<br><br>");
                    continue;
                }
                if (i != maxMessages) continue;
                if (maxMessages == 0) {
                    sb.append(bundle.getString("WarningsAndErrorsTab.TooManyMessages.None.txt"));
                } else if (maxMessages == 1) {
                    sb.append(bundle.getString("WarningsAndErrorsTab.TooManyMessages.One.txt"));
                } else {
                    sb.append(bundle.formatString("WarningsAndErrorsTab.TooManyMessages.Many.fmt.txt", (Object)Integer.toString(maxMessages)));
                }
                sb.append("<br><br>");
            }
        }
        sb.append("<b>");
        sb.append(bundle.getString("WarningsAndErrorsTab.See.txt"));
        sb.append("</b> <a href=\"");
        if (this.m_bShowCodeLinks) {
            sb.append(LINKACTION_CODE);
            sb.append(":");
            sb.append(runObjectID);
            sb.append("\">");
            sb.append(bundle.getString("WarningsAndErrorsTab.Code.txt"));
            sb.append("</a> | <a href=\"");
        }
        if (this.m_bShowLogLinks) {
            sb.append(LINKACTION_LOG);
            sb.append(":");
            sb.append(runObjectID);
            sb.append("\">");
            sb.append(bundle.getString("WarningsAndErrorsTab.Log.txt"));
            sb.append("</a> | <a href=\"");
        }
        sb.append(LINKACTION_PROPERTIES);
        sb.append(":");
        sb.append(runObjectID);
        sb.append("\">");
        sb.append(bundle.getString("WarningsAndErrorsTab.Properties.txt"));
        sb.append("</a><br><br>");
        return sb.toString();
    }

    private class cRunModelListener
    implements RunModelListener {
        private int m_iCurrentNode;

        private cRunModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            String sType = ev.getType();
            if ("RunStarted".equals(sType)) {
                WarningsAndErrorsTab.this.clear();
                this.m_iCurrentNode = -1;
                WarningsAndErrorsTab.this.m_bCurrentRunSuccessful = true;
                WarningsAndErrorsTab.this.m_bCurrentValidateSuccessful = false;
                WarningsAndErrorsTab.this.m_iWarnings = 0;
                WarningsAndErrorsTab.this.m_iErrors = 0;
                WarningsAndErrorsTab.this.m_iLogLength = 0;
            } else if ("SegmentCompleted".equals(sType)) {
                ++this.m_iCurrentNode;
                RunResults runResults = ev.getResults();
                IObject runObject = runResults.getModelObject();
                if (runResults.getStatus() != 0 && runResults.getStatus() != 5) {
                    WarningsAndErrorsTab.this.m_bCurrentRunSuccessful = false;
                    String name = runObject instanceof IUserWrittenCodeContainer ? (this.m_iCurrentNode == 0 ? bundle.getString("StatisticsTable.PreCode.txt") : (this.m_iCurrentNode == WarningsAndErrorsTab.this.m_mdlRun.getCodeSegments().length - 1 ? bundle.getString("StatisticsTable.PostCode.txt") : runObject.getName())) : runObject.getName();
                    WarningsAndErrorsTab.this.m_sbWarningsErrors.append(WarningsAndErrorsTab.this.buildFormattedMessage(name, runObject, runResults.getWarningsAndErrors(), runResults.getWarningsAndErrorsStartLineNumbers(), runResults.getWarningsAndErrorsStartIndexes(), runResults.getWarningsAndErrorsEndIndexes()));
                }
                WarningsAndErrorsTab.this.m_iLogLength += runResults.getLogLength();
            }
        }
    }

    private class cValidateModelListener
    implements ValidateModelListener {
        private int m_iCurrentNode;

        private cValidateModelListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
        }

        @Override
        public void validateEventHappened(ValidateEvent ev) {
            String sType = ev.getType();
            if ("ValidateStarted".equals(sType)) {
                WarningsAndErrorsTab.this.clear();
                this.m_iCurrentNode = -1;
                WarningsAndErrorsTab.this.m_bCurrentValidateSuccessful = true;
                WarningsAndErrorsTab.this.m_bCurrentRunSuccessful = false;
                WarningsAndErrorsTab.this.m_iWarnings = 0;
                WarningsAndErrorsTab.this.m_iErrors = 0;
                WarningsAndErrorsTab.this.m_iLogLength = 0;
            } else if ("SegmentCompleted".equals(sType)) {
                ++this.m_iCurrentNode;
                ValidateResults validateResults = ev.getResults();
                IObject validateObject = validateResults.getModelObject();
                if (validateResults.getStatus() != 0) {
                    WarningsAndErrorsTab.this.m_bCurrentValidateSuccessful = false;
                    String name = validateObject instanceof IUserWrittenCodeContainer ? (this.m_iCurrentNode == 0 ? bundle.getString("StatisticsTable.PreCode.txt") : (this.m_iCurrentNode == WarningsAndErrorsTab.this.m_mdlValidate.getCodeSegments().length - 1 ? bundle.getString("StatisticsTable.PostCode.txt") : validateObject.getName())) : validateObject.getName();
                    WarningsAndErrorsTab.this.m_sbWarningsErrors.append(WarningsAndErrorsTab.this.buildFormattedMessage(name, validateObject, validateResults.getWarningsAndErrors(), validateResults.getWarningsAndErrorsStartLineNumbers(), validateResults.getWarningsAndErrorsStartIndexes(), validateResults.getWarningsAndErrorsEndIndexes()));
                }
                WarningsAndErrorsTab.this.m_iLogLength += validateResults.getLogLength();
            }
        }
    }
}

