/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.runtimedetails.AnimatedImageObserver;
import com.sas.wadmin.jobeditor.runtimedetails.RuntimeDetailsTab;
import com.sas.wadmin.jobeditor.runtimedetails.StatusTableModel;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.run.RunResults;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.wadmin.validate.ValidateResults;
import com.sas.workspace.WATextPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class StatusTab
extends RuntimeDetailsTab {
    private static WAdminResource bundle = WAdminResource.getBundle(StatusTab.class);
    public static final String STATUS_SUCCESS = bundle.getString("StatusTableModel.StatusColumn.Success.txt");
    public static final String STATUS_WARNING = bundle.getString("StatusTableModel.StatusColumn.Warning.txt");
    public static final String STATUS_ERROR = bundle.getString("StatusTableModel.StatusColumn.Error.txt");
    public static final String STATUS_STOP = bundle.getString("StatusTableModel.StatusColumn.RunStopped.txt");
    public static final String STATUS_ABORT = bundle.getString("StatusTableModel.StatusColumn.RunAborted.txt");
    public static final String STATUS_INCOMPLETE = bundle.getString("StatusTableModel.StatusColumn.Incomplete.txt");
    public static final String STATUS_EXCLUDED = bundle.getString("StatusTableModel.StatusColumn.Excluded.txt");
    public static final String STATUS_UNSUPPORTED = bundle.getString("StatusTableModel.StatusColumn.Unsupported.txt");
    public static final String STATUS_PROCESSING_LOG = bundle.getString("StatusTableModel.StatusColumn.ProcessingLog.txt");
    public static final String STATUS_IN_PROGRESS = bundle.getString("StatusTableModel.StatusColumn.InProgress.txt");
    public static final String STATUS_CPRSKIPPED = bundle.getString("StatusTableModel.StatusColumn.CPRSkipped.txt");
    public static final String LINKACTION_WARNING = "WARNING";
    public static final String LINKACTION_ERROR = "ERROR";
    public static final int MODE_VALIDATE = 0;
    public static final int MODE_RUN = 1;
    private RunModelListener m_lsrRun;
    private ValidateModelListener m_lsrValidate;
    private JToolBar m_toolbar;
    private JButton m_btnTableView;
    private JButton m_btnDetailView;
    private WsTable m_tblStatus;
    private StatusTableModel m_mdlStatus;
    private JScrollPane m_scrStatusTable;
    private WATextPane m_txtStatus;
    private JScrollPane m_scrStatusList;
    private int m_iMode;
    private StringBuffer m_sbStatusDetails;
    protected WsAbstractToggleAction m_actTableView;
    protected WsAbstractToggleAction m_actDetailView;

    public StatusTab(RunModel runModel) {
        this(runModel, null);
    }

    public StatusTab(RunModel runModel, ValidateModel validateModel) {
        super(runModel, validateModel);
        this.setName(bundle.getString("StatusTab.Name.txt"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_lsrRun = this.createRunModelListener();
        this.m_mdlRun.addListener(this.m_lsrRun);
        this.m_lsrValidate = this.createValidateModelListener();
        this.m_mdlValidate.addListener(this.m_lsrValidate);
        this.m_actTableView = this.createTableViewAction();
        this.m_actDetailView = this.createDetailViewAction();
        this.m_toolbar = WsUIUtilities.createToolBar();
        this.m_btnTableView = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.m_actTableView);
        this.m_btnDetailView = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.m_actDetailView);
        this.m_btnPrint = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.createPrintAction());
        this.m_mdlStatus = new StatusTableModel();
        this.m_tblStatus = new WsTable((WsAbstractTableModel)this.m_mdlStatus);
        this.m_scrStatusTable = new JScrollPane((Component)this.m_tblStatus);
        this.m_scrStatusTable.setPreferredSize(new Dimension(200, 100));
        this.m_tblStatus.setEditable(false);
        this.m_tblStatus.setColumnHidingEnabled(false);
        this.m_tblStatus.setColumnHoldingEnabled(false);
        this.m_tblStatus.setRowHoldingEnabled(false);
        this.m_tblStatus.setColumnsReorderable(false);
        this.m_tblStatus.setRowHeaderPopupMenuEnabled(false);
        this.m_tblStatus.setAutoResizeMode(4);
        this.m_tblStatus.setColumnAutoResizeMode(4);
        this.m_tblStatus.setRowHeaderVisible(false);
        this.m_tblStatus.setDoubleBuffered(true);
        this.m_txtStatus = new WATextPane();
        this.m_txtStatus.setAutoSelect(false);
        this.m_txtStatus.setEditable(false);
        this.m_txtStatus.setEditorKit((EditorKit)new HTMLEditorKit());
        this.m_scrStatusList = new JScrollPane((Component)this.m_txtStatus);
        this.m_scrStatusList.setPreferredSize(new Dimension(200, 100));
        this.m_actTableView.setSelected(true);
        this.m_scrStatusList.setVisible(false);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_toolbar.add(this.m_btnTableView);
        this.m_toolbar.add(this.m_btnDetailView);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.m_btnPrint);
        this.add(this.m_toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_barCommon, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add(this.m_scrStatusTable, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrStatusList, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlRun.removeListener(this.m_lsrRun);
        this.m_txtStatus.setEditorKit((EditorKit)new StyledEditorKit());
    }

    @Override
    protected void printTab() {
        String affiliateName = "";
        SimpleObject affiliate = this.m_mdlRun.getAffiliate();
        if (affiliate != null) {
            affiliateName = affiliate.getName();
        }
        String printTitle = bundle.formatString("StatusTab.PrintTitle.fmt", (Object)affiliateName);
        if (this.m_actDetailView.isSelected()) {
            this.printImpl((JComponent)this.m_txtStatus, printTitle);
        } else {
            this.printImpl((JComponent)this.m_tblStatus, printTitle);
        }
    }

    public void addHyperlinkListener(HyperlinkListener l) {
        this.m_txtStatus.addHyperlinkListener(l);
    }

    public void addMouseListenerToTable(MouseListener l) {
        this.m_tblStatus.addMouseListener(l);
    }

    public WsTable getStatusTable() {
        return this.m_tblStatus;
    }

    public void setMode(int iMode) {
        if (iMode != 1 && iMode != 0) {
            throw new IllegalArgumentException("illegal mode: " + iMode);
        }
        if (this.m_iMode == iMode) {
            return;
        }
        this.m_iMode = iMode;
    }

    public int getMode() {
        return this.m_iMode;
    }

    @Override
    public void setSelectedModelObjects(IObject[] aObjects) {
        int iObject;
        this.setSelectionInProgress(true);
        this.m_tblStatus.clearSelection();
        for (iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] == null) continue;
            int[] aRows = this.m_mdlStatus.findRows(4, aObjects[iObject]);
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                this.m_tblStatus.addRowToSelection(this.m_tblStatus.convertRowIndexToView(aRows[iRow]));
            }
        }
        for (iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] == null) continue;
            String key = String.valueOf(aObjects[iObject].hashCode());
            this.m_txtStatus.scrollToReference(key);
        }
        this.setSelectionInProgress(false);
    }

    public void showDetailView() {
        this.m_scrStatusList.setVisible(true);
        this.m_scrStatusTable.setVisible(false);
        this.revalidate();
        this.m_actDetailView.setSelected(true);
        this.m_actTableView.setSelected(false);
        int[] selectedRows = this.m_tblStatus.getSelectedRowsFromSelectedCells();
        IObject[] selectedObjects = new IObject[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedObjects[i] = (IObject)this.m_mdlStatus.getValueAt(selectedRows[i], 4);
        }
        this.setSelectedModelObjects(selectedObjects);
    }

    public void showTableView() {
        this.m_scrStatusList.setVisible(false);
        this.m_scrStatusTable.setVisible(true);
        this.m_actTableView.setSelected(true);
        this.m_actDetailView.setSelected(false);
    }

    public void clear() {
        this.m_tblStatus.clearSelection();
        this.m_mdlStatus.clear();
        this.m_txtStatus.setText("");
        this.m_sbStatusDetails = new StringBuffer();
    }

    protected WsAbstractToggleAction createTableViewAction() {
        return new cTableViewAction();
    }

    protected WsAbstractToggleAction createDetailViewAction() {
        return new cDetailViewAction();
    }

    protected RunModelListener createRunModelListener() {
        return new cStatusRunModelListener();
    }

    protected ValidateModelListener createValidateModelListener() {
        return new cStatusValidateModelListener();
    }

    private String buildFormattedMessage(int messageType, String runObjectName, IObject runObject, String message) {
        String runObjectID = null;
        StringBuffer sb = new StringBuffer();
        if (runObject != null) {
            URL transformIconURL;
            runObjectID = String.valueOf(runObject.hashCode());
            if (runObject instanceof ITransform && (transformIconURL = AppIconFactory.getAppInstance().getIconURLForTransformation(((ITransform)runObject).getType())) != null) {
                sb.append("<img src=\"");
                sb.append(transformIconURL);
                sb.append("\">&nbsp;");
            }
            sb.append("<a name=\"");
            sb.append(runObjectID);
            sb.append("\"");
            sb.append("<a href=\"");
            sb.append("SCROLL");
            sb.append(":");
            sb.append(runObjectID);
            sb.append("\">");
            sb.append(runObjectName);
            sb.append("</a><br>");
        } else {
            sb.append(runObjectName);
            sb.append("<br>");
        }
        sb.append(bundle.getString("StatusTab.StatusPrefix.txt"));
        sb.append(" ");
        sb.append("<img src=\"");
        if (messageType == 4) {
            sb.append(ABORT_ICON_URL);
            sb.append("\"> ");
            sb.append(STATUS_ABORT);
        } else if (messageType == 3) {
            sb.append(STOP_ICON_URL);
            sb.append("\"> ");
            sb.append(STATUS_STOP);
        } else if (messageType == 2) {
            sb.append(ERROR_ICON_URL);
            sb.append("\"> ");
            sb.append("<a href=\"");
            sb.append(LINKACTION_ERROR);
            sb.append(":");
            sb.append(runObjectID);
            sb.append("\">");
            sb.append(STATUS_ERROR);
            sb.append("</a>");
        } else if (messageType == 1) {
            sb.append(WARNING_ICON_URL);
            sb.append("\"> ");
            sb.append("<a href=\"");
            sb.append(LINKACTION_WARNING);
            sb.append(":");
            sb.append(runObjectID);
            sb.append("\">");
            sb.append(STATUS_WARNING);
            sb.append("</a>");
        } else if (runObject instanceof ICodeGenerator && !((ICodeGenerator)runObject).isCodeGenerationEnabled()) {
            sb.append(EXCLUDED_ICON_URL);
            sb.append("\"> ");
            sb.append(STATUS_EXCLUDED);
        } else if (runObject instanceof ITransform && !((ITransform)runObject).isCompleteWithUserWritten()) {
            sb.append(INCOMPLETE_ICON_URL);
            sb.append("\"> ");
            sb.append(STATUS_INCOMPLETE);
        } else if (runObject instanceof ITransform && !((ITransform)runObject).isValidateAvailable() && this.getMode() == 0) {
            sb.append(INCOMPLETE_ICON_URL);
            sb.append("\"> ");
            sb.append(STATUS_UNSUPPORTED);
        } else {
            sb.append(SUCCESS_ICON_URL);
            sb.append("\"> ");
            sb.append(STATUS_SUCCESS);
        }
        sb.append("<br>");
        if (message != null && message.length() > 0) {
            sb.append(message);
            sb.append("<br>");
        }
        sb.append("<br>");
        return sb.toString();
    }

    private class cTableViewAction
    extends WsAbstractToggleAction {
        public cTableViewAction() {
            super(bundle, "StatusTab.cTableViewAction", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("TableView"));
        }

        public void actionPerformed(ActionEvent e) {
            StatusTab.this.showTableView();
        }
    }

    private class cDetailViewAction
    extends WsAbstractToggleAction {
        public cDetailViewAction() {
            super(bundle, "StatusTab.cDetailViewAction", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("DetailsView"));
        }

        public void actionPerformed(ActionEvent e) {
            StatusTab.this.showDetailView();
        }
    }

    private class cStatusRunModelListener
    implements RunModelListener {
        private int m_iCurrentNode;
        private int m_iParsingNode;
        private int m_iJobStatus;

        private cStatusRunModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            block11: {
                String sType;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    sType = ev.getType();
                                    if (ev.getCodeSegment() instanceof ICodeSegment && ev.getCodeSegment().isClientGeneratedSegment()) {
                                        return;
                                    }
                                    if (!"RunStarted".equals(sType)) break block10;
                                    StatusTab.this.clear();
                                    StatusTab.this.setMode(1);
                                    this.m_iCurrentNode = -1;
                                    this.m_iParsingNode = -1;
                                    this.m_iJobStatus = 0;
                                    break block11;
                                }
                                if (!"SegmentStarted".equals(sType)) break block12;
                                ++this.m_iCurrentNode;
                                ICodeSegment segment = ev.getCodeSegment();
                                StatusTab.this.m_mdlStatus.insertRowForObject(segment.getName(), segment.getModelObject(), true, false);
                                ImageIcon icon = (ImageIcon)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 6);
                                AnimatedImageObserver imageObserver = new AnimatedImageObserver((JTable)StatusTab.this.m_tblStatus, this.m_iCurrentNode, 6);
                                icon.setImageObserver(imageObserver);
                                break block11;
                            }
                            if (!"SegmentParsing".equals(sType)) break block13;
                            Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 2);
                            if (currentStatus == null || !currentStatus.equals(STATUS_IN_PROGRESS)) break block11;
                            StatusTab.this.m_mdlStatus.setValueAt(STATUS_PROCESSING_LOG, this.m_iCurrentNode, 2);
                            break block11;
                        }
                        if (!"SegmentCompleted".equals(sType)) break block14;
                        ++this.m_iParsingNode;
                        ImageIcon icon = (ImageIcon)StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 6);
                        icon.setImageObserver(null);
                        Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2);
                        if (currentStatus != null && (currentStatus.equals(STATUS_STOP) || currentStatus.equals(STATUS_ABORT))) {
                            return;
                        }
                        RunResults runResults = ev.getResults();
                        int iSegmentStatus = runResults.getStatus();
                        String[] details = runResults.getDetails();
                        StringBuffer detailsBuffer = new StringBuffer();
                        StringBuffer detailsColumnValue = new StringBuffer();
                        if (ev.getResults().getPushDown() != null) {
                            ((IDataTransform)ev.getResults().getModelObject()).updateDBMSExecutionType();
                        }
                        if (details.length > 0) {
                            detailsBuffer.append("<ul>");
                            for (int i = 0; i < details.length; ++i) {
                                detailsBuffer.append("<li>");
                                String messageText = details[i];
                                String messageText2 = messageText.replaceAll("<", "&lt;");
                                detailsBuffer.append(messageText2);
                                detailsBuffer.append("</li>");
                                detailsColumnValue.append(details[i]).append("  ");
                            }
                            detailsBuffer.append("</ul>");
                        }
                        StatusTab.this.m_mdlStatus.setValueAt(detailsColumnValue.toString(), this.m_iParsingNode, 3);
                        StatusTab.this.m_sbStatusDetails.append(StatusTab.this.buildFormattedMessage(iSegmentStatus, (String)StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 1), (IObject)StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 4), detailsBuffer.toString()));
                        StatusTab.this.m_txtStatus.setText(StatusTab.this.m_sbStatusDetails.toString());
                        this.updateTableWithStatus(iSegmentStatus);
                        break block11;
                    }
                    if (!"RunCompleted".equals(sType)) break block15;
                    ++this.m_iCurrentNode;
                    ++this.m_iParsingNode;
                    SimpleObject runAffiliate = StatusTab.this.m_mdlRun.getAffiliate();
                    if (!(runAffiliate instanceof IJob) || this.m_iCurrentNode <= 1) break block11;
                    IJob job = (IJob)runAffiliate;
                    StatusTab.this.m_mdlStatus.insertRowForObject(job.getName(), (IObject)job, false, false);
                    this.updateTableWithStatus(this.m_iJobStatus);
                    StatusTab.this.m_mdlStatus.setValueAt(AppIconFactory.getInstance().getIconForPublicType(job.getPublicType()), this.m_iCurrentNode, 5);
                    break block11;
                }
                if ("RunAborted".equals(sType) && this.m_iCurrentNode > -1) {
                    StatusTab.this.m_sbStatusDetails.append(StatusTab.this.buildFormattedMessage(4, (String)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 1), (IObject)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 4), ""));
                    StatusTab.this.m_txtStatus.setText(StatusTab.this.m_sbStatusDetails.toString());
                    StatusTab.this.m_mdlStatus.setValueAt(STATUS_ABORT, this.m_iCurrentNode, 2);
                    StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunAborted.image"), this.m_iCurrentNode, 6);
                    for (int i = this.m_iCurrentNode - 1; i >= 0; --i) {
                        Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(i, 2);
                        if (currentStatus == null || !currentStatus.equals(STATUS_IN_PROGRESS) && !currentStatus.equals(STATUS_PROCESSING_LOG)) continue;
                        StatusTab.this.m_mdlStatus.setValueAt(STATUS_ABORT, i, 2);
                        StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunAborted.image"), i, 6);
                    }
                } else if ("RunStopped".equals(sType)) {
                    StatusTab.this.m_sbStatusDetails.append(StatusTab.this.buildFormattedMessage(3, (String)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 1), (IObject)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 4), ""));
                    StatusTab.this.m_txtStatus.setText(StatusTab.this.m_sbStatusDetails.toString());
                    StatusTab.this.m_mdlStatus.setValueAt(STATUS_STOP, this.m_iCurrentNode, 2);
                    StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunStopped.image"), this.m_iCurrentNode, 6);
                    for (int i = this.m_iCurrentNode - 1; i >= 0; --i) {
                        Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(i, 2);
                        if (currentStatus == null || !currentStatus.equals(STATUS_IN_PROGRESS) && !currentStatus.equals(STATUS_PROCESSING_LOG)) continue;
                        StatusTab.this.m_mdlStatus.setValueAt(STATUS_STOP, i, 2);
                        StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunStopped.image"), i, 6);
                    }
                }
            }
        }

        private void updateTableWithStatus(int iStatus) {
            if (iStatus == 0) {
                if (!StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_EXCLUDED) && !StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_INCOMPLETE)) {
                    StatusTab.this.m_mdlStatus.setValueAt(STATUS_SUCCESS, this.m_iParsingNode, 2);
                    StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.Success.image"), this.m_iParsingNode, 6);
                }
            } else if (iStatus == 1) {
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_WARNING, this.m_iParsingNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.Warning.image"), this.m_iParsingNode, 6);
                if (this.m_iJobStatus != 2) {
                    this.m_iJobStatus = 1;
                }
            } else if (iStatus == 2) {
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_ERROR, this.m_iParsingNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.Error.image"), this.m_iParsingNode, 6);
                this.m_iJobStatus = 2;
            } else if (iStatus == 4) {
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_ABORT, this.m_iCurrentNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunAborted.image"), this.m_iCurrentNode, 6);
                this.m_iJobStatus = 4;
            } else if (iStatus == 5 && !StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_EXCLUDED) && !StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_INCOMPLETE)) {
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_CPRSKIPPED, this.m_iParsingNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.NeutralStatus.image"), this.m_iParsingNode, 6);
            }
        }
    }

    private class cStatusValidateModelListener
    implements ValidateModelListener {
        private int m_iCurrentNode;
        private int m_iParsingNode;
        private int m_iJobStatus;

        private cStatusValidateModelListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
        }

        @Override
        public void validateEventHappened(ValidateEvent ev) {
            String sType = ev.getType();
            if ("ValidateStarted".equals(sType)) {
                StatusTab.this.clear();
                StatusTab.this.setMode(0);
                this.m_iCurrentNode = -1;
                this.m_iParsingNode = -1;
                this.m_iJobStatus = 0;
            } else if ("SegmentStarted".equals(sType)) {
                ++this.m_iCurrentNode;
                ICodeSegment segment = ev.getCodeSegment();
                StatusTab.this.m_mdlStatus.insertRowForObject(segment.getName(), segment.getModelObject(), true, true);
                ImageIcon icon = (ImageIcon)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 6);
                AnimatedImageObserver imageObserver = new AnimatedImageObserver((JTable)StatusTab.this.m_tblStatus, this.m_iCurrentNode, 6);
                icon.setImageObserver(imageObserver);
            } else if ("SegmentParsing".equals(sType)) {
                Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 2);
                if (currentStatus != null && currentStatus.equals(STATUS_IN_PROGRESS)) {
                    StatusTab.this.m_mdlStatus.setValueAt(STATUS_PROCESSING_LOG, this.m_iCurrentNode, 2);
                }
            } else if ("SegmentCompleted".equals(sType)) {
                ++this.m_iParsingNode;
                ImageIcon icon = (ImageIcon)StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 6);
                icon.setImageObserver(null);
                Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2);
                if (currentStatus != null && currentStatus.equals(STATUS_STOP)) {
                    return;
                }
                ValidateResults validateResults = ev.getResults();
                int iSegmentStatus = validateResults.getStatus();
                StringBuffer detailsBuffer = new StringBuffer();
                if (validateResults.getPushDown() != null) {
                    String sPushDown = validateResults.getPushDown().trim();
                    ((IDataTransform)validateResults.getModelObject()).updateDBMSExecutionType();
                    if (sPushDown.equals("0")) {
                        detailsBuffer.append(bundle.formatString("StatusTab.ProcessingOn.txt", (Object)validateResults.getPushDownDBMSType()));
                    } else if (validateResults.getPushDownDBMSType() == null || validateResults.getPushDownDBMSType() == "SAS") {
                        detailsBuffer.append(bundle.getString("StatusTab.NoProcessingOnSAS.txt"));
                    } else {
                        detailsBuffer.append(bundle.formatString("StatusTab.NoProcessingOn.txt", (Object)validateResults.getPushDownDBMSType()));
                    }
                } else {
                    String[] details = validateResults.getDetails();
                    if (details.length > 0) {
                        for (int i = 0; i < details.length; ++i) {
                            detailsBuffer.append(details[i]);
                            detailsBuffer.append("  ");
                        }
                    }
                }
                String detailsMessage = detailsBuffer.toString();
                StatusTab.this.m_mdlStatus.setValueAt(detailsMessage, this.m_iParsingNode, 3);
                StatusTab.this.m_sbStatusDetails.append(StatusTab.this.buildFormattedMessage(iSegmentStatus, (String)StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 1), (IObject)StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 4), detailsMessage));
                StatusTab.this.m_txtStatus.setText(StatusTab.this.m_sbStatusDetails.toString());
                this.updateTableWithStatus(iSegmentStatus);
            } else if ("ValidateCompleted".equals(sType)) {
                ++this.m_iCurrentNode;
                ++this.m_iParsingNode;
                SimpleObject validateAffiliate = StatusTab.this.m_mdlValidate.getAffiliate();
                if (validateAffiliate instanceof IJob && this.m_iCurrentNode > 1) {
                    IJob job = (IJob)validateAffiliate;
                    StatusTab.this.m_mdlStatus.insertRowForObject(job.getName(), (IObject)job, false, false);
                    this.updateTableWithStatus(this.m_iJobStatus);
                    StatusTab.this.m_mdlStatus.setValueAt(AppIconFactory.getInstance().getIconForPublicType(job.getPublicType()), this.m_iCurrentNode, 5);
                }
            } else if ("ValidateStopped".equals(sType)) {
                StatusTab.this.m_sbStatusDetails.append(StatusTab.this.buildFormattedMessage(3, (String)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 1), (IObject)StatusTab.this.m_mdlStatus.getValueAt(this.m_iCurrentNode, 4), ""));
                StatusTab.this.m_txtStatus.setText(StatusTab.this.m_sbStatusDetails.toString());
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_STOP, this.m_iCurrentNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunStopped.image"), this.m_iCurrentNode, 6);
                for (int i = this.m_iCurrentNode - 1; i >= 0; --i) {
                    Object currentStatus = StatusTab.this.m_mdlStatus.getValueAt(i, 2);
                    if (currentStatus == null || !currentStatus.equals(STATUS_IN_PROGRESS) && !currentStatus.equals(STATUS_PROCESSING_LOG)) continue;
                    StatusTab.this.m_mdlStatus.setValueAt(STATUS_STOP, i, 2);
                    StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.RunStopped.image"), i, 6);
                }
            }
        }

        private void updateTableWithStatus(int iStatus) {
            if (iStatus == 0) {
                if (!(StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_EXCLUDED) || StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_INCOMPLETE) || StatusTab.this.m_mdlStatus.getValueAt(this.m_iParsingNode, 2).equals(STATUS_UNSUPPORTED))) {
                    StatusTab.this.m_mdlStatus.setValueAt(STATUS_SUCCESS, this.m_iParsingNode, 2);
                    StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.Success.image"), this.m_iParsingNode, 6);
                }
            } else if (iStatus == 1) {
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_WARNING, this.m_iParsingNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.Warning.image"), this.m_iParsingNode, 6);
                if (this.m_iJobStatus != 2) {
                    this.m_iJobStatus = 1;
                }
            } else if (iStatus == 2) {
                StatusTab.this.m_mdlStatus.setValueAt(STATUS_ERROR, this.m_iParsingNode, 2);
                StatusTab.this.m_mdlStatus.setValueAt(bundle.getImageIcon("StatusTableModel.Error.image"), this.m_iParsingNode, 6);
                this.m_iJobStatus = 2;
            }
        }
    }
}

