/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.graphics.components.Graph;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.runtimedetails.RuntimeDetailsTab;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsBarChartPanel;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsGraphTableModel;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsLineChartPanel;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsSelectionPanel;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsTableModel;
import com.sas.wadmin.jobeditor.runtimedetails.StatusTab;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.run.RunResults;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsFileChooser;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class StatisticsTab
extends RuntimeDetailsTab {
    private static WAdminResource bundle = WAdminResource.getBundle(StatisticsTab.class);
    private IJob m_job;
    private RunModelListener m_lsrRun;
    private StatisticsLineChartPanel m_lineChartPanel;
    private StatisticsBarChartPanel m_barChartPanel;
    private StatisticsGraphTableModel m_graphModel;
    private StatisticsSelectionPanel m_selectPanel;
    private WsTable m_tblStatistics;
    private StatisticsTableModel m_mdlStatistics;
    private boolean m_perfStatsEnabled;
    private JToolBar m_toolbar;
    private JToolBar m_barSelect;
    private JButton m_btnDetailView;
    private JButton m_btnGraphView;
    private JButton m_btnGraphSaveToFile;
    private JButton m_btnSaveAsTableToFile;
    private JButton m_btnSelect;
    private JRadioButton m_rbnGraphLineButton;
    private JRadioButton m_rbnGraphBarButton;
    private JScrollPane m_scrStatisticsTable;
    private WAPanel m_statisticsPanel;
    private WAPanel m_noStatsPanel;
    private JLabel m_noStats;
    private CardLayout m_statisticsCards;
    private cLoadPerfDataModelListener m_listener;
    private PerfModel m_mdlPerfData;
    private WAComboBox m_cmbSelectTransformations;
    private boolean m_editable = true;
    private double m_hwmMemVal = 0.0;
    private double m_jobStartTime = 0.0;
    private double m_jobEndTime = 0.0;
    private double m_jobCpuTime = 0.0;
    private double m_jobMemory = 0.0;
    private double m_jobDuration = 0.0;
    private double m_jobIO = 0.0;
    private double m_jobThreads = 0.0;
    private boolean m_isSummary;
    private boolean m_isLoop;
    private double m_stepHwmMemVal = 0.0;
    private double m_stepStartTime = 0.0;
    private double m_stepEndTime = 0.0;
    private double m_stepCpuTime = 0.0;
    private double m_stepMemory = 0.0;
    private double m_stepDuration = 0.0;
    private double m_stepIO = 0.0;
    private double m_stepThreads = 0.0;
    private SimpleDateFormat m_formatter;
    private TimeZone m_tzd;
    private SASDateTimeFormat m_dtFormat;
    private Calendar m_cal;
    private String m_jobName;
    protected WsAbstractToggleAction m_actDetailView;
    protected WsAbstractToggleAction m_actGraphView;
    protected WsAbstractToggleAction m_actGraphTypeView;
    protected WsAbstractToggleAction m_actSelectView;
    protected WsAbstractToggleAction m_actGraphSaveToFile;
    protected WsAppServer m_defaultAppserver;
    protected WsAbstractAction m_actPrint;
    protected WsAbstractToggleAction m_actSaveTableToFile;
    protected WsAbstractToggleAction m_actSaveAsTableToFile;
    private final String m_strTabularView = "Tabular";
    private final String m_strLineChartView = "LineChart";
    private final String m_strBarChartView = "BarChart";
    private final String m_strEmptyView = "Empty";
    private final int TABULAR = 0;
    private final int LINECHART = 1;
    private final int BARCHART = 2;
    private final int EMPTY = 3;
    private final String SUMMARY = "SUMM";
    private final int TRANID = 0;
    private final int SERVER = 1;
    private final int SUBSTEP = 2;
    private final int ARMRECORDCOUNT = 7;
    private final int ARMMEMCURRENT = 6;
    private final int ARMMEMHIGH = 9;
    private final int ARMTHREADCURRENT = 10;
    private final int ARMTHREADHIGH = 11;
    private final int ARMIOCOUNT = 12;
    private final int ARMIOCOUNT2 = 13;
    private final int ARMSYSTEMCPUTIME = 14;
    private final int ARMTRANRESPTIME = 15;
    private final int ARMTRANSTARTTIME = 16;
    private final int ARMTRANSTOPTIME = 17;
    private WAStandardDialog m_dialog;

    public StatisticsTab(IJob job, RunModel runModel) {
        super(runModel);
        this.m_job = job;
        this.setName(bundle.getString("StatisticsTab.Name.txt"));
        this.setSourcePanel(3);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setPreferredSize(new Dimension(20, 0));
        this.m_graphModel = new StatisticsGraphTableModel();
        this.m_actDetailView = this.createDetailViewAction();
        this.m_actGraphView = this.createGraphViewAction();
        this.m_actSelectView = this.createSelectViewAction();
        this.m_actPrint = this.createPrintAction();
        this.m_actSaveAsTableToFile = this.createSaveAsTableToFileAction();
        this.m_actGraphSaveToFile = this.createGraphSaveToFileAction();
        this.setupRadioButtons();
        this.m_toolbar = WsUIUtilities.createToolBar();
        this.m_barSelect = WsUIUtilities.createToolBar();
        this.m_btnDetailView = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.m_actDetailView);
        this.m_btnGraphView = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.m_actGraphView);
        this.m_btnSelect = WsUIUtilities.createFlatTextButton((WsAbstractAction)this.m_actSelectView);
        this.m_btnSelect.setEnabled(false);
        this.m_btnPrint = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actPrint);
        this.m_btnGraphSaveToFile = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.m_actGraphSaveToFile);
        this.m_actGraphSaveToFile.setEnabled(false);
        this.m_btnSaveAsTableToFile = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.m_actSaveAsTableToFile);
        this.m_btnSaveAsTableToFile.setEnabled(this.m_perfStatsEnabled);
        this.m_mdlStatistics = new StatisticsTableModel();
        this.m_tblStatistics = new WsTable((WsAbstractTableModel)this.m_mdlStatistics);
        this.m_scrStatisticsTable = new JScrollPane((Component)this.m_tblStatistics);
        this.m_scrStatisticsTable.setPreferredSize(new Dimension(20, 0));
        this.m_tblStatistics.removeColumn(17);
        this.m_tblStatistics.removeColumn(18);
        this.m_tblStatistics.removeColumn(19);
        this.m_tblStatistics.removeColumn(13);
        this.m_tblStatistics.removeColumn(2);
        this.m_tblStatistics.setColumnHeaderToolTipsEnabled(true);
        this.m_mdlStatistics.createColumnTooltips();
        this.m_tblStatistics.setEditable(false);
        this.m_tblStatistics.setColumnHidingEnabled(true);
        this.m_tblStatistics.setColumnHoldingEnabled(true);
        this.m_tblStatistics.setRowHoldingEnabled(false);
        this.m_tblStatistics.setColumnsReorderable(true);
        this.m_tblStatistics.setRowHeaderPopupMenuEnabled(false);
        this.m_tblStatistics.setRowHeaderVisible(false);
        this.m_mdlPerfData = new PerfModel();
        this.m_listener = new cLoadPerfDataModelListener();
        this.m_mdlPerfData.addListener(this.m_listener);
        this.m_graphModel.setPerfModel(this.m_mdlPerfData);
        this.m_lsrRun = this.createRunModelListener(this.m_mdlStatistics, this.m_graphModel);
        this.m_mdlRun.addListener(this.m_lsrRun);
        this.m_statisticsCards = new CardLayout();
        this.m_statisticsPanel = new WAPanel();
        this.m_barChartPanel = new StatisticsBarChartPanel();
        this.m_lineChartPanel = new StatisticsLineChartPanel(this.m_mdlStatistics);
        this.m_noStatsPanel = new WAPanel();
        this.m_noStats = new JLabel(bundle.getString("StatisticsTab.NoPerformanceStats.txt"));
        this.m_selectPanel = new StatisticsSelectionPanel();
        this.m_selectPanel.setSelectionListener(this.m_lineChartPanel.getSelectionListener());
        this.m_cmbSelectTransformations = new WAComboBox();
        this.initializeComboBox();
        this.m_cmbSelectTransformations.addActionListener((ActionListener)new cSelectTransformationsListener());
        this.m_actDetailView.setSelected(true);
    }

    public void setupRadioButtons() {
        this.m_rbnGraphLineButton = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"StatisticsTab.GraphLineType", (int)5);
        this.m_rbnGraphBarButton = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"StatisticsTab.GraphBarType", (int)5);
        this.listenForDataChangesTo(this.m_rbnGraphLineButton);
        this.listenForDataChangesTo(this.m_rbnGraphBarButton);
        cGraphTypeViewAction graphTypeAction = new cGraphTypeViewAction();
        this.m_rbnGraphLineButton.addActionListener(graphTypeAction);
        this.m_rbnGraphBarButton.addActionListener(graphTypeAction);
        ButtonGroup grpMissingValues = new ButtonGroup();
        grpMissingValues.add(this.m_rbnGraphLineButton);
        grpMissingValues.add(this.m_rbnGraphBarButton);
        this.m_rbnGraphLineButton.setSelected(true);
        this.m_rbnGraphLineButton.setEnabled(false);
        this.m_rbnGraphBarButton.setEnabled(false);
    }

    public void initializeComboBox() {
        this.m_cmbSelectTransformations.removeAllItems();
        this.m_cmbSelectTransformations.addItem((Object)bundle.getString("StatisticsTab.SelectAllTransformations.txt"));
        this.m_cmbSelectTransformations.addItem(WAComboBox.SEPARATOR);
        this.m_cmbSelectTransformations.setEnabled(false);
    }

    public void moveDataToView() {
    }

    protected void layoutWidgets() {
        this.m_statisticsPanel.setLayout((LayoutManager)this.m_statisticsCards);
        this.m_statisticsPanel.add((Component)this.m_scrStatisticsTable, (Object)"Tabular");
        this.m_statisticsPanel.add((Component)this.m_lineChartPanel, (Object)"LineChart");
        this.m_statisticsPanel.add((Component)this.m_barChartPanel, (Object)"BarChart");
        this.m_statisticsPanel.add((Component)this.m_noStatsPanel, (Object)"Empty");
        this.m_noStatsPanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_noStatsPanel.add((Component)this.m_noStats, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_toolbar.add(this.m_btnDetailView);
        this.m_toolbar.add(this.m_btnGraphView);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.m_btnPrint);
        this.m_toolbar.add(this.m_btnGraphSaveToFile);
        this.m_toolbar.add(this.m_btnSaveAsTableToFile);
        this.m_barSelect.add(this.m_btnSelect);
        this.setLayout(new GridBagLayout());
        this.add(this.m_toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
        this.add(this.m_rbnGraphLineButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_barSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
        this.add(this.m_rbnGraphBarButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
        this.add((Component)this.m_cmbSelectTransformations, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_barCommon, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_statisticsPanel, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void setSourcePanel(int iType) {
        switch (iType) {
            case 0: {
                this.m_statisticsCards.show((Container)this.m_statisticsPanel, "Tabular");
                break;
            }
            case 1: {
                this.m_statisticsCards.show((Container)this.m_statisticsPanel, "LineChart");
                break;
            }
            case 2: {
                this.m_statisticsCards.show((Container)this.m_statisticsPanel, "BarChart");
                break;
            }
            case 3: {
                this.m_statisticsCards.show((Container)this.m_statisticsPanel, "Empty");
            }
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_editable = bEditable;
    }

    public Dimension getMinimumSize() {
        Dimension d = new Dimension(150, 150);
        return d;
    }

    public void addMouseListenerToTable(MouseListener l) {
        this.m_tblStatistics.addMouseListener(l);
    }

    public WsTable getStatisticsTable() {
        return this.m_tblStatistics;
    }

    @Override
    public void setSelectedModelObjects(IObject[] aObjects) {
        this.setSelectionInProgress(true);
        if (this.m_actDetailView.isSelected()) {
            this.m_tblStatistics.clearSelection();
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (aObjects[iObject] == null) continue;
                int[] aRows = this.m_mdlStatistics.findRows(23, aObjects[iObject]);
                for (int iRow = 0; iRow < aRows.length; ++iRow) {
                    this.m_tblStatistics.addRowToSelection(this.m_tblStatistics.convertRowIndexToView(aRows[iRow]));
                }
            }
        }
        this.setSelectionInProgress(false);
    }

    public void clear() {
        this.m_perfStatsEnabled = false;
        this.m_tblStatistics.clearSelection();
        this.m_mdlStatistics.clear();
        this.m_actGraphView.setEnabled(false);
        this.m_btnSelect.setEnabled(false);
        this.m_actGraphSaveToFile.setEnabled(false);
        this.m_rbnGraphLineButton.setEnabled(false);
        this.m_rbnGraphBarButton.setEnabled(false);
        this.initializeComboBox();
        this.setSourcePanel(3);
        this.m_selectPanel.resetSelections();
        this.m_lineChartPanel.resetGraphAttributes();
        this.m_lineChartPanel.setGraphModel(null);
        this.m_lineChartPanel.setGraphResponseVariables();
        this.m_lineChartPanel.setGraphColors();
        this.m_barChartPanel.resetModel();
        this.m_barChartPanel.setGraphModel(null);
    }

    @Override
    protected void printTab() {
        String printTitle = bundle.formatString("StatisticsTab.PrintTitle.fmt", (Object)this.m_job.getName());
        if (this.m_btnDetailView.isSelected()) {
            this.printImpl((JComponent)this.m_tblStatistics, printTitle);
        } else if (this.m_btnGraphView.isSelected()) {
            Object graph = this.m_rbnGraphLineButton.isSelected() ? this.m_lineChartPanel.getLinePlot() : this.m_barChartPanel.getBarChart();
            this.printImpl((JComponent)graph, printTitle);
        }
    }

    public void saveAsFile(Graph graph, int width, int height, String name) {
        String sFileName;
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sDefaultDirectoryKey = "StatisticsTab.SaveToFile.DefaultDirectory";
        String sDefaultPath = appDefaults.getPropertyString(sDefaultDirectoryKey, "");
        WsFileChooser dlg = new WsFileChooser(sDefaultPath);
        dlg.setFileSelectionMode(0);
        dlg.setMultiSelectionEnabled(false);
        dlg.setDialogTitle(bundle.getString("StatisticsTab.SaveToFileDialog.Title.txt"));
        if (this.m_jobName == null) {
            this.m_jobName = name;
        }
        if (!(sFileName = this.m_rbnGraphLineButton.isSelected() ? this.m_jobName + bundle.getString("StatisticsTab.JobName_linevalue.txt.notrans") : this.m_jobName + bundle.getString("StatisticsTab.JobName_barvalue.txt.notrans")).endsWith(".png")) {
            sFileName = sFileName + ".png";
        }
        dlg.setSelectedFile(new File(sFileName));
        if (dlg.showSaveDialog((Component)Workspace.getWorkspace()) == 0) {
            File file = dlg.getSelectedFile();
            this.saveToPNG(graph, width, height, file);
            appDefaults.setPropertyString(sDefaultDirectoryKey, dlg.getCurrentDirectory().getPath());
        }
    }

    private void saveToPNG(Graph graph, int width, int height, File file) {
        BufferedImage i = new BufferedImage(width, height, 1);
        Graphics2D ig = i.createGraphics();
        Rectangle b = new Rectangle(0, 0, i.getWidth(null), i.getHeight(null));
        graph.setAutoRepaintEnabled(false);
        graph.addNotify();
        graph.setBounds(0, 0, b.width, b.height);
        graph.prepareToPaint();
        graph.paintAll((Graphics)ig);
        try {
            ImageIO.write((RenderedImage)i, "PNG", file);
        }
        catch (IOException f) {
            System.err.println("Error: Saving image to disk.");
        }
        graph.setAutoRepaintEnabled(true);
    }

    protected WsAbstractToggleAction createDetailViewAction() {
        return new cDetailViewAction();
    }

    protected WsAbstractToggleAction createGraphViewAction() {
        return new cGraphViewAction();
    }

    protected WsAbstractToggleAction createGraphSaveToFileAction() {
        return new cGraphSaveToFileAction();
    }

    protected WsAbstractToggleAction createSelectViewAction() {
        return new cSelectViewAction();
    }

    protected RunModelListener createRunModelListener(StatisticsTableModel tModel, StatisticsGraphTableModel graphModel) {
        return new cRunModelListener(tModel, graphModel);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlRun.removeListener(this.m_lsrRun);
    }

    public List tokenizeList(String[] inList) {
        ArrayList<String> procList = new ArrayList<String>();
        ArrayList<ArrayList<String>> outList = new ArrayList<ArrayList<String>>();
        if (inList == null) {
            return outList;
        }
        for (int i = 0; i < inList.length; ++i) {
            String inMessage = inList[i];
            if (inMessage.indexOf(RunResults.DIS_ARM_PROC_TAG) != 0 && inMessage.indexOf(RunResults.DIS_ARM_DISARM_TAG) != 0) continue;
            StringTokenizer st = new StringTokenizer(inList[i], "|");
            while (st.hasMoreTokens()) {
                String tokenValue = st.nextToken();
                if (tokenValue.indexOf("_DISARM") != -1 || tokenValue.indexOf("_ENDDISARM") != -1) continue;
                procList.add(tokenValue);
            }
            outList.add(procList);
            procList = new ArrayList();
        }
        return outList;
    }

    public List tokenizeList(String inList) {
        ArrayList<String> outList = new ArrayList<String>();
        String inMessage = inList;
        if (inMessage.indexOf(RunResults.DIS_ARM_PROC_TAG) == 0 || inMessage.indexOf(RunResults.DIS_ARM_DISARM_TAG) == 0) {
            StringTokenizer st = new StringTokenizer(inList, "|");
            while (st.hasMoreTokens()) {
                String tokenValue = st.nextToken();
                if (tokenValue.indexOf("_DISARM") != -1 || tokenValue.indexOf("_ENDDISARM") != -1) continue;
                outList.add(tokenValue);
            }
        }
        return outList;
    }

    protected WsAbstractToggleAction createSaveAsTableToFileAction() {
        return new cSaveAsTableToFileAction();
    }

    protected String buildCSVFile(WsTable tab, boolean hdr_rec) {
        WsTable statTable = tab;
        StringBuffer csvFile = new StringBuffer();
        if (hdr_rec) {
            for (int k = 0; k < statTable.getColumnCount(); ++k) {
                if (k > 0) {
                    csvFile.append(",");
                }
                csvFile.append(statTable.getColumnName(k).trim());
            }
            csvFile.append("\n");
        }
        for (int i = 0; i < statTable.getRowCount(); ++i) {
            for (int j = 0; j < statTable.getColumnCount(); ++j) {
                if (j > 0) {
                    csvFile.append(",");
                }
                csvFile.append(statTable.getValueAt(i, j));
            }
            csvFile.append("\n");
        }
        return csvFile.toString();
    }

    protected WsAppServer getWsAppServer() {
        if (this.m_defaultAppserver != null) {
            return this.m_defaultAppserver;
        }
        this.m_defaultAppserver = WsAppServer.createDefaultAppServer((boolean)true);
        if (this.m_defaultAppserver == null) {
            MessageUtil.displayMessage((String)bundle.getString("StatisticsTab.NoAppserverError.txt"), (String)bundle.getString("StatisticsTab.AppserverError.title.txt"), (int)0);
            return null;
        }
        try {
            this.m_defaultAppserver.open();
        }
        catch (WsAppServerFailException failException) {
            return null;
        }
        return this.m_defaultAppserver;
    }

    private void saveLogFile() {
        int rc;
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sDefaultFileName = appDefaults.getPropertyString("StatisticsTab.SaveToCSV.DefaultFileName", "");
        int startPos = sDefaultFileName.lastIndexOf("\\") + 1;
        String baseName = sDefaultFileName.substring(startPos, sDefaultFileName.length());
        File selectedFile = new File(baseName);
        String fullFileName = null;
        JFileChooser fc = new JFileChooser(sDefaultFileName);
        fc.setDialogType(1);
        fc.setFileSelectionMode(2);
        fc.addChoosableFileFilter(new CsvFilter());
        fc.setAcceptAllFileFilterUsed(false);
        if (selectedFile != null) {
            fc.setSelectedFile(selectedFile);
        }
        if ((rc = fc.showSaveDialog((Component)((Object)this))) == 0) {
            File file = fc.getSelectedFile();
            fullFileName = file.getPath();
        }
        if (fullFileName != null) {
            TransformManager.exportSourcetoFile(fullFileName, this.buildCSVFile(this.m_tblStatistics, true), null);
            appDefaults.setPropertyString("StatisticsTab.SaveToCSV.DefaultFileName", fullFileName);
        }
    }

    public class PerfModel {
        public static final String MODEL_UPDATED = "ModelUpdated";
        public static final String MODEL_NOT_UPDATED = "ModelNotUpdated";
        public static final int INACTIVE = 0;
        public static final int RUNNING = 1;
        private List m_lListeners = new ArrayList();
        private int m_eState = 0;

        public void setState(int eState) {
            if (this.m_eState == eState) {
                return;
            }
            this.m_eState = eState;
            this.fireModelEvent(MODEL_UPDATED);
        }

        public int getState() {
            return this.m_eState;
        }

        public void addListener(EventListener lsnr) {
            this.m_lListeners.add(lsnr);
        }

        public void removeListener(EventListener lsnr) {
            this.m_lListeners.remove(lsnr);
        }

        public void run() {
            if (this.m_eState == 1) {
                throw new UnsupportedOperationException("Can not run while waiting for run to complete");
            }
            this.setState(1);
            new BuildDataModelThread().start();
        }

        public void fireModelEvent(String sEventType) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new FireModelEventRunnable(sEventType));
                return;
            }
            cLoadPerfDataModelEvent ev = new cLoadPerfDataModelEvent(this, sEventType);
            for (int iListener = 0; iListener < this.m_lListeners.size(); ++iListener) {
                cLoadPerfDataModelListener lsnr = (cLoadPerfDataModelListener)this.m_lListeners.get(iListener);
                lsnr.perfDataModelEventHappened(ev);
            }
        }

        public class BuildDataModelThread
        extends Thread {
            public BuildDataModelThread() {
                super("Build Data Model");
            }

            @Override
            public void run() {
                PerfModel.this.fireModelEvent(PerfModel.MODEL_NOT_UPDATED);
            }
        }

        public class FireModelEventRunnable
        implements Runnable {
            private String m_sEventType;

            FireModelEventRunnable(String sEventType) {
                this.m_sEventType = sEventType;
            }

            @Override
            public void run() {
                PerfModel.this.fireModelEvent(this.m_sEventType);
            }
        }
    }

    public class cLoadPerfDataModelListener
    implements EventListener {
        public void perfDataModelEventHappened(cLoadPerfDataModelEvent ev) {
            if ("ModelUpdated".equals(ev.getType())) {
                if (SwingUtilities.isEventDispatchThread()) {
                    StatisticsTab.this.m_lineChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                    StatisticsTab.this.m_barChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                    if (StatisticsTab.this.m_actGraphView.isSelected()) {
                        if (StatisticsTab.this.m_rbnGraphLineButton.isSelected()) {
                            StatisticsTab.this.setSourcePanel(1);
                            StatisticsTab.this.m_lineChartPanel.moveDataToView();
                            StatisticsTab.this.m_cmbSelectTransformations.setEnabled(false);
                            StatisticsTab.this.m_actSelectView.setEnabled(true);
                        } else if (StatisticsTab.this.m_rbnGraphBarButton.isSelected()) {
                            StatisticsTab.this.setSourcePanel(2);
                            StatisticsTab.this.m_cmbSelectTransformations.setEnabled(true);
                            StatisticsTab.this.m_barChartPanel.moveDataToView();
                        }
                    } else if (StatisticsTab.this.m_actDetailView.isSelected()) {
                        StatisticsTab.this.setSourcePanel(0);
                        StatisticsTab.this.m_cmbSelectTransformations.setEnabled(false);
                    }
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (StatisticsTab.this.m_actGraphView.isEnabled()) {
                                    if (StatisticsTab.this.m_rbnGraphLineButton.isSelected()) {
                                        StatisticsTab.this.setSourcePanel(1);
                                        StatisticsTab.this.m_lineChartPanel.moveDataToView();
                                    } else {
                                        StatisticsTab.this.setSourcePanel(2);
                                        StatisticsTab.this.m_barChartPanel.moveDataToView();
                                    }
                                } else if (StatisticsTab.this.m_actDetailView.isEnabled()) {
                                    StatisticsTab.this.setSourcePanel(0);
                                }
                                StatisticsTab.this.m_lineChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                                StatisticsTab.this.m_barChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                    }
                }
            }
        }
    }

    public class cSelectTransformationsListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            int indx = StatisticsTab.this.m_cmbSelectTransformations.getSelectedIndex();
            Object obj = StatisticsTab.this.m_cmbSelectTransformations.getSelectedItem();
            if (indx > -1) {
                StatisticsTab.this.m_barChartPanel.moveDataToView(indx, obj);
            }
        }
    }

    private class cGraphTypeViewAction
    implements ActionListener {
        private cGraphTypeViewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StatisticsTab.this.m_rbnGraphLineButton.isSelected()) {
                if (!StatisticsTab.this.m_perfStatsEnabled) {
                    StatisticsTab.this.setSourcePanel(3);
                } else {
                    StatisticsTab.this.setSourcePanel(1);
                    StatisticsTab.this.m_btnSelect.setEnabled(StatisticsTab.this.m_editable);
                    StatisticsTab.this.m_cmbSelectTransformations.setEnabled(false);
                    StatisticsTab.this.m_lineChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                    StatisticsTab.this.m_lineChartPanel.moveDataToView();
                }
            } else if (!StatisticsTab.this.m_perfStatsEnabled) {
                StatisticsTab.this.setSourcePanel(3);
            } else {
                StatisticsTab.this.setSourcePanel(2);
                StatisticsTab.this.m_btnSelect.setEnabled(false);
                StatisticsTab.this.m_cmbSelectTransformations.setEnabled(StatisticsTab.this.m_editable);
                StatisticsTab.this.m_barChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                StatisticsTab.this.m_barChartPanel.moveDataToView();
            }
        }
    }

    private class cDetailViewAction
    extends WsAbstractToggleAction {
        public cDetailViewAction() {
            super(bundle, "StatisticsTab.cDetailViewAction", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("TableView"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!StatisticsTab.this.m_perfStatsEnabled) {
                StatisticsTab.this.setSourcePanel(3);
            } else {
                StatisticsTab.this.setSourcePanel(0);
                StatisticsTab.this.m_btnSaveAsTableToFile.setEnabled(true);
            }
            StatisticsTab.this.m_actGraphView.setSelected(false);
            StatisticsTab.this.m_actSelectView.setSelected(false);
            StatisticsTab.this.m_rbnGraphLineButton.setEnabled(false);
            StatisticsTab.this.m_rbnGraphBarButton.setEnabled(false);
            StatisticsTab.this.m_actGraphSaveToFile.setEnabled(false);
            StatisticsTab.this.m_cmbSelectTransformations.setEnabled(false);
            StatisticsTab.this.m_btnSelect.setEnabled(false);
        }
    }

    private class cGraphViewAction
    extends WsAbstractToggleAction {
        public cGraphViewAction() {
            super(bundle, "StatisticsTab.cGraphViewAction", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("GraphView"));
        }

        public void actionPerformed(ActionEvent e) {
            StatisticsTab.this.m_rbnGraphLineButton.setEnabled(StatisticsTab.this.m_editable);
            StatisticsTab.this.m_rbnGraphBarButton.setEnabled(StatisticsTab.this.m_editable);
            StatisticsTab.this.m_actGraphSaveToFile.setEnabled(StatisticsTab.this.m_editable);
            StatisticsTab.this.m_btnSaveAsTableToFile.setEnabled(false);
            if (StatisticsTab.this.m_rbnGraphLineButton.isSelected()) {
                if (!StatisticsTab.this.m_perfStatsEnabled) {
                    StatisticsTab.this.setSourcePanel(3);
                } else {
                    StatisticsTab.this.setSourcePanel(1);
                    StatisticsTab.this.m_btnSelect.setEnabled(StatisticsTab.this.m_editable);
                    StatisticsTab.this.m_cmbSelectTransformations.setEnabled(false);
                    StatisticsTab.this.m_lineChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                    StatisticsTab.this.m_lineChartPanel.moveDataToView();
                    StatisticsTab.this.m_lineChartPanel.setPreferredSize(new Dimension(20, 0));
                }
            } else if (!StatisticsTab.this.m_perfStatsEnabled) {
                StatisticsTab.this.setSourcePanel(3);
            } else {
                StatisticsTab.this.setSourcePanel(2);
                StatisticsTab.this.m_btnSelect.setEnabled(false);
                StatisticsTab.this.m_cmbSelectTransformations.setEnabled(StatisticsTab.this.m_editable);
                StatisticsTab.this.m_barChartPanel.setGraphModel(StatisticsTab.this.m_graphModel.getTableModel());
                StatisticsTab.this.m_barChartPanel.moveDataToView();
                StatisticsTab.this.m_barChartPanel.setPreferredSize(new Dimension(20, 0));
            }
            StatisticsTab.this.m_actDetailView.setSelected(false);
        }
    }

    private class cGraphSaveToFileAction
    extends WsAbstractToggleAction {
        public cGraphSaveToFileAction() {
            super(bundle, "StatisticsTab.cGraphSaveToFileAction", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("PrintToFile"));
        }

        public void actionPerformed(ActionEvent e) {
            if (StatisticsTab.this.m_btnGraphView.isSelected()) {
                Object graph = StatisticsTab.this.m_rbnGraphLineButton.isSelected() ? StatisticsTab.this.m_lineChartPanel.getLinePlot() : StatisticsTab.this.m_barChartPanel.getBarChart();
                StatisticsTab.this.saveAsFile((Graph)graph, 680, 480, bundle.getString("StatisticsTab.FilenameDefault.txt.notrans"));
            }
        }
    }

    private class cSelectViewAction
    extends WsAbstractToggleAction {
        public cSelectViewAction() {
            super(bundle, "StatisticsTab.cSelectViewAction", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("TableView"));
        }

        public void actionPerformed(ActionEvent e) {
            StatisticsTab.this.m_dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("StatisticsTab.SelectStatisticsVariables.txt"), true);
            StatisticsTab.this.m_dialog.setMainPanel((WAPanel)StatisticsTab.this.m_selectPanel);
            StatisticsTab.this.m_dialog.setEditable(true);
            StatisticsTab.this.m_dialog.setOKButtonVisible(false);
            StatisticsTab.this.m_dialog.setCloseButtonVisible(true);
            StatisticsTab.this.m_dialog.setApplyButtonVisible(true);
            StatisticsTab.this.m_dialog.setCancelButtonVisible(false);
            StatisticsTab.this.m_dialog.setHelpButtonVisible(false);
            StatisticsTab.this.m_dialog.setResizable(false);
            StatisticsTab.this.m_dialog.show();
        }
    }

    private class cRunModelListener
    implements RunModelListener {
        private int m_iCurrentNode;
        private int m_iNodeNumber;
        private StatisticsTableModel m_statsModel;
        private StatisticsGraphTableModel m_graphTableModel;
        private String m_innerStepName;
        private String m_stepName;
        private int m_iJobStatus;
        private List armTokenList;

        public cRunModelListener(StatisticsTableModel statsModel, StatisticsGraphTableModel graphTableModel) {
            this.m_statsModel = statsModel;
            this.m_graphTableModel = graphTableModel;
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            String sType = ev.getType();
            if ("RunStarted".equals(sType)) {
                StatisticsTab.this.clear();
                this.m_iCurrentNode = -1;
                this.m_iJobStatus = 0;
                StatisticsTab.this.m_jobStartTime = 0.0;
                StatisticsTab.this.m_jobEndTime = 0.0;
                StatisticsTab.this.m_jobCpuTime = 0.0;
                StatisticsTab.this.m_jobMemory = 0.0;
                StatisticsTab.this.m_jobDuration = 0.0;
                StatisticsTab.this.m_jobIO = 0.0;
                StatisticsTab.this.m_jobThreads = 0.0;
                StatisticsTab.this.m_hwmMemVal = 0.0;
                StatisticsTab.this.m_stepStartTime = 0.0;
                StatisticsTab.this.m_stepEndTime = 0.0;
                StatisticsTab.this.m_stepCpuTime = 0.0;
                StatisticsTab.this.m_stepMemory = 0.0;
                StatisticsTab.this.m_stepDuration = 0.0;
                StatisticsTab.this.m_stepIO = 0.0;
                StatisticsTab.this.m_stepThreads = 0.0;
                StatisticsTab.this.m_stepHwmMemVal = 0.0;
                this.m_iNodeNumber = 0;
                StatisticsTab.this.m_isSummary = false;
                StatisticsTab.this.m_perfStatsEnabled = false;
                this.m_statsModel.clear();
            } else if ("SegmentCompleted".equals(sType)) {
                String name;
                IObject modelObject = ev.getCodeSegment().getModelObject();
                if (modelObject instanceof ITransform) {
                    ITransform transform = (ITransform)modelObject;
                    int node = transform.getJob().getControlOrderedTransformsList().indexOf(transform) + 1;
                    this.m_stepName = name = bundle.formatString("StatisticsTab.NodeNameAndNumber.fmt", (Object)modelObject.getName(), (Object)node);
                } else {
                    if (!modelObject.getName().trim().equals("SUMM")) {
                        if (this.m_statsModel.getRowCount() == 0) {
                            modelObject = StatisticsTab.this.m_job.getPreProcessCode().getUserWrittenSourceCode();
                            name = bundle.getString("StatisticsTable.PreCode.txt");
                        } else {
                            modelObject = StatisticsTab.this.m_job.getPostProcessCode().getUserWrittenSourceCode();
                            name = bundle.getString("StatisticsTable.PostCode.txt");
                        }
                    } else {
                        name = modelObject.getName();
                    }
                    this.m_stepName = name;
                    this.m_innerStepName = name;
                }
                RunResults runResults = ev.getResults();
                int iSegmentStatus = runResults.getStatus();
                int iLoopValue = 0;
                String[] messageList = runResults.getARMMessages();
                int msgSize = messageList.length;
                StatisticsTab.this.m_isLoop = false;
                StatisticsTab.this.m_isSummary = false;
                if (msgSize > 1) {
                    StatisticsTab.this.m_isLoop = true;
                }
                for (int i = 0; i < msgSize; ++i) {
                    Date nd;
                    long jdt;
                    double dVal;
                    List armTokens = StatisticsTab.this.tokenizeList(messageList[i]);
                    if (armTokens.size() <= 0) continue;
                    String tranid = (String)armTokens.get(0);
                    String subStepName = (String)armTokens.get(2);
                    if (subStepName.trim().length() > 0) {
                        if (subStepName.trim().equals("SUMM")) {
                            StatisticsTab.this.m_isSummary = true;
                        } else if (!subStepName.trim().equals("NULL")) {
                            this.m_innerStepName = subStepName;
                        }
                    }
                    if (StatisticsTab.this.m_isLoop) {
                        StringBuffer stepName = new StringBuffer();
                        StatisticsTab.this.m_perfStatsEnabled = true;
                        int ctr = i + 1;
                        stepName.append(this.m_innerStepName).append(" :");
                        stepName.append(ctr);
                        StatisticsTab.this.m_cmbSelectTransformations.addItem((Object)stepName.toString());
                        this.m_statsModel.insertRow(stepName.toString(), ev.getCodeSegment().getModelObject(), true);
                        this.m_iCurrentNode = this.m_statsModel.getRowCount() - 1;
                        this.updateTableWithStatus(iSegmentStatus);
                    } else {
                        if (StatisticsTab.this.m_isSummary) {
                            if (StatisticsTab.this.m_perfStatsEnabled) {
                                this.m_statsModel.insertRow(this.m_stepName, ev.getCodeSegment().getModelObject(), true);
                                this.m_iCurrentNode = this.m_statsModel.getRowCount() - 1;
                                this.updateTableWithStatus(iSegmentStatus);
                                StatisticsTab.this.m_stepDuration = StatisticsTab.this.m_stepEndTime - StatisticsTab.this.m_stepStartTime;
                                StatisticsTab.this.m_dtFormat.setTimeZone(StatisticsTab.this.m_tzd);
                                long jdt2 = SASDateTimeFormat.SASDateTimeToJavaDate((double)StatisticsTab.this.m_stepStartTime);
                                Date nd2 = new Date(jdt2);
                                StatisticsTab.this.m_cal.setTime(nd2);
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_formatter.format(StatisticsTab.this.m_cal.getTime()), this.m_iCurrentNode, 5);
                                StatisticsTab.this.m_dtFormat.setTimeZone(StatisticsTab.this.m_tzd);
                                jdt2 = SASDateTimeFormat.SASDateTimeToJavaDate((double)StatisticsTab.this.m_stepEndTime);
                                nd2 = new Date(jdt2);
                                StatisticsTab.this.m_cal.setTime(nd2);
                                if (StatisticsTab.this.m_stepMemory == 0.0) {
                                    StatisticsTab.this.m_stepMemory = StatisticsTab.this.m_stepHwmMemVal;
                                } else if (StatisticsTab.this.m_stepMemory < StatisticsTab.this.m_stepHwmMemVal) {
                                    StatisticsTab.this.m_stepMemory = StatisticsTab.this.m_stepHwmMemVal;
                                }
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_formatter.format(StatisticsTab.this.m_cal.getTime()), this.m_iCurrentNode, 6);
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_stepDuration, this.m_iCurrentNode, 7);
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_stepCpuTime, this.m_iCurrentNode, 8);
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_stepMemory, this.m_iCurrentNode, 10);
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_stepIO, this.m_iCurrentNode, 12);
                                this.m_statsModel.setValueAt(StatisticsTab.this.m_stepThreads, this.m_iCurrentNode, 15);
                                this.m_statsModel.setValueAt("", this.m_iCurrentNode, 14);
                                StatisticsTab.this.m_stepStartTime = 0.0;
                                StatisticsTab.this.m_stepEndTime = 0.0;
                                StatisticsTab.this.m_stepCpuTime = 0.0;
                                StatisticsTab.this.m_stepMemory = 0.0;
                                StatisticsTab.this.m_stepDuration = 0.0;
                                StatisticsTab.this.m_stepIO = 0.0;
                                StatisticsTab.this.m_stepThreads = 0.0;
                                StatisticsTab.this.m_stepHwmMemVal = 0.0;
                            }
                            break;
                        }
                        this.m_statsModel.insertRow(this.m_stepName, ev.getCodeSegment().getModelObject(), true);
                        iLoopValue = this.m_statsModel.getRowCount();
                        this.m_iCurrentNode = iLoopValue - 1;
                        this.updateTableWithStatus(iSegmentStatus);
                        StatisticsTab.this.m_perfStatsEnabled = true;
                        StatisticsTab.this.m_cmbSelectTransformations.addItem((Object)this.m_stepName);
                    }
                    this.m_statsModel.setValueAt(tranid, this.m_iCurrentNode, 22);
                    String sRecords = ((String)armTokens.get(7)).trim();
                    Double iRecords = sRecords.length() == 0 ? Double.valueOf(0.0) : Double.valueOf(sRecords);
                    if (iRecords < 0.0) {
                        iRecords = 0.0;
                    }
                    this.m_statsModel.setValueAt(iRecords, this.m_iCurrentNode, 4);
                    String dt = "";
                    StatisticsTab.this.m_dtFormat = (SASDateTimeFormat)SASFormat.getInstance((String)"nldatmap.");
                    StatisticsTab.this.m_tzd = TimeZone.getTimeZone("GMT-00:00");
                    StatisticsTab.this.m_cal = Calendar.getInstance();
                    StatisticsTab.this.m_formatter = new SimpleDateFormat("MM/dd/yyyy 'at' hh:mm:ss a zzz");
                    String sVal = (String)armTokens.get(16);
                    if (sVal.trim().length() == 0) {
                        dVal = 0.0;
                        dt = "0";
                    } else {
                        dVal = Double.parseDouble(sVal);
                        StatisticsTab.this.m_dtFormat.setTimeZone(StatisticsTab.this.m_tzd);
                        jdt = SASDateTimeFormat.SASDateTimeToJavaDate((double)dVal);
                        nd = new Date(jdt);
                        StatisticsTab.this.m_cal.setTime(nd);
                        dt = StatisticsTab.this.m_formatter.format(StatisticsTab.this.m_cal.getTime());
                    }
                    if (StatisticsTab.this.m_jobStartTime == 0.0) {
                        StatisticsTab.this.m_jobStartTime = dVal;
                    } else if (StatisticsTab.this.m_jobStartTime > dVal) {
                        StatisticsTab.this.m_jobStartTime = dVal;
                    }
                    if (StatisticsTab.this.m_isLoop) {
                        if (StatisticsTab.this.m_stepStartTime == 0.0) {
                            StatisticsTab.this.m_stepStartTime = dVal;
                        } else if (StatisticsTab.this.m_stepStartTime > dVal) {
                            StatisticsTab.this.m_stepStartTime = dVal;
                        }
                    }
                    this.m_statsModel.setValueAt(String.valueOf(dVal), this.m_iCurrentNode, 17);
                    this.m_statsModel.setValueAt(dt, this.m_iCurrentNode, 5);
                    sVal = (String)armTokens.get(17);
                    if (sVal.trim().length() == 0) {
                        dVal = 0.0;
                        dt = "0";
                    } else {
                        dVal = Double.parseDouble(sVal);
                        StatisticsTab.this.m_dtFormat.setTimeZone(StatisticsTab.this.m_tzd);
                        jdt = SASDateTimeFormat.SASDateTimeToJavaDate((double)dVal);
                        nd = new Date(jdt);
                        StatisticsTab.this.m_cal.setTime(nd);
                        dt = StatisticsTab.this.m_formatter.format(StatisticsTab.this.m_cal.getTime());
                    }
                    if (StatisticsTab.this.m_jobEndTime == 0.0) {
                        StatisticsTab.this.m_jobEndTime = dVal;
                    } else if (StatisticsTab.this.m_jobEndTime < dVal) {
                        StatisticsTab.this.m_jobEndTime = dVal;
                    }
                    if (StatisticsTab.this.m_isLoop) {
                        if (StatisticsTab.this.m_stepEndTime == 0.0) {
                            StatisticsTab.this.m_stepEndTime = dVal;
                        } else if (StatisticsTab.this.m_stepEndTime < dVal) {
                            StatisticsTab.this.m_stepEndTime = dVal;
                        }
                    }
                    this.m_statsModel.setValueAt(String.valueOf(dVal), this.m_iCurrentNode, 20);
                    this.m_statsModel.setValueAt(dt, this.m_iCurrentNode, 6);
                    sVal = ((String)armTokens.get(15)).trim();
                    if (sVal.length() == 0) {
                        sVal = "0";
                    }
                    this.m_statsModel.setValueAt(Double.valueOf(sVal), this.m_iCurrentNode, 7);
                    this.m_statsModel.setValueAt(sVal, this.m_iCurrentNode, 18);
                    sVal = (String)armTokens.get(14);
                    if (sVal.trim().length() == 0) {
                        dVal = 0.0;
                        sVal = "0";
                    } else {
                        dVal = Double.parseDouble(sVal);
                    }
                    StatisticsTab.this.m_jobCpuTime = StatisticsTab.this.m_jobCpuTime + dVal;
                    if (StatisticsTab.this.m_isLoop) {
                        StatisticsTab.this.m_stepCpuTime = StatisticsTab.this.m_stepCpuTime + dVal;
                    }
                    this.m_statsModel.setValueAt(Double.valueOf(sVal), this.m_iCurrentNode, 8);
                    this.m_statsModel.setValueAt(sVal, this.m_iCurrentNode, 19);
                    sVal = (String)armTokens.get(9);
                    if (sVal.trim().length() == 0) {
                        sVal = "0";
                        dVal = 0.0;
                    } else {
                        dVal = Double.parseDouble(sVal);
                        dVal /= 1000.0;
                    }
                    if (dVal > StatisticsTab.this.m_hwmMemVal) {
                        StatisticsTab.this.m_hwmMemVal = dVal;
                    }
                    if (StatisticsTab.this.m_isLoop && dVal > StatisticsTab.this.m_stepHwmMemVal) {
                        StatisticsTab.this.m_stepHwmMemVal = dVal;
                    }
                    this.m_statsModel.setValueAt(dVal, this.m_iCurrentNode, 10);
                    this.m_statsModel.setValueAt(((String)armTokens.get(1)).trim(), this.m_iCurrentNode, 14);
                    sVal = (String)armTokens.get(10);
                    if (sVal.trim().length() == 0) {
                        sVal = "0";
                        dVal = 0.0;
                    } else {
                        dVal = Double.parseDouble(sVal);
                    }
                    if (StatisticsTab.this.m_jobThreads == 0.0) {
                        StatisticsTab.this.m_jobThreads = dVal;
                    } else if (StatisticsTab.this.m_jobThreads < dVal) {
                        StatisticsTab.this.m_jobThreads = dVal;
                    }
                    if (StatisticsTab.this.m_isLoop) {
                        if (StatisticsTab.this.m_stepThreads == 0.0) {
                            StatisticsTab.this.m_stepThreads = dVal;
                        } else if (StatisticsTab.this.m_stepThreads < dVal) {
                            StatisticsTab.this.m_stepThreads = dVal;
                        }
                    }
                    this.m_statsModel.setValueAt(dVal, this.m_iCurrentNode, 15);
                    this.m_statsModel.setValueAt(((String)armTokens.get(11)).trim(), this.m_iCurrentNode, 16);
                    sVal = ((String)armTokens.get(12)).trim();
                    if (sVal.length() == 0) {
                        sVal = "0";
                        dVal = 0.0;
                    } else {
                        dVal = Double.parseDouble(sVal);
                    }
                    this.m_statsModel.setValueAt(Double.valueOf(sVal), this.m_iCurrentNode, 11);
                    sVal = ((String)armTokens.get(13)).trim();
                    if (sVal.length() == 0) {
                        sVal = "0";
                        dVal = 0.0;
                    } else {
                        dVal = Double.parseDouble(sVal);
                    }
                    if (StatisticsTab.this.m_jobIO == 0.0) {
                        StatisticsTab.this.m_jobIO = dVal;
                    } else if (StatisticsTab.this.m_jobIO < dVal) {
                        StatisticsTab.this.m_jobIO = dVal;
                    }
                    if (StatisticsTab.this.m_isLoop) {
                        if (StatisticsTab.this.m_stepIO == 0.0) {
                            StatisticsTab.this.m_stepIO = dVal;
                        } else if (StatisticsTab.this.m_stepIO < dVal) {
                            StatisticsTab.this.m_stepIO = dVal;
                        }
                    }
                    this.m_statsModel.setValueAt(Double.valueOf(sVal), this.m_iCurrentNode, 12);
                    String durVal = (String)armTokens.get(15);
                    StringTokenizer durSt = new StringTokenizer(durVal, " ");
                    String durValue = durSt.nextToken();
                    if (durValue.trim().length() == 0) {
                        durValue = "0";
                    }
                    this.m_statsModel.setValueAt(Double.valueOf(durVal), this.m_iCurrentNode, 13);
                    List procMessagesRaw = runResults.getArmProcSegmentMessages();
                    List procMessages = new ArrayList();
                    List messageProcList = null;
                    if (procMessagesRaw.size() > 0) {
                        if (procMessagesRaw.size() == 1) {
                            procMessages = StatisticsTab.this.tokenizeList((String[])procMessagesRaw.get(0));
                        } else if (i < procMessagesRaw.size()) {
                            procMessages = StatisticsTab.this.tokenizeList((String[])procMessagesRaw.get(i));
                        }
                    }
                    double d_hwmMemVal = 0.0;
                    for (int j = 0; j < procMessages.size(); ++j) {
                        messageProcList = (List)procMessages.get(j);
                        sVal = ((String)messageProcList.get(6)).trim();
                        if (sVal.length() <= 0) continue;
                        dVal = Double.parseDouble(sVal);
                        if (!((dVal /= 1000.0) > d_hwmMemVal)) continue;
                        d_hwmMemVal = dVal;
                    }
                    this.m_statsModel.setValueAt(d_hwmMemVal, this.m_iCurrentNode, 9);
                    this.m_statsModel.setValueAt(messageProcList, this.m_iCurrentNode, 26);
                    if (SwingUtilities.isEventDispatchThread()) {
                        if (StatisticsTab.this.m_actDetailView.isSelected()) {
                            StatisticsTab.this.setSourcePanel(0);
                        }
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (StatisticsTab.this.m_actDetailView.isSelected()) {
                                        StatisticsTab.this.setSourcePanel(0);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                        }
                        catch (InvocationTargetException ex) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                        }
                    }
                    ++this.m_iNodeNumber;
                }
            } else if ("RunCompleted".equals(sType) && StatisticsTab.this.m_perfStatsEnabled) {
                IJob job = StatisticsTab.this.m_job;
                StatisticsTab.this.m_jobName = job.getName();
                this.m_statsModel.insertRow(StatisticsTab.this.m_jobName, (IObject)job, false);
                this.m_iCurrentNode = this.m_statsModel.getRowCount() - 1;
                this.updateTableWithStatus(this.m_iJobStatus);
                this.m_statsModel.setValueAt(WAdminResource.getTypeIcon((String)"Job", (boolean)true), this.m_iCurrentNode, 24);
                StatisticsTab.this.m_jobDuration = StatisticsTab.this.m_jobEndTime - StatisticsTab.this.m_jobStartTime;
                if (StatisticsTab.this.m_tzd != null) {
                    StatisticsTab.this.m_dtFormat.setTimeZone(StatisticsTab.this.m_tzd);
                    long jdt = SASDateTimeFormat.SASDateTimeToJavaDate((double)StatisticsTab.this.m_jobStartTime);
                    Date nd = new Date(jdt);
                    StatisticsTab.this.m_cal.setTime(nd);
                    this.m_statsModel.setValueAt(0.0, this.m_iCurrentNode, 4);
                    this.m_statsModel.setValueAt(StatisticsTab.this.m_formatter.format(StatisticsTab.this.m_cal.getTime()), this.m_iCurrentNode, 5);
                    StatisticsTab.this.m_dtFormat.setTimeZone(StatisticsTab.this.m_tzd);
                    jdt = SASDateTimeFormat.SASDateTimeToJavaDate((double)StatisticsTab.this.m_jobEndTime);
                    nd = new Date(jdt);
                    StatisticsTab.this.m_cal.setTime(nd);
                    this.m_statsModel.setValueAt(StatisticsTab.this.m_formatter.format(StatisticsTab.this.m_cal.getTime()), this.m_iCurrentNode, 6);
                }
                if (StatisticsTab.this.m_jobMemory == 0.0) {
                    StatisticsTab.this.m_jobMemory = StatisticsTab.this.m_hwmMemVal;
                } else if (StatisticsTab.this.m_jobMemory < StatisticsTab.this.m_hwmMemVal) {
                    StatisticsTab.this.m_jobMemory = StatisticsTab.this.m_hwmMemVal;
                }
                this.m_statsModel.setValueAt(StatisticsTab.this.m_jobDuration, this.m_iCurrentNode, 7);
                this.m_statsModel.setValueAt(StatisticsTab.this.m_jobCpuTime, this.m_iCurrentNode, 8);
                this.m_statsModel.setValueAt(StatisticsTab.this.m_jobMemory, this.m_iCurrentNode, 10);
                this.m_statsModel.setValueAt(StatisticsTab.this.m_jobIO, this.m_iCurrentNode, 12);
                this.m_statsModel.setValueAt(StatisticsTab.this.m_jobThreads, this.m_iCurrentNode, 15);
                this.m_statsModel.setValueAt("", this.m_iCurrentNode, 14);
                StatisticsTab.this.m_actGraphView.setEnabled(true);
                if (StatisticsTab.this.m_actGraphView.isSelected()) {
                    StatisticsTab.this.m_rbnGraphLineButton.setEnabled(true);
                    StatisticsTab.this.m_rbnGraphBarButton.setEnabled(true);
                    StatisticsTab.this.m_actGraphSaveToFile.setEnabled(true);
                }
                if (StatisticsTab.this.m_perfStatsEnabled) {
                    this.m_graphTableModel.startPerfDataThreads(this.m_statsModel);
                    StatisticsTab.this.m_btnSaveAsTableToFile.setEnabled(true);
                } else {
                    StatisticsTab.this.setSourcePanel(3);
                }
            }
        }

        private void updateTableWithStatus(int iStatus) {
            int iCurrentNode = this.m_statsModel.getRowCount() - 1;
            if (iStatus == 0) {
                this.m_statsModel.setValueAt(StatusTab.STATUS_SUCCESS, iCurrentNode, 3);
                this.m_statsModel.setValueAt(bundle.getImageIcon("StatusTableModel.Success.image"), iCurrentNode, 25);
            } else if (iStatus == 1) {
                this.m_statsModel.setValueAt(StatusTab.STATUS_WARNING, iCurrentNode, 3);
                this.m_statsModel.setValueAt(bundle.getImageIcon("StatusTableModel.Warning.image"), iCurrentNode, 25);
                if (this.m_iJobStatus != 2) {
                    this.m_iJobStatus = 1;
                }
            } else if (iStatus == 2) {
                this.m_statsModel.setValueAt(StatusTab.STATUS_ERROR, iCurrentNode, 3);
                this.m_statsModel.setValueAt(bundle.getImageIcon("StatusTableModel.Error.image"), iCurrentNode, 25);
                this.m_iJobStatus = 2;
            }
        }

        public List getARMList() {
            return this.armTokenList;
        }

        public StatisticsTableModel getStatsModel() {
            return this.m_statsModel;
        }
    }

    private class cSaveAsTableToFileAction
    extends WsAbstractToggleAction {
        public cSaveAsTableToFileAction() {
            super(bundle, "RuntimeDetailsTab.cSaveAsTableToFileAction", 17);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:SaveAs"));
        }

        public void actionPerformed(ActionEvent e) {
            StatisticsTab.this.saveLogFile();
        }
    }

    public class CsvFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equalsIgnoreCase("csv");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return bundle.getString("StatisticsTab.SaveTypes.txt");
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    public class cLoadPerfDataModelEvent
    extends EventObject {
        private String m_sType;
        public static final String MODEL_UPDATED = "ModelUpdated";
        public static final String MODEL_NOT_UPDATED = "ModelNotUpdated";

        public cLoadPerfDataModelEvent(PerfModel mdl, String sType) {
            super(mdl);
            this.m_sType = sType;
        }

        public String getType() {
            return this.m_sType;
        }
    }
}

