/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.DataElementColors;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PlotVariable;
import com.sas.graphics.components.PlotVariableList;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.lineplot.LinePlot;
import com.sas.graphics.components.lineplot.LinePlotDataModel;
import com.sas.graphics.components.lineplot.LinePlotModel;
import com.sas.graphics.components.lineplot.LinePlotTableDataModel;
import com.sas.measures.BaseLength;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsSelectionPanel;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsTableModel;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class StatisticsLineChartPanel
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(StatisticsLineChartPanel.class);
    private LinePlotTableDataModel m_dataModel;
    private LinePlotModel m_graphModel;
    private LinePlot m_linePlot;
    private boolean m_graphCreated = false;
    private StatisticsTableModel m_tableModel;
    private TableModel m_perfDataModel;
    private boolean m_graphAttributesChanged;
    private boolean m_records = true;
    private boolean m_real = true;
    private boolean m_system = true;
    private boolean m_memory = true;
    private boolean m_memory2 = true;
    private boolean m_io = true;
    private boolean m_io2 = true;
    private Color[] m_colors;
    private StrokeLineStyle m_response1Color;
    private StrokeLineStyle m_response2Color;
    private StrokeLineStyle m_response3Color;
    private StrokeLineStyle m_response4Color;
    private StrokeLineStyle m_response5Color;
    private StrokeLineStyle m_response6Color;
    private StrokeLineStyle m_response7Color;
    private MarkerStyle m_marker1Style;
    private MarkerStyle m_marker2Style;
    private MarkerStyle m_marker3Style;
    private MarkerStyle m_marker4Style;
    private MarkerStyle m_marker5Style;
    private MarkerStyle m_marker6Style;
    private MarkerStyle m_marker7Style;
    private cSelectionListener m_selectionListener;

    public StatisticsLineChartPanel(StatisticsTableModel tableModel) {
        this.m_tableModel = tableModel;
        this.initialize();
    }

    public void initialize() {
        this.m_selectionListener = new cSelectionListener();
        this.m_dataModel = new LinePlotTableDataModel();
        this.m_dataModel.setModel(this.m_tableModel.getEmptyDataModel());
        this.m_linePlot = new LinePlot((LinePlotDataModel)this.m_dataModel);
        this.m_linePlot.setVisible(true);
        this.m_linePlot.setRequestFocusEnabled(true);
        this.m_linePlot.setSize(new Dimension(200, 200));
        this.m_linePlot.setPreferredSize(new Dimension(20, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_linePlot, "Center");
    }

    public cSelectionListener getSelectionListener() {
        return this.m_selectionListener;
    }

    public void setGraphModel(TableModel model) {
        this.m_perfDataModel = model;
    }

    public void moveDataToView() {
        if (!this.isGraphCreated()) {
            this.buildGraph();
        }
        this.m_dataModel.setModel(this.m_perfDataModel);
    }

    public void refreshLineChart() {
        if (this.hasGraphAttributesChanged()) {
            this.setGraphColors();
            this.setGraphResponseVariables();
            this.m_graphAttributesChanged = false;
        }
    }

    public boolean isGraphCreated() {
        return this.m_graphCreated;
    }

    public boolean hasGraphAttributesChanged() {
        return this.m_graphAttributesChanged;
    }

    public void resetGraphAttributes() {
        this.setGraphAttributes(true, true, true, true, true, true, true);
    }

    public void setGraphAttributes(boolean records, boolean real, boolean system, boolean memory, boolean memory2, boolean io, boolean io2) {
        if (records != this.m_records) {
            this.m_records = records;
            this.m_graphAttributesChanged = true;
        }
        if (real != this.m_real) {
            this.m_real = real;
            this.m_graphAttributesChanged = true;
        }
        if (system != this.m_system) {
            this.m_system = system;
            this.m_graphAttributesChanged = true;
        }
        if (memory != this.m_memory) {
            this.m_memory = memory;
            this.m_graphAttributesChanged = true;
        }
        if (memory2 != this.m_memory2) {
            this.m_memory2 = memory2;
            this.m_graphAttributesChanged = true;
        }
        if (io != this.m_io) {
            this.m_io = io;
            this.m_graphAttributesChanged = true;
        }
        if (io2 != this.m_io2) {
            this.m_io2 = io2;
            this.m_graphAttributesChanged = true;
        }
    }

    public void setSelectionListener(cSelectionListener selectionListener) {
        this.m_selectionListener = selectionListener;
    }

    public LinePlot getLinePlot() {
        return this.m_linePlot;
    }

    public void buildGraph() {
        this.m_graphModel = this.m_linePlot.getGraphModel();
        ColorScheme colorScheme = new ColorScheme(101015);
        colorScheme.getValueColor();
        this.m_linePlot.applyColorScheme(colorScheme);
        this.m_linePlot.setDisplayPolicy(10002);
        PlotVariable oneCategory = new PlotVariable("Task", null, null, null);
        this.m_dataModel.setXVariable(oneCategory);
        this.m_graphModel.getYAxisModel().setLabel(bundle.getString("StatisticsLineChartPanel.YAxis.label.txt"));
        this.m_graphModel.getYAxisModel().getMinorTickStyle().getLineStyle().setVisibilityPolicy(10202);
        this.m_graphModel.getXAxisModel().setLabel(bundle.getString("StatisticsLineChartPanel.XAxis.label.txt"));
        ColorScheme scheme = new ColorScheme(101012);
        DataElementColors dec = scheme.getDataElementColors();
        this.m_colors = dec.getDiscreteFillColors();
        this.m_response1Color = new StrokeLineStyle();
        this.m_response1Color.setColor(this.m_colors[8]);
        this.m_response1Color.setThickness(new BaseLength(2.0, "pt"));
        this.m_response2Color = new StrokeLineStyle();
        this.m_response2Color.setColor(this.m_colors[3]);
        this.m_response2Color.setThickness(new BaseLength(2.0, "pt"));
        this.m_response3Color = new StrokeLineStyle();
        this.m_response3Color.setColor(this.m_colors[2]);
        this.m_response3Color.setThickness(new BaseLength(2.0, "pt"));
        this.m_response4Color = new StrokeLineStyle();
        this.m_response4Color.setColor(this.m_colors[9]);
        this.m_response4Color.setThickness(new BaseLength(2.0, "pt"));
        this.m_response5Color = new StrokeLineStyle();
        this.m_response5Color.setColor(this.m_colors[10]);
        this.m_response5Color.setThickness(new BaseLength(2.0, "pt"));
        this.m_response6Color = new StrokeLineStyle();
        this.m_response6Color.setColor(this.m_colors[11]);
        this.m_response6Color.setThickness(new BaseLength(2.0, "pt"));
        this.m_response7Color = new StrokeLineStyle();
        this.m_response7Color.setColor(this.m_colors[4]);
        this.m_response7Color.setThickness(new BaseLength(2.0, "pt"));
        MarkerStyle[] markerStyle = this.m_graphModel.getDataElementStyles().getMarkerStyles();
        this.m_marker1Style = markerStyle[0];
        this.m_marker2Style = markerStyle[1];
        this.m_marker3Style = markerStyle[2];
        this.m_marker4Style = markerStyle[3];
        this.m_marker5Style = markerStyle[4];
        this.m_marker6Style = markerStyle[5];
        this.m_marker7Style = markerStyle[6];
        this.setGraphColors();
        this.setGraphResponseVariables();
        this.m_linePlot.setVisible(true);
        this.m_graphCreated = true;
    }

    public void setGraphColors() {
        int cnt = 0;
        if (this.m_system) {
            ++cnt;
        }
        if (this.m_memory) {
            ++cnt;
        }
        if (this.m_memory2) {
            ++cnt;
        }
        if (this.m_real) {
            ++cnt;
        }
        if (this.m_records) {
            ++cnt;
        }
        if (this.m_io) {
            ++cnt;
        }
        if (this.m_io2) {
            ++cnt;
        }
        int index = 0;
        StrokeLineStyle[] lineStyles = new StrokeLineStyle[cnt];
        MarkerStyle[] markers = new MarkerStyle[cnt];
        if (this.m_system) {
            lineStyles[index] = this.m_response1Color;
            markers[index] = this.m_marker1Style;
            ++index;
        }
        if (this.m_io) {
            lineStyles[index] = this.m_response5Color;
            markers[index] = this.m_marker5Style;
            ++index;
        }
        if (this.m_io2) {
            lineStyles[index] = this.m_response7Color;
            markers[index] = this.m_marker7Style;
            ++index;
        }
        if (this.m_memory) {
            lineStyles[index] = this.m_response2Color;
            markers[index] = this.m_marker2Style;
            ++index;
        }
        if (this.m_memory2) {
            lineStyles[index] = this.m_response6Color;
            markers[index] = this.m_marker6Style;
            ++index;
        }
        if (this.m_real) {
            lineStyles[index] = this.m_response3Color;
            markers[index] = this.m_marker3Style;
            ++index;
        }
        if (this.m_records) {
            lineStyles[index] = this.m_response4Color;
            markers[index] = this.m_marker4Style;
            ++index;
        }
        if (this.m_graphModel != null) {
            this.m_graphModel.getDataElementStyles().setLineStyles(lineStyles);
            this.m_graphModel.getDataElementStyles().setMarkerStyles(markers);
        }
    }

    public void setGraphSize() {
        this.m_linePlot.setRequestFocusEnabled(true);
    }

    public void setGraphResponseVariables() {
        ArrayList<PlotVariable> plotList = new ArrayList<PlotVariable>();
        if (this.m_system) {
            plotList.add(new PlotVariable("cpu", "12."));
        }
        if (this.m_io) {
            plotList.add(new PlotVariable("I/O", "12."));
        }
        if (this.m_io2) {
            plotList.add(new PlotVariable("OS I/O", "12."));
        }
        if (this.m_memory) {
            plotList.add(new PlotVariable("memory", "12."));
        }
        if (this.m_memory2) {
            plotList.add(new PlotVariable("OS memory", "12."));
        }
        if (this.m_real) {
            plotList.add(new PlotVariable("real", "12."));
        }
        if (this.m_records) {
            plotList.add(new PlotVariable("records"));
        }
        PlotVariableList multiPlots = new PlotVariableList(plotList.toArray(new PlotVariable[7]));
        this.m_dataModel.setYVariable((PlotVariable)multiPlots);
    }

    public class cSelectionListener
    implements EventListener {
        public void selectionEventHappened(StatisticsSelectionPanel.cSelectionEvent ev, boolean recordsSelected, boolean realSelected, boolean systemSelected, boolean memorySelected, boolean memorySelected2, boolean ioSelected, boolean ioSelected2) {
            if ("SelectionApplied".equals(ev.getType())) {
                StatisticsLineChartPanel.this.setGraphAttributes(recordsSelected, realSelected, systemSelected, memorySelected, memorySelected2, ioSelected, ioSelected2);
                StatisticsLineChartPanel.this.refreshLineChart();
            }
        }
    }
}

