/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.AbstractDetailsTab;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsUIUtilities;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public abstract class RuntimeDetailsTab
extends AbstractDetailsTab {
    private static WAdminResource bundle = WAdminResource.getBundle(RuntimeDetailsTab.class);
    protected static URL SUCCESS_ICON_URL;
    protected static URL WARNING_ICON_URL;
    protected static URL ERROR_ICON_URL;
    protected static URL ABORT_ICON_URL;
    protected static URL STOP_ICON_URL;
    protected static URL INCOMPLETE_ICON_URL;
    protected static URL EXCLUDED_ICON_URL;
    private static boolean s_bIconURLInitialized;
    protected JToolBar m_barCommon;
    protected JLabel m_lblLastRunTimestamp;
    protected JButton m_btnClearAll;
    protected JButton m_btnPrint;
    private WsAbstractAction m_actClearAll;
    public static final String LINKACTION_SCROLL = "SCROLL";
    public static final String LINKDELIMITER = ":";
    protected RunModel m_mdlRun;
    protected ValidateModel m_mdlValidate;

    public RuntimeDetailsTab(RunModel runModel) {
        this(runModel, null);
    }

    public RuntimeDetailsTab(RunModel runModel, ValidateModel validateModel) {
        this.m_mdlRun = runModel;
        this.m_mdlValidate = validateModel;
        if (!s_bIconURLInitialized) {
            String imageLocation = bundle.getString("ImageLocation.notrans");
            String successIconName = bundle.getString("StatusTableModel.Success.image");
            String warningIconName = bundle.getString("StatusTableModel.Warning.image");
            String errorIconName = bundle.getString("StatusTableModel.Error.image");
            String abortIconName = bundle.getString("StatusTableModel.RunAborted.image");
            String stopIconName = bundle.getString("StatusTableModel.RunStopped.image");
            String incompleteIconName = bundle.getString("StatusTableModel.Incomplete.image");
            String excludedIconName = bundle.getString("StatusTableModel.Excluded.image");
            ClassLoader classLoader = RuntimeDetailsTab.class.getClassLoader();
            SUCCESS_ICON_URL = classLoader.getResource(imageLocation + successIconName);
            WARNING_ICON_URL = classLoader.getResource(imageLocation + warningIconName);
            ERROR_ICON_URL = classLoader.getResource(imageLocation + errorIconName);
            ABORT_ICON_URL = classLoader.getResource(imageLocation + abortIconName);
            STOP_ICON_URL = classLoader.getResource(imageLocation + stopIconName);
            INCOMPLETE_ICON_URL = classLoader.getResource(imageLocation + incompleteIconName);
            EXCLUDED_ICON_URL = classLoader.getResource(imageLocation + excludedIconName);
            s_bIconURLInitialized = true;
        }
        this.m_lblLastRunTimestamp = new JLabel();
        this.m_actClearAll = new ClearAllAction();
        this.m_btnClearAll = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actClearAll);
        this.m_barCommon = WsUIUtilities.createToolBar();
        this.m_barCommon.add(this.m_lblLastRunTimestamp);
        this.m_barCommon.addSeparator();
        this.m_barCommon.add(this.m_btnClearAll);
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        super.initialize();
        this.m_mdlRun.addListener(new cRunModelListener());
        if (this.m_mdlValidate != null) {
            this.m_mdlValidate.addListener(new cValidateModelListener());
        }
    }

    protected void printTab() {
        MessageUtil.displayMessage((String)"TODO override default print action", (String)"TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printImpl(JComponent cmp, String sTitle) {
        WsTitledPageFormat pf = new WsTitledPageFormat(sTitle);
        WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter((JComponent)cmp, (PageFormat)pf);
        try {
            PrinterJob pjob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                return;
            }
            pjob.setJobName(sTitle);
            pjob.setPageable((Pageable)printer);
            if (pjob.printDialog()) {
                pjob.print();
            }
        }
        catch (PrinterException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("WsTextComponentAdapter.PrintErrorTitle.txt"), (int)0);
        }
        finally {
            printer.dispose();
        }
    }

    public JButton getClearAllButton() {
        return this.m_btnClearAll;
    }

    protected WsAbstractAction createPrintAction() {
        return new cPrintAction();
    }

    static {
        s_bIconURLInitialized = false;
    }

    private class ClearAllAction
    extends WsAbstractAction {
        public ClearAllAction() {
            super(bundle, "RuntimeDetailsTab.ClearAll", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ClearAll"));
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class cRunModelListener
    implements RunModelListener {
        private cRunModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            String sEventType = ev.getType();
            if ("RunStarted".equals(sEventType)) {
                RuntimeDetailsTab.this.m_actClearAll.setEnabled(false);
            } else if ("RunCompleted".equals(sEventType) || "RunAborted".equals(sEventType) || "RunStopped".equals(sEventType)) {
                Date endTime = new Date(System.currentTimeMillis());
                RuntimeDetailsTab.this.m_lblLastRunTimestamp.setText(bundle.formatString("RuntimeDetailsTab.LastRun.fmt.txt", (Object)DateFormat.getDateTimeInstance().format(endTime)));
                RuntimeDetailsTab.this.m_actClearAll.setEnabled(true);
            }
        }
    }

    private class cValidateModelListener
    implements ValidateModelListener {
        private cValidateModelListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
        }

        @Override
        public void validateEventHappened(ValidateEvent ev) {
            String sEventType = ev.getType();
            if ("ValidateStarted".equals(sEventType)) {
                RuntimeDetailsTab.this.m_actClearAll.setEnabled(false);
            } else if ("ValidateCompleted".equals(sEventType) || "ValidateStopped".equals(sEventType)) {
                Date endTime = new Date(System.currentTimeMillis());
                RuntimeDetailsTab.this.m_lblLastRunTimestamp.setText(bundle.formatString("RuntimeDetailsTab.LastValidate.fmt.txt", (Object)DateFormat.getDateTimeInstance().format(endTime)));
                RuntimeDetailsTab.this.m_actClearAll.setEnabled(true);
            }
        }
    }

    private class cPrintAction
    extends WsAbstractAction {
        public cPrintAction() {
            super(bundle, "RuntimeDetailsTab.cPrintAction", 16);
            this.setMenuSupportId("Common:Print");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Print"));
        }

        public void actionPerformed(ActionEvent e) {
            RuntimeDetailsTab.this.printTab();
        }
    }
}

