/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.metadata.remote.MdException;
import com.sas.table.StaticRowLabelInterface;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class ControlFlowTableModel
extends WsAbstractTableModel
implements StaticRowLabelInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(ControlFlowTableModel.class);
    private static final int VISIBLE_COLUMNS = 4;
    private static final int HIDDEN_COLUMNS = 2;
    public static final int WARNING_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int DESCRIPTION_COLUMN = 3;
    public static final int TRANSFORMATION_COLUMN = 4;
    private static final int ICON_COLUMN = 5;
    private static final int WARNING_WIDTH = 18;
    private static final int NAME_WIDTH = 100;
    private static final int TYPE_WIDTH = 75;
    private static final int DESCRIPTION_WIDTH = 150;
    private static final Icon WARNING_ICON = bundle.getIcon("ControlFlowTableModel.Warning.image");
    private static final Icon BLANK_ICON = bundle.getIcon("ControlFlowTableModel.Blank.image");
    private IJob m_job;
    private IModelListener m_lsnrModel;

    public ControlFlowTableModel(IJob job) {
        this.m_job = job;
        this.m_lsnrModel = new ModelListener();
        this.m_job.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_job.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        WsIconTableColumn colWarning = new WsIconTableColumn(0, " ", 18);
        WsStringTableColumn colName = new WsStringTableColumn(1, bundle.getString("ControlFlowTableModel.Name.txt"), 100);
        WsStringTableColumn colType = new WsStringTableColumn(2, bundle.getString("ControlFlowTableModel.Type.txt"), 75);
        WsStringTableColumn colDescription = new WsStringTableColumn(3, bundle.getString("ControlFlowTableModel.Description.txt"), 150);
        WsObjectTableColumn colTransformation = new WsObjectTableColumn();
        WsObjectTableColumn colIcon = new WsObjectTableColumn();
        colName.setIconColumn(5);
        colName.setEditable(false);
        colType.setEditable(false);
        colDescription.setEditable(false);
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = colWarning;
        this.m_aColumns[1] = colName;
        this.m_aColumns[2] = colType;
        this.m_aColumns[4] = colTransformation;
        this.m_aColumns[5] = colIcon;
        this.m_aColumns[3] = colDescription;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public String getToolTipAt(int iRow, int iColumn) {
        if (iColumn == 0 && this.getValueAt(iRow, iColumn) == WARNING_ICON) {
            return bundle.getString("ControlFlowTableModel.Warning.tip");
        }
        return null;
    }

    public void moveDataToModel() {
        int iTransform;
        this.clear();
        ITransform[] aTransforms = this.m_job.getControlOrderedTransforms();
        for (iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            this.m_lData.add(this.createRowValues(aTransforms[iTransform]));
        }
        aTransforms = this.m_job.getTransforms();
        for (iTransform = 0; iTransform < aTransforms.length; ++iTransform) {
            if (this.getRowIndex(aTransforms[iTransform]) != -1) continue;
            this.m_lData.add(this.createRowValues(aTransforms[iTransform]));
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore is not supported");
    }

    public void populateStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("populateStore is not supported");
    }

    private List createRowValues(ITransform xfm) {
        Icon iconTransform = AppIconFactory.getAppInstance().getIconForTransformation(xfm.getType());
        ArrayList<Object> lValues = new ArrayList<Object>(6);
        lValues.add(this.getWarningIcon(xfm));
        lValues.add(xfm.getName());
        lValues.add(xfm.getDisplayType());
        lValues.add(xfm.getDescription());
        lValues.add(xfm);
        lValues.add(iconTransform);
        return lValues;
    }

    public Object getRowLabel(int iRow) {
        return iRow >= this.m_job.getControlOrderedTransformsList().size() ? "-" : Integer.toString(iRow + 1);
    }

    public Object[] getRowLabels(int iStartRow, int nRows) {
        Object[] aLabels = new String[nRows];
        int nExecution = this.m_job.getControlOrderedTransformsList().size();
        int nNumbers = Math.min(nRows, nExecution - iStartRow);
        for (int iRow = 0; iRow < nNumbers; ++iRow) {
            aLabels[iRow] = Integer.toString(iRow + 1);
        }
        Arrays.fill(aLabels, nNumbers, nRows - 1, "-");
        return null;
    }

    public boolean isRowLabelsSupported() {
        return true;
    }

    public boolean isRowsLabelSupported() {
        return true;
    }

    public int getRowIndex(ITransform xfm) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(4) != xfm) continue;
            return iRow;
        }
        return -1;
    }

    public ITransform getTransformForRow(int iRow) {
        return (ITransform)this.getValueAt(iRow, 4);
    }

    private int addTransform(ITransform xfm) {
        List lExecution = this.m_job.getControlOrderedTransformsList();
        int iRow = lExecution.indexOf(xfm);
        if (iRow == -1) {
            iRow = lExecution.size();
            ITransform[] aTransforms = this.m_job.getTransforms();
            for (int iTransform = 0; iTransform < aTransforms.length && aTransforms[iTransform] != xfm; ++iTransform) {
                if (lExecution.contains(aTransforms[iTransform])) continue;
                ++iRow;
            }
        }
        this.insertRow(iRow - 1, this.createRowValues(xfm));
        return iRow;
    }

    private int removeTransform(ITransform xfm) {
        int iRow = this.getRowIndex(xfm);
        this.deleteRow(iRow);
        return iRow;
    }

    private void updateWarningIcons() {
        List lExecution = this.m_job.getControlOrderedTransformsList();
        for (int iRow = 0; iRow < lExecution.size(); ++iRow) {
            super.setValueAt((Object)this.getWarningIcon(this.getTransformForRow(iRow)), iRow, 0);
        }
    }

    private Icon getWarningIcon(ITransform xfm) {
        DesignTimeJobModel mdl = (DesignTimeJobModel)this.m_job.getModel();
        return mdl.areTransformationSourcesPopulatedBeforeRunnning(xfm) ? BLANK_ICON : WARNING_ICON;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                ControlFlowTableModel.this.moveDataToModel();
            } else if (obj == ControlFlowTableModel.this.m_job) {
                if (sType == "Job:TransformAdded") {
                    ControlFlowTableModel.this.addTransform((ITransform)ev.getData());
                    ControlFlowTableModel.this.updateWarningIcons();
                } else if (sType == "Job:TransformRemoved") {
                    ControlFlowTableModel.this.removeTransform((ITransform)ev.getData());
                    ControlFlowTableModel.this.updateWarningIcons();
                } else if (sType == "Job:TransformAddedToExecutionOrder") {
                    ControlFlowTableModel.this.removeTransform((ITransform)ev.getData());
                    ControlFlowTableModel.this.addTransform((ITransform)ev.getData());
                    ControlFlowTableModel.this.updateWarningIcons();
                } else if (sType == "Job:TransformRemovedFromExecutionOrder") {
                    ControlFlowTableModel.this.removeTransform((ITransform)ev.getData());
                    ControlFlowTableModel.this.addTransform((ITransform)ev.getData());
                    ControlFlowTableModel.this.updateWarningIcons();
                }
            } else if (obj instanceof ITransform) {
                ITransform xfm = (ITransform)obj;
                int iRowIndex = ControlFlowTableModel.this.getRowIndex(xfm);
                if (iRowIndex == -1) {
                    return;
                }
                if (sType == "Object:NameChanged") {
                    ControlFlowTableModel.super.setValueAt(xfm.getName(), iRowIndex, 1);
                } else if (sType == "Object:DescriptionChanged") {
                    ControlFlowTableModel.super.setValueAt(xfm.getDescription(), iRowIndex, 3);
                } else {
                    List lControlFlow = ControlFlowTableModel.this.m_job.getControlOrderedTransformsList();
                    int iRow = lControlFlow.indexOf(xfm);
                    if (iRow >= 0) {
                        if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataSourceRemoved") {
                            ControlFlowTableModel.super.setValueAt(ControlFlowTableModel.this.getWarningIcon(xfm), iRow, 0);
                        } else if (sType == "DataTransform.DataTargetAdded" || sType == "DataTransform.DataTargetRemoved") {
                            ControlFlowTableModel.this.updateWarningIcons();
                        }
                    }
                }
            }
        }
    }
}

