/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.IDataNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.WorkTableAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IControlTransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.ITransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.WorkTableNode;

public class DiagramNodeFactory {
    private static DiagramNodeFactory s_instance;

    protected DiagramNodeFactory() {
    }

    public static DiagramNodeFactory getInstance() {
        if (s_instance == null) {
            s_instance = new DiagramNodeFactory();
        }
        return s_instance;
    }

    public PFDAbstractNode createNode(IDiagramNodeAdapter adapter) {
        if (adapter instanceof IControlTransformNodeAdapter) {
            return new ControlTransformNode((IControlTransformNodeAdapter)adapter);
        }
        if (adapter instanceof ITransformNodeAdapter) {
            return new DataTransformNode((ITransformNodeAdapter)adapter);
        }
        if (adapter instanceof WorkTableAdapter) {
            return new WorkTableNode((IDataNodeAdapter)adapter);
        }
        if (adapter instanceof IDataNodeAdapter) {
            return new DataNode((IDataNodeAdapter)adapter);
        }
        throw new UnsupportedOperationException("Cannot create a node for this adapter: " + adapter.getObject().getName());
    }
}

