/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import com.sas.workspace.WAdminResource;
import java.awt.Point;
import java.util.List;
import java.util.StringTokenizer;

public class ControlLink
extends BaseLink
implements IControlLink {
    private static final WAdminResource bundle = WAdminResource.getBundle(ControlLink.class);

    public ControlLink() {
        super(null, null, true);
        this.setDraggable(false);
    }

    public ControlLink(PFDPort from, PFDPort to, boolean bDoValidation) {
        super(from, to, true, bDoValidation);
        this.setDraggable(false);
    }

    public ControlLink(PFDPort from, PFDPort to) {
        super(from, to, true);
        this.setDraggable(false);
    }

    protected ControlLink(List lAttributes, List lValues) {
        super(null, null, true, false);
        this.setDraggable(false);
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.setId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("ToNode")) {
                this.setToNodeId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("FromNode")) {
                this.setFromNodeId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("ToPortIndex")) {
                this.setToNodePortIndex(Integer.parseInt(sValue));
                continue;
            }
            if (sAttribute.equalsIgnoreCase("FromPortIndex")) {
                this.setFromNodePortIndex(Integer.parseInt(sValue));
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Positions")) continue;
            StringTokenizer sTok = new StringTokenizer(sValue, ",");
            this.setCustomBreakPointsUsed(true);
            while (sTok.hasMoreTokens()) {
                Point point = new Point();
                point.x = Integer.parseInt(sTok.nextToken());
                if (!sTok.hasMoreTokens()) continue;
                point.y = Integer.parseInt(sTok.nextToken());
                this.addBreakPoint(point);
            }
        }
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        StringBuffer outXML = new StringBuffer();
        outXML.append("<ControlLink>");
        outXML.append("<NodeId>");
        outXML.append(this.getId());
        outXML.append("</NodeId>");
        outXML.append("<ToNode>");
        outXML.append(this.getToNodeId());
        outXML.append("</ToNode>");
        outXML.append("<FromNode>");
        outXML.append(this.getFromNodeId());
        outXML.append("</FromNode>");
        outXML.append("<ToPortIndex>");
        outXML.append(String.valueOf(this.getToNodePortIndex(this.getToPort())));
        outXML.append("</ToPortIndex>");
        outXML.append("<FromPortIndex>");
        outXML.append(String.valueOf(this.getFromNodePortIndex(this.getFromPort())));
        outXML.append("</FromPortIndex>");
        Point[] points = this.getBreakPoints();
        if (points.length > 0) {
            outXML.append("<Positions>");
            for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                outXML.append(String.valueOf(points[iPoint].x));
                outXML.append(",");
                outXML.append(String.valueOf(points[iPoint].y));
                outXML.append(",");
            }
            outXML.append("</Positions>");
        }
        outXML.append("</ControlLink>");
        return outXML.toString();
    }
}

