/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.etl.models.IObject;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.shapes.IAdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BasePort;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.ControlPort;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DataPort;
import com.sas.workspace.WAdminResource;

public class AdapterNode
implements IAdapterNode {
    private static final WAdminResource bundle = WAdminResource.getBundle(AdapterNode.class);
    private IDiagramNodeAdapter m_adapter;
    private IDiagramNode m_node;

    public AdapterNode() {
    }

    public AdapterNode(IDiagramNodeAdapter adapter, IDiagramNode node) {
        this.m_adapter = adapter;
        this.m_node = node;
        this.m_node.setNodeIcon(this.m_adapter.getDecoratedIcon(24));
        this.m_node.setNodeType(this.m_adapter.getNodeType());
        this.m_node.setNodeTypeDescription(this.m_adapter.getNodeTypeDescription());
        this.m_node.setNodeTypeIcon(this.m_adapter.getIcon(16));
        this.refresh();
        this.createPorts();
    }

    @Override
    public IDiagramNodeAdapter getAdapter() {
        return this.m_adapter;
    }

    @Override
    public IObject getObject() {
        return this.m_adapter != null ? this.m_adapter.getObject() : null;
    }

    @Override
    public String getObjectId() {
        return this.m_adapter.getObject().getID();
    }

    protected void createPorts() {
        PFDPort port;
        int iPort;
        this.m_node.removeAllInputPorts();
        this.m_node.removeAllOutputPorts();
        IPortDescription[] aPorts = this.m_adapter.getInputPortDescriptions();
        int iPortDisplay = 1;
        for (iPort = 0; iPort < aPorts.length; ++iPort) {
            port = this.createPort(aPorts[iPort]);
            this.m_node.addInputPort(port);
            ++iPortDisplay;
        }
        aPorts = this.m_adapter.getOutputPortDescriptions();
        iPortDisplay = 1;
        for (iPort = 0; iPort < aPorts.length; ++iPort) {
            port = this.createPort(aPorts[iPort]);
            this.m_node.addOutputPort(port);
            ++iPortDisplay;
        }
    }

    @Override
    public PFDPort createPort(IPortDescription portDescription) {
        BasePort port = null;
        port = portDescription.getType() == 1 ? new ControlPort() : new DataPort();
        port.setToolTipText(portDescription.getText());
        port.setName(portDescription.getName());
        port.setMaxNumLinks(portDescription.getMaximumConnections());
        port.setSupportedInputTypes(portDescription.getConnectionTypes());
        port.setSupportedOutputTypes(portDescription.getConnectionTypes());
        return port;
    }

    @Override
    public PFDPort getInputPort(IObject obj) {
        int iPort = this.getAdapter().getInputPortIndex(obj);
        return iPort == -1 ? null : this.m_node.getInputPort(iPort);
    }

    @Override
    public PFDPort getOutputPort(IObject obj) {
        int iPort = this.getAdapter().getOutputPortIndex(obj);
        return iPort == -1 ? null : this.m_node.getOutputPort(iPort);
    }

    @Override
    public void refresh() {
        this.m_node.setName(this.m_adapter.getName());
        this.m_node.setTitleText(this.m_adapter.getTitleText());
        this.m_node.setContentText(this.m_adapter.getObject().getDescription());
        this.m_node.setToolTipText(this.m_adapter.getToolTipText());
        this.m_node.setNodeIcon(this.m_adapter.getDecoratedIcon(24));
    }

    protected void setAdapter(IDiagramNodeAdapter adapter) {
        this.m_adapter = adapter;
    }
}

