/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.ISourceInvalidMessage;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.tablemaintenance.StatementPropertyTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TableMaintenanceTransformAdapter
extends AbstractDataTransformAdapter
implements ISourceInvalidMessage {
    private static final WAdminResource bundle = WAdminResource.getBundle(TableMaintenanceTransformAdapter.class);
    private static final String[] TABLES_TYPE_ONLY = new String[]{"PhysicalTable", "WorkTable"};
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation("com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance", 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation("com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance", 24);
    private static final IPortDescription OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(bundle.getString("TableMaintenance.OutputPort.ToolTip.txt"), -1, TABLES_TYPE_ONLY);
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{DEFAULT_OUTPUT_CONTROL_PORT, OUTPUT_DATA_PORT};
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation("com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance", 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation("com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance", 24);
    private TableMaintenanceTransformModel m_transform;

    public TableMaintenanceTransformAdapter(TableMaintenanceTransformModel transform) {
        super((IDataTransform)transform);
        this.m_transform = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        return null;
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        return null;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return super.getInputPortDescriptions();
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    protected MappingsTab.Configuration createMappingsConfiguration(boolean details) {
        MappingsTab.Configuration configuration = super.createMappingsConfiguration(details);
        configuration.setMultipleSourceTablesEnabled(true);
        configuration.setMultipleTargetTablesEnabled(true);
        configuration.setHiddenColumnsInTargetColumnsTable(new int[]{4});
        return configuration;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        OptionsTab optionTab = null;
        try {
            optionTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_tablemaintenance", false);
            optionTab.setHelpProduct("wdb");
            optionTab.setHelpTopic("options_tab_tablemaint");
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(new StatementPropertyTab(this.m_transform));
            lTabs.add(optionTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj) {
        return null;
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj) {
        return null;
    }

    @Override
    public int deleteInputPort(Object obj) {
        return 0;
    }

    @Override
    public int deleteOutputPort(Object obj) {
        return 0;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.getString("TableMaintenanceAdapter.InvalidSource.txt");
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.getString("TableMaintenanceAdapter.InvalidSource.txt");
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof ITransform;
    }
}

