/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.splitter.IRowSelectorTransform;
import com.sas.etl.models.job.transforms.splitter.SplitterTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.splitter.RowSelectionTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SplitterTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(SplitterTransformAdapter.class);
    private static final IPortDescription SPLITTER_OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(bundle.getString("SplitterTransformAdapter.OutputDataPort.ToolTip.txt"), Integer.MAX_VALUE, DEFAULT_TABLE_TYPES);
    private static final IPortDescription[] SPLITTER_OUTPUT_PORTS = new IPortDescription[]{DEFAULT_OUTPUT_CONTROL_PORT, SPLITTER_OUTPUT_DATA_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(SplitterTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(SplitterTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(SplitterTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(SplitterTransformModel.getTransformTypeID(), 24);
    private SplitterTransformModel m_splitter;

    public SplitterTransformAdapter(SplitterTransformModel transform) {
        super((IDataTransform)transform);
        this.m_splitter = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return SPLITTER_OUTPUT_PORTS;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1 && obj instanceof IDataObject) {
            if (this.m_splitter.containsInDataTargets((IDataObject)obj)) {
                return false;
            }
            this.m_splitter.addRowSelectorAndDataTarget((IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_splitter.getOptionModel(), "options_tab_transform", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_splitter, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_splitter));
            lTabs.add(new RowSelectionTab((IRowSelectorTransform)this.m_splitter));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(tabOptions);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_splitter, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_splitter));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_splitter));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_splitter));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_splitter, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setMultipleTargetTablesEnabled(true);
        config.setExpressionActionsVisible(false);
        config.setDragMultipleSourceColumnsEnabled(false);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{4});
        config.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        config.setTargetTableSettingsKeyPrefix("Splitter.TargetTable");
        return new MappingsTab((IMappingsContainer)this.m_splitter, config);
    }
}

