/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.etl.models.job.transforms.SortTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.sort.SASSortByTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SortTransformAdapter
extends AbstractDataTransformAdapter {
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(SortTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(SortTransformModel.getTransformTypeID(), 24);
    private SortTransformModel m_sort;

    public SortTransformAdapter(SortTransformModel transform) {
        super((IDataTransform)transform);
        this.m_sort = transform;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_sort.getOptionModel(), "sort_options", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_sort, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_sort));
            lTabs.add(new SASSortByTab((ISortingTransform)this.m_sort, 1));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(tabOptions);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_sort, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_sort));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_sort));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_sort));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_sort, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setExpressionActionsVisible(false);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{4, 5, 6});
        config.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        config.setTargetTableSettingsKeyPrefix("Sort.TargetColumnsTable");
        return new MappingsTab((IMappingsContainer)this.m_sort, config);
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }
}

