/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.sql.impl.SQLSetOperatorsTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.sql.editor.SQLSetOperatorsPropertyTab;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SQLSetOperatorsTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(SQLSetOperatorsTransformAdapter.class);
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(SQLSetOperatorsTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(SQLSetOperatorsTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(SQLSetOperatorsTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(SQLSetOperatorsTransformModel.getTransformTypeID(), 24);
    private static final IPortDescription SET_OPERATORS_INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(bundle.getString("SQLSetOperatorsTransformAdapter.InputDataPort.ToolTip.txt"), Integer.MAX_VALUE, DEFAULT_TABLE_TYPES);
    private static final IPortDescription[] SET_OPERATORS_INPUT_PORTS = new IPortDescription[]{DEFAULT_INPUT_CONTROL_PORT, SET_OPERATORS_INPUT_DATA_PORT};
    private SQLSetOperatorsTransformModel m_oSetOperators;

    public SQLSetOperatorsTransformAdapter(SQLSetOperatorsTransformModel transform) {
        super((IDataTransform)transform);
        this.m_oSetOperators = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return SET_OPERATORS_INPUT_PORTS;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_oSetOperators.getOptionModel(), "options_tab_sql_set_ops", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_oSetOperators, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_oSetOperators));
            lTabs.add(new SQLSetOperatorsPropertyTab(this.m_oSetOperators));
            lTabs.add(tabOptions);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_oSetOperators, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_oSetOperators));
            lTabs.add(new ConditionActionsTab((IConditionActionSetContainer)this.m_oSetOperators));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_oSetOperators));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_oSetOperators));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_oSetOperators, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex == 1 && obj instanceof IDataObject && !this.m_oSetOperators.containsInDataSources((IDataObject)obj) && this.m_oSetOperators.isValidAsSourceTable((IDataObject)obj);
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        if (obj instanceof IPhysicalTable) {
            IDBMSType dbmsType = ((IPhysicalTable)obj).getDBMSType();
            if (dbmsType instanceof SASHDATType) {
                return bundle.formatString("AbstractDataTransformAdapter.SASHDATInvalidAsInputMessage.txt", (Object)this.getName());
            }
            if (dbmsType instanceof SASIOLAType) {
                return bundle.formatString("AbstractDataTransformAdapter.SASIOLAInvalidAsInputMessage.txt", (Object)this.getName());
            }
        }
        return bundle.formatString("AbstractDataTransformAdapter.InvalidInputMessage.txt", (Object)this.getName());
    }
}

