/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IMessageQueue;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.impl.BaseMessageQueue;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.IBMWSQReaderTransformModel;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.queues.QueueColumnsTabHolder;
import com.sas.wadmin.transforms.queues.QueueMessageOptionsTab2;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;

public class IBMWSQReaderTranformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(IBMWSQReaderTranformAdapter.class);
    protected static final String[] MESSAGEQUEUE = new String[]{"WSMQMessageQueue", "MessageQueue"};
    private static final IPortDescription IBMWSQREADER_INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(bundle.getString("IBMWSQReaderTranformAdapter.InputPort.ToolTip.txt"), 1, MESSAGEQUEUE);
    private static final IPortDescription[] IBMWSQREADER_INPUT_PORTS = new IPortDescription[]{DEFAULT_INPUT_CONTROL_PORT, IBMWSQREADER_INPUT_DATA_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(IBMWSQReaderTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(IBMWSQReaderTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(IBMWSQReaderTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(IBMWSQReaderTransformModel.getTransformTypeID(), 24);
    private IBMWSQReaderTransformModel m_WSMQReader;

    public IBMWSQReaderTranformAdapter(IBMWSQReaderTransformModel transform) {
        super((IDataTransform)transform);
        this.m_WSMQReader = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL() {
        return this.getIconURL(16);
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return IBMWSQREADER_INPUT_PORTS;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
        lTabs.add(new GeneralTab((IObject)this.m_WSMQReader));
        lTabs.add(new QueueMessageOptionsTab2((CommonQueueTransformModel)this.m_WSMQReader));
        lTabs.add(new QueueColumnsTabHolder((CommonQueueTransformModel)this.m_WSMQReader));
        lTabs.add(new TransformTableOptionsTab((IDataTransform)this.m_WSMQReader, null, false));
        lTabs.add(new ProcessTab((ICodeGenerator)this.m_WSMQReader, true, false));
        lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_WSMQReader));
        lTabs.add(new ConditionActionsTab((IConditionActionSetContainer)this.m_WSMQReader));
        lTabs.add(new ParameterTab((IParametersContainer)this.m_WSMQReader));
        lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_WSMQReader));
        this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_WSMQReader, false);
        return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1 && obj instanceof IMessageQueue) {
            BaseMessageQueue messageQueue = (BaseMessageQueue)obj;
            if (messageQueue.getMessageQueueType() == 1) {
                this.m_WSMQReader.addDataSource((IDataObject)obj);
                return true;
            }
            MessageUtil.displayMessage((String)bundle.getString("IBMWSQReaderTransformAdapter.InvalidQueue.txt"), (int)0);
        }
        return false;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.formatString("IBMWSQReaderTransformAdapter.InvalidInputMessage.txt", (Object)this.getName());
    }
}

