/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.hpf.HPFPortDescriptionModel;
import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.hpf.ForecastPropertyTab;
import com.sas.wadmin.transforms.hpf.HPFPropertyTab;
import com.sas.wadmin.transforms.hpf.HPFSortByPropertyTab;
import com.sas.wadmin.transforms.hpf.IDPropertyTab;
import com.sas.wadmin.transforms.hpf.TargetTablePropertyTab;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.ExtendedAttributesTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HPFTransformationAdapter
extends AbstractDataTransformAdapter {
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(HPFTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(HPFTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(HPFTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(HPFTransformModel.getTransformTypeID(), 24);
    private HPFTransformModel m_transformation;
    public static final int CONTROL_PORT = 0;

    public HPFTransformationAdapter(HPFTransformModel transformation) {
        super((IDataTransform)transformation);
        this.m_transformation = transformation;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transformation.getOptionModel(), "options_tab_hpf", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_transformation, null, false);
            return new WAPropertyTab[]{new GeneralTab((IObject)this.m_transformation), new HPFPropertyTab(this.m_transformation), new HPFSortByPropertyTab(this.m_transformation), new IDPropertyTab(this.m_transformation), new ForecastPropertyTab(this.m_transformation), new TargetTablePropertyTab(this.m_transformation), new ProcessTab((ICodeGenerator)this.m_transformation, true, false), optionsTab, tableOptionsTab, new PrePostCodeTab((IPrePostCode)this.m_transformation), new ConditionActionsTab((IConditionActionSetContainer)this.m_transformation), new ParameterTab((IParametersContainer)this.m_transformation), new NotesTab((INotesAndDocumentsContainer)this.m_transformation), new ExtendedAttributesTab((IExtendedAttributesContainer)this.m_transformation)};
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Icon getIcon(int eSize) {
        if (eSize == 16) {
            return ICON_SMALL;
        }
        if (eSize == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("size must be ICON_SIZE_SMALL and ICON_SIZE_MEDIUM");
    }

    @Override
    public URL getIconURL(int eSize) {
        if (eSize == 16) {
            return ICON_URL_SMALL;
        }
        if (eSize == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("size must be ICON_SIZE_SMALL and ICON_SIZE_MEDIUM");
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        HPFPortDescriptionModel outputPort;
        HPFPortDescriptionModel[] aOutputPorts = this.m_transformation.getOutputPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aOutputPorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
        for (int i = 0; i < aOutputPorts.length - 1; ++i) {
            outputPort = aOutputPorts[i];
            aPortDesc[i + 1] = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(outputPort.getTooltipText(), outputPort.getName(), 1, new String[]{"WorkTable"});
        }
        int iPort = 7;
        outputPort = aOutputPorts[iPort];
        aPortDesc[iPort + 1] = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(outputPort.getTooltipText(), outputPort.getName(), 1, new String[]{"Document"});
        return aPortDesc;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        HPFPortDescriptionModel[] aPorts = this.m_transformation.getOutputPortDescriptions();
        for (int iPort = 0; iPort < aPorts.length; ++iPort) {
            IObject target = aPorts[iPort].getObject();
            if (target == null || !target.equals((Object)obj)) continue;
            return iPort + 1;
        }
        return -1;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof ITransform;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (obj instanceof IDataObject) {
            this.m_transformation.removeDataTarget((IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (obj instanceof IPhysicalTable) {
            this.m_transformation.addDataTarget((IDataObject)((IPhysicalTable)obj));
            return true;
        }
        return false;
    }
}

