/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.conditional.impl.ConditionalStartTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractControlTransformAdapter;
import com.sas.wadmin.transforms.conditional.ConditionTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ConditionalStartTransformAdapter
extends AbstractControlTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(ConditionalStartTransformAdapter.class);
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(ConditionalStartTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(ConditionalStartTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(ConditionalStartTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(ConditionalStartTransformModel.getTransformTypeID(), 24);
    private ConditionalStartTransformModel m_transform;

    public ConditionalStartTransformAdapter(ConditionalStartTransformModel transform) {
        super((ITransform)transform);
        this.m_transform = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return new ConditionTab(this.m_transform);
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_conditional_start", false);
            optionsTab.setHelpProduct("wdb");
            optionsTab.setHelpTopic("options_tab_cond_flow");
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(this.getNodeDetailsPanel());
            lTabs.add(optionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.getString("ConditionalStartTransformAdapter.InvalidOutputMessage.txt");
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.getString("ConditionalStartTransformAdapter.InvalidInputMessage.txt");
    }
}

