/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMultiplePortTransformModel;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTransformModel;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMapping;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractMultiplePortTransformAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.transforms.businessrules.BusinessRuleInputOutputTab;
import com.sas.wadmin.transforms.businessrules.BusinessRulesAttributesTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BusinessRuleTransformAdapter
extends AbstractMultiplePortTransformAdapter
implements IDataTransformNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(BusinessRuleTransformAdapter.class);
    private static final WAdminResource appActionsManagerBundle = WAdminResource.getBundle(AppActionsManager.class);
    public static final int CONTROL_PORT = 0;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 24);
    private BusinessRuleTransformModel m_transform;

    public BusinessRuleTransformAdapter(BusinessRuleTransformModel transform) {
        super((IMultiplePortTransformModel)transform);
        this.m_transform = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected MappingsTab.Configuration createMappingsConfiguration(boolean details) {
        MappingsTab.Configuration config = super.createMappingsConfiguration(details);
        config.setHiddenColumnsInTargetColumnsTable(new int[]{4});
        config.setMultipleTargetTablesEnabled(true);
        return config;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_bus_rule", false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(this.getNodeDetailsPanel());
            lTabs.add(this.createBRMappingsTab(false));
            lTabs.add(optionsTab);
            lTabs.add(new TransformTableOptionsTab((IDataTransform)this.m_transform, null, false));
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return new BusinessRulesAttributesTab(this.m_transform);
    }

    protected WAPropertyTab createBRMappingsTab(boolean details) {
        MappingsTab.Configuration configuration = new MappingsTab.Configuration();
        configuration.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        configuration.setPropagationActionsVisible(2);
        configuration.setSettingsActionVisible(false);
        configuration.setExpressionActionsVisible(true);
        configuration.setMappingsFilter(new BRMappingsFilter());
        configuration.setTargetTableLabel(bundle.getString("BusinessRuleTransformAdapter.MappingsTab.TargetTable.Label.txt"));
        configuration.setTargetTablesEditable(false);
        configuration.setTargetTableSettingsKeyPrefix("BusinessRule.RequiredInputs");
        configuration.setHiddenColumnsInTargetColumnsTable(new int[]{5, 6, 4});
        return new BusinessRuleInputOutputTab(this.m_transform, configuration);
    }

    @Override
    public void addContextMenuItems(JPopupMenu popupMenu) {
        boolean isSeparator = false;
        for (int index = 0; index < popupMenu.getSubElements().length; ++index) {
            MenuElement element = popupMenu.getSubElements()[index];
            if (element instanceof JMenu) {
                if (!((JMenu)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.ContextAction.PropagateColumnsForJob.txt")))) continue;
                popupMenu.remove(index);
                --index;
                continue;
            }
            if (element instanceof JMenuItem) {
                if (!((JMenuItem)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.ContextAction.MapColumnsForTransformations.txt"))) && !((JMenuItem)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.Action.ContextSettingsIncludeInPropagation.txt"))) && !((JMenuItem)element).getText().equalsIgnoreCase(this.removeAndCharacter(appActionsManagerBundle.getString("AppActionsManager.Action.ContextSettingsIncludeInMappings.txt")))) continue;
                popupMenu.remove(index);
                --index;
                continue;
            }
            if (element instanceof JPopupMenu.Separator) {
                if (!isSeparator) continue;
                popupMenu.remove(index);
                continue;
            }
            isSeparator = element instanceof JPopupMenu.Separator;
        }
        List missTargets = this.m_transform.getTargetPortsMissingObjects();
        if (missTargets.size() > 0) {
            JMenu menu = new JMenu(bundle.getString("BusinessRuleTransformAdapter.AddDefaultTargetAction.Name.txt"));
            ArrayList<ITransformPort<IPhysicalTable>> lst = new ArrayList<ITransformPort<IPhysicalTable>>();
            for (ITransformPort port : missTargets) {
                menu.add(new AddDefaultTargetAction((ITransformPort<IPhysicalTable>)port));
                lst.add((ITransformPort<IPhysicalTable>)port);
            }
            menu.add(new AddAllDefaultTargetAction(lst));
            popupMenu.add(menu);
        }
    }

    private String removeAndCharacter(String word) {
        return word.replaceAll("&", "");
    }

    private static class BRMappingsFilter
    implements IFilter {
        private BRMappingsFilter() {
        }

        public boolean pass(Object obj) {
            return obj instanceof IBusinessRuleMapping;
        }
    }

    private class AddDefaultTargetAction
    extends AbstractAction {
        private ITransformPort<IPhysicalTable> _port;

        public AddDefaultTargetAction(ITransformPort<IPhysicalTable> port) {
            this._port = port;
            this.putValue("Name", BusinessRuleTransformAdapter.this.getPortDescription(this._port));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BusinessRuleTransformAdapter.this.m_transform.createPortGeneratedTable(this._port);
        }
    }

    private class AddAllDefaultTargetAction
    extends AbstractAction {
        private List<ITransformPort<IPhysicalTable>> _port;

        public AddAllDefaultTargetAction(List<ITransformPort<IPhysicalTable>> port) {
            this._port = port;
            this.putValue("Name", bundle.getString("BusinessRuleTransformAdapter.AddAllDefaultTargetAction.Name.txt"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            BusinessRuleTransformAdapter.this.m_transform.getModel().startCompoundUndoable();
            try {
                for (ITransformPort<IPhysicalTable> port : this._port) {
                    BusinessRuleTransformAdapter.this.m_transform.createPortGeneratedTable(port);
                }
            }
            finally {
                BusinessRuleTransformAdapter.this.m_transform.getModel().endCompoundUndoable();
            }
        }
    }
}

