/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITransform;
import com.sas.wadmin.jobeditor.diagram.adapters.AbstractObjectAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.IndicatorFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.mutable.MutableInt;

public abstract class AbstractDataTransformAdapter
extends AbstractObjectAdapter
implements IDataTransformNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractDataTransformAdapter.class);
    protected static final String[] DEFAULT_TABLE_TYPES = new String[]{"PhysicalTable", "WorkTable"};
    protected static final IPortDescription DEFAULT_INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(bundle.getString("AbstractDataTransformAdapter.InputDataPort.ToolTip.txt"), 1, DEFAULT_TABLE_TYPES);
    protected static final IPortDescription DEFAULT_OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(bundle.getString("AbstractDataTransformAdapter.OutputDataPort.ToolTip.txt"), 1, DEFAULT_TABLE_TYPES);
    protected static final IPortDescription DEFAULT_INPUT_CONTROL_PORT = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
    protected static final IPortDescription DEFAULT_OUTPUT_CONTROL_PORT = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
    private static final IPortDescription[] INPUT_PORTS = new IPortDescription[]{DEFAULT_INPUT_CONTROL_PORT, DEFAULT_INPUT_DATA_PORT};
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{DEFAULT_OUTPUT_CONTROL_PORT, DEFAULT_OUTPUT_DATA_PORT};
    private IDataTransform m_transform;
    private Integer m_iDBMSType;
    private boolean m_bDatabasePushDown;

    public AbstractDataTransformAdapter(IDataTransform transform) {
        super((IComplexPersistableObject)transform);
        this.m_transform = transform;
    }

    @Override
    public String getNodeType() {
        return this.getName();
    }

    @Override
    public String getNodeTypeDescription() {
        return this.getName();
    }

    @Override
    public boolean isDatabasePushDown() {
        return this.m_bDatabasePushDown;
    }

    @Override
    public void setDatabasePushDown(boolean bDatabasePushDown) {
        this.m_bDatabasePushDown = bDatabasePushDown;
    }

    @Override
    public List getIndicatorButtons() {
        Integer iUserWritten = new Integer(1000);
        Integer iPrePost = new Integer(1001);
        Integer iDiagMode = new Integer(1002);
        Integer iDBMSType = new Integer(this.m_transform.getDBMSExecutionType());
        Integer iCheckpointSet = new Integer(1003);
        Integer iDataTransfer = new Integer(1005);
        if (this.m_transform.isUsingUserWrittenCode() && !this.getIndicatorsMap().containsKey(iUserWritten)) {
            this.getIndicatorsMap().put(iUserWritten, IndicatorFactory.getInstance().getIndicator(1000));
        } else if (!this.m_transform.isUsingUserWrittenCode() && this.getIndicatorsMap().containsKey(iUserWritten)) {
            this.getIndicatorsMap().remove(iUserWritten);
        }
        if ((this.m_transform.isUsingPostProcessCode() || this.m_transform.isUsingPreProcessCode()) && !this.getIndicatorsMap().containsKey(iPrePost)) {
            this.getIndicatorsMap().put(iPrePost, IndicatorFactory.getInstance().getIndicator(1001));
        } else if (!this.m_transform.isUsingPostProcessCode() && !this.m_transform.isUsingPreProcessCode() && this.getIndicatorsMap().containsKey(iPrePost)) {
            this.getIndicatorsMap().remove(iPrePost);
        }
        if (this.m_transform.isCollectingDiagnostics() && !this.getIndicatorsMap().containsKey(iDiagMode)) {
            this.getIndicatorsMap().put(iDiagMode, IndicatorFactory.getInstance().getIndicator(1002));
        } else if (!this.m_transform.isCollectingDiagnostics() && this.getIndicatorsMap().containsKey(iDiagMode)) {
            this.getIndicatorsMap().remove(iDiagMode);
        }
        if (this.m_transform.isCheckpointEnabled() && !this.getIndicatorsMap().containsKey(iCheckpointSet)) {
            this.getIndicatorsMap().put(iCheckpointSet, IndicatorFactory.getInstance().getIndicator(1003));
        } else if (!this.m_transform.isCheckpointEnabled() && this.getIndicatorsMap().containsKey(iCheckpointSet)) {
            this.getIndicatorsMap().remove(iCheckpointSet);
        }
        boolean isTransfer = ModelUIUtilities.isTransformPerformingDataTransfer(this.m_transform);
        if (isTransfer && !this.getIndicatorsMap().containsKey(iDataTransfer)) {
            this.getIndicatorsMap().put(iDataTransfer, IndicatorFactory.getInstance().getIndicator(1005));
        } else if (!isTransfer && this.getIndicatorsMap().containsKey(iDataTransfer)) {
            this.getIndicatorsMap().remove(iDataTransfer);
        }
        if ((this.isDatabasePushDown() || this.m_transform.isExplicitOn()) && this.m_transform.getDBMSExecutionType() != 109) {
            if (iDBMSType != this.m_iDBMSType) {
                this.getIndicatorsMap().remove(this.m_iDBMSType);
                this.getIndicatorsMap().put(iDBMSType, IndicatorFactory.getInstance().getIndicator(this.m_transform.getDBMSExecutionType()));
                this.m_iDBMSType = iDBMSType;
            }
        } else if (!this.isDatabasePushDown() && !this.m_transform.isExplicitOn() && this.m_iDBMSType != Integer.valueOf(109)) {
            this.getIndicatorsMap().remove(this.m_iDBMSType);
        }
        ArrayList buttons = new ArrayList();
        buttons.addAll(this.getIndicatorsMap().values());
        return buttons;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return INPUT_PORTS;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public boolean isAutomaticAddToControlFlow() {
        return false;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_transform.containsInDataSources((IDataObject)obj) ? 1 : -1;
        }
        return -1;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_transform.containsInDataTargets((IDataObject)obj) ? 1 : -1;
        }
        return -1;
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        int ind = this.getInputPortIndex(obj);
        if (ind != -1) {
            return new int[]{ind};
        }
        return null;
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        int ind = this.getOutputPortIndex(obj);
        if (ind != -1) {
            return new int[]{ind};
        }
        return null;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1 && obj instanceof IDataObject && !this.m_transform.containsInDataSources((IDataObject)obj)) {
            this.m_transform.addDataSource((IDataObject)obj);
            this.m_transform.addConnectedSource((IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1 && obj instanceof IDataObject) {
            this.m_transform.addDataTarget((IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1 && obj instanceof IDataObject) {
            this.m_transform.removeDataSource((IDataObject)obj);
            if (!this.m_transform.getModel().isUndoing()) {
                this.m_transform.removeConnectedSource((IDataObject)obj);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1 && obj instanceof IDataObject) {
            this.m_transform.removeDataTarget((IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex == 1 && obj instanceof IDataObject && !this.m_transform.containsInDataSources((IDataObject)obj);
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : portIndex == 1 && obj instanceof IDataObject && !this.m_transform.containsInDataTargets((IDataObject)obj);
    }

    @Override
    public boolean isMappingAutomatically(int iPortIndex) {
        return this.m_transform.isIncludedInMapping();
    }

    @Override
    public boolean isPropagatingAutomatically(int iPortIndex) {
        return this.m_transform.isIncludedInPropagation();
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj, int inputPortIndex) {
        return null;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj, MutableInt inputPortIndex) {
        return this.addInputPortDescription(obj, inputPortIndex.intValue());
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj) {
        return null;
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj, int outputPortIndex) {
        return null;
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj, MutableInt outputPortIndex) {
        return this.addOutputPortDescription(obj, outputPortIndex.intValue());
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj) {
        return null;
    }

    @Override
    public int deleteInputPort(Object obj, int inputPortIndex) {
        return -1;
    }

    @Override
    public int deleteInputPort(Object obj) {
        return -1;
    }

    @Override
    public int deleteOutputPort(Object obj, int outputPortIndex) {
        return -1;
    }

    @Override
    public int deleteOutputPort(Object obj) {
        return -1;
    }

    @Override
    public List updateInputPort(Object obj) {
        return null;
    }

    @Override
    public List updateOutputPort(Object obj) {
        return null;
    }

    public final JMenuItem[] getPopupMenuItems() {
        return null;
    }

    @Override
    public void addContextMenuItems(JPopupMenu mnuPopup) {
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return this.createMappingsTab(true);
    }

    protected MappingsTab.Configuration createMappingsConfiguration(boolean details) {
        MappingsTab.Configuration configuration = new MappingsTab.Configuration();
        configuration.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        return configuration;
    }

    protected WAPropertyTab createMappingsTab(boolean details) {
        return new MappingsTab((IMappingsContainer)this.m_transform, this.createMappingsConfiguration(details));
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.formatString("AbstractDataTransformAdapter.InvalidOutputMessage.txt", (Object)this.getName());
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.formatString("AbstractDataTransformAdapter.InvalidInputMessage.txt", (Object)this.getName());
    }
}

