/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.data;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.ISourceInvalidMessage;
import com.sas.wadmin.jobeditor.diagram.adapters.IndicatorFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.data.AbstractDataAdapter;
import com.sas.wadmin.visuals.common.ColumnsTab;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleObject;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class ExternalTableAdapter
extends AbstractDataAdapter
implements ISourceInvalidMessage {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExternalTableAdapter.class);
    private static final IPortDescription INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createInputPortDescriptionForDataObject("ExternalTable", 1);
    private static final IPortDescription OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createOutputPortDescriptionForDataObject("ExternalTable");
    private static final IPortDescription[] INPUT_PORTS = new IPortDescription[]{INPUT_DATA_PORT};
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{OUTPUT_DATA_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getInstance().getIconForPublicType("ExternalFile", 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getInstance().getIconForPublicType("ExternalFile", 24);
    private IExternalTable m_table;

    public ExternalTableAdapter(IExternalTable table) {
        super((IDataObject)table);
        this.m_table = table;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return INPUT_PORTS;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        throw new UnsupportedOperationException("This method is not supported because this class overrides the showPropertiesDialog method");
    }

    @Override
    public int showPropertiesDialog(Window wdwParent) {
        return AppPropertiesDialogFactory.getInstance().showPropertiesDialog(wdwParent, (SimpleObject)this.m_table);
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        ColumnsTab.Configuration config = new ColumnsTab.Configuration();
        config.setHiddenActions(new int[]{10});
        return new ColumnsTab((ITable)this.m_table, config);
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.getString("ExternalTableAdapter.InvalidOutputMessage.txt");
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.getString("ExternalTableAdapter.InvalidInputMessage.txt");
    }

    @Override
    public void addContextMenuItems(JPopupMenu menuPopup) {
    }

    @Override
    public List getIndicatorButtons() {
        if (this.m_table.getFile() != null && this.m_table.getFile().getAccessServer() instanceof IHadoopServer) {
            if (this.getIndicatorsMap().containsKey(1004)) {
                return new ArrayList(this.getIndicatorsMap().values());
            }
            this.getIndicatorsMap().clear();
            this.getIndicatorsMap().put(1004, IndicatorFactory.getInstance().getIndicator(1004));
        }
        return new ArrayList(this.getIndicatorsMap().values());
    }
}

