/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.data;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IDataTransform;
import com.sas.wadmin.jobeditor.diagram.adapters.AbstractObjectAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.DataNodeColumnsTableModel;
import com.sas.wadmin.jobeditor.diagram.adapters.data.IDataNodeAdapter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public abstract class AbstractDataAdapter
extends AbstractObjectAdapter
implements IDataNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractDataAdapter.class);
    private IDataObject m_data;
    private WsTable m_tableComponent;
    private DataNodeColumnsTableModel m_tableModel;

    public AbstractDataAdapter(IDataObject data) {
        super((IComplexPersistableObject)data);
        this.m_data = data;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        if (obj instanceof IDataTransform) {
            return this.m_data.containsInProducerTransforms((IDataTransform)obj) ? 0 : -1;
        }
        return -1;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        if (obj instanceof IDataTransform) {
            return this.m_data.containsInConsumerTransforms((IDataTransform)obj) ? 0 : -1;
        }
        return -1;
    }

    public final JMenuItem[] getPopupMenuItems() {
        return null;
    }

    @Override
    public void addContextMenuItems(JPopupMenu mnuPopup) {
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IDataTransform && !this.m_data.containsInProducerTransforms((IDataTransform)obj);
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IDataTransform;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IDataTransform;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IDataTransform;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IDataTransform && !this.m_data.containsInProducerTransforms((IDataTransform)obj);
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 && obj instanceof IDataTransform;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public JTable getTableComponent() {
        if (!(this.m_data instanceof ITable)) {
            throw new UnsupportedOperationException("Cannot show columns for non-table object.");
        }
        if (this.m_tableComponent == null) {
            this.createTableComponent((ITable)this.m_data);
        }
        return this.m_tableComponent;
    }

    protected void createTableComponent(ITable table) {
        this.m_tableModel = new DataNodeColumnsTableModel(table);
        this.m_tableComponent = new WsTable((WsAbstractTableModel)this.m_tableModel);
        this.m_tableComponent.setColumnHeaderVisible(false);
        this.m_tableComponent.setRowHeaderVisible(false);
        this.m_tableComponent.setEditable(false);
        this.m_tableComponent.setShowGrid(false);
        this.m_tableModel.load();
    }

    @Override
    public void disposeTableComponent() {
        if (this.m_tableModel != null) {
            this.m_tableModel.dispose();
        }
    }

    @Override
    public String getNodeType() {
        return this.m_data.getPublicType();
    }

    @Override
    public String getNodeTypeDescription() {
        return this.m_data.getPublicType();
    }
}

