/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.impl.BaseModel;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeDecorator;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.visuals.common.ExtendedAttributesTab;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.models.DecoratableIcon;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.plugins.PluginViewInterface;
import java.awt.Window;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;

public abstract class AbstractObjectAdapter
implements IDiagramNodeAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractObjectAdapter.class);
    private static final String ICON_KEY_SMALL = "AbstractObjectAdapter.DefaultIcon.16.image";
    private static final String ICON_KEY_MEDIUM = "AbstractObjectAdapter.DefaultIcon.24.image";
    private static final Icon ICON_SMALL = bundle.getIcon("AbstractObjectAdapter.DefaultIcon.16.image");
    private static final Icon ICON_MEDIUM = bundle.getIcon("AbstractObjectAdapter.DefaultIcon.24.image");
    private static final URL ICON_URL_SMALL = bundle.getIconURL("AbstractObjectAdapter.DefaultIcon.16.image");
    private static final URL ICON_URL_MEDIUM = bundle.getIconURL("AbstractObjectAdapter.DefaultIcon.24.image");
    private IComplexPersistableObject m_object;
    private Action m_actDefault;
    private Action m_actDelete;
    private WsDecoratableIcon m_icon;
    private Map m_hIndicators;

    public AbstractObjectAdapter(IComplexPersistableObject object) {
        this.m_object = object;
        this.m_icon = new WsDecoratableIcon();
        this.m_hIndicators = new HashMap();
    }

    @Override
    public IObject getObject() {
        return this.m_object;
    }

    @Override
    public String getName() {
        return this.m_object.getName();
    }

    public String getDescription() {
        return this.m_object.getDescription();
    }

    @Override
    public String getTitleText() {
        return this.m_object.getName();
    }

    @Override
    public String getToolTipText() {
        return this.m_object.getName();
    }

    @Override
    public Icon getDecoratedIcon(int size) {
        this.m_icon.setIcon(this.getIcon(size));
        try {
            DiagramNodeDecorator.getInstance().decorateIcon((DecoratableIcon)this.m_icon, (SimpleObject)this.m_object);
        }
        catch (ServiceException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return this.m_icon;
    }

    @Override
    public Icon getIcon() {
        return this.getIcon(16);
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    public URL getIconURL() {
        return this.getIconURL(16);
    }

    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    public Map getIndicatorsMap() {
        return this.m_hIndicators;
    }

    @Override
    public void setDefaultAction(Action actDefault) {
        this.m_actDefault = actDefault;
    }

    @Override
    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    @Override
    public void setDeleteAction(Action actDelete) {
        this.m_actDelete = actDelete;
    }

    @Override
    public Action getDeleteAction() {
        return this.m_actDelete;
    }

    @Override
    public boolean isLayoutRequired() {
        return false;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return null;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return null;
    }

    @Override
    public boolean isValidToConnectInputOnRedraw(IObject obj) {
        return true;
    }

    @Override
    public boolean isValidToConnectOutputOnRedraw(IObject obj) {
        return true;
    }

    @Override
    public int showPropertiesDialog(Window wdwParent) {
        WAPropertyTab[] aTabs = this.getPropertyTabs();
        if (aTabs == null) {
            return -1;
        }
        return ModelUIUtilities.showPropertiesDialog(this.m_object, aTabs);
    }

    protected abstract WAPropertyTab[] getPropertyTabs();

    protected void addAdvancedTabs(List lTabs, IPersistableObject obj, boolean bAddAuthorizationTab) {
        if (!AppPropertiesDialogFactory.isUserPreferenceToShowAdvancedTabs()) {
            return;
        }
        if (obj instanceof IExtendedAttributesContainer) {
            lTabs.add(new ExtendedAttributesTab((IExtendedAttributesContainer)obj));
        }
        if (bAddAuthorizationTab) {
            this.addAuthorizationPluginTab(lTabs, obj);
        }
    }

    private void addAuthorizationPluginTab(List lTabs, IPersistableObject obj) {
        try {
            Root mdo = ((BaseModel)obj.getModel()).getOMRObject(obj, Workspace.getMdFactory());
            ArrayList lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.authtab.AuthorizationTabPluginInterface", true);
            for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
                PluginViewInterface plugin = (PluginViewInterface)lPlugins.get(iPlugin);
                ArrayList lPluginTabs = plugin.getPropertyTabs((CMetadata)mdo);
                if (lPluginTabs == null) continue;
                for (int iTab = 0; iTab < lPluginTabs.size(); ++iTab) {
                    lTabs.add(lPluginTabs.get(iTab));
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
    }

    @Override
    public List getIndicatorButtons() {
        return null;
    }
}

