/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.WADiagramModel;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.IPersistableShape;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.PhysicalStorageTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPanel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Frame;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class WADiagramPanel
extends WsPFDPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(WADiagramPanel.class);
    private static final String SHOW_GRID_KEY = "DiagramPanel.ShowGrid";
    private static final String SNAP_TO_GRID_KEY = "DiagramPanel.SnapToGrid";
    private static final String GRID_STYLE_KEY = "DiagramPanel.GridStyle";
    private static final String FLOW_DIRECTION_KEY = "DiagramPanel.FlowDirection";
    private static final String ZOOM_KEY = "DiagramPanel.Zoom";
    private static final String STICKY_NOTE_COLOR_KEY = "DiagramPanel.StickyNoteColor";
    private static final String INCLUDE_PHYSICAL_NAME_KEY = "DiagramPanel.IncludePhysicalName";
    public static final String FLOW_LEFT_TO_RIGHT = "Right";
    public static final String FLOW_TOP_TO_BOTTOM = "Down";
    public static final String FLOW_BOTTOM_TO_TOP = "Up";
    public static final String ZOOM_10_PERCENT = ".1";
    public static final String ZOOM_25_PERCENT = ".25";
    public static final String ZOOM_50_PERCENT = ".5";
    public static final String ZOOM_75_PERCENT = ".75";
    public static final String ZOOM_100_PERCENT = "1";
    public static final String ZOOM_150_PERCENT = "1.5";
    public static final String ZOOM_200_PERCENT = "2.0";
    public static final String ZOOM_FIT_WIDTH = "FitWidth";
    public static final String ZOOM_FIT_HEIGHT = "FitHeight";
    public static final String ZOOM_FIT_BOTH = "FitBoth";
    public static final double ZOOM_10 = 0.1;
    public static final double ZOOM_25 = 0.25;
    public static final double ZOOM_50 = 0.5;
    public static final double ZOOM_75 = 0.75;
    public static final double ZOOM_100 = 1.0;
    public static final double ZOOM_150 = 1.5;
    public static final double ZOOM_200 = 2.0;
    private WADiagramModel m_mdlDiagram;
    private String m_sFlowDirection;
    private boolean m_bDoLayout;
    private boolean m_bShowGrid;
    private boolean m_bSnapToGrid;
    private int m_iGridStyle;
    private String m_sZoom;
    private HashMap m_mSelectedDragNodeLocations;
    private HashMap m_mSelectedDragLinkLocations;

    public WADiagramPanel(WADiagramModel mdl) {
        super((WsPFDModel)mdl);
        mdl.setIgnoreEvents(false);
        this.setDiagramModel(mdl);
        this.m_mSelectedDragNodeLocations = new HashMap();
        this.m_mSelectedDragLinkLocations = new HashMap();
        this.m_bDoLayout = true;
        this.setShowGrid(WADiagramPanel.isUserPreferenceToShowGrid());
        this.setSnapToGrid(WADiagramPanel.isUserPreferenceToSnapToGrid());
        this.setGridStyle(WADiagramPanel.getUserPreferenceGridStyle());
        this.setFlowDirection(WADiagramPanel.getUserPreferenceFlowDirection());
        this.setZoom(WADiagramPanel.getUserPreferenceZoom());
    }

    public void setModel(IPersistableObject mdlObject) {
        this.getDiagramModel().setMainObject(mdlObject);
        this.refreshDiagramModel();
    }

    public Point getDragNodeLocation(String id) {
        return (Point)this.m_mSelectedDragNodeLocations.get(id);
    }

    public Map getDragNodeMap() {
        return this.m_mSelectedDragNodeLocations;
    }

    public void setDiagramModel(WADiagramModel mdl) {
        this.m_mdlDiagram = mdl;
    }

    public WADiagramModel getDiagramModel() {
        return this.m_mdlDiagram;
    }

    protected LayoutStrategyInterface createDefaultLayoutStrategy(String eLayoutDirection) {
        LayeredLayoutStrategy lls = new LayeredLayoutStrategy();
        lls.setNodePositionHonored(true);
        lls.setFlowDirection(DiagramPanel.getUserPreferenceFlowDirection());
        return lls;
    }

    protected boolean addLink(PFDLink link) {
        WADiagramModel mdl = this.getDiagramModel();
        if (mdl != null) {
            mdl.putLink((IDiagramLink)link);
        }
        return true;
    }

    public void updateLayout() {
        this.doPFDLayout(true);
    }

    public boolean getDoLayout() {
        return this.m_bDoLayout;
    }

    public void setDoLayout(boolean bDoLayout) {
        this.m_bDoLayout = bDoLayout;
    }

    public void openStickyNote() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IDiagramStickyNote) {
            ((IDiagramStickyNote)aSelectedPrimitives[0]).setCollapsed(false);
        }
    }

    public void closeStickyNote() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IDiagramStickyNote) {
            ((IDiagramStickyNote)aSelectedPrimitives[0]).setCollapsed(true);
        }
    }

    protected void refreshDiagramModel() {
        WADiagramModel diagramModel = this.getDiagramModel();
        if (diagramModel == null) {
            return;
        }
        boolean bLayout = diagramModel.refresh();
        if (bLayout) {
            this.setDoLayout(false);
            this.updateLayout();
            this.setDoLayout(true);
        }
    }

    public void setZoom(String sZoom) {
        if (this.m_sZoom == sZoom) {
            return;
        }
        this.m_sZoom = sZoom;
        if (sZoom.equals(ZOOM_200_PERCENT)) {
            this.setScale(2.0);
        } else if (sZoom.equals(ZOOM_150_PERCENT)) {
            this.setScale(1.5);
        } else if (sZoom.equals(ZOOM_100_PERCENT)) {
            this.setScale(1.0);
        } else if (sZoom.equals(ZOOM_75_PERCENT)) {
            this.setScale(0.75);
        } else if (sZoom.equals(ZOOM_50_PERCENT)) {
            this.setScale(0.5);
        } else if (sZoom.equals(ZOOM_25_PERCENT)) {
            this.setScale(0.25);
        } else if (sZoom.equals(ZOOM_10_PERCENT)) {
            this.setScale(0.1);
        } else if (sZoom.equals(ZOOM_FIT_WIDTH)) {
            this.setScale(this.getFitScaleWidth());
            this.setViewPosition(new Point(0, 0));
        } else if (sZoom.equals(ZOOM_FIT_HEIGHT)) {
            this.setScale(this.getFitScaleHeight());
            this.setViewPosition(new Point(0, 0));
        } else if (sZoom.equals(ZOOM_FIT_BOTH)) {
            this.setScale(this.getFitScale());
            this.setViewPosition(new Point(0, 0));
        }
    }

    public String getZoom() {
        return this.m_sZoom;
    }

    public void setShowGrid(boolean bShowGrid) {
        if (this.m_bShowGrid == bShowGrid) {
            return;
        }
        this.m_bShowGrid = bShowGrid;
        this.setGridVisible(this.m_bShowGrid);
    }

    public boolean isShowGrid() {
        return this.m_bShowGrid;
    }

    public void setSnapToGrid(boolean bSnapToGrid) {
        if (this.m_bSnapToGrid == bSnapToGrid) {
            return;
        }
        this.m_bSnapToGrid = bSnapToGrid;
        super.setSnapToGrid(this.m_bSnapToGrid);
    }

    public boolean isSnapToGrid() {
        return this.m_bSnapToGrid;
    }

    public void setGridStyle(int iGridStyle) {
        if (this.m_iGridStyle == iGridStyle) {
            return;
        }
        this.m_iGridStyle = iGridStyle;
        this.setGridType(this.m_iGridStyle);
    }

    public int getGridStyle() {
        return this.m_iGridStyle;
    }

    public List getAllNodes() {
        return new ArrayList(this.getDiagramModel().getAllNodes());
    }

    public IDiagramNode[] selectNodes(IObject obj) {
        this.clearSelections();
        List lNodes = this.getDiagramModel().getNodes(obj);
        if (lNodes == null) {
            return new IDiagramNode[0];
        }
        for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
            PFDPrimitive node = (PFDPrimitive)lNodes.get(iNode);
            this.selectPrimitive(node);
        }
        return lNodes.toArray(new IDiagramNode[lNodes.size()]);
    }

    public boolean isDropValid(WsPFDPrimitive prim, Point ptEvent, List lObjects) {
        return this.isDropValid(ptEvent, lObjects);
    }

    public boolean drop(WsPFDPrimitive prim, Point ptEvent, List lObjects) {
        return this.drop(ptEvent, lObjects);
    }

    public boolean isAddValid(List lObjects) {
        return this.isEditable();
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return this.isAddValid(lObjects);
    }

    protected void addStickyNote(IDiagramStickyNote note, Point p) {
        WADiagramModel mdl = this.getDiagramModel();
        if (mdl != null) {
            this.getDiagramModel().getObjectModel().undoableEditHappened((UndoableEdit)new AddStickyNoteUndoable(note));
            mdl.addStickyNote(note);
            if (p != null) {
                note.setLocation(p.x, p.y);
            }
        }
    }

    protected void removeStickyNote(IDiagramStickyNote note) {
        WADiagramModel mdl = this.getDiagramModel();
        if (mdl != null) {
            mdl.getObjectModel().undoableEditHappened((UndoableEdit)new RemoveStickyNoteUndoable(note));
            mdl.removeStickyNote(note);
        }
    }

    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }

    public IDiagramNode[] findNodes(IObject obj) {
        return this.findNodes(obj, true);
    }

    public IDiagramNode[] findNodes(IObject obj, boolean bScrollToNodes) {
        this.clearSelections();
        WADiagramModel mdl = this.getDiagramModel();
        if (mdl != null && obj != null) {
            List lNodes = mdl.getNodes(obj);
            if (lNodes == null) {
                return null;
            }
            for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                PFDPrimitive node = (PFDPrimitive)lNodes.get(iNode);
                this.selectPrimitive(node);
                if (!bScrollToNodes) continue;
                this.panToPrimitive(node, false);
            }
            return lNodes.toArray(new IDiagramNode[lNodes.size()]);
        }
        return null;
    }

    public void setNodesLocation(IPersistableShape[] aNodes) {
        WADiagramModel mdl = this.getDiagramModel();
        IModel jobMdl = mdl.getObjectModel();
        if (jobMdl != null && mdl != null) {
            jobMdl.startCompoundUndoable();
            for (int iNode = 0; iNode < aNodes.length; ++iNode) {
                IPersistableShape node = aNodes[iNode];
                if (node instanceof IWorkTableNode) {
                    node = mdl.getNode(((IWorkTableNode)node).getTransformNodeId());
                }
                Point oldLocation = (Point)this.m_mSelectedDragNodeLocations.get(node.getId());
                Point newLocation = node.getSpotLocation(1, null);
                mdl.setLocation(node, oldLocation, newLocation);
                this.m_mSelectedDragNodeLocations.remove(node.getId());
            }
            jobMdl.endCompoundUndoable();
        }
    }

    public void saveLinksLocations(PFDLink[] aLinks) {
        for (int iLink = 0; iLink < aLinks.length; ++iLink) {
            WADiagramModel mdl;
            IDiagramLink link;
            if (!(aLinks[iLink] instanceof IDiagramLink) || (link = (IDiagramLink)aLinks[iLink]) == null || (mdl = this.getDiagramModel()) == null || link.getBreakPoints() == null) continue;
            Point[] aPoints = link.getBreakPoints();
            ArrayList<Point> points = new ArrayList<Point>();
            for (int iPoint = 0; iPoint < aPoints.length; ++iPoint) {
                Point point = new Point();
                point.setLocation(aPoints[iPoint]);
                points.add(point);
            }
            this.m_mSelectedDragLinkLocations.put(link.getId(), points.toArray(new Point[points.size()]));
        }
    }

    public void saveNodesLocation(IPersistableShape[] aNodes) {
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            IPersistableShape node = aNodes[iNode];
            WADiagramModel mdl = this.getDiagramModel();
            if (mdl != null && node instanceof IWorkTableNode) {
                node = mdl.getNode(((IWorkTableNode)node).getTransformNodeId());
            }
            this.m_mSelectedDragNodeLocations.put(node.getId(), node.getSpotLocation(1, null));
        }
    }

    public void setLinksLocations(PFDLink[] aLinks) {
        WADiagramModel mdl = this.getDiagramModel();
        IModel jobMdl = mdl.getObjectModel();
        if (jobMdl != null && mdl != null) {
            jobMdl.startCompoundUndoable();
            for (int iLink = 0; iLink < aLinks.length; ++iLink) {
                if (!(aLinks[iLink] instanceof IDiagramLink)) continue;
                IDiagramLink link = (IDiagramLink)aLinks[iLink];
                Point[] aOldLocation = (Point[])this.m_mSelectedDragLinkLocations.get(link.getId());
                Point[] aNewLocation = link.getBreakPoints();
                mdl.setLinkLocations(link, aOldLocation, aNewLocation);
                this.m_mSelectedDragLinkLocations.remove(link.getId());
            }
            jobMdl.endCompoundUndoable();
        }
    }

    public static void setUserPreferenceToFlowDirection(String sFlowDirection) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(FLOW_DIRECTION_KEY, sFlowDirection);
    }

    public static String getUserPreferenceFlowDirection() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(FLOW_DIRECTION_KEY, FLOW_LEFT_TO_RIGHT);
    }

    public static void setUserPreferenceForStickyNoteColor(String sColor) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(STICKY_NOTE_COLOR_KEY, sColor);
    }

    public static String getUserPreferenceForStickyNoteColor() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(STICKY_NOTE_COLOR_KEY, "NoteStyleYellow");
    }

    public static void setUserPreferenceForZoom(String sZoom) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(ZOOM_KEY, sZoom);
    }

    public static String getUserPreferenceZoom() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(ZOOM_KEY, ZOOM_100_PERCENT);
    }

    public static boolean isUserPreferenceToShowGrid() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_GRID_KEY, false);
    }

    public static boolean isUserPreferenceToIncludePhysicalName() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(INCLUDE_PHYSICAL_NAME_KEY, false);
    }

    public static void setUserPreferenceToShowGrid(boolean bShowGrid) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_GRID_KEY, bShowGrid);
    }

    public static void setUserPreferenceToSnapToGrid(boolean bSnapToGrid) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SNAP_TO_GRID_KEY, bSnapToGrid);
    }

    public static boolean isUserPreferenceToSnapToGrid() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SNAP_TO_GRID_KEY, false);
    }

    public static void setUserPreferenceToGridStyle(int iGridStyle) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(GRID_STYLE_KEY, iGridStyle);
    }

    public static int getUserPreferenceGridStyle() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(GRID_STYLE_KEY, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNodes(Point pt, Object[] aObjects) {
        boolean bAddHappened = false;
        WADiagramModel mdl = this.getDiagramModel();
        if (mdl == null) {
            return false;
        }
        IModel jobMdl = mdl.getObjectModel();
        jobMdl.startCompoundUndoable();
        try {
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                Object obj = aObjects[iObject];
                if (pt == null) {
                    pt = new Point();
                }
                this.ViewToModel(pt);
                if (obj instanceof TransformInterface) {
                    bAddHappened = mdl.dropTransform(pt, (TransformInterface)obj);
                } else if (obj instanceof CMetadata) {
                    bAddHappened = mdl.dropDataObject(pt, (CMetadata)obj);
                } else if (obj instanceof SimpleObject) {
                    bAddHappened = mdl.dropSimpleObject(pt, (SimpleObject)obj);
                }
                pt.x += 20;
                pt.y += 20;
            }
        }
        finally {
            jobMdl.endCompoundUndoable();
        }
        return bAddHappened;
    }

    public IDiagramNode showReplaceTableDialog(IDataNode tableNode) {
        SimpleObject newTable;
        ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 3, bundle.getString("DiagramPanel.ReplaceTable.Title.txt"));
        pnl.setSelectionOptional(true);
        String sTitle = bundle.getString("DiagramPanel.RegisterTable.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.show();
        if (dlg.getReturnValue() == 1 && (newTable = pnl.getSelectedObject()) != null) {
            this.addNodes(tableNode.getLocation(), new Object[]{newTable});
            return this.getDiagramModel().getLastNodeAdded();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTable() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IDataNode && ((IDiagramNode)aSelectedPrimitives[0]).getObject() instanceof ITable) {
            IModel jobModel = this.getObjectModel();
            IDataNode dataTableNode = (IDataNode)aSelectedPrimitives[0];
            ((IDataObject)dataTableNode.getObject()).setChangedNodeId(dataTableNode.getId());
            if (jobModel != null) {
                jobModel.startCompoundUndoable();
                try {
                    IDiagramNode newTableNode = this.showReplaceTableDialog(dataTableNode);
                    if (newTableNode != null) {
                        Point oldLocation = ((IDataNode)aSelectedPrimitives[0]).getLocation();
                        newTableNode.setLocation(oldLocation.x, oldLocation.y);
                        IJob job = this.getJobObject();
                        boolean bAutoPropagate = false;
                        boolean bAutoMap = false;
                        if (job != null) {
                            bAutoPropagate = job.isPropagatingAutomatically();
                            bAutoMap = job.isMappingAutomatically();
                            job.setPropagateAutomatically(false);
                            job.setMapAutomatically(false);
                        }
                        List links = this.getDiagramModel().getLinks(dataTableNode.getObject());
                        HashMap<NodeLayoutInterface, ArrayList<Integer>> consumerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            NodeLayoutInterface node;
                            BaseLink link = (BaseLink)links.get(iLink);
                            if (link == null || !((node = link.getToNode()) instanceof IDataTransformNode) || !link.getFromNodeId().equals(dataTableNode.getId())) continue;
                            ArrayList<Integer> cList = (ArrayList<Integer>)consumerTransforms.get(node);
                            if (cList == null) {
                                cList = new ArrayList<Integer>();
                                consumerTransforms.put(node, cList);
                            }
                            cList.add(new Integer(link.getToNodePortIndex()));
                            ((ITable)newTableNode.getObject()).setChangedNodeId(newTableNode.getId());
                        }
                        for (IDataTransformNode node : consumerTransforms.keySet()) {
                            List intList = (List)consumerTransforms.get(node);
                            ((IDataTransform)node.getObject()).replaceSourceTable((ITable)dataTableNode.getObject(), (ITable)newTableNode.getObject(), intList.toArray(new Integer[intList.size()]));
                        }
                        HashMap<NodeLayoutInterface, ArrayList<Integer>> producerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            NodeLayoutInterface node;
                            BaseLink link = (BaseLink)links.get(iLink);
                            if (link == null || !((node = link.getFromNode()) instanceof IDataTransformNode) || !link.getToNodeId().equals(dataTableNode.getId())) continue;
                            ArrayList<Integer> cList = (ArrayList<Integer>)producerTransforms.get(node);
                            if (cList == null) {
                                cList = new ArrayList<Integer>();
                                producerTransforms.put(node, cList);
                            }
                            cList.add(new Integer(link.getFromNodePortIndex()));
                            ((ITable)newTableNode.getObject()).setChangedNodeId(newTableNode.getId());
                        }
                        for (IDataTransformNode node : producerTransforms.keySet()) {
                            List intList = (List)producerTransforms.get(node);
                            ((IDataTransform)node.getObject()).replaceTargetTable((ITable)dataTableNode.getObject(), (ITable)newTableNode.getObject(), intList.toArray(new Integer[intList.size()]));
                        }
                        if (job != null) {
                            job.setPropagateAutomatically(bAutoPropagate);
                            job.setMapAutomatically(bAutoMap);
                            job.getDataObjectsList().remove(dataTableNode.getObject());
                        }
                        this.selectPrimitive((PFDPrimitive)newTableNode);
                    }
                }
                finally {
                    jobModel.endCompoundUndoable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showRegisterTableDialog(IPhysicalTable table) {
        WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("DiagramPanel.RegisterTable.Title.txt"), true);
        dlg.setResizable(true);
        dlg.setEditable(table.getModel().isEditable() && Workspace.isObjectEditable((SimpleObject)table));
        WATabbedPanel pnlMain = (WATabbedPanel)dlg.getMainPanel();
        dlg.addTab((WAPropertyTab)new GeneralTab((IObject)table, false, true));
        dlg.addTab((WAPropertyTab)new PhysicalStorageTab(table));
        IModel mdl = table.getModel();
        UndoManager mgrOld = mdl.getUndoManager();
        ModelUndoManager mgrNew = new ModelUndoManager();
        dlg.setUndoManager((UndoManager)((Object)mgrNew));
        pnlMain.setUndoManager((UndoManager)((Object)mgrNew));
        mdl.setUndoManager((UndoManager)((Object)mgrNew));
        try {
            dlg.show();
            ((UndoManager)((Object)mgrNew)).end();
            if (((UndoManager)((Object)mgrNew)).canUndo()) {
                if (dlg.getReturnValue() == 1) {
                    mgrOld.addEdit((UndoableEdit)((Object)mgrNew));
                } else {
                    ((UndoManager)((Object)mgrNew)).undo();
                }
            }
        }
        finally {
            mdl.setUndoManager(mgrOld);
        }
        return dlg.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTable() {
        block18: {
            PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
            if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IWorkTableNode) {
                IModel jobModel = this.getObjectModel();
                IWorkTableNode workTableNode = (IWorkTableNode)aSelectedPrimitives[0];
                if (jobModel != null) {
                    jobModel.startCompoundUndoable();
                    try {
                        int iDialogReturnValue = this.showRegisterTableDialog((IPhysicalTable)workTableNode.getObject());
                        if (iDialogReturnValue != 1) break block18;
                        String sId = null;
                        if (((IPhysicalTable)workTableNode.getObject()).getFolder() != null) {
                            ((IPhysicalTable)workTableNode.getObject()).getFolder().getID();
                        }
                        if (sId == null) {
                            sId = workTableNode.getObject().getID();
                        }
                        IPhysicalTable physicalTable = jobModel.getObjectFactory().createNewPhysicalTable(sId);
                        Map columnsMap = null;
                        try {
                            columnsMap = ((IWorkTable)workTableNode.getObject()).deepCopy(physicalTable);
                        }
                        catch (MdException me) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                            jobModel.endCompoundUndoable();
                            return;
                        }
                        IDiagramNode physicalTableNode = (IDiagramNode)this.getDiagramModel().getNodes((IObject)physicalTable).get(0);
                        Point location = workTableNode.getLocation();
                        this.getDiagramModel().setLocation(physicalTableNode, null, location);
                        IJob job = this.getJobObject();
                        boolean bAutoPropagate = false;
                        boolean bAutoMap = false;
                        if (job != null) {
                            job.getDataObjectsList().add(physicalTable);
                            bAutoPropagate = job.isPropagatingAutomatically();
                            bAutoMap = job.isMappingAutomatically();
                            job.setPropagateAutomatically(false);
                            job.setMapAutomatically(false);
                        }
                        List links = this.getDiagramModel().getLinks(workTableNode.getObject());
                        HashMap<NodeLayoutInterface, ArrayList<Integer>> consumerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            NodeLayoutInterface node;
                            BaseLink link = (BaseLink)links.get(iLink);
                            if (link == null || !((node = link.getToNode()) instanceof IDataTransformNode)) continue;
                            ArrayList<Integer> cList = (ArrayList<Integer>)consumerTransforms.get(node);
                            if (cList == null) {
                                cList = new ArrayList<Integer>();
                                consumerTransforms.put(node, cList);
                            }
                            cList.add(new Integer(link.getToNodePortIndex()));
                        }
                        for (IDataTransformNode node : consumerTransforms.keySet()) {
                            List intList = (List)consumerTransforms.get(node);
                            ((IDataTransform)node.getObject()).replaceSourceTable((ITable)workTableNode.getObject(), (ITable)physicalTable, columnsMap, intList.toArray(new Integer[intList.size()]));
                        }
                        HashMap<NodeLayoutInterface, ArrayList<Integer>> producerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            NodeLayoutInterface node;
                            BaseLink link = (BaseLink)links.get(iLink);
                            if (link == null || !((node = link.getFromNode()) instanceof IDataTransformNode)) continue;
                            ArrayList<Integer> cList = (ArrayList<Integer>)producerTransforms.get(node);
                            if (cList == null) {
                                cList = new ArrayList<Integer>();
                                producerTransforms.put(node, cList);
                            }
                            cList.add(new Integer(link.getFromNodePortIndex()));
                        }
                        for (IDataTransformNode node : producerTransforms.keySet()) {
                            List intList = (List)producerTransforms.get(node);
                            ((IDataTransform)node.getObject()).replaceTargetTable((ITable)workTableNode.getObject(), (ITable)physicalTable, columnsMap, intList.toArray(new Integer[intList.size()]));
                        }
                        if (job != null) {
                            job.setPropagateAutomatically(bAutoPropagate);
                            job.setMapAutomatically(bAutoMap);
                        }
                        this.selectPrimitive((PFDPrimitive)physicalTableNode);
                    }
                    finally {
                        jobModel.endCompoundUndoable();
                    }
                }
            }
        }
    }

    public IModel getObjectModel() {
        return this.getDiagramModel().getObjectModel();
    }

    public IObject getObject() {
        return this.getDiagramModel().getMainObject();
    }

    protected IJob getJobObject() {
        IJob job = null;
        IObject main = this.getObject();
        if (main instanceof IJob) {
            job = (IJob)main;
        } else if (main instanceof ITransform) {
            job = ((ITransform)main).getJob();
        }
        return job;
    }

    public String getFlowDirection() {
        return this.m_sFlowDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowDirection(String sFlowDirection) {
        WADiagramModel mdl;
        IModel jobMdl;
        if (this.m_sFlowDirection == sFlowDirection) {
            return;
        }
        if (!(sFlowDirection.equals(FLOW_BOTTOM_TO_TOP) || sFlowDirection.equals(FLOW_TOP_TO_BOTTOM) || sFlowDirection.equals(FLOW_LEFT_TO_RIGHT))) {
            throw new IllegalArgumentException("Illegal layout direction: " + sFlowDirection);
        }
        String oldFlow = this.m_sFlowDirection;
        this.m_sFlowDirection = sFlowDirection;
        LayeredLayoutStrategy lls = (LayeredLayoutStrategy)this.getPFDLayout();
        if (lls != null) {
            lls.setFlowDirection(sFlowDirection);
        }
        if ((jobMdl = (mdl = this.getDiagramModel()).getObjectModel()) != null && mdl != null) {
            mdl.setFlowDirection(sFlowDirection);
            if (this.m_bDoLayout) {
                try {
                    jobMdl.startCompoundUndoable();
                    jobMdl.undoableEditHappened((UndoableEdit)new SetFlowDirectionUndoable(oldFlow, sFlowDirection));
                    this.updateLayout();
                }
                finally {
                    jobMdl.endCompoundUndoable();
                }
            }
        }
    }

    protected boolean save() {
        WADiagramModel diagramModel = this.getDiagramModel();
        if (diagramModel == null) {
            return false;
        }
        return diagramModel.save();
    }

    private class AddStickyNoteUndoable
    extends AbstractUndoableEdit {
        private IDiagramStickyNote m_stickyNote;

        public AddStickyNoteUndoable(IDiagramStickyNote stickyNote) {
            this.m_stickyNote = stickyNote;
        }

        @Override
        public void undo() {
            super.undo();
            WADiagramModel mdl = WADiagramPanel.this.getDiagramModel();
            if (mdl != null) {
                mdl.removePrimitive((PFDPrimitive)this.m_stickyNote);
            }
        }

        @Override
        public void redo() {
            super.redo();
            WADiagramPanel.this.addStickyNote(this.m_stickyNote, this.m_stickyNote.getLocation());
        }
    }

    private class RemoveStickyNoteUndoable
    extends AbstractUndoableEdit {
        private IDiagramStickyNote m_stickyNote;

        public RemoveStickyNoteUndoable(IDiagramStickyNote stickyNote) {
            this.m_stickyNote = stickyNote;
        }

        @Override
        public void undo() {
            super.undo();
            WADiagramPanel.this.addStickyNote(this.m_stickyNote, this.m_stickyNote.getLocation());
        }

        @Override
        public void redo() {
            super.redo();
            WADiagramModel mdl = WADiagramPanel.this.getDiagramModel();
            if (mdl != null) {
                mdl.removePrimitive((PFDPrimitive)this.m_stickyNote);
            }
        }
    }

    private class SetFlowDirectionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldFlowDirection;
        private String m_sNewFlowDirection;

        public SetFlowDirectionUndoable(String sOldFlowDirection, String sNewFlowDirection) {
            this.m_sOldFlowDirection = sOldFlowDirection;
            this.m_sNewFlowDirection = sNewFlowDirection;
        }

        @Override
        public void undo() {
            super.undo();
            WADiagramPanel.this.setFlowDirection(this.m_sOldFlowDirection);
        }

        @Override
        public void redo() {
            super.redo();
            WADiagramPanel.this.setFlowDirection(this.m_sNewFlowDirection);
        }
    }
}

