/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ObjectFactory;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.wadmin.jobeditor.diagram.DiagramModel;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.ICollapsibleShape;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramPersistable;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.IForceShowPorts;
import com.sas.wadmin.jobeditor.diagram.shapes.IPersistableShape;
import com.sas.wadmin.jobeditor.diagram.shapes.ITransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.PhysicalStorageTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPanel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class DiagramPanel
extends WsPFDPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(DiagramPanel.class);
    public static final int COLLAPSED_CHANGED = 7001;
    public static final String COLLAPSED_TRUE = "true";
    public static final String COLLAPSED_FALSE = "false";
    public static final String FLOW_LEFT_TO_RIGHT = "Right";
    public static final String FLOW_TOP_TO_BOTTOM = "Down";
    public static final String FLOW_BOTTOM_TO_TOP = "Up";
    public static final String ZOOM_10_PERCENT = ".1";
    public static final String ZOOM_25_PERCENT = ".25";
    public static final String ZOOM_50_PERCENT = ".5";
    public static final String ZOOM_75_PERCENT = ".75";
    public static final String ZOOM_100_PERCENT = "1";
    public static final String ZOOM_150_PERCENT = "1.5";
    public static final String ZOOM_200_PERCENT = "2.0";
    public static final String ZOOM_FIT_WIDTH = "FitWidth";
    public static final String ZOOM_FIT_HEIGHT = "FitHeight";
    public static final String ZOOM_FIT_BOTH = "FitBoth";
    public static final double ZOOM_10 = 0.1;
    public static final double ZOOM_25 = 0.25;
    public static final double ZOOM_50 = 0.5;
    public static final double ZOOM_75 = 0.75;
    public static final double ZOOM_100 = 1.0;
    public static final double ZOOM_150 = 1.5;
    public static final double ZOOM_200 = 2.0;
    private static final String COLLAPSE_KEY = "DiagramPanel.Collapse";
    private static final String SHOW_CONTROL_ORDER_KEY = "DiagramPanel.ShowControlOrder";
    private static final String SHOW_GRID_KEY = "DiagramPanel.ShowGrid";
    private static final String SNAP_TO_GRID_KEY = "DiagramPanel.SnapToGrid";
    private static final String GRID_STYLE_KEY = "DiagramPanel.GridStyle";
    private static final String DO_AUTOMATIC_CONTROL_FLOW_KEY = "DiagramPanel.DoAutomaticControlFlow";
    private static final String AUTOMATICALLY_JOIN_KEY = "DiagramPanel.AutomaticallyJoin";
    private static final String AUTOMATIC_PASSTHRU = "DiagramPanel.AutomaticPassThru";
    private static final String FLOW_DIRECTION_KEY = "DiagramPanel.FlowDirection";
    private static final String ZOOM_KEY = "DiagramPanel.Zoom";
    private static final String STICKY_NOTE_COLOR_KEY = "DiagramPanel.StickyNoteColor";
    private static final String INCLUDE_PHYSICAL_NAME_KEY = "DiagramPanel.IncludePhysicalName";
    private static final String DEFAULT_REGISTER_TABLE_LIBRARYID = "DefaultRegisterTableLibraryId";
    private boolean m_bAutomaticControlFlow;
    private boolean m_bShowGrid;
    private boolean m_bSnapToGrid;
    private int m_iGridStyle;
    private String m_sZoom;
    private String m_sFlowDirection;
    private String m_sLibraryId;
    private boolean m_bDoLayout;
    private PFDViewListener m_lsnrDiagram;
    private PFDModelListener m_lsnrDiagramModel;
    private RunModelListener m_lsnrRun;
    private ValidateModelListener m_lsnrValidate;
    private HashMap m_mSelectedDragNodeLocations;
    private HashMap m_mSelectedDragLinkLocations;
    private RunModel m_mdlRun;
    private ValidateModel m_mdlValidate;

    public static boolean isUserPreferenceToCollapse() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(COLLAPSE_KEY, true);
    }

    public static void setUserPreferenceToCollapse(boolean bCollapse) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(COLLAPSE_KEY, bCollapse);
    }

    public static boolean isUserPreferenceToIncludePhysicalName() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(INCLUDE_PHYSICAL_NAME_KEY, false);
    }

    public static void setUserPreferenceToIncludePhysicalName(boolean bIncludePhysicalName) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(INCLUDE_PHYSICAL_NAME_KEY, bIncludePhysicalName);
    }

    public static boolean isUserPreferenceToShowGrid() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_GRID_KEY, true);
    }

    public static void setUserPreferenceToShowGrid(boolean bShowGrid) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_GRID_KEY, bShowGrid);
    }

    public static void setUserPreferenceToSnapToGrid(boolean bSnapToGrid) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SNAP_TO_GRID_KEY, bSnapToGrid);
    }

    public static boolean isUserPreferenceToSnapToGrid() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SNAP_TO_GRID_KEY, false);
    }

    public static void setUserPreferenceToGridStyle(int iGridStyle) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(GRID_STYLE_KEY, iGridStyle);
    }

    public static int getUserPreferenceGridStyle() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(GRID_STYLE_KEY, 0);
    }

    public static void setUserPreferenceToFlowDirection(String sFlowDirection) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(FLOW_DIRECTION_KEY, sFlowDirection);
    }

    public static String getUserPreferenceFlowDirection() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(FLOW_DIRECTION_KEY, FLOW_LEFT_TO_RIGHT);
    }

    public static void setUserPreferenceForStickyNoteColor(String sColor) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(STICKY_NOTE_COLOR_KEY, sColor);
    }

    public static String getUserPreferenceForStickyNoteColor() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(STICKY_NOTE_COLOR_KEY, "NoteStyleYellow");
    }

    public static void setUserPreferenceForZoom(String sZoom) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(ZOOM_KEY, sZoom);
    }

    public static String getUserPreferenceZoom() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(ZOOM_KEY, ZOOM_100_PERCENT);
    }

    public static boolean isUserPreferenceToDoAutomaticControlFlow() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(DO_AUTOMATIC_CONTROL_FLOW_KEY, true);
    }

    public static void setUserPreferenceToDoAutomaticControlFlow(boolean bDoAutomaticControlFlow) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(DO_AUTOMATIC_CONTROL_FLOW_KEY, bDoAutomaticControlFlow);
    }

    public static void setUserPreferenceToAutomaticallyJoin(boolean bAutomaticallyJoin) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(AUTOMATICALLY_JOIN_KEY, bAutomaticallyJoin);
    }

    public static boolean isUserPreferenceToAutomaticallyJoin() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AUTOMATICALLY_JOIN_KEY, true);
    }

    public static void setUserPreferenceToAutomaticPassThru(boolean bAutomaticPassThru) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(AUTOMATIC_PASSTHRU, bAutomaticPassThru);
    }

    public static boolean isUserPreferenceToAutomaticPassThru() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AUTOMATIC_PASSTHRU, false);
    }

    public static boolean isUserPreferenceToShowControlOrder() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_CONTROL_ORDER_KEY, false);
    }

    public static void setUserPreferenceToShowControlOrder(boolean bShowControlOrder) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_CONTROL_ORDER_KEY, bShowControlOrder);
    }

    private static String getUserPreferenceDefaultRegisterTableLibrary() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(DEFAULT_REGISTER_TABLE_LIBRARYID);
    }

    private static void setUserPreferenceDefaultRegisterTableLibrary(String sLibraryId) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(DEFAULT_REGISTER_TABLE_LIBRARYID, sLibraryId);
    }

    public DiagramPanel() {
    }

    public DiagramPanel(DiagramModel mdl) {
        super((WsPFDModel)mdl);
        mdl.setIgnoreEvents(false);
        this.m_lsnrDiagram = new DiagramListener();
        this.addPFDViewListener(this.m_lsnrDiagram);
        this.m_mSelectedDragNodeLocations = new HashMap();
        this.m_mSelectedDragLinkLocations = new HashMap();
        this.setControlOrderVisible(DiagramPanel.isUserPreferenceToShowControlOrder());
        this.setAutomaticControlFlow(DiagramPanel.isUserPreferenceToDoAutomaticControlFlow());
        this.setShowGrid(DiagramPanel.isUserPreferenceToShowGrid());
        this.setSnapToGrid(DiagramPanel.isUserPreferenceToSnapToGrid());
        this.setGridStyle(DiagramPanel.getUserPreferenceGridStyle());
        this.setFlowDirection(DiagramPanel.getUserPreferenceFlowDirection());
        this.setZoom(DiagramPanel.getUserPreferenceZoom());
        if (mdl != null) {
            mdl.setCollapse(DiagramPanel.isUserPreferenceToCollapse());
        }
        this.m_lsnrRun = new RunJobModelListener();
        this.m_lsnrValidate = new ValidateJobModelListener();
        this.m_lsnrDiagramModel = new DiagramModelListener();
        this.getPFDModel().addPFDModelListener(this.m_lsnrDiagramModel);
        this.getSelectionModel().setSelectionMode(1);
        this.m_bDoLayout = true;
    }

    public void setJobModel(DesignTimeJobModel mdlJob) {
        this.getDiagramModel().setJobModel(mdlJob);
        this.refreshDiagramModel();
    }

    public ValidateModel getValidateModel() {
        return this.m_mdlValidate;
    }

    public void setValidateModel(ValidateModel mdlValidate) {
        if (this.m_mdlValidate == mdlValidate) {
            return;
        }
        if (this.m_mdlValidate != null) {
            this.m_mdlValidate.removeListener(this.m_lsnrValidate);
        }
        this.m_mdlValidate = mdlValidate;
        if (this.m_mdlValidate != null) {
            this.m_mdlValidate.addListener(this.m_lsnrValidate);
        }
    }

    public RunModel getRunModel() {
        return this.m_mdlRun;
    }

    public void setRunModel(RunModel mdlRunTime) {
        if (this.m_mdlRun == mdlRunTime) {
            return;
        }
        if (this.m_mdlRun != null) {
            this.m_mdlRun.removeListener(this.m_lsnrRun);
        }
        this.m_mdlRun = mdlRunTime;
        if (this.m_mdlRun != null) {
            this.m_mdlRun.addListener(this.m_lsnrRun);
        }
    }

    public void setModeOnTransformNodes(int eMode) {
        this.getDiagramModel().setModeOnTransformNodes(eMode);
    }

    public DesignTimeJobModel getJobModel() {
        return this.getDiagramModel().getJobModel();
    }

    public void setNodesLocation(IPersistableShape[] aNodes) {
        DiagramModel mdl = (DiagramModel)this.getPFDModel();
        DesignTimeJobModel jobMdl = mdl.getJobModel();
        if (jobMdl != null && mdl != null) {
            jobMdl.startCompoundUndoable();
            for (int iNode = 0; iNode < aNodes.length; ++iNode) {
                IPersistableShape node = aNodes[iNode];
                if (node == null) continue;
                if (node instanceof IWorkTableNode) {
                    node = mdl.getNode(((IWorkTableNode)node).getTransformNodeId());
                }
                Point oldLocation = (Point)this.m_mSelectedDragNodeLocations.get(node.getId());
                Point newLocation = node.getSpotLocation(1, null);
                mdl.setLocation(node, oldLocation, newLocation);
                this.m_mSelectedDragNodeLocations.remove(node.getId());
            }
            jobMdl.endCompoundUndoable();
        }
    }

    public void setLinksLocations(PFDLink[] aLinks) {
        DiagramModel mdl = (DiagramModel)this.getPFDModel();
        DesignTimeJobModel jobMdl = mdl.getJobModel();
        if (jobMdl != null && mdl != null) {
            jobMdl.startCompoundUndoable();
            for (int iLink = 0; iLink < aLinks.length; ++iLink) {
                IDiagramLink link;
                if (!(aLinks[iLink] instanceof IDiagramLink) || (link = (IDiagramLink)aLinks[iLink]) == null) continue;
                Point[] aOldLocation = (Point[])this.m_mSelectedDragLinkLocations.get(link.getId());
                Point[] aNewLocation = link.getBreakPoints();
                mdl.setLinkLocations(link, aOldLocation, aNewLocation);
                this.m_mSelectedDragLinkLocations.remove(link.getId());
            }
            jobMdl.endCompoundUndoable();
        }
    }

    public void saveLinksLocations(PFDLink[] aLinks) {
        for (int iLink = 0; iLink < aLinks.length; ++iLink) {
            DiagramModel mdl;
            IDiagramLink link;
            if (!(aLinks[iLink] instanceof IDiagramLink) || (link = (IDiagramLink)aLinks[iLink]) == null || (mdl = (DiagramModel)this.getPFDModel()) == null || link.getBreakPoints() == null) continue;
            Point[] aPoints = link.getBreakPoints();
            ArrayList<Point> points = new ArrayList<Point>();
            for (int iPoint = 0; iPoint < aPoints.length; ++iPoint) {
                Point point = new Point();
                point.setLocation(aPoints[iPoint]);
                points.add(point);
            }
            this.m_mSelectedDragLinkLocations.put(link.getId(), points.toArray(new Point[points.size()]));
        }
    }

    public void saveNodesLocation(IPersistableShape[] aNodes) {
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            IPersistableShape node = aNodes[iNode];
            if (node == null) continue;
            DiagramModel mdl = (DiagramModel)this.getPFDModel();
            if (mdl != null && node instanceof IWorkTableNode) {
                node = mdl.getNode(((IWorkTableNode)node).getTransformNodeId());
            }
            this.m_mSelectedDragNodeLocations.put(node.getId(), node.getSpotLocation(1, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCollapse(boolean bCollapsed) {
        DiagramModel mdl = this.getDiagramModel();
        DesignTimeJobModel jobMdl = mdl.getJobModel();
        if (jobMdl != null && mdl != null) {
            jobMdl.startCompoundUndoable();
            try {
                jobMdl.undoableEditHappened((UndoableEdit)new SetCollapseUndoable(bCollapsed));
                mdl.setCollapse(bCollapsed);
            }
            finally {
                jobMdl.endCompoundUndoable();
            }
        }
    }

    public boolean isCollapsed() {
        return this.getDiagramModel().isCollapsed();
    }

    public void setControlOrderVisible(boolean bVisible) {
        this.getDiagramModel().setControlOrderVisible(bVisible);
    }

    public boolean isControlOrderVisible() {
        return this.getDiagramModel().isControlOrderVisible();
    }

    public void setAutomaticControlFlow(boolean bAutomaticControlFlow) {
        if (this.m_bAutomaticControlFlow == bAutomaticControlFlow) {
            return;
        }
        this.m_bAutomaticControlFlow = bAutomaticControlFlow;
    }

    public boolean isAutomaticControlFlow() {
        return this.m_bAutomaticControlFlow;
    }

    public boolean getDoLayout() {
        return this.m_bDoLayout;
    }

    public void setDoLayout(boolean bDoLayout) {
        this.m_bDoLayout = bDoLayout;
    }

    public void setLayoutDirection(String eLayoutDirection) {
    }

    public String getFlowDirection() {
        return this.m_sFlowDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowDirection(String sFlowDirection) {
        if (this.m_sFlowDirection == sFlowDirection) {
            return;
        }
        if (!(sFlowDirection.equals(FLOW_BOTTOM_TO_TOP) || sFlowDirection.equals(FLOW_TOP_TO_BOTTOM) || sFlowDirection.equals(FLOW_LEFT_TO_RIGHT))) {
            throw new IllegalArgumentException("Illegal layout direction: " + sFlowDirection);
        }
        String oldFlow = this.m_sFlowDirection;
        this.m_sFlowDirection = sFlowDirection;
        LayeredLayoutStrategy lls = (LayeredLayoutStrategy)this.getPFDLayout();
        if (lls != null) {
            lls.setFlowDirection(sFlowDirection);
        }
        DiagramModel mdl = (DiagramModel)this.getPFDModel();
        DesignTimeJobModel jobMdl = mdl.getJobModel();
        if (mdl != null) {
            this.getModel().setFlowDirection(sFlowDirection);
        }
        if (jobMdl != null && this.m_bDoLayout) {
            try {
                jobMdl.startCompoundUndoable();
                jobMdl.undoableEditHappened((UndoableEdit)new SetFlowDirectionUndoable(oldFlow, sFlowDirection));
                this.updateLayout();
            }
            finally {
                jobMdl.endCompoundUndoable();
            }
        }
    }

    protected LayoutStrategyInterface createDefaultLayoutStrategy(String eLayoutDirection) {
        LayeredLayoutStrategy lls = new LayeredLayoutStrategy();
        lls.setNodePositionHonored(true);
        lls.setFlowDirection(DiagramPanel.getUserPreferenceFlowDirection());
        return lls;
    }

    public void updateLayout() {
        this.doPFDLayout(true);
    }

    public void setZoom(String sZoom) {
        if (this.m_sZoom == sZoom) {
            return;
        }
        this.m_sZoom = sZoom;
        if (sZoom.equals(ZOOM_200_PERCENT)) {
            this.setScale(2.0);
        } else if (sZoom.equals(ZOOM_150_PERCENT)) {
            this.setScale(1.5);
        } else if (sZoom.equals(ZOOM_100_PERCENT)) {
            this.setScale(1.0);
        } else if (sZoom.equals(ZOOM_75_PERCENT)) {
            this.setScale(0.75);
        } else if (sZoom.equals(ZOOM_50_PERCENT)) {
            this.setScale(0.5);
        } else if (sZoom.equals(ZOOM_25_PERCENT)) {
            this.setScale(0.25);
        } else if (sZoom.equals(ZOOM_10_PERCENT)) {
            this.setScale(0.1);
        } else if (sZoom.equals(ZOOM_FIT_WIDTH)) {
            this.setScale(this.getFitScaleWidth());
            this.setViewPosition(new Point(0, 0));
        } else if (sZoom.equals(ZOOM_FIT_HEIGHT)) {
            this.setScale(this.getFitScaleHeight());
            this.setViewPosition(new Point(0, 0));
        } else if (sZoom.equals(ZOOM_FIT_BOTH)) {
            this.setScale(this.getFitScale());
            this.setViewPosition(new Point(0, 0));
        }
    }

    public String getZoom() {
        return this.m_sZoom;
    }

    public void setShowGrid(boolean bShowGrid) {
        if (this.m_bShowGrid == bShowGrid) {
            return;
        }
        this.m_bShowGrid = bShowGrid;
        this.setGridVisible(this.m_bShowGrid);
    }

    public boolean isShowGrid() {
        return this.m_bShowGrid;
    }

    public void setSnapToGrid(boolean bSnapToGrid) {
        if (this.m_bSnapToGrid == bSnapToGrid) {
            return;
        }
        this.m_bSnapToGrid = bSnapToGrid;
        super.setSnapToGrid(this.m_bSnapToGrid);
    }

    public boolean isSnapToGrid() {
        return this.m_bSnapToGrid;
    }

    public void setGridStyle(int iGridStyle) {
        if (this.m_iGridStyle == iGridStyle) {
            return;
        }
        this.m_iGridStyle = iGridStyle;
        this.setGridType(this.m_iGridStyle);
    }

    public int getGridStyle() {
        return this.m_iGridStyle;
    }

    public List getAllNodes() {
        return new ArrayList(this.getDiagramModel().getAllNodes());
    }

    public void addStickyNote(IDiagramStickyNote note, Point point) {
        DiagramModel mdl = this.getDiagramModel();
        if (mdl != null) {
            mdl.addStickyNote(note, point);
        }
    }

    protected void removeStickyNote(IDiagramStickyNote note) {
        DiagramModel mdl = (DiagramModel)this.getPFDModel();
        if (mdl != null) {
            mdl.removeStickyNote(note);
        }
    }

    private boolean addLink(PFDLink link) {
        DiagramModel mdl = (DiagramModel)this.getPFDModel();
        if (mdl != null) {
            mdl.putLink((IDiagramLink)link);
        }
        return true;
    }

    private SimpleObject showReplaceTableDialog(IDataNode tableNode) {
        SimpleObject newTable;
        ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 3, bundle.getString("DiagramPanel.ReplaceTable.Title.txt"));
        pnl.setSelectionOptional(true);
        String sTitle = bundle.getString("DiagramPanel.ReplaceTable.TableSelectorTitle.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.setHelpProduct("wdb");
        dlg.setHelpTopic("table_selector_window");
        dlg.show();
        if (dlg.getReturnValue() == 1 && (newTable = pnl.getSelectedObject()) != null && !newTable.getID().equals(tableNode.getObject().getID())) {
            return newTable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showRegisterTableDialog(IPhysicalTable table) {
        WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("DiagramPanel.RegisterTable.Title.txt"), true);
        dlg.setResizable(true);
        dlg.setEditable(table.getModel().isEditable() && Workspace.isObjectEditable((SimpleObject)table));
        WATabbedPanel pnlMain = (WATabbedPanel)dlg.getMainPanel();
        GeneralTab genTab = new GeneralTab((IObject)table, false, true);
        MdObjectStore store = null;
        try {
            store = Workspace.getMdFactory().createObjectStore(null, "registerTable");
            genTab.setFolder(WsMetadataUtil.getDefaultFolder((MdObjectStore)store));
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        dlg.addTab((WAPropertyTab)genTab);
        dlg.addTab((WAPropertyTab)new PhysicalStorageTab(table));
        IModel mdl = table.getModel();
        UndoManager mgrOld = mdl.getUndoManager();
        ModelUndoManager mgrNew = new ModelUndoManager();
        dlg.setUndoManager((UndoManager)((Object)mgrNew));
        pnlMain.setUndoManager((UndoManager)((Object)mgrNew));
        mdl.setUndoManager((UndoManager)((Object)mgrNew));
        try {
            dlg.show();
            ((UndoManager)((Object)mgrNew)).end();
            if (((UndoManager)((Object)mgrNew)).canUndo()) {
                if (dlg.getReturnValue() == 1) {
                    mgrOld.addEdit((UndoableEdit)((Object)mgrNew));
                } else {
                    ((UndoManager)((Object)mgrNew)).undo();
                }
            }
        }
        finally {
            mdl.setUndoManager(mgrOld);
        }
        return dlg.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTable() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IDataNode && ((IDiagramNode)aSelectedPrimitives[0]).getObject() instanceof ITable) {
            DesignTimeJobModel jobModel = this.getJobModel();
            IDataNode dataTableNode = (IDataNode)aSelectedPrimitives[0];
            if (jobModel != null) {
                IDiagramPersistable newTableNode = null;
                boolean bValidReplace = true;
                boolean bReplacingTableAlreadyExists = false;
                jobModel.startCompoundUndoable();
                ((IDataObject)dataTableNode.getObject()).setChangedNodeId(dataTableNode.getId());
                try {
                    SimpleObject newTable = this.showReplaceTableDialog(dataTableNode);
                    if (newTable != null) {
                        if (jobModel.getObject(newTable.getID()) != null) {
                            bReplacingTableAlreadyExists = true;
                        }
                        this.addNodes(dataTableNode.getLocation(), new Object[]{newTable});
                        newTableNode = this.getDiagramModel().getLastNodeAdded();
                    }
                    if (newTableNode != null) {
                        BaseLink link;
                        int iLink;
                        List links = this.getDiagramModel().getLinks(dataTableNode.getObject());
                        for (iLink = 0; !(iLink >= links.size() || (link = (BaseLink)links.get(iLink)) != null && link.getToNode() instanceof IDataTransformNode && link.getFromNodeId().equals(dataTableNode.getId()) && !(bValidReplace = ((IDiagramNode)link.getToNode()).getAdapter().isValidConnectToInput(this.getDiagramModel().getLastNodeAdded().getObject(), link.getToNodePortIndex()))); ++iLink) {
                        }
                        if (!bValidReplace) {
                            return;
                        }
                        for (iLink = 0; !(iLink >= links.size() || (link = (BaseLink)links.get(iLink)) != null && link.getFromNode() instanceof IDataTransformNode && link.getToNodeId().equals(dataTableNode.getId()) && !(bValidReplace = ((IDiagramNode)link.getFromNode()).getAdapter().isValidConnectToOutput(this.getDiagramModel().getLastNodeAdded().getObject(), link.getFromNodePortIndex()))); ++iLink) {
                        }
                        if (!bValidReplace) {
                            return;
                        }
                        Point oldLocation = ((IDataNode)aSelectedPrimitives[0]).getLocation();
                        newTableNode.setLocation(oldLocation.x, oldLocation.y);
                        Point p = new Point();
                        newTableNode.getSpotLocation(1, p);
                        newTableNode.getUIPlacement().setXPosition(p.x);
                        newTableNode.getUIPlacement().setYPosition(p.y);
                        boolean bAutoPropagate = jobModel.getJob().isPropagatingAutomatically();
                        boolean bAutoMap = jobModel.getJob().isMappingAutomatically();
                        jobModel.getJob().setPropagateAutomatically(false);
                        jobModel.getJob().setMapAutomatically(false);
                        HashMap<NodeLayoutInterface, ArrayList<Integer>> consumerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                        for (int iLink2 = 0; iLink2 < links.size(); ++iLink2) {
                            NodeLayoutInterface node;
                            BaseLink link2 = (BaseLink)links.get(iLink2);
                            if (link2 == null || !((node = link2.getToNode()) instanceof IDataTransformNode) || !link2.getFromNodeId().equals(dataTableNode.getId())) continue;
                            ((ITable)newTableNode.getObject()).setChangedNodeId(newTableNode.getId());
                            ArrayList<Integer> cList = (ArrayList<Integer>)consumerTransforms.get(node);
                            if (cList == null) {
                                cList = new ArrayList<Integer>();
                                consumerTransforms.put(node, cList);
                            }
                            cList.add(new Integer(link2.getToNodePortIndex()));
                        }
                        for (IDataTransformNode node : consumerTransforms.keySet()) {
                            List intList = (List)consumerTransforms.get(node);
                            ((IDataTransform)node.getObject()).replaceSourceTable((ITable)dataTableNode.getObject(), (ITable)newTableNode.getObject(), intList.toArray(new Integer[intList.size()]));
                        }
                        HashMap<NodeLayoutInterface, ArrayList<Integer>> producerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                        for (int iLink3 = 0; iLink3 < links.size(); ++iLink3) {
                            NodeLayoutInterface node;
                            BaseLink link3 = (BaseLink)links.get(iLink3);
                            if (link3 == null || !((node = link3.getFromNode()) instanceof IDataTransformNode) || !link3.getToNodeId().equals(dataTableNode.getId())) continue;
                            ArrayList<Integer> cList = (ArrayList<Integer>)producerTransforms.get(node);
                            if (cList == null) {
                                cList = new ArrayList<Integer>();
                                producerTransforms.put(node, cList);
                            }
                            cList.add(new Integer(link3.getFromNodePortIndex()));
                            ((ITable)newTableNode.getObject()).setChangedNodeId(newTableNode.getId());
                        }
                        for (IDataTransformNode node : producerTransforms.keySet()) {
                            List intList = (List)producerTransforms.get(node);
                            ((IDataTransform)node.getObject()).replaceTargetTable((ITable)dataTableNode.getObject(), (ITable)newTableNode.getObject(), intList.toArray(new Integer[intList.size()]));
                        }
                        jobModel.getJob().setPropagateAutomatically(bAutoPropagate);
                        jobModel.getJob().setMapAutomatically(bAutoMap);
                        if (this.getDiagramModel().getNodes(dataTableNode.getObject()) != null && this.getDiagramModel().getNodes(dataTableNode.getObject()).size() > 1) {
                            this.getDiagramModel().removeNode(dataTableNode.getId());
                            this.getJobModel().undoableEditHappened((UndoableEdit)new RemoveDataObjectUndoable(dataTableNode));
                        } else {
                            jobModel.getJob().getDataObjectsList().remove(dataTableNode.getObject());
                        }
                    }
                }
                finally {
                    if (!bValidReplace) {
                        if (!bReplacingTableAlreadyExists) {
                            jobModel.getJob().getDataObjectsList().remove(newTableNode.getObject());
                        }
                        this.getDiagramModel().removeNode(newTableNode.getId());
                        MessageUtil.displayMessage((String)bundle.getString("DiagramPanel.ReplaceInvalidMessage.txt"), (int)0);
                        jobModel.discardCompoundUndoable();
                    } else {
                        if (newTableNode != null) {
                            this.deselectPrimitive((PFDPrimitive)dataTableNode);
                            this.selectPrimitive((PFDPrimitive)newTableNode);
                        }
                        jobModel.endCompoundUndoable();
                    }
                }
            }
        }
    }

    public void registerTable() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IWorkTableNode) {
            DesignTimeJobModel jobModel = this.getJobModel();
            IWorkTableNode workTableNode = (IWorkTableNode)aSelectedPrimitives[0];
            if (jobModel != null) {
                int iDialogReturnValue;
                jobModel.startCompoundUndoable();
                String sId = null;
                if (((IPhysicalTable)workTableNode.getObject()).getFolder() != null) {
                    ((IPhysicalTable)workTableNode.getObject()).getFolder().getID();
                }
                if (sId == null) {
                    sId = workTableNode.getObject().getID();
                }
                IPhysicalTable physicalTable = jobModel.getObjectFactory().createNewPhysicalTable(sId);
                Map columnsMap = null;
                try {
                    columnsMap = ((IWorkTable)workTableNode.getObject()).deepCopy(physicalTable);
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    return;
                }
                if (DiagramPanel.getUserPreferenceDefaultRegisterTableLibrary() != "" || this.m_sLibraryId != null) {
                    try {
                        String sDefaultLibraryID = DiagramPanel.getUserPreferenceDefaultRegisterTableLibrary();
                        String options = "<XMLSELECT search=\"@Id='" + sDefaultLibraryID + "'\"/>";
                        int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist("A0000001." + sDefaultLibraryID.substring(0, 8), "SASLibrary", options);
                        if (objCount != 0) {
                            ILibrary iLib = (ILibrary)jobModel.getObject(sDefaultLibraryID);
                            if (iLib == null) {
                                iLib = jobModel.getObjectFactory().createLibrary(sDefaultLibraryID);
                                jobModel.loadFromOMR((IOMRPersistable)iLib, Workspace.getMdFactory());
                            }
                            physicalTable.setLibrary(iLib);
                            physicalTable.setView(false);
                        }
                    }
                    catch (MdException sDefaultLibraryID) {
                    }
                    catch (RemoteException sDefaultLibraryID) {
                        // empty catch block
                    }
                }
                if ((iDialogReturnValue = this.showRegisterTableDialog(physicalTable)) == 1) {
                    try {
                        jobModel.saveToOMR((IOMRPersistable)physicalTable, Workspace.getMdFactory());
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                        return;
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                        return;
                    }
                    jobModel.getJob().getDataObjectsList().add(physicalTable);
                    IDiagramNode physicalTableNode = (IDiagramNode)this.getDiagramModel().getNodes((IObject)physicalTable).get(0);
                    Point p = new Point();
                    workTableNode.getSpotLocation(1, p);
                    this.getDiagramModel().setLocation(physicalTableNode, null, p);
                    boolean bAutoPropagate = jobModel.getJob().isPropagatingAutomatically();
                    boolean bAutoMap = jobModel.getJob().isMappingAutomatically();
                    jobModel.getJob().setPropagateAutomatically(false);
                    jobModel.getJob().setMapAutomatically(false);
                    List links = this.getDiagramModel().getLinks(workTableNode.getObject());
                    HashMap<NodeLayoutInterface, ArrayList<Integer>> consumerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                    for (int iLink = 0; iLink < links.size(); ++iLink) {
                        NodeLayoutInterface node;
                        BaseLink link = (BaseLink)links.get(iLink);
                        if (link == null || !((node = link.getToNode()) instanceof IDataTransformNode)) continue;
                        ArrayList<Integer> cList = (ArrayList<Integer>)consumerTransforms.get(node);
                        if (cList == null) {
                            cList = new ArrayList<Integer>();
                            consumerTransforms.put(node, cList);
                        }
                        cList.add(new Integer(link.getToNodePortIndex()));
                    }
                    for (IDataTransformNode node : consumerTransforms.keySet()) {
                        List intList = (List)consumerTransforms.get(node);
                        ((IDataTransform)node.getObject()).replaceSourceTable((ITable)workTableNode.getObject(), (ITable)physicalTable, columnsMap, intList.toArray(new Integer[intList.size()]));
                    }
                    HashMap<NodeLayoutInterface, ArrayList<Integer>> producerTransforms = new HashMap<NodeLayoutInterface, ArrayList<Integer>>();
                    for (int iLink = 0; iLink < links.size(); ++iLink) {
                        NodeLayoutInterface node;
                        BaseLink link = (BaseLink)links.get(iLink);
                        if (link == null || !((node = link.getFromNode()) instanceof IDataTransformNode)) continue;
                        ArrayList<Integer> cList = (ArrayList<Integer>)producerTransforms.get(node);
                        if (cList == null) {
                            cList = new ArrayList<Integer>();
                            producerTransforms.put(node, cList);
                        }
                        cList.add(new Integer(link.getFromNodePortIndex()));
                    }
                    for (IDataTransformNode node : producerTransforms.keySet()) {
                        List intList = (List)producerTransforms.get(node);
                        ((IDataTransform)node.getObject()).replaceTargetTable((ITable)workTableNode.getObject(), (ITable)physicalTable, columnsMap, intList.toArray(new Integer[intList.size()]));
                    }
                    jobModel.getJob().setPropagateAutomatically(bAutoPropagate);
                    jobModel.getJob().setMapAutomatically(bAutoMap);
                    if (physicalTable.getLibrary() != null && !physicalTable.getLibrary().getID().equalsIgnoreCase(DiagramPanel.getUserPreferenceDefaultRegisterTableLibrary())) {
                        DiagramPanel.setUserPreferenceDefaultRegisterTableLibrary(physicalTable.getLibrary().getID());
                        this.m_sLibraryId = physicalTable.getLibrary().getID();
                    }
                    this.deselectPrimitive((PFDPrimitive)workTableNode);
                    this.selectPrimitive((PFDPrimitive)physicalTableNode);
                    jobModel.endCompoundUndoable();
                } else {
                    physicalTable.dispose();
                    jobModel.discardCompoundUndoable();
                }
            }
        }
    }

    public void openStickyNote() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IDiagramStickyNote) {
            ((IDiagramStickyNote)aSelectedPrimitives[0]).setCollapsed(false);
        }
    }

    public void closeStickyNote() {
        PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
        if (aSelectedPrimitives.length == 1 && aSelectedPrimitives[0] instanceof IDiagramStickyNote) {
            ((IDiagramStickyNote)aSelectedPrimitives[0]).setCollapsed(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputJobPort() {
        DiagramModel mdl = this.getDiagramModel();
        DesignTimeJobModel jobModel = mdl.getJobModel();
        jobModel.startCompoundUndoable();
        try {
            PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
            DesignTimeJobModel mdlJob = this.getJobModel();
            for (int iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                PFDPrimitive prim = aSelectedPrimitives[iPrimitive];
                IObject object = null;
                if (!(prim instanceof IDiagramNode)) continue;
                object = ((IDiagramNode)prim).getObject();
                if (object instanceof IDataObject && mdlJob.getJob().getInputJobPortsList().indexOf(object) == -1) {
                    mdlJob.getJob().getInputJobPortsList().add(object);
                    continue;
                }
                if (!(object instanceof IDataObject)) continue;
                mdlJob.getJob().getInputJobPortsList().remove(object);
            }
        }
        finally {
            jobModel.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputJobPort() {
        DiagramModel mdl = this.getDiagramModel();
        DesignTimeJobModel jobModel = mdl.getJobModel();
        jobModel.startCompoundUndoable();
        try {
            PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
            DesignTimeJobModel mdlJob = this.getJobModel();
            for (int iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                PFDPrimitive prim = aSelectedPrimitives[iPrimitive];
                IObject object = null;
                if (!(prim instanceof IDiagramNode)) continue;
                object = ((IDiagramNode)prim).getObject();
                if (object instanceof IDataObject && mdlJob.getJob().getOutputJobPortsList().indexOf(object) == -1) {
                    mdlJob.getJob().getOutputJobPortsList().add(object);
                    continue;
                }
                if (!(object instanceof IDataObject)) continue;
                mdlJob.getJob().getOutputJobPortsList().remove(object);
            }
        }
        finally {
            jobModel.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        DiagramModel mdl = this.getDiagramModel();
        DesignTimeJobModel jobModel = mdl.getJobModel();
        jobModel.startCompoundUndoable();
        try {
            PFDPrimitive prim;
            int iPrimitive;
            PFDPrimitive[] aSelectedPrimitives = this.getSelectionModel().getPrimitives();
            this.setHoldDisplay(true);
            DesignTimeJobModel mdlJob = this.getJobModel();
            for (iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                prim = aSelectedPrimitives[iPrimitive];
                if (!(prim instanceof PFDLink)) continue;
                if (((PFDLink)prim).getToNode() instanceof IWorkTableNode) break;
                mdl.removePrimitive(prim);
            }
            for (iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                prim = aSelectedPrimitives[iPrimitive];
                if (prim instanceof IDiagramNode) {
                    IDiagramLink link;
                    List links;
                    IObject obj = ((IDiagramNode)prim).getObject();
                    if (obj instanceof IDataTransform) {
                        links = mdl.getLinks(obj);
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            link = (IDiagramLink)links.get(iLink);
                            if (!(link instanceof IDataLink)) continue;
                            if (link.getToNode() instanceof IWorkTableNode) {
                                if (mdl.getNodes(((IDiagramNode)link.getToNode()).getObject()) == null) continue;
                                List workTableLinks = mdl.getLinks(((IDiagramNode)link.getToNode()).getObject());
                                for (int iWTLink = 0; iWTLink < workTableLinks.size(); ++iWTLink) {
                                    IDiagramLink wtLink = (IDiagramLink)workTableLinks.get(iWTLink);
                                    if (wtLink == null || !(wtLink.getFromNode() instanceof IWorkTableNode)) continue;
                                    mdl.removePrimitive((PFDPrimitive)wtLink);
                                }
                            }
                            mdl.removePrimitive((PFDPrimitive)link);
                        }
                        mdlJob.getJob().getTransformsList().remove((ITransform)obj);
                        continue;
                    }
                    if (obj instanceof ITransform) {
                        mdlJob.getJob().getTransformsList().remove(obj);
                        continue;
                    }
                    if (obj instanceof IWorkTable) {
                        if (mdl.getNodes(obj) == null) continue;
                        links = mdl.getLinks(obj);
                        Collections.sort(links, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                if (((IDiagramLink)o1).getToNode() instanceof IWorkTableNode) {
                                    return 1;
                                }
                                return -1;
                            }
                        });
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            link = (BaseLink)links.get(iLink);
                            if (link == null) continue;
                            mdl.removePrimitive((PFDPrimitive)link);
                        }
                        continue;
                    }
                    if (!(obj instanceof IDataObject)) continue;
                    ((IDataObject)obj).setChangedNodeId(((IDiagramNode)prim).getId());
                    if (mdl.getNodes(obj).size() > 1) {
                        links = mdl.getLinks(obj);
                        for (int iLink = 0; iLink < links.size(); ++iLink) {
                            IDiagramNode node;
                            link = (BaseLink)links.get(iLink);
                            if (link.getFromNode().equals((Object)prim)) {
                                node = (IDiagramNode)link.getToNode();
                                node.getAdapter().disconnectFromInput(obj, link.getToNodePortIndex());
                                continue;
                            }
                            if (!link.getToNode().equals((Object)prim)) continue;
                            node = (IDiagramNode)link.getFromNode();
                            node.getAdapter().disconnectFromOutput(obj, link.getFromNodePortIndex());
                        }
                        List nodes = mdl.getNodes(((IDiagramNode)prim).getObject());
                        mdl.removeNode(((IDiagramNode)prim).getId());
                        if (nodes.size() == 1) continue;
                        this.getJobModel().undoableEditHappened((UndoableEdit)new RemoveDataObjectUndoable((IDiagramNode)prim));
                        continue;
                    }
                    links = mdl.getLinks(obj);
                    for (int iLink = 0; iLink < links.size(); ++iLink) {
                        link = (BaseLink)links.get(iLink);
                        if (link == null) continue;
                        mdl.removePrimitive((PFDPrimitive)link);
                    }
                    mdlJob.removeDataObjectFromJob((IDataObject)obj);
                    continue;
                }
                if (!(prim instanceof IDiagramStickyNote)) continue;
                mdl.removePrimitive(prim);
            }
            this.clearSelections();
            this.setHoldDisplay(false);
        }
        finally {
            jobModel.endCompoundUndoable();
        }
    }

    public DiagramModel getDiagramModel() {
        return (DiagramModel)this.getPFDModel();
    }

    public boolean isDropValid(WsPFDPrimitive prim, Point ptEvent, List lObjects) {
        return this.isDropValid(ptEvent, lObjects);
    }

    public boolean drop(WsPFDPrimitive prim, Point ptEvent, List lObjects) {
        return this.drop(ptEvent, lObjects);
    }

    public static boolean isAddPossible(List lObjects) {
        return DiagramPanel.isAddValid(lObjects, null);
    }

    private static boolean isAddValid(List lObjects, IJob job) {
        if (lObjects.isEmpty()) {
            return false;
        }
        for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
            Object obj = lObjects.get(iObject);
            if (obj instanceof CMetadata) {
                try {
                    CMetadata object = (CMetadata)obj;
                    String strType = object.getCMetadataType();
                    if ("PhysicalTable".equals(strType) || "SASLibrary".equals(strType) || "ExternalTable".equals(strType) || "Transformation".equals(strType) || "Document".equals(strType) || "Prototype".equals(strType)) continue;
                    return false;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                    return false;
                }
            }
            if (obj instanceof SimpleObject) {
                String strType = ((SimpleObject)obj).getPublicType();
                if (job != null && "Job".equals(strType) && ((SimpleObject)obj).getID().equals(job.getID())) {
                    return false;
                }
                if ("Table".equals(strType) || "Library".equals(strType) || "ExternalFile".equals(strType) || "MessageQueue".equals(strType) || "Document".equals(strType) || "GeneratedTransform".equals(strType) || "Job".equals(strType) || ObjectFactory.isDataObjectSupportedForPublicType((String)strType) || "BusinessRuleFlow".equals(strType) || "DecisionLogic".equals(strType) || "Directive.DL".equals(strType)) continue;
                return false;
            }
            if (obj instanceof TransformInterface) continue;
            return false;
        }
        return true;
    }

    public boolean isAddValid(List lObjects) {
        return this.isEditable() && DiagramPanel.isAddValid(lObjects, this.getJobModel().getJob());
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return this.isAddValid(lObjects);
    }

    public IDiagramNode[] selectNodes(IObject obj) {
        this.clearSelections();
        List lNodes = this.getDiagramModel().getNodes(obj);
        if (lNodes == null) {
            return new IDiagramNode[0];
        }
        for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
            PFDPrimitive node = (PFDPrimitive)lNodes.get(iNode);
            this.selectPrimitive(node);
        }
        return lNodes.toArray(new IDiagramNode[lNodes.size()]);
    }

    public IDiagramNode[] findNodes(IObject obj) {
        return this.findNodes(obj, true);
    }

    public IDiagramNode[] findNodes(IObject obj, boolean bScrollToNodes) {
        this.clearSelections();
        DiagramModel mdl = this.getDiagramModel();
        if (mdl != null && obj != null) {
            List lNodes = mdl.getNodes(obj);
            if (lNodes == null) {
                return null;
            }
            for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                PFDPrimitive node = (PFDPrimitive)lNodes.get(iNode);
                this.selectPrimitive(node);
                if (!bScrollToNodes) continue;
                this.panToPrimitive(node, false);
            }
            return lNodes.toArray(new IDiagramNode[lNodes.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNodes(Point pt, Object[] aObjects) {
        boolean bAddHappened = false;
        DiagramModel mdl = this.getDiagramModel();
        if (mdl == null) {
            return false;
        }
        DesignTimeJobModel jobMdl = mdl.getJobModel();
        jobMdl.startCompoundUndoable();
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (pt == null) {
                pt = new Point();
            }
            this.ViewToModel(pt);
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                Object obj = aObjects[iObject];
                if (obj instanceof TransformInterface) {
                    bAddHappened = mdl.dropTransform(pt, (TransformInterface)obj);
                } else if (obj instanceof CMetadata) {
                    bAddHappened = mdl.dropDataObject(pt, (CMetadata)obj);
                } else if (obj instanceof SimpleObject) {
                    bAddHappened = mdl.dropSimpleObject(pt, (SimpleObject)obj);
                }
                pt.x += 20;
                pt.y += 20;
            }
        }
        finally {
            jobMdl.endCompoundUndoable();
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
        JInternalFrame frame = this.getParentInternalFrame();
        if (frame != null) {
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return bAddHappened;
    }

    private JInternalFrame getParentInternalFrame() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof JInternalFrame); parent = parent.getParent()) {
        }
        return (JInternalFrame)parent;
    }

    public void setDropLocation(Point location) {
        this.ViewToModel(location);
        this.getDiagramModel().setDropLocation(location);
    }

    public boolean drop(Point ptEvent, List lObjects) {
        return this.addNodes(ptEvent, lObjects.toArray());
    }

    public void modelChanged(PFDModelEvent ev) {
        super.modelChanged(ev);
    }

    protected boolean save() {
        DiagramModel diagramModel = this.getDiagramModel();
        if (diagramModel == null) {
            return false;
        }
        return diagramModel.save();
    }

    protected void refreshDiagramModel() {
        DiagramModel diagramModel = this.getDiagramModel();
        if (diagramModel == null) {
            return;
        }
        boolean bLayout = diagramModel.refresh();
        if (bLayout) {
            bLayout = this.getDoLayout();
            this.setDoLayout(false);
            this.updateLayout();
            this.setDoLayout(bLayout);
        }
    }

    private class DiagramListener
    implements PFDViewListener {
        private DiagramListener() {
        }

        public void viewChanged(PFDViewEvent ev) {
            switch (ev.getType()) {
                case 9: {
                    this.onLinkAdded(ev);
                    break;
                }
                case 10: {
                    this.onLinkRedirected(ev);
                    break;
                }
                case 8: {
                    this.onPrimitiveDeleted(ev);
                    break;
                }
                case 1: {
                    this.onDragStarted(ev);
                    break;
                }
                case 2: {
                    this.onDragEnded(ev);
                    break;
                }
                case 12: {
                    this.onPendingLayoutAction(ev);
                    break;
                }
                case 3: {
                    this.onLayoutAction(ev);
                    break;
                }
                default: {
                    Workspace.getDefaultLogger().debug((Object)("Event type=" + ev.getType() + ", Event property = " + ev.getProperty()));
                }
            }
        }

        private void onDragStarted(PFDViewEvent ev) {
            IPersistableShape[] nodes = new IPersistableShape[DiagramPanel.this.getSelectedPrimitivesCount()];
            PFDLink[] links = new PFDLink[DiagramPanel.this.getSelectedPrimitivesCount()];
            PFDPrimitive[] prims = DiagramPanel.this.getSelectedPrimitives();
            for (int iNode = 0; iNode < prims.length; ++iNode) {
                PFDLink link;
                if (prims[iNode] instanceof IPersistableShape) {
                    IPersistableShape shape;
                    nodes[iNode] = shape = (IPersistableShape)prims[iNode];
                    continue;
                }
                if (!(prims[iNode] instanceof IDiagramLink)) continue;
                links[iNode] = link = (PFDLink)prims[iNode];
            }
            if (nodes.length > 0 && nodes[0] != null) {
                DiagramPanel.this.saveNodesLocation(nodes);
            }
            if (links.length > 0 && links[0] != null) {
                DiagramPanel.this.saveLinksLocations(links);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDragEnded(PFDViewEvent ev) {
            DesignTimeJobModel jobMdl;
            PFDPrimitive[] prims = DiagramPanel.this.getSelectedPrimitives();
            if (prims.length == 0) {
                return;
            }
            if (prims.length == 1 && prims[0] instanceof IDiagramLink) {
                return;
            }
            IPersistableShape[] nodes = new IPersistableShape[DiagramPanel.this.getSelectedPrimitivesCount()];
            PFDLink[] links = new PFDLink[DiagramPanel.this.getSelectedPrimitivesCount()];
            DiagramModel mdl = (DiagramModel)DiagramPanel.this.getPFDModel();
            PFDPrimitive prim = prims[0];
            if (prim instanceof IPersistableShape) {
                Point oldLocation;
                IPersistableShape shape = (IPersistableShape)prim;
                if (shape instanceof IWorkTableNode) {
                    shape = mdl.getNode(((IWorkTableNode)shape).getTransformNodeId());
                }
                if ((oldLocation = (Point)DiagramPanel.this.m_mSelectedDragNodeLocations.get(shape.getId())) == null || prim.getSpotLocation((int)1, null).x == oldLocation.x && prim.getSpotLocation((int)1, null).y == oldLocation.y) {
                    return;
                }
            }
            if ((jobMdl = mdl.getJobModel()) != null && mdl != null) {
                try {
                    jobMdl.startCompoundUndoable();
                    for (int iNode = 0; iNode < prims.length; ++iNode) {
                        PFDLink link;
                        if (prims[iNode] instanceof IPersistableShape) {
                            IPersistableShape shape;
                            nodes[iNode] = shape = (IPersistableShape)prims[iNode];
                            continue;
                        }
                        if (!(prims[iNode] instanceof PFDLink)) continue;
                        links[iNode] = link = (PFDLink)prims[iNode];
                    }
                    DiagramPanel.this.setNodesLocation(nodes);
                    if (links.length > 0) {
                        DiagramPanel.this.setLinksLocations(links);
                    }
                }
                finally {
                    jobMdl.endCompoundUndoable();
                }
            }
        }

        private void onLinkAdded(PFDViewEvent ev) {
            boolean bAddLink;
            PFDLink link = ev.getLink();
            if (link.isCollapsed()) {
                return;
            }
            PFDPort portFrom = link.getFromPort();
            PFDPort portTo = link.getToPort();
            IDiagramNode nodeFrom = (IDiagramNode)ev.getNewFromNode();
            if (nodeFrom == null) {
                nodeFrom = (IDiagramNode)portFrom.getParentNode();
            }
            IDiagramNode nodeTo = (IDiagramNode)ev.getNewToNode();
            if (nodeFrom == null || nodeTo == null) {
                return;
            }
            IObject objFrom = nodeFrom.getObject();
            IObject objTo = nodeTo.getObject();
            int portIndexFrom = nodeFrom.getOutputPortIndex(portFrom);
            int portIndexTo = nodeTo.getInputPortIndex(portTo);
            IDiagramNodeAdapter adapterFrom = nodeFrom.getAdapter();
            IDiagramNodeAdapter adapterTo = nodeTo.getAdapter();
            DiagramModel mdl = DiagramPanel.this.getDiagramModel();
            DesignTimeJobModel jobModel = mdl.getJobModel();
            jobModel.startCompoundUndoable();
            if (link instanceof IDiagramLink) {
                ((IDiagramLink)link).setFromNodeId(nodeFrom.getId());
                ((IDiagramLink)link).setToNodeId(nodeTo.getId());
                ((IDiagramLink)link).setFromNodePortIndex(portIndexFrom);
                ((IDiagramLink)link).setToNodePortIndex(portIndexTo);
            }
            if (objFrom instanceof IDataObject) {
                ((IDataObject)objFrom).setChangedNodeId(nodeFrom.getId());
            }
            if (objTo instanceof IDataObject) {
                ((IDataObject)objTo).setChangedNodeId(nodeTo.getId());
            }
            if (!(bAddLink = DiagramPanel.this.addLink(link))) {
                mdl.removePrimitive((PFDPrimitive)link);
                DiagramPanel.this.clearSelections();
                return;
            }
            boolean bToConnectSuccess = adapterTo.connectToInput(objFrom, portIndexTo);
            boolean bFromConnectSuccess = adapterFrom.connectToOutput(objTo, portIndexFrom);
            if (!bToConnectSuccess || !bFromConnectSuccess) {
                mdl.setIgnoreEvents(true);
                mdl.removeLink((IDiagramLink)link);
                mdl.setIgnoreEvents(false);
                return;
            }
            if (DiagramPanel.this.isAutomaticControlFlow()) {
                int iNode;
                if (objFrom instanceof IDataObject && objTo instanceof IDataTransform) {
                    List beforeNodes = DiagramPanel.this.getDiagramModel().getNodesBefore(nodeFrom);
                    if (beforeNodes != null && !beforeNodes.isEmpty()) {
                        for (iNode = 0; iNode < beforeNodes.size(); ++iNode) {
                            IDiagramNode beforeNode = (IDiagramNode)beforeNodes.get(iNode);
                            if (beforeNode == null || !(beforeNode instanceof ITransformNode)) continue;
                            jobModel.connectAutomaticControlFlow((ITransform)beforeNode.getObject(), (IDataTransform)objTo);
                        }
                    } else if (!(((IDataTransform)objTo).getDataTargetsCount() <= 0 && ((IDataTransform)objTo).isDataTargetsAllowed() || jobModel.getJob().getControlOrderedTransformsList().indexOf(objTo) != -1)) {
                        jobModel.getJob().getControlOrderedTransformsList().add(objTo);
                    }
                } else if (objFrom instanceof IDataTransform && objTo instanceof IDataObject) {
                    List afterNodes = DiagramPanel.this.getDiagramModel().getNodesAfter(nodeTo);
                    if (afterNodes != null && !afterNodes.isEmpty()) {
                        for (iNode = 0; iNode < afterNodes.size(); ++iNode) {
                            IDiagramNode afterNode = (IDiagramNode)afterNodes.get(iNode);
                            if (afterNode == null || !(afterNode instanceof ITransformNode)) continue;
                            jobModel.connectAutomaticControlFlow((IDataTransform)objFrom, (ITransform)afterNode.getObject());
                        }
                    } else if (((IDataTransform)objFrom).getDataSourcesCount() > 0 && jobModel.getJob().getControlOrderedTransformsList().indexOf(objFrom) == -1) {
                        jobModel.getJob().getControlOrderedTransformsList().add(objFrom);
                    }
                }
            }
            if (objFrom instanceof ITable && objTo instanceof IDataTransform) {
                ITable tbl = (ITable)objFrom;
                IDataTransform xfm = (IDataTransform)objTo;
                if (jobModel.getJob().isPropagatingAutomatically() && ((IDataTransformNodeAdapter)((IDataTransformNode)nodeTo).getAdapter()).isPropagatingAutomatically(portIndexTo)) {
                    if (jobModel.getJob().getAutomaticPropagationDirection() == 0) {
                        jobModel.propagateFromBeginningToEnd(tbl, xfm);
                    } else {
                        jobModel.propagateFromEndToBeginning(tbl, xfm);
                    }
                }
                if (jobModel.getJob().isMappingAutomatically() && ((IDataTransformNodeAdapter)((IDataTransformNode)nodeTo).getAdapter()).isMappingAutomatically(portIndexTo)) {
                    ITable[] aTargets = xfm.getTargetTables();
                    for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                        xfm.mapColumns(tbl, aTargets[iTarget]);
                    }
                }
            } else if (objFrom instanceof IDataTransform && objTo instanceof ITable) {
                IDataTransform xfm = (IDataTransform)objFrom;
                ITable tbl = (ITable)objTo;
                if (jobModel.getJob().isPropagatingAutomatically() && ((IDataTransformNodeAdapter)((IDataTransformNode)nodeFrom).getAdapter()).isPropagatingAutomatically(portIndexTo)) {
                    if (jobModel.getJob().getAutomaticPropagationDirection() == 0) {
                        jobModel.propagateFromBeginningToEnd(xfm, tbl);
                    } else {
                        jobModel.propagateFromEndToBeginning(xfm, tbl);
                    }
                }
                if (jobModel.getJob().isMappingAutomatically() && ((IDataTransformNodeAdapter)((IDataTransformNode)nodeFrom).getAdapter()).isMappingAutomatically(portIndexTo)) {
                    ITable[] aSources = xfm.getSourceTables();
                    for (int iSource = 0; iSource < aSources.length; ++iSource) {
                        xfm.mapColumns(aSources[iSource], tbl);
                    }
                }
            }
            jobModel.endCompoundUndoable();
            if (bFromConnectSuccess && bToConnectSuccess) {
                Workspace.getDefaultLogger().debug((Object)(objFrom.getName() + " connected successful to " + objTo.getName()));
            } else {
                Workspace.getDefaultLogger().debug((Object)(objFrom.getName() + " was unsuccessful connecting to " + objTo.getName()));
            }
        }

        private void onPrimitiveDeleted(PFDViewEvent ev) {
            Workspace.getDefaultLogger().debug((Object)ev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onLinkRedirected(PFDViewEvent ev) {
            if (ev.getLink().isCollapsed()) {
                return;
            }
            PFDPort portNewFrom = ev.getNewFromPort();
            PFDPort portNewTo = ev.getNewToPort();
            PFDPort portOldFrom = ev.getOldFromPort();
            PFDPort portOldTo = ev.getOldToPort();
            IDiagramNode nodeOldFrom = (IDiagramNode)ev.getOldFromNode();
            IDiagramNode nodeOldTo = (IDiagramNode)ev.getOldToNode();
            IDiagramNode nodeNewFrom = (IDiagramNode)ev.getNewFromNode();
            IDiagramNode nodeNewTo = (IDiagramNode)ev.getNewToNode();
            IObject objOldFrom = nodeOldFrom.getObject();
            IObject objOldTo = nodeOldTo.getObject();
            IObject objNewFrom = nodeNewFrom.getObject();
            IObject objNewTo = nodeNewTo.getObject();
            int portIndexNewFrom = nodeNewFrom.getOutputPortIndex(portNewFrom);
            int portIndexNewTo = nodeNewTo.getInputPortIndex(portNewTo);
            int portIndexOldFrom = nodeOldFrom.getOutputPortIndex(portOldFrom);
            int portIndexOldTo = nodeOldTo.getInputPortIndex(portOldTo);
            IDiagramNodeAdapter adapterNewFrom = nodeNewFrom.getAdapter();
            IDiagramNodeAdapter adapterNewTo = nodeNewTo.getAdapter();
            IDiagramNodeAdapter adapterOldFrom = nodeOldFrom.getAdapter();
            IDiagramNodeAdapter adapterOldTo = nodeOldTo.getAdapter();
            DiagramModel mdl = DiagramPanel.this.getDiagramModel();
            DesignTimeJobModel jobModel = mdl.getJobModel();
            boolean bIgnore = mdl.getIgnoreEvents();
            mdl.setIgnoreEvents(true);
            try {
                jobModel.startCompoundUndoable();
                if (objOldFrom instanceof IDataObject) {
                    ((IDataObject)objOldFrom).setChangedNodeId(nodeOldFrom.getId());
                } else if (objNewTo instanceof IDataObject) {
                    ((IDataObject)objOldTo).setChangedNodeId(nodeOldTo.getId());
                }
                boolean bToDisconnectSuccess = adapterOldTo.disconnectFromInput(objOldFrom, portIndexOldTo);
                boolean bFromDisconnectSuccess = adapterOldFrom.disconnectFromOutput(objOldTo, portIndexOldFrom);
                if (bFromDisconnectSuccess && bToDisconnectSuccess) {
                    Workspace.getDefaultLogger().debug((Object)(objNewFrom.getName() + " disconnected successful from " + objOldTo.getName()));
                } else {
                    Workspace.getDefaultLogger().debug((Object)(objOldFrom.getName() + " was unsuccessful disconnecting from " + objOldTo.getName()));
                }
                if (objNewFrom instanceof IDataObject) {
                    ((IDataObject)objNewFrom).setChangedNodeId(nodeNewFrom.getId());
                } else if (objNewTo instanceof IDataObject) {
                    ((IDataObject)objNewTo).setChangedNodeId(nodeNewTo.getId());
                }
                boolean bToConnectSuccess = adapterNewTo.connectToInput(objNewFrom, portIndexNewTo);
                boolean bFromConnectSuccess = adapterNewFrom.connectToOutput(objNewTo, portIndexNewFrom);
                ((IDiagramLink)ev.getLink()).setFromNodeId(nodeNewFrom.getId());
                ((IDiagramLink)ev.getLink()).setFromNodePortIndex(portIndexNewFrom);
                mdl.removeObjectShape(objOldFrom, (IDiagramPersistable)ev.getLink());
                mdl.putObjectShape(objNewFrom, (IDiagramPersistable)ev.getLink());
                ((IDiagramLink)ev.getLink()).setToNodeId(nodeNewTo.getId());
                ((IDiagramLink)ev.getLink()).setToNodePortIndex(portIndexNewTo);
                mdl.removeObjectShape(objOldTo, (IDiagramPersistable)ev.getLink());
                mdl.putObjectShape(objNewTo, (IDiagramPersistable)ev.getLink());
                if (bFromConnectSuccess && bToConnectSuccess) {
                    Workspace.getDefaultLogger().debug((Object)(objNewFrom.getName() + " connected successful to " + objNewTo.getName()));
                } else {
                    Workspace.getDefaultLogger().debug((Object)(objNewFrom.getName() + " was unsuccessful connecting to " + objNewTo.getName()));
                }
                if (objNewFrom instanceof ITable && objNewTo instanceof IDataTransform) {
                    if (jobModel.getJob().isPropagatingAutomatically()) {
                        if (jobModel.getJob().getAutomaticPropagationDirection() == 0) {
                            jobModel.propagateFromBeginningToEnd((ITable)objNewFrom, (IDataTransform)objNewTo);
                        } else {
                            jobModel.propagateFromEndToBeginning((ITable)objNewFrom, (IDataTransform)objNewTo);
                        }
                    }
                    if (jobModel.getJob().isMappingAutomatically()) {
                        ((IDataTransform)objNewTo).mapColumns();
                    }
                } else if (objNewFrom instanceof IDataTransform && objNewTo instanceof ITable) {
                    if (jobModel.getJob().isPropagatingAutomatically()) {
                        if (jobModel.getJob().getAutomaticPropagationDirection() == 0) {
                            jobModel.propagateFromBeginningToEnd((IDataTransform)objNewFrom, (ITable)objNewTo);
                        } else {
                            jobModel.propagateFromEndToBeginning((IDataTransform)objNewFrom, (ITable)objNewTo);
                        }
                    }
                    if (jobModel.getJob().isMappingAutomatically()) {
                        ((IDataTransform)objNewFrom).mapColumns();
                    }
                }
                nodeOldFrom.refresh();
                nodeOldTo.refresh();
                nodeNewFrom.refresh();
                nodeNewTo.refresh();
            }
            finally {
                jobModel.endCompoundUndoable();
                mdl.setIgnoreEvents(bIgnore);
            }
        }

        private void onPendingLayoutAction(PFDViewEvent ev) {
            DiagramModel mdl = (DiagramModel)DiagramPanel.this.getPFDModel();
            DesignTimeJobModel jobMdl = mdl.getJobModel();
            if (jobMdl != null && mdl != null && DiagramPanel.this.getDoLayout()) {
                Vector vNodes;
                Vector vLinks = DiagramPanel.this.getDiagramModel().getAllLinks();
                if (vLinks.size() > 0) {
                    DiagramPanel.this.saveLinksLocations(vLinks.toArray(new PFDLink[vLinks.size()]));
                }
                if ((vNodes = DiagramPanel.this.getDiagramModel().getAllNodes()).size() > 0) {
                    DiagramPanel.this.saveNodesLocation(vNodes.toArray(new IPersistableShape[vNodes.size()]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onLayoutAction(PFDViewEvent ev) {
            DiagramModel mdl = (DiagramModel)DiagramPanel.this.getPFDModel();
            DesignTimeJobModel jobMdl = mdl.getJobModel();
            if (jobMdl != null && mdl != null && DiagramPanel.this.getDoLayout()) {
                try {
                    Vector vNewNodes;
                    jobMdl.startCompoundUndoable();
                    Vector vNewLinks = DiagramPanel.this.getDiagramModel().getAllLinks();
                    if (vNewLinks.size() > 0) {
                        DiagramPanel.this.setLinksLocations(vNewLinks.toArray(new PFDLink[vNewLinks.size()]));
                    }
                    if ((vNewNodes = DiagramPanel.this.getDiagramModel().getAllNodes()).size() > 0) {
                        DiagramPanel.this.setNodesLocation(vNewNodes.toArray(new IPersistableShape[vNewNodes.size()]));
                    }
                }
                finally {
                    jobMdl.endCompoundUndoable();
                }
            }
        }
    }

    private class RunJobModelListener
    implements RunModelListener {
        private RunJobModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
        }

        @Override
        public void runEventHappened(RunEvent ev) {
            String sType = ev.getType();
            DiagramModel mdl = DiagramPanel.this.getDiagramModel();
            ICodeSegment segment = ev.getCodeSegment();
            IObject object = null;
            if (segment != null) {
                object = segment.getModelObject();
            }
            List lNodes = null;
            if (object != null && object instanceof ITransform) {
                lNodes = mdl.getNodes(object);
            }
            ITransformNode node = null;
            if (lNodes != null && !lNodes.isEmpty()) {
                node = (ITransformNode)lNodes.get(0);
            }
            if (sType == "RunStarted") {
                mdl.setModeOnTransformNodes(1);
            } else if (sType == "SegmentStarted") {
                if (node != null) {
                    DiagramPanel.this.panToPrimitive((PFDPrimitive)node, false);
                    node.setRunStatus(1);
                }
            } else if (sType == "SegmentCompleted") {
                if (node != null) {
                    int eStatus = 2;
                    if (node instanceof IDataTransformNode && ev.getResults().getPushDown() != null) {
                        ((IDataTransformNode)node).setDatabasePushDown(ev.getResults().getPushDown().trim().equalsIgnoreCase("0"));
                    }
                    switch (ev.getResults().getStatus()) {
                        case 2: {
                            eStatus = 4;
                            break;
                        }
                        case 1: {
                            eStatus = 3;
                            break;
                        }
                        case 5: {
                            eStatus = 5;
                        }
                    }
                    ITransform transform = (ITransform)node.getAdapter().getObject();
                    if (transform.isValidateAvailable() && node instanceof IDataTransformNode && ev.getResults().getPushDown() != null) {
                        ((IDataTransformNode)node).setDatabasePushDown(ev.getResults().getPushDown().trim().equalsIgnoreCase("0"));
                    }
                    if (!transform.isCompleteWithUserWritten()) {
                        node.setMode(0);
                        node.refresh();
                    } else {
                        node.setRunStatusMessages(ev.getResults().getWarningsAndErrors());
                        node.setRunStatus(eStatus);
                    }
                }
            } else if (sType == "RunStopped" || sType == "RunAborted") {
                mdl.setResetModeOnEdit(true);
                mdl.setModeOnTransformNodes(0);
            } else if (sType == "RunCompleted") {
                mdl.setResetModeOnEdit(true);
            }
        }
    }

    private class ValidateJobModelListener
    implements ValidateModelListener {
        private ValidateJobModelListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
        }

        @Override
        public void validateEventHappened(ValidateEvent ev) {
            String sType = ev.getType();
            DiagramModel mdl = DiagramPanel.this.getDiagramModel();
            ICodeSegment segment = ev.getCodeSegment();
            IObject object = null;
            if (segment != null) {
                object = segment.getModelObject();
            }
            List lNodes = null;
            if (object != null && object instanceof ITransform) {
                lNodes = mdl.getNodes(object);
            }
            ITransformNode node = null;
            if (lNodes != null && !lNodes.isEmpty()) {
                node = (ITransformNode)lNodes.get(0);
            }
            if (sType == "ValidateStarted") {
                mdl.setModeOnTransformNodes(2);
            } else if (sType == "SegmentStarted") {
                if (node != null) {
                    DiagramPanel.this.panToPrimitive((PFDPrimitive)node, false);
                    node.setValidateStatus(1);
                }
            } else if (sType == "SegmentCompleted") {
                if (node != null) {
                    int eStatus;
                    ITransform transform = (ITransform)node.getAdapter().getObject();
                    if (!transform.isValidateAvailable()) {
                        eStatus = 5;
                    } else {
                        eStatus = 2;
                        if (node instanceof IDataTransformNode && ev.getResults().getPushDown() != null) {
                            ((IDataTransformNode)node).setDatabasePushDown(ev.getResults().getPushDown().trim().equalsIgnoreCase("0"));
                        }
                    }
                    switch (ev.getResults().getStatus()) {
                        case 2: {
                            eStatus = 4;
                            break;
                        }
                        case 1: {
                            eStatus = 3;
                        }
                    }
                    if (!transform.isCompleteWithUserWritten()) {
                        node.setMode(0);
                        node.refresh();
                    } else {
                        node.setValidateStatusMessages(ev.getResults().getWarningsAndErrors());
                        node.setValidateStatus(eStatus);
                    }
                }
            } else if (sType == "ValidateStopped") {
                mdl.setResetModeOnEdit(true);
                mdl.setModeOnTransformNodes(0);
            } else if (sType == "ValidateCompleted") {
                mdl.setResetModeOnEdit(true);
            }
        }
    }

    private class DiagramModelListener
    implements PFDModelListener {
        private DiagramModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(PFDModelEvent ev) {
            DiagramModel mdl = DiagramPanel.this.getDiagramModel();
            if (!mdl.getIgnoreEvents()) {
                if (ev.getType() == 7 && ev.getProperty().equals("isCollapsed")) {
                    if (ev.getPrimitive() instanceof ICollapsibleShape) {
                        boolean bForce;
                        DiagramPanel.this.getJobModel().undoableEditHappened((UndoableEdit)new CollapseShapeUndoable((ICollapsibleShape)ev.getPrimitive(), ((ICollapsibleShape)ev.getPrimitive()).isCollapsed()));
                        boolean bl = bForce = !((ICollapsibleShape)ev.getPrimitive()).isCollapsed();
                        if (ev.getPrimitive() instanceof IForceShowPorts) {
                            ((IForceShowPorts)ev.getPrimitive()).setForceShowPorts(bForce);
                        }
                    }
                } else if (ev.getType() == 1000) {
                    DiagramPanel.this.setActivePrimitive(null);
                    DiagramPanel.this.removeAllPrimitivesFromSelection();
                    boolean layout = DiagramPanel.this.getDoLayout();
                    DiagramPanel.this.setDoLayout(false);
                    DiagramPanel.this.updateLayout();
                    DiagramPanel.this.setDoLayout(layout);
                    if (DiagramPanel.this.getDiagramModel().isCleanUpRequired()) {
                        MessageUtil.displayMessage((String)bundle.getString("DiagramPanel.CleanUpRequiredMessage.txt"), (int)1);
                        DiagramPanel.this.getDiagramModel().setCleanUpRequired(false);
                    }
                } else if (ev.getType() == 5) {
                    DesignTimeJobModel mdlJob = mdl.getJobModel();
                    if (ev.getPrimitive() instanceof IDiagramStickyNote) {
                        DiagramPanel.this.removeStickyNote((IDiagramStickyNote)ev.getPrimitive());
                    } else if (ev.getPrimitive() instanceof PFDLink) {
                        PFDLink link = (PFDLink)ev.getPrimitive();
                        if (link.isCollapsed()) {
                            return;
                        }
                        mdlJob.startCompoundUndoable();
                        try {
                            if (link.isCollapsed() || mdl.getLink(((BaseLink)link).getId()) == null || link.getFromNode() == null || link instanceof IControlLink || link.getToNode() == null) {
                                return;
                            }
                            IDiagramNode nodeOldFrom = (IDiagramNode)link.getFromNode();
                            IDiagramNode nodeOldTo = (IDiagramNode)link.getToNode();
                            PFDPort portOldFrom = link.getFromPort();
                            PFDPort portOldTo = link.getToPort();
                            IObject objFrom = ((IDiagramNode)link.getFromNode()).getObject();
                            IObject objTo = ((IDiagramNode)link.getToNode()).getObject();
                            if (objFrom instanceof IDataObject) {
                                ((IDataObject)objFrom).setChangedNodeId(((IDiagramNode)link.getFromNode()).getId());
                            }
                            if (objTo instanceof IDataObject) {
                                ((IDataObject)objTo).setChangedNodeId(((IDiagramNode)link.getToNode()).getId());
                            }
                            int portIndexOldFrom = nodeOldFrom.getOutputPortIndex(portOldFrom);
                            int portIndexOldTo = nodeOldTo.getInputPortIndex(portOldTo);
                            IDiagramNodeAdapter adapterOldFrom = nodeOldFrom.getAdapter();
                            IDiagramNodeAdapter adapterOldTo = nodeOldTo.getAdapter();
                            boolean bToDisconnectSuccess = adapterOldTo.disconnectFromInput(objFrom, portIndexOldTo);
                            boolean bFromDisconnectSuccess = adapterOldFrom.disconnectFromOutput(objTo, portIndexOldFrom);
                            if (bFromDisconnectSuccess && bToDisconnectSuccess) {
                                Workspace.getDefaultLogger().debug((Object)(objFrom.getName() + " disconnected successful from " + objTo.getName()));
                            } else {
                                Workspace.getDefaultLogger().debug((Object)(objFrom.getName() + " was unsuccessful disconnecting from " + objTo.getName()));
                            }
                        }
                        finally {
                            mdlJob.endCompoundUndoable();
                        }
                    }
                }
            }
        }
    }

    private class SetCollapseUndoable
    extends AbstractUndoableEdit {
        private boolean m_bCollapsed;

        public SetCollapseUndoable(boolean bCollapsed) {
            this.m_bCollapsed = bCollapsed;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bCollapsed) {
                DiagramPanel.this.fireViewChange(7001, DiagramPanel.COLLAPSED_FALSE);
            } else {
                DiagramPanel.this.fireViewChange(7001, DiagramPanel.COLLAPSED_TRUE);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bCollapsed) {
                DiagramPanel.this.fireViewChange(7001, DiagramPanel.COLLAPSED_TRUE);
            } else {
                DiagramPanel.this.fireViewChange(7001, DiagramPanel.COLLAPSED_FALSE);
            }
        }
    }

    private class SetFlowDirectionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldFlowDirection;
        private String m_sNewFlowDirection;

        public SetFlowDirectionUndoable(String sOldFlowDirection, String sNewFlowDirection) {
            this.m_sOldFlowDirection = sOldFlowDirection;
            this.m_sNewFlowDirection = sNewFlowDirection;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramPanel.this.setFlowDirection(this.m_sOldFlowDirection);
        }

        @Override
        public void redo() {
            super.redo();
            DiagramPanel.this.setFlowDirection(this.m_sNewFlowDirection);
        }
    }

    private class RemoveDataObjectUndoable
    extends AbstractUndoableEdit {
        private IDiagramNode m_node;

        public RemoveDataObjectUndoable(IDiagramNode node) {
            this.m_node = node;
        }

        @Override
        public void undo() {
            super.undo();
            DiagramModel mdl = (DiagramModel)DiagramPanel.this.getPFDModel();
            mdl.addPrimitive((PFDPrimitive)((PFDAbstractNode)this.m_node));
            mdl.removeDeletedNode(this.m_node.getObject(), this.m_node);
            mdl.putNode(this.m_node.getObject(), this.m_node);
        }

        @Override
        public void redo() {
            super.redo();
            DiagramModel mdl = (DiagramModel)DiagramPanel.this.getPFDModel();
            mdl.removeNode(this.m_node.getId());
        }
    }

    private class CollapseShapeUndoable
    extends AbstractUndoableEdit {
        private ICollapsibleShape m_shape;
        private boolean m_bCollapsed;

        public CollapseShapeUndoable(ICollapsibleShape shape, boolean bCollapsed) {
            this.m_shape = shape;
            this.m_bCollapsed = bCollapsed;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_shape != null) {
                this.m_shape.setCollapsed(!this.m_bCollapsed);
                if (this.m_shape instanceof IForceShowPorts) {
                    ((IForceShowPorts)((Object)this.m_shape)).setForceShowPorts(this.m_bCollapsed);
                }
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_shape != null) {
                this.m_shape.setCollapsed(this.m_bCollapsed);
                if (this.m_shape instanceof IForceShowPorts) {
                    ((IForceShowPorts)((Object)this.m_shape)).setForceShowPorts(!this.m_bCollapsed);
                }
            }
        }
    }
}

