/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor;

import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogParser {
    private static WAdminResource bundle = WAdminResource.getBundle(LogParser.class);
    private static final String LINE_NUMBER_EXPRESSION = "[1-9].*";
    private static final String PAGE_NUMBER_EXPRESSION = "[1-9].*" + bundle.getString("LogParser.TheSASSystem.txt") + ".*";
    private static final String DIS_ARM_EXPRESSION = ".*_DISARM.*";
    private static final String END_DIS_ARM_EXPRESSION = ".*_ENDDISARM.*";
    private static final String PERF_ARM_EXPRESSION = ".*%perfstrt.*";
    private static final String MPRINT_EXPRESSION = ".*MPRINT.*";
    public static final String NOTES_EXPRESSION = ".*" + bundle.getString("LogParser.Note.txt") + ".*";
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("[0-9]*");
    private static final int LINE_LENGTH = 100;
    private static int[] m_aStartLineNumbers;
    private static int[] m_aStartIndexes;
    private static int[] m_aEndIndexes;
    private static int m_iLength;

    public static String[] parse(String parseExpression, String[] logLines) {
        return LogParser.parse(parseExpression, logLines, true);
    }

    public static String[] parse(String parseExpression, String[] logLines, boolean bIgnoreLineNumbers) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Integer> lStartLineNumbers = new ArrayList<Integer>();
        ArrayList<Integer> lStartIndexes = new ArrayList<Integer>();
        ArrayList<Integer> lEndIndexes = new ArrayList<Integer>();
        boolean armLineEncountered = false;
        m_iLength = 0;
        int iSASLogLineNumber = 0;
        for (int i = 0; i < logLines.length; ++i) {
            int iCurrentMessageLength = LogParser.getLengthInLogOf(logLines[i]);
            String currentLine = logLines[i].trim();
            armLineEncountered = currentLine.matches(DIS_ARM_EXPRESSION) && !currentLine.matches(PERF_ARM_EXPRESSION);
            if (!(bIgnoreLineNumbers && currentLine.matches(LINE_NUMBER_EXPRESSION) || !currentLine.matches(parseExpression))) {
                int j;
                StringBuffer message = new StringBuffer(currentLine);
                if (!armLineEncountered) {
                    for (j = i + 1; !(j >= logLines.length - 1 || !logLines[j].matches(PAGE_NUMBER_EXPRESSION) && (logLines[j].matches(parseExpression) || logLines[j].matches(MPRINT_EXPRESSION) || logLines[j].matches(NOTES_EXPRESSION) || logLines[j].matches(LINE_NUMBER_EXPRESSION))); ++j) {
                        iCurrentMessageLength += LogParser.getLengthInLogOf(logLines[j]);
                        String nextLine = logLines[j].trim();
                        if (logLines[j].matches(PAGE_NUMBER_EXPRESSION) || nextLine.length() <= 0) continue;
                        message.append(" ");
                        message.append(nextLine);
                    }
                    i = j - 1;
                } else {
                    for (j = i + 1; j < logLines.length - 1 && !logLines[i].matches(END_DIS_ARM_EXPRESSION) && (logLines[j].matches(DIS_ARM_EXPRESSION) || logLines[j].matches(PAGE_NUMBER_EXPRESSION) || logLines[j].trim().length() == 0 || logLines[j].matches(NOTES_EXPRESSION)); ++j) {
                        iCurrentMessageLength += LogParser.getLengthInLogOf(logLines[j]);
                        if (logLines[j].matches(PAGE_NUMBER_EXPRESSION) || logLines[j].trim().length() <= 0) continue;
                        message.append(" ");
                        message.append(logLines[j].trim());
                    }
                    i = j - 1;
                }
                list.add(message.toString());
                lStartLineNumbers.add(iSASLogLineNumber);
                lStartIndexes.add(m_iLength);
                lEndIndexes.add(m_iLength + iCurrentMessageLength);
            }
            if (!currentLine.matches(PAGE_NUMBER_EXPRESSION) && currentLine.matches(LINE_NUMBER_EXPRESSION) && logLines[i].charAt(0) != ' ') {
                Matcher matcher = LINE_NUMBER_PATTERN.matcher(currentLine);
                matcher.find();
                try {
                    iSASLogLineNumber = Integer.parseInt(matcher.group(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            m_iLength += iCurrentMessageLength;
        }
        m_aStartLineNumbers = LogParser.convertToIntArray(lStartLineNumbers);
        m_aStartIndexes = LogParser.convertToIntArray(lStartIndexes);
        m_aEndIndexes = LogParser.convertToIntArray(lEndIndexes);
        return list.toArray(new String[0]);
    }

    public static int getParsedLength() {
        return m_iLength;
    }

    public static int[] getStartLineNumbers() {
        return m_aStartLineNumbers;
    }

    public static int[] getStartIndexes() {
        return m_aStartIndexes;
    }

    public static int[] getEndIndexes() {
        return m_aEndIndexes;
    }

    public static int[] convertToIntArray(List lIntegers) {
        int[] aInts = new int[lIntegers.size()];
        for (int i = 0; i < lIntegers.size(); ++i) {
            aInts[i] = (Integer)lIntegers.get(i);
        }
        return aInts;
    }

    public static int getLengthInLogOf(String message) {
        return message.length() + message.length() / 100 + 1;
    }
}

