/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor;

import com.sas.editor.CodeEditorPane;
import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdCallbackCancelledException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.drill.DrillComponent;
import com.sas.wadmin.drill.DrillEvent;
import com.sas.wadmin.drill.DrillListener;
import com.sas.wadmin.drill.DrillableComponent;
import com.sas.wadmin.jobeditor.DetailsTab;
import com.sas.wadmin.jobeditor.JobCodeTab;
import com.sas.wadmin.jobeditor.JobLogTab;
import com.sas.wadmin.jobeditor.diagram.DebugEvent;
import com.sas.wadmin.jobeditor.diagram.DebugEventListener;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.DiagramTab;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.runtimedetails.ControlFlowTab;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsTab;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsTableModel;
import com.sas.wadmin.jobeditor.runtimedetails.StatusTab;
import com.sas.wadmin.jobeditor.runtimedetails.StatusTableModel;
import com.sas.wadmin.jobeditor.runtimedetails.WarningsAndErrorsTab;
import com.sas.wadmin.run.RunEvent;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunModelEvent;
import com.sas.wadmin.run.RunModelFactory;
import com.sas.wadmin.run.RunModelListener;
import com.sas.wadmin.run.RunResults;
import com.sas.wadmin.validate.ValidateEvent;
import com.sas.wadmin.validate.ValidateModel;
import com.sas.wadmin.validate.ValidateModelEvent;
import com.sas.wadmin.validate.ValidateModelFactory;
import com.sas.wadmin.validate.ValidateModelListener;
import com.sas.wadmin.validate.ValidateResults;
import com.sas.wadmin.visuals.common.CodeGenerationController;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsSplittableTabbedPane2;
import com.sas.workspace.WsStatusBar;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.SubmitType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class JobEditorPanel
extends WAPanel
implements DrillableComponent {
    private static WAdminResource bundle = WAdminResource.getBundle(JobEditorPanel.class);
    private static final String CLEAR_LOG_AND_OUTPUT_KEY = "Workspace.ClearLogBeforeSubmit";
    private static final String SHOW_DETAILS_KEY = "JobEditorPanel.ShowDetails";
    private static final String SHOW_CODE_KEY = "com.sas.wadmin.visuals.WAPFDEditorOMAView.ShowEditor";
    private static final String SHOW_LOG_KEY = "com.sas.wadmin.visuals.WAPFDEditorOMAView.ShowLog";
    private static final String SHOW_OUTPUT_KEY = "com.sas.wadmin.visuals.WAPFDEditorOMAView.ShowOutput";
    private static final String PROMPT_BEFORE_RUNNING_A_JOB_WITH_WARNINGS_KEY = "JobEditorPanel.PromptBeforeRunningAJobWithWarnings";
    private static final String PROMPT_BEFORE_REFRESHING_THE_JOB = "JobEditorPanel.PromptBeforeRefreshingTheJob";
    private static final String PROMPT_BEFORE_SAVING_DATA_OBJECTS_KEY = "JobEditorPanel.PromptBeforeSavingDataObjects";
    private static final int DETAILS_PANEL_NORMAL = 0;
    private static final int DETAILS_PANEL_MINIMIZED = 1;
    private static final int DETAILS_PANEL_MAXIMIZED = 2;
    private int m_iRunRestartChoice;
    private static final int NO_PENDING_RESTART = 100;
    private Dimension m_dimMinMainSize;
    private Dimension m_dimMinDetailsSize;
    private DesignTimeJobModel m_mdlJob;
    private RunModel m_mdlRun;
    private ValidateModel m_mdlValidate;
    private WsUndoManager m_mgrUndo;
    private WsSplittableTabbedPane2 m_tabsMain;
    private DiagramTab m_tabDiagram;
    private ProcessTab m_tabCode;
    private JobLogTab m_tabLog;
    private JobLogTab m_tabOutput;
    private WATitledPane m_pnlDetails;
    private JTabbedPane m_tabsDetails;
    private WAPanel m_tabNodeDetails;
    private StatusTab m_tabStatus;
    private WarningsAndErrorsTab m_tabWarnings;
    private StatisticsTab m_tabStatistics;
    private ControlFlowTab m_tabControlFlow;
    private WsStatusBar m_barStatus;
    private JToolBar m_barEditor;
    private JSplitPane m_spltDetails;
    private JSplitPane m_spltDebug;
    private boolean m_bDetailsVisible;
    private boolean m_bDebugVisible;
    private IObject m_selectedObject;
    private WsSelectionProvider m_provider;
    private boolean m_bActive;
    CodeGenerationController m_controller;
    private WAPropertyTab m_tabActive;
    private int m_eDetailsPanelState;
    private boolean m_bIgnoreDividerLocationEvents;
    private int m_cyDetails;
    private Map m_mapObjects;
    private Runnable m_runLastSelectionChanged;
    private Object m_selectionSource;
    private boolean m_bShowCodeTab;
    private boolean m_bShowLogTab;
    private boolean m_bSelectionOccurredDuringDelete;
    private ITransform[] m_aTransformsRun;
    private WsAbstractAction m_actSave;
    private WsAbstractAction m_actSaveAsLocal;
    private WsAbstractAction m_actSaveAsRemote;
    private WsAbstractAction m_actSaveCopyLocal;
    private WsAbstractAction m_actSaveCopyRemote;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractToggleAction m_actDetails;
    private WsAbstractAction m_actGenerateCode;
    private WsAbstractAction m_actValidate;
    private WsAbstractAction m_actRun;
    private WsAbstractAction m_actStop;
    private WsAbstractAction m_actStep;
    private WsAbstractAction m_actContinue;
    private WsAbstractAction m_actRunTo;
    private WsAbstractAction m_actRunFrom;
    private WsAbstractAction m_actRunSelected;
    private WsAbstractAction m_actFindInCode;
    private WsAbstractAction m_actFindInLog;
    private WsAbstractAction m_actFindInStatus;
    private WsAbstractAction m_actFindInWarningsAndErrors;
    private WsAbstractAction m_actFindInStatistics;
    private List m_lDrillListeners;
    private List m_lReferences;
    private ChangeListener m_lsnrUndo;
    private IModelListener m_lsnrModel;
    private WsSelectionChangedListener m_lsnrSelection;
    private ClearRuntimeDetailsListener m_lsnrClearRuntimeDetails;
    private DataChangedListener m_lsnrDataChanged;
    private MdFactoryListener m_lsnrOMR;
    private DiagramDebugListener m_lsnrDebugEvents;

    public static boolean isUserPreferenceToShowDetails() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_DETAILS_KEY, true);
    }

    public static void setUserPreferenceToShowDetails(boolean bShowDetails) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_DETAILS_KEY, bShowDetails);
    }

    public static boolean isUserPreferenceToClearLogAndOutput() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(CLEAR_LOG_AND_OUTPUT_KEY, true);
    }

    public static void setUserPreferenceToClearLogAndOutput(boolean bClearLogAndOutput) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(CLEAR_LOG_AND_OUTPUT_KEY, bClearLogAndOutput);
    }

    public static boolean isUserPreferenceToShowCode() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_CODE_KEY, true);
    }

    public static boolean isUserPreferenceToShowLog() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_LOG_KEY, true);
    }

    public static boolean isUserPreferenceToShowOutput() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_OUTPUT_KEY, true);
    }

    public static void setUserPreferenceToPromptBeforeSavingDataObjects(boolean bPrompt) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(PROMPT_BEFORE_SAVING_DATA_OBJECTS_KEY, bPrompt);
    }

    public static boolean isUserPreferenceToPromptBeforeSavingDataObjects() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(PROMPT_BEFORE_SAVING_DATA_OBJECTS_KEY, false);
    }

    public static void setUserPreferenceToPromptBeforeRunningAJobWithWarnings(boolean bPrompt) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(PROMPT_BEFORE_RUNNING_A_JOB_WITH_WARNINGS_KEY, bPrompt);
    }

    public static boolean isUserPreferenceToPromptBeforeRunningAJobWithWarnings() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(PROMPT_BEFORE_RUNNING_A_JOB_WITH_WARNINGS_KEY, true);
    }

    public static void setUserPreferenceToPromptBeforeRefreshingTheJob(boolean bPrompt) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(PROMPT_BEFORE_REFRESHING_THE_JOB, bPrompt);
    }

    public static boolean isUserPreferenceToPromptBeforeRefreshingTheJob() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(PROMPT_BEFORE_REFRESHING_THE_JOB, true);
    }

    public static boolean isAddPossible(Object[] aObjects) {
        return DiagramPanel.isAddPossible(Arrays.asList(aObjects));
    }

    public JobEditorPanel(DesignTimeJobModel mdlJob) {
        this.m_mdlJob = mdlJob;
        this.m_bShowCodeTab = JobEditorPanel.isUserPreferenceToShowCode();
        this.m_bShowLogTab = JobEditorPanel.isUserPreferenceToShowLog();
        this.initialize();
    }

    protected void initialize() {
        this.m_lDrillListeners = new ArrayList();
        this.m_lReferences = new ArrayList();
        this.m_lsnrModel = new ModelListener();
        this.m_mdlJob.addModelListener(this.m_lsnrModel);
        try {
            this.m_lsnrOMR = new OMRListener();
            Workspace.getMdFactory().addMdFactoryListener(this.m_lsnrOMR);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.m_controller = new CodeGenerationController((ICodeGenerator)this.m_mdlJob.getJob());
        this.m_lsnrSelection = new SelectionListener();
        this.initializeUndo();
        this.createMainTabs();
        this.createValidateModel();
        this.createRunModel();
        this.createDetailsPanel();
        this.createActions();
        this.m_spltDebug = this.createSplitPane(1, 0.0);
        this.m_spltDetails = new cSplitPane(0, 1.0);
        this.m_spltDetails.setBottomComponent((Component)this.m_pnlDetails);
        this.m_mapObjects = new HashMap();
        this.m_barEditor = this.createEditorToolBar();
        this.m_barStatus = new WsStatusBar();
        this.m_barStatus.setProgressShown(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabsMain, "Center");
        this.add((Component)this.m_barStatus, "South");
        this.setDetailsVisible(JobEditorPanel.isUserPreferenceToShowDetails());
        this.setActiveTab((WAPropertyTab)this.m_tabDiagram);
        this.m_barEditor.add(this.m_tabDiagram.getDiagramToolBar());
        this.setHelpProduct("wdb");
        this.setHelpTopic("job_editor_win");
        this.updateActions();
    }

    private void initializeUndo() {
        this.m_mgrUndo = new ModelUndoManager();
        this.m_mgrUndo.setLimit(AppPropertiesDialogFactory.getUserPreferenceForUndoLimit());
        this.m_mdlJob.setUndoManager((UndoManager)this.m_mgrUndo);
        this.m_mdlJob.setUndoSupported(this.m_mdlJob.isEditable());
        this.m_lsnrUndo = new UndoManagerListener();
        this.m_mgrUndo.addChangeListener(this.m_lsnrUndo);
    }

    private void createActions() {
        this.m_actSave = new SaveAction();
        this.m_actSaveAsLocal = new SaveAsLocalAction();
        this.m_actSaveAsRemote = new SaveAsRemoteAction();
        this.m_actSaveCopyLocal = new SaveCopyLocalAction();
        this.m_actSaveCopyRemote = new SaveCopyRemoteAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actDetails = new DetailsAction();
        this.m_actGenerateCode = new GenerateCodeAction();
        this.m_actValidate = new ValidateAction();
        this.m_actRun = new RunAction();
        this.m_actStop = new StopAction();
        this.m_actStep = new StepAction();
        this.m_actContinue = new ContinueAction();
        this.m_actRunTo = new RunToSelectedTransformation();
        this.m_actRunFrom = new RunFromSelectedTransformation();
        this.m_actRunSelected = new RunSelectedTransformations();
        this.m_actFindInCode = new FindInCodeAction();
        this.m_actFindInLog = new FindInLogAction();
        this.m_actFindInStatus = new FindInStatusAction();
        this.m_actFindInWarningsAndErrors = new FindInWarningsAndErrorsAction();
        this.m_actFindInStatistics = new FindInStatisticsAction();
    }

    private void createRunModel() {
        this.m_mdlRun = RunModelFactory.getInstance().createRunModel((SimpleObject)this.m_mdlJob.getJob());
        this.m_mdlRun.addListener(new RunJobModelListener());
        this.m_tabDiagram.setRunModel(this.m_mdlRun);
    }

    private void createValidateModel() {
        this.m_mdlValidate = ValidateModelFactory.getInstance().createValidateModel((SimpleObject)this.m_mdlJob.getJob());
        this.m_mdlValidate.addListener(new ValidateJobModelListener());
        this.m_tabDiagram.setValidateModel(this.m_mdlValidate);
    }

    private void createMainTabs() {
        this.m_tabDiagram = new DiagramTab(this.m_mdlJob);
        this.m_tabCode = new JobCodeTab(this.m_controller);
        this.m_tabLog = new JobLogTab(1);
        this.m_tabOutput = new JobLogTab(2);
        this.m_tabDiagram.addDrillListener(new DiagramDrillListener());
        this.m_lsnrDebugEvents = new DiagramDebugListener();
        this.m_tabDiagram.addDebugListener(this.m_lsnrDebugEvents);
        this.m_lsnrDataChanged = new DataChangedListener();
        this.m_tabDiagram.addPropertyChangeListener("DataChanged", this.m_lsnrDataChanged);
        this.m_tabCode.addPropertyChangeListener("DataChanged", this.m_lsnrDataChanged);
        this.m_tabLog.addPropertyChangeListener("DataChanged", this.m_lsnrDataChanged);
        this.m_tabOutput.addPropertyChangeListener("DataChanged", this.m_lsnrDataChanged);
        this.m_tabsMain = new WsSplittableTabbedPane2();
        this.m_tabsMain.insertTab(this.m_tabDiagram.getName(), (Component)((Object)this.m_tabDiagram), 0, false);
        if (this.m_bShowCodeTab) {
            this.m_tabsMain.addTab(this.m_tabCode.getName(), (Component)((Object)this.m_tabCode));
        }
        if (this.m_bShowLogTab) {
            this.m_tabsMain.addTab(this.m_tabLog.getName(), (Component)((Object)this.m_tabLog));
        }
        if (JobEditorPanel.isUserPreferenceToShowOutput()) {
            this.m_tabsMain.addTab(this.m_tabOutput.getName(), (Component)((Object)this.m_tabOutput));
        }
        this.m_tabsMain.setSelectedTab((Component)((Object)this.m_tabDiagram));
        this.m_tabsMain.addChangeListener((ChangeListener)new TabSelectionListener());
        this.m_dimMinMainSize = this.m_tabsMain.getMinimumSize();
    }

    private JToolBar createEditorToolBar() {
        JToolBar barEditor = WsUIUtilities.createToolBar();
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actRun));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actStop));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actRunFrom));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actRunTo));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actRunSelected));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actStep));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actContinue));
        barEditor.addSeparator();
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actGenerateCode));
        barEditor.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actValidate));
        barEditor.addSeparator();
        barEditor.add(WsUIUtilities.createFlatToggleTextIconButton((WsAbstractToggleAction)this.m_actDetails));
        barEditor.addSeparator();
        barEditor.setVisible(true);
        return barEditor;
    }

    private void createDetailsPanel() {
        this.m_lsnrClearRuntimeDetails = new ClearRuntimeDetailsListener();
        this.m_tabStatus = new StatusTab(this.m_mdlRun, this.m_mdlValidate);
        this.m_tabWarnings = new WarningsAndErrorsTab(this.m_mdlRun, this.m_mdlValidate, this.m_bShowCodeTab, this.m_bShowLogTab);
        this.m_tabStatistics = new StatisticsTab(this.m_mdlJob.getJob(), this.m_mdlRun);
        this.m_tabControlFlow = new ControlFlowTab(this.m_mdlJob.getJob());
        this.m_tabStatus.getClearAllButton().addActionListener(this.m_lsnrClearRuntimeDetails);
        this.m_tabWarnings.getClearAllButton().addActionListener(this.m_lsnrClearRuntimeDetails);
        this.m_tabStatistics.getClearAllButton().addActionListener(this.m_lsnrClearRuntimeDetails);
        this.m_tabsDetails = new JTabbedPane();
        this.m_tabsDetails.add((Component)((Object)this.m_tabStatus));
        this.m_tabsDetails.add((Component)((Object)this.m_tabWarnings));
        this.m_tabsDetails.add((Component)((Object)this.m_tabStatistics));
        this.m_tabsDetails.add((Component)((Object)this.m_tabControlFlow));
        this.m_pnlDetails = this.createTitledPane(bundle.getString("JobEditorPanel.Details.Name.txt"), this.m_tabsDetails, true);
        this.m_pnlDetails.getCloseButton().addActionListener(new CloseDetailsPanelListener());
        this.m_pnlDetails.getMaxButton().addActionListener(new MaximizeDetailsPanelListener());
        this.m_pnlDetails.getMinButton().addActionListener(new MinimizeDetailsPanelListener());
        this.m_dimMinDetailsSize = this.m_pnlDetails.getMinimumSize();
        RuntimeDetailsHyperlinkListener hl = new RuntimeDetailsHyperlinkListener();
        this.m_tabStatus.addHyperlinkListener(hl);
        this.m_tabWarnings.addHyperlinkListener(hl);
        this.m_tabStatus.addMouseListenerToTable(new StatusTableMouseListener());
        this.m_tabStatistics.addMouseListenerToTable(new StatisticsTableMouseListener());
        WsTable tblStatus = this.m_tabStatus.getStatusTable();
        WsTable tblStatistics = this.m_tabStatistics.getStatisticsTable();
        WsTable tblControlFlow = this.m_tabControlFlow.getControlFlowTable();
        tblStatus.getSelectionModel().addListSelectionListener(new RuntimeTableSelectionListener(this.m_tabStatus, tblStatus, 4));
        tblStatistics.getSelectionModel().addListSelectionListener(new RuntimeTableSelectionListener(this.m_tabStatistics, tblStatistics, 23));
        tblControlFlow.getSelectionModel().addListSelectionListener(new RuntimeTableSelectionListener(this.m_tabControlFlow, tblControlFlow, 4));
    }

    private WATitledPane createTitledPane(String sTitle, JComponent cmpContents, boolean bClosable) {
        WATitledPane pnl = new WATitledPane(sTitle, false, true, true, bClosable);
        pnl.setContents((Component)cmpContents);
        return pnl;
    }

    private JSplitPane createSplitPane(int eOrientation, double resizeWeight) {
        JSplitPane spl = new JSplitPane(eOrientation);
        spl.setContinuousLayout(true);
        spl.setResizeWeight(resizeWeight);
        spl.setBorder(null);
        return spl;
    }

    private void setDetailsVisible(boolean bVisible) {
        if (this.m_bDetailsVisible == bVisible) {
            return;
        }
        this.m_bDetailsVisible = bVisible;
        this.m_actDetails.setSelected(bVisible);
        this.setDetailsState(0);
        if (bVisible) {
            this.addNodeDetailsTab();
        } else {
            this.removeNodeDetailsTab();
        }
        if (this.m_bDetailsVisible && this.m_bDebugVisible) {
            this.m_spltDetails.setTopComponent((Component)this.m_tabsMain);
            this.m_spltDebug.setLeftComponent(this.m_spltDetails);
        } else if (this.m_bDebugVisible) {
            this.m_spltDebug.setLeftComponent((Component)this.m_tabsMain);
        } else if (this.m_bDetailsVisible) {
            this.m_spltDetails.setTopComponent((Component)this.m_tabsMain);
            this.add(this.m_spltDetails, "Center");
        } else {
            this.remove(this.m_spltDetails);
            this.add((Component)this.m_tabsMain, "Center");
        }
        this.validate();
    }

    private boolean isDetailsVisible() {
        return this.m_bDetailsVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDetailsState(int eDetailsState) {
        if (this.m_eDetailsPanelState == eDetailsState) {
            return;
        }
        if (this.m_eDetailsPanelState == 0) {
            this.m_cyDetails = this.m_spltDetails.getDividerLocation();
        }
        this.m_eDetailsPanelState = eDetailsState;
        this.m_bIgnoreDividerLocationEvents = true;
        try {
            if (eDetailsState == 0) {
                this.m_pnlDetails.getMinButton().setIcon(WATitledPane.MINIMIZE_ICON);
                this.m_pnlDetails.getMaxButton().setIcon(WATitledPane.MAXIMIZE_ICON);
                this.m_pnlDetails.getMinButton().setRolloverIcon(WATitledPane.MINIMIZE_ROLLOVER_ICON);
                this.m_pnlDetails.getMaxButton().setRolloverIcon(WATitledPane.MAXIMIZE_ROLLOVER_ICON);
                this.m_pnlDetails.getMinButton().setToolTipText(WATitledPane.MINIMIZE_TOOLTIP);
                this.m_pnlDetails.getMaxButton().setToolTipText(WATitledPane.MAXIMIZE_TOOLTIP);
                this.m_spltDetails.setDividerLocation(this.m_cyDetails);
                this.m_spltDetails.setResizeWeight(1.0);
                this.m_tabsMain.setMinimumSize(this.m_dimMinMainSize);
                this.m_tabsDetails.setMinimumSize(this.m_dimMinDetailsSize);
            } else if (eDetailsState == 2) {
                this.m_pnlDetails.getMinButton().setIcon(WATitledPane.MINIMIZE_ICON);
                this.m_pnlDetails.getMaxButton().setIcon(WATitledPane.RESTORE_ICON);
                this.m_pnlDetails.getMinButton().setRolloverIcon(WATitledPane.MINIMIZE_ROLLOVER_ICON);
                this.m_pnlDetails.getMaxButton().setRolloverIcon(WATitledPane.RESTORE_ROLLOVER_ICON);
                this.m_pnlDetails.getMinButton().setToolTipText(WATitledPane.MINIMIZE_TOOLTIP);
                this.m_pnlDetails.getMaxButton().setToolTipText(WATitledPane.RESTORE_TOOLTIP);
                this.m_spltDetails.setDividerLocation(0.0);
                this.m_spltDetails.setResizeWeight(0.0);
                this.m_tabsMain.setMinimumSize(new Dimension(0, 0));
                this.m_tabsDetails.setMinimumSize(this.m_dimMinDetailsSize);
            } else if (eDetailsState == 1) {
                Insets insSplitter = this.m_spltDetails.getInsets();
                int cyDivider = this.m_spltDetails.getHeight() - insSplitter.top - insSplitter.bottom - this.m_spltDetails.getDividerSize() - this.m_pnlDetails.getInsets().top - this.m_pnlDetails.getTitleComponent().getHeight();
                this.m_pnlDetails.getMinButton().setIcon(WATitledPane.RESTORE_ICON);
                this.m_pnlDetails.getMaxButton().setIcon(WATitledPane.MAXIMIZE_ICON);
                this.m_pnlDetails.getMinButton().setRolloverIcon(WATitledPane.RESTORE_ROLLOVER_ICON);
                this.m_pnlDetails.getMaxButton().setRolloverIcon(WATitledPane.MAXIMIZE_ROLLOVER_ICON);
                this.m_pnlDetails.getMinButton().setToolTipText(WATitledPane.RESTORE_TOOLTIP);
                this.m_pnlDetails.getMaxButton().setToolTipText(WATitledPane.MAXIMIZE_TOOLTIP);
                this.m_spltDetails.setDividerLocation(cyDivider);
                this.m_spltDetails.setResizeWeight(1.0);
                this.m_tabsMain.setMinimumSize(this.m_dimMinMainSize);
                this.m_tabsDetails.setMinimumSize(new Dimension(0, 0));
            }
        }
        finally {
            this.m_bIgnoreDividerLocationEvents = false;
        }
    }

    private int getDetailsState() {
        return this.m_eDetailsPanelState;
    }

    private void setActiveTab(WAPropertyTab tab) {
        if (this.m_tabActive == tab) {
            return;
        }
        if (this.m_tabActive == this.m_tabCode) {
            try {
                this.m_tabCode.moveDataToStore();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
        }
        if (this.m_bActive && this.m_tabActive != null) {
            this.m_tabActive.updateWorkspaceUIComponents(false);
        }
        this.m_tabActive = tab;
        if (this.m_bActive && this.m_tabActive != null) {
            this.m_tabActive.updateWorkspaceUIComponents(true);
        }
        this.setSelectionProvider(tab instanceof WsSelectionProvider ? (WsSelectionProvider)tab : null);
        this.updateSaveActions();
        if (tab == this.m_tabCode && this.m_mdlRun.getRunState() == 0 && this.m_controller.isCodeNeedingUpdate()) {
            try {
                this.generateCode();
            }
            catch (MdCallbackCancelledException ex) {
                MessageUtil.displayMessage((String)bundle.getString("JobEditorPanel.Error.LogonCanceled.txt"), (int)0);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private WAPropertyTab getActiveTab() {
        return this.m_tabActive;
    }

    private void setSelectionProvider(WsSelectionProvider provider) {
        if (this.m_provider == provider) {
            return;
        }
        if (this.m_provider != null) {
            this.m_provider.removeSelectionChangedListener(this.m_lsnrSelection);
        }
        this.m_provider = provider;
        if (this.m_provider != null) {
            this.m_provider.addSelectionChangedListener(this.m_lsnrSelection);
        }
        this.updateActions();
    }

    private WsSelectionProvider getSelectionProvider() {
        return this.m_provider;
    }

    private void setSelectedObject(IObject obj) {
        boolean bSelectNodeDetailsTab;
        if (this.m_selectedObject == obj) {
            return;
        }
        Component cmpSelectedTab = this.m_tabsDetails.getSelectedComponent();
        boolean bl = bSelectNodeDetailsTab = cmpSelectedTab == this.m_tabNodeDetails;
        if (!this.validateNodeDetailsTab()) {
            this.m_tabDiagram.selectObject(this.m_selectedObject);
            return;
        }
        if (this.m_mdlJob.areAnyDataObjectsChanged()) {
            this.saveChangedDataObjects();
        }
        this.removeNodeDetailsTab();
        this.m_selectedObject = obj;
        this.addNodeDetailsTab();
        if (bSelectNodeDetailsTab) {
            this.m_tabsDetails.setSelectedIndex(0);
        } else {
            this.m_tabsDetails.setSelectedComponent(cmpSelectedTab);
        }
    }

    private IObject getSelectedObject() {
        return this.m_selectedObject;
    }

    private void undo() {
        this.m_mgrUndo.undo();
    }

    private void redo() {
        this.m_mgrUndo.redo();
    }

    public boolean load() {
        return this.m_tabDiagram.load();
    }

    public boolean save() {
        return this.saveAllTabs();
    }

    private boolean saveCurrentTab() {
        if (this.getActiveTab() == this.m_tabDiagram && !this.validateNodeDetailsTab()) {
            return false;
        }
        return this.getActiveTab().save();
    }

    private boolean saveAllTabs() {
        boolean bReturn = true;
        if (this.m_tabCode.hasDataChanged()) {
            bReturn = this.m_tabCode.save();
            if (bReturn) {
                bReturn = this.m_tabDiagram.save();
            }
        } else if (this.m_mgrUndo.canUndo()) {
            bReturn = this.m_tabDiagram.save();
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChangedDataObjects() {
        String sTitle;
        String sMessage;
        int eAnswer;
        if (JobEditorPanel.isUserPreferenceToPromptBeforeSavingDataObjects() && (eAnswer = MessageUtil.displayMessage((String)(sMessage = bundle.getString("JobEditorPanel.Prompt.SaveChangedDataObjects.txt")), (String)(sTitle = bundle.getString("JobEditorPanel.Prompt.SaveChangedDataObjects.Title.txt")), (int)3, (int)0)) != 0) {
            return;
        }
        SaveChangedDataObjectsRunnable run = new SaveChangedDataObjectsRunnable();
        this.m_mdlJob.setModelEventsEnabled(false);
        try {
            OpRequestUI op = new OpRequestUI();
            op.setTitle(bundle.getString("JobEditorPanel.SavingChanges.txt"));
            op.setMessage(bundle.getString("JobEditorPanel.Saving.txt"));
            op.execute((Runnable)run);
        }
        finally {
            this.m_mgrUndo.addEdit((UndoableEdit)new ModelUIUtilities.UnableToUndoUndoable((BaseModel)this.m_mdlJob));
            this.m_mdlJob.setModelEventsEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeletedObjectsFromModel(String[] aIDs) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new RemoveDeletedObjectsFromModelRunnable(aIDs));
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"removeDeletedObjectsFromModel", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"removeDeletedObjectsFromModel", (Throwable)ex);
            }
            return;
        }
        boolean bDeleteFromModel = false;
        this.m_mdlJob.setUndoSupported(false);
        try {
            for (int iID = 0; iID < aIDs.length; ++iID) {
                IObject obj = this.m_mdlJob.getObject(aIDs[iID]);
                if (!(obj instanceof IPersistableObject)) continue;
                bDeleteFromModel = true;
                ((IPersistableObject)obj).delete();
                this.m_mdlJob.removeObject(obj);
            }
        }
        finally {
            this.m_mdlJob.setUndoSupported(true);
        }
        if (bDeleteFromModel && this.m_mgrUndo.canUndo()) {
            this.m_mgrUndo.discardAllEdits();
            this.m_mgrUndo.addEdit((UndoableEdit)new ModelUIUtilities.UnableToUndoUndoable((BaseModel)this.m_mdlJob));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadChangedModelObjects(String[] aIDs) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new ReloadChangedModelObjectsRunnable(aIDs));
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"reloadChangedModelObjects", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"reloadChangedModelObjects", (Throwable)ex);
            }
            return;
        }
        if (this.m_mgrUndo.canUndo()) {
            this.m_mgrUndo.discardAllEdits();
            this.m_mgrUndo.addEdit((UndoableEdit)new ModelUIUtilities.UnableToUndoUndoable((BaseModel)this.m_mdlJob));
        }
        Object[] oldSelectedObjects = this.m_tabDiagram.getSelectedObjects();
        try {
            OMRAdapter omr = new OMRAdapter((IModel)this.m_mdlJob, Workspace.getMdFactory(), "Model Reload:" + this.m_mdlJob.getJob().getName());
            try {
                this.m_mdlJob.setUndoSupported(false);
                this.m_mdlJob.setModelEventsEnabled(false);
                try {
                    for (int iID = 0; iID < aIDs.length; ++iID) {
                        IObject obj = this.m_mdlJob.getObject(aIDs[iID]);
                        Workspace.getDefaultLogger().debug((Object)("Updating " + this.m_mdlJob.getDebugName() + " for " + aIDs[iID] + "=" + obj));
                        if (!(obj instanceof IPersistableObject)) continue;
                        IPersistableObject object = (IPersistableObject)obj;
                        omr.populateFor((IOMRPersistable)object);
                        object.loadFromOMR(omr);
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                finally {
                    this.m_mdlJob.setUndoSupported(true);
                    this.m_mdlJob.setModelEventsEnabled(true);
                }
            }
            finally {
                omr.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            if (oldSelectedObjects != null && oldSelectedObjects.length == 1 && oldSelectedObjects[0] instanceof IObject) {
                this.m_tabDiagram.selectObject((IObject)oldSelectedObjects[0]);
            }
        }
    }

    private ICodeSegment generateRestartPendingCheck() throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException, CodegenException {
        IJob job = this.m_mdlJob.getJob();
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        ICodeGenerationEnvironment environment = factory.createCodeGenerationEnvironment(this.m_mdlJob.getJob(), ModelUIUtilities.getServerForAppServer((IModel)this.m_mdlJob, this.getSASAppServer()));
        ICodeSegment segment = job.getRestartPendingCode(environment, "etls_checkRestartPending");
        return segment;
    }

    private ICodeSegment[] generateCodeSegments() throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException, CodegenException {
        IJob job = this.m_mdlJob.getJob();
        if (this.m_mdlJob.isEditable()) {
            job.addAllUnorderedTransformsToControlOrder();
        }
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        ICodeGenerationEnvironment environment = factory.createCodeGenerationEnvironment(this.m_controller.getCodeGenerator().getJob(), ModelUIUtilities.getServerForAppServer((IModel)this.m_mdlJob, this.getSASAppServer()));
        this.m_aTransformsRun = job.getControlOrderedTransforms();
        ICodeSegment[] segments = this.m_controller.getSegments();
        IObject obj = segments[0].getModelObject();
        ICodeSegment initialSegment = null;
        if (this.getRunRestartChoice() == -1) {
            return null;
        }
        if (this.getRunRestartChoice() == 0) {
            initialSegment = environment.createNewCodeSegment(obj);
            initialSegment.addSourceCode("%let etls_resetRestart = 1;\n");
        }
        if (job.getAlternateTemporaryLibrary() != null && job.isDeletingAlternateTemporaryTables()) {
            if (initialSegment == null) {
                initialSegment = environment.createNewCodeSegment(obj);
            }
            initialSegment.addSourceCode("%let etls_runningInteractive =1;\n");
        }
        if (SubmitType.getInstance().getSelectedSubmitType().equals("D7E796B4-654C-4ab3-B690-657EE79309FB")) {
            ArrayList<ICodeSegment> tempSegs = new ArrayList<ICodeSegment>();
            for (int i = 0; i < segments.length; ++i) {
                StringBuffer code = new StringBuffer();
                ICodeSegment preGrid = environment.createNewCodeSegment(segments[i].getModelObject());
                preGrid.setClientGeneratedSegment(true);
                if (i == 0) {
                    preGrid.addSourceCode(preGrid.getSubmitToGridSignon(environment.getDefaultServer(), job));
                    if (initialSegment != null) {
                        preGrid.addSourceCode(preGrid.getSubmitToGridRSubmit()).addSourceCode(initialSegment).addSourceCode(preGrid.getSubmitToGridEndRSubmit());
                    }
                }
                preGrid.addSourceCode(preGrid.getSubmitToGridRSubmit());
                ICodeSegment postGrid = environment.createNewCodeSegment(segments[i].getModelObject());
                postGrid.setClientGeneratedSegment(true);
                postGrid.addSourceCode(postGrid.getSubmitToGridEndRSubmit());
                if (i == segments.length - 1) {
                    postGrid.addSourceCode(postGrid.getSubmitToGridSuffix(false));
                }
                code.append(preGrid.getGeneratedCode());
                code.append(segments[i].getGeneratedCode());
                code.append(postGrid.getGeneratedCode());
                ICodeSegment fullGridStep = environment.createNewCodeSegment(segments[i].getModelObject());
                fullGridStep.addSourceCode(code);
                tempSegs.add(fullGridStep);
                Workspace.getDefaultLogger().debug((Object)code);
            }
            return tempSegs.toArray(new ICodeSegment[tempSegs.size()]);
        }
        if (initialSegment != null && segments.length > 0) {
            initialSegment.setClientGeneratedSegment(true);
            ArrayList<ICodeSegment> lst = new ArrayList<ICodeSegment>(Arrays.asList(segments));
            lst.add(0, initialSegment);
            segments = lst.toArray(new ICodeSegment[lst.size()]);
        }
        return segments;
    }

    private ICodeSegment[] generateCodeSegments(ITransform[] transforms) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException, CodegenException {
        IJob job = this.m_mdlJob.getJob();
        if (this.m_mdlJob.isEditable()) {
            job.addAllUnorderedTransformsToControlOrder();
        }
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        ICodeGenerationEnvironment environment = factory.createCodeGenerationEnvironment(job, ModelUIUtilities.getServerForAppServer((IModel)this.m_mdlJob, this.getSASAppServer()));
        this.m_aTransformsRun = transforms;
        ArrayList<ICodeSegment> gSegments = new ArrayList<ICodeSegment>();
        if (transforms != null && transforms.length > 0) {
            ITransform first;
            ITransform[] jobTransforms = job.getControlOrderedTransformsAndOthers();
            if (jobTransforms[0] == (first = transforms[0]) || !this.m_mdlRun.getHasRun()) {
                gSegments.add(job.getPreJobCode(environment));
            }
            ICodeSegment[] segments = job.getTransformCodeSegments(environment, transforms);
            for (int i = 0; i < segments.length; ++i) {
                gSegments.add(segments[i]);
            }
            if (jobTransforms[jobTransforms.length - 1] == transforms[transforms.length - 1]) {
                gSegments.add(job.getPostJobCode(environment));
            }
        } else {
            gSegments.addAll(Arrays.asList(job.getCodeSegments(environment)));
        }
        IObject obj = ((ICodeSegment)gSegments.get(0)).getModelObject();
        ICodeSegment initialSegment = null;
        if (job.getAlternateTemporaryLibrary() != null && job.isDeletingAlternateTemporaryTables()) {
            if (initialSegment == null) {
                initialSegment = environment.createNewCodeSegment(obj);
            }
            initialSegment.addSourceCode("%let etls_runningInteractive =1;\n");
            gSegments.add(0, initialSegment);
        }
        return gSegments.toArray(new ICodeSegment[gSegments.size()]);
    }

    private ICodeSegment[] generateValidateCodeSegments() throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException, CodegenException {
        IJob job = this.m_mdlJob.getJob();
        if (this.m_mdlJob.isEditable()) {
            job.addAllUnorderedTransformsToControlOrder();
        }
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        ICodeGenerationEnvironment environment = factory.createCodeGenerationEnvironment(job, ModelUIUtilities.getServerForAppServer((IModel)this.m_mdlJob, this.m_mdlValidate.getSASAppServer()));
        environment.setGenerateRCSetCalls(false);
        environment.setRunStatisticsEnabled(false);
        environment.setRunTableStatisticsEnabled(false);
        ITransform[] aAllTransforms = job.getControlOrderedTransforms();
        ICodeSegment[] segments = null;
        ArrayList<ITransform> lAllTransforms = new ArrayList<ITransform>();
        lAllTransforms.addAll(Arrays.asList(aAllTransforms));
        if (lAllTransforms != null && !lAllTransforms.isEmpty()) {
            segments = new ICodeSegment[lAllTransforms.size()];
            for (int iSegment = 0; iSegment < lAllTransforms.size(); ++iSegment) {
                segments[iSegment] = ((ITransform)lAllTransforms.get(iSegment)).getCompleteValidateCode(environment);
            }
        }
        return segments;
    }

    private void validateCode() throws MdException, RemoteException, CodegenException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException {
        if (!this.verifySASAppServerReadyForValidatingCode()) {
            return;
        }
        this.m_tabLog.clear();
        ICodeSegment[] codeSegments = this.generateValidateCodeSegments();
        if (codeSegments != null) {
            this.m_mdlValidate.setCodeSegments(codeSegments);
            this.m_mdlValidate.validate();
        }
    }

    private void generateCode() throws RemoteException, MdException, ServerException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        this.getParent().setCursor(Cursor.getPredefinedCursor(3));
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            Workspace.getDefaultLogger().debug((Object)"Generating code");
            if (!this.verifySASAppServerSelected()) {
                return;
            }
            this.m_tabCode.updateView();
            Workspace.getDefaultLogger().debug((Object)"Code generated");
        }
        finally {
            this.getParent().setCursor(Cursor.getDefaultCursor());
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setSASAppServer(WsAppServer srvr) {
        WsAppServer appServer = this.getSASAppServer();
        if (appServer != srvr && appServer != null) {
            appServer.dispose();
        }
        this.m_mdlJob.setSASAppServer(srvr);
        this.m_mdlRun.setSASAppServer(srvr);
        this.m_tabDiagram.setSASAppServer(srvr);
    }

    private WsAppServer getSASAppServer() {
        return this.m_mdlJob.getSASAppServer();
    }

    private boolean verifySASAppServerSelected() {
        WsAppServer server = this.getSASAppServer();
        if (server == null || !server.getServerFQID().equals(WsAppServer.getDefaultAppServerFQID())) {
            server = WsAppServer.createDefaultAppServer();
        }
        this.setSASAppServer(server);
        return this.getSASAppServer() != null;
    }

    private boolean verifySASAppServerReadyForRunningCode() {
        if (!this.verifySASAppServerSelected()) {
            return false;
        }
        if (!this.getSASAppServer().isSASCodeSessionOpen()) {
            try {
                this.getSASAppServer().openSASCodeSession();
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                return false;
            }
        }
        return true;
    }

    private boolean verifySASAppServerReadyForValidatingCode() {
        WsAppServer server = this.m_mdlValidate.getSASAppServer();
        if (server != null) {
            server.close();
        }
        server = WsAppServer.createDefaultAppServer();
        this.m_mdlValidate.setSASAppServer(server);
        try {
            this.m_mdlValidate.getSASAppServer().openSASCodeSession();
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
        return true;
    }

    private void refreshJobIfNecessary() {
        ArrayList lRefreshObjects = new ArrayList();
        if (this.m_aTransformsRun == null) {
            return;
        }
        for (int iTransform = 0; iTransform < this.m_aTransformsRun.length; ++iTransform) {
            List lCandidates = this.m_aTransformsRun[iTransform].getRefreshObjects();
            if (lCandidates == null || lCandidates.isEmpty()) continue;
            lRefreshObjects.addAll(lCandidates);
        }
        if (lRefreshObjects.isEmpty()) {
            return;
        }
        if (JobEditorPanel.isUserPreferenceToPromptBeforeRefreshingTheJob()) {
            String sJobName = this.m_mdlJob.getJob().getName();
            String sTitle = bundle.formatString("JobEditorPanel.Prompt.RefreshJob.Title.fmt", (Object)sJobName);
            String sMessage = bundle.formatString("JobEditorPanel.Prompt.RefreshJob.Message.fmt", (Object)sJobName);
            JCheckBox ckbDoNotShow = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"JobEditorPanel.Checkbox.DoNotShowMessageAgain", (int)1);
            Object[] aMessages = new Object[]{sMessage, " ", ckbDoNotShow};
            int eAnswer = JOptionPane.showConfirmDialog((Component)((Object)this), aMessages, sTitle, 0, 3);
            JobEditorPanel.setUserPreferenceToPromptBeforeRefreshingTheJob(!ckbDoNotShow.isSelected());
            if (eAnswer != 0) {
                return;
            }
        }
        this.fireRefreshEvents(lRefreshObjects);
    }

    private void fireRefreshEvents(List lRefreshObjects) {
        try {
            HashMap<String, String> mapDeleted = new HashMap<String, String>();
            HashMap<String, String> mapUpdated = new HashMap<String, String>();
            for (int iCandidate = 0; iCandidate < lRefreshObjects.size(); ++iCandidate) {
                String sType;
                IPersistableObject obj = (IPersistableObject)lRefreshObjects.get(iCandidate);
                String sID = obj.getID();
                if (WsMetadataUtil.doesObjectExist((String)sID, (String)(sType = obj.getOMRType()))) {
                    mapUpdated.put(sID, sType);
                    continue;
                }
                mapDeleted.put(sID, sType);
            }
            MdFactory factory = Workspace.getMdFactory();
            if (!mapDeleted.isEmpty()) {
                factory.fireMdObjectsDeleted(new MdFactoryEvent(factory, mapDeleted));
            }
            if (!mapUpdated.isEmpty()) {
                factory.fireMdObjectsModified(new MdFactoryEvent(factory, mapUpdated));
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void runSelectedCode() throws MdException, RemoteException {
        if (!this.m_tabCode.validateData()) {
            return;
        }
        if (!this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        this.m_tabLog.clear();
        IJob job = this.m_mdlJob.getJob();
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        ICodeGenerationEnvironment environment = factory.createCodeGenerationEnvironment(job, ModelUIUtilities.getServerForAppServer((IModel)this.m_mdlJob, this.getSASAppServer()));
        ICodeSegment[] codeSegments = new ICodeSegment[]{environment.createNewCodeSegment((IObject)job)};
        if (codeSegments[0] != null) {
            codeSegments[0].addSourceCode(this.m_tabCode.getCodePane().getSelectedText());
            this.m_mdlRun.setCodeSegments(codeSegments);
            this.m_mdlRun.run();
        }
    }

    private void runJob() throws MdException, RemoteException, CodegenException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException {
        if (!this.m_tabCode.validateData()) {
            return;
        }
        if (this.isCancelRunOnIncomplete()) {
            return;
        }
        try {
            this.m_tabCode.moveDataToStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        if (this.m_controller.isCodeNeedingUpdate()) {
            this.generateCode();
        }
        if (!this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        String sPendingName = "";
        if (this.m_mdlJob.getJob().isCPRJobCodeNeeded()) {
            boolean bPending = false;
            try {
                ICodeSegment codeSegment = this.generateRestartPendingCheck();
                this.getSASAppServer().submitSASCode(codeSegment.toString(), true);
                String sPending = this.getSASAppServer().getMacroVariableValue("etls_checkRestartPending");
                if (!"0".equals(sPending)) {
                    List lTransforms = this.m_mdlJob.getJob().getTransformsList();
                    for (int iTransform = 0; iTransform < lTransforms.size(); ++iTransform) {
                        ITransform transform = (ITransform)lTransforms.get(iTransform);
                        if (!transform.getID().equals(sPending)) continue;
                        bPending = true;
                        sPendingName = transform.getName();
                    }
                }
            }
            catch (WsAppServerFailException failException) {
                bPending = false;
            }
            catch (WsAppServerCodeException e) {
                bPending = false;
            }
            catch (SQLException se) {
                bPending = false;
            }
            this.m_iRunRestartChoice = bPending ? this.showRestartPendingAvailable(sPendingName) : 100;
        }
        this.m_tabLog.clear();
        ICodeSegment[] codeSegments = this.generateCodeSegments();
        if (codeSegments != null) {
            this.m_mdlRun.setCodeSegments(codeSegments);
            this.m_mdlRun.run();
        }
    }

    public int showRestartPendingAvailable(String transformName) {
        cRestartRunOptionsPanel pnl = new cRestartRunOptionsPanel(transformName);
        String sTitle = bundle.getString("RestartRunOptionsPanel.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.show();
        if (dlg.getReturnValue() != 2) {
            return pnl.getAnswer();
        }
        return -1;
    }

    private int getRunRestartChoice() {
        return this.m_iRunRestartChoice;
    }

    protected boolean isCancelRunOnIncomplete() {
        String sMessage;
        String sTitle;
        List allNodes = this.m_tabDiagram.getDiagramPanel().getAllNodes();
        boolean bComplete = true;
        for (int iNode = 0; iNode < allNodes.size() && bComplete; ++iNode) {
            IObject obj = ((IDiagramNode)allNodes.get(iNode)).getAdapter().getObject();
            bComplete = obj instanceof ITransform ? (((ITransform)obj).isCodeGenerationEnabled() ? ((ITransform)obj).isCompleteWithUserWritten() : true) : obj.isComplete();
        }
        List lTransformationsOutOfOrder = this.m_tabDiagram.getDiagramPanel().getJobModel().validateControlFlow();
        if (bComplete && lTransformationsOutOfOrder.isEmpty()) {
            return false;
        }
        if (!JobEditorPanel.isUserPreferenceToPromptBeforeRunningAJobWithWarnings()) {
            return false;
        }
        JCheckBox ckbDoNotShow = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"JobEditorPanel.Checkbox.DoNotShowMessageAgain", (int)1);
        if (!bComplete && !lTransformationsOutOfOrder.isEmpty()) {
            sTitle = bundle.getString("JobEditorPanel.Warning.JobWarnings.title");
            sMessage = bundle.getString("JobEditorPanel.Warning.ControlFlowOutOfOrder.txt") + "\n\n" + bundle.getString("JobEditorPanel.Warning.IncompleteTransformations.txt");
        } else if (!bComplete) {
            sTitle = bundle.getString("JobEditorPanel.Warning.IncompleteTransformations.title");
            sMessage = bundle.getString("JobEditorPanel.Warning.IncompleteTransformations.txt");
        } else {
            sTitle = bundle.getString("JobEditorPanel.Warning.ControlFlowOutOfOrder.title");
            sMessage = bundle.getString("JobEditorPanel.Warning.ControlFlowOutOfOrder.txt");
        }
        String sRunAnyway = bundle.getString("JobEditorPanel.RunAnyway.txt");
        Object[] oaMessage = new Object[]{sMessage, " ", sRunAnyway, " ", ckbDoNotShow};
        int eAnswer = JOptionPane.showConfirmDialog((Component)Workspace.getWorkspace(), oaMessage, sTitle, 0, 2);
        JobEditorPanel.setUserPreferenceToPromptBeforeRunningAJobWithWarnings(!ckbDoNotShow.isSelected());
        return eAnswer != 0;
    }

    private void stopJob() {
        this.m_mdlRun.stop();
    }

    private void stopValidate() {
        this.m_mdlValidate.stop();
    }

    private void stepJob() throws MdException, RemoteException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException {
        if (this.m_mdlRun.getRunState() == 0) {
            if (!this.verifySASAppServerReadyForRunningCode()) {
                return;
            }
            this.m_mdlRun.setCodeSegments(this.generateCodeSegments());
        }
        this.m_mdlRun.step();
    }

    private void continueJob() {
        this.m_mdlRun.run();
    }

    private void runTo(ITransform xfm) throws MdException, RemoteException, ServerException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        int index;
        if (this.m_mdlRun.getRunState() == 0 && !this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        ITransform[] allTransforms = this.m_mdlJob.getJob().getControlOrderedTransformsAndOthers();
        List<ITransform> transforms = Arrays.asList(allTransforms);
        List<ITransform> txfms = transforms.subList(0, (index = transforms.indexOf(xfm)) + 1);
        ICodeSegment[] aSegments = this.generateCodeSegments(txfms.toArray(new ITransform[txfms.size()]));
        if (aSegments != null && aSegments.length > 0) {
            this.m_mdlRun.setCodeSegments(aSegments);
            this.m_mdlRun.run();
            return;
        }
        throw new IllegalStateException("Unable to run from transformation because the transformation was not found in the code.");
    }

    private void runFrom(ITransform xfm) throws MdException, RemoteException, ServerException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        int index;
        if (this.m_mdlRun.getRunState() == 0 && !this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        ITransform[] allTransforms = this.m_mdlJob.getJob().getControlOrderedTransformsAndOthers();
        List<ITransform> transforms = Arrays.asList(allTransforms);
        List<ITransform> txfms = transforms.subList(index = transforms.indexOf(xfm), allTransforms.length);
        ICodeSegment[] aSegments = this.generateCodeSegments(txfms.toArray(new ITransform[txfms.size()]));
        if (aSegments != null && aSegments.length > 0) {
            this.m_mdlRun.setCodeSegments(aSegments);
            this.m_mdlRun.run();
            return;
        }
        throw new IllegalStateException("Unable to run from transformation because the transformation was not found in the code.");
    }

    private void runSelected(List selectedTransforms) throws MdException, RemoteException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException {
        if (this.m_mdlRun.getRunState() == 0 && !this.verifySASAppServerReadyForRunningCode()) {
            return;
        }
        ITransform[] allTransforms = this.m_mdlJob.getJob().getControlOrderedTransformsAndOthers();
        ITransform[] aSelectedTransforms = new ITransform[selectedTransforms.size()];
        int iControlOrder = 0;
        for (int i = 0; i < allTransforms.length; ++i) {
            if (!selectedTransforms.contains(allTransforms[i])) continue;
            aSelectedTransforms[iControlOrder] = allTransforms[i];
            ++iControlOrder;
        }
        ICodeSegment[] aSegments = this.generateCodeSegments(aSelectedTransforms);
        if (aSegments != null && aSegments.length > 0) {
            this.m_mdlRun.setCodeSegments(aSegments);
            this.m_mdlRun.run();
            return;
        }
        throw new IllegalStateException("Unable to run the selected transformations because one or more of the transformations were not found in the code.");
    }

    public int getRunState() {
        return this.m_mdlRun.getRunState();
    }

    public int getValidateState() {
        return this.m_mdlValidate.getValidateState();
    }

    private void findInDiagram(IObject obj) {
        this.m_tabsMain.setSelectedTab((Component)((Object)this.m_tabDiagram));
        this.m_tabsMain.validate();
        JComponent cmp = (JComponent)this.m_tabDiagram.getDefaultFocusComponent();
        if (cmp != null) {
            cmp.requestFocusInWindow();
        }
        this.m_tabDiagram.findNodes(obj);
    }

    private void findInCode(IObject obj) {
        this.m_tabsMain.setSelectedTab((Component)((Object)this.m_tabCode));
        this.m_tabsMain.validate();
        JComponent cmp = (JComponent)this.m_tabCode.getDefaultFocusComponent();
        if (cmp != null) {
            cmp.requestFocusInWindow();
        }
        this.m_tabCode.getCodePane().setSelectedModelObject(obj);
    }

    private void findInLog(IObject obj) {
        this.m_tabsMain.setSelectedTab((Component)((Object)this.m_tabLog));
        this.m_tabsMain.validate();
        JComponent cmp = (JComponent)this.m_tabLog.getDefaultFocusComponent();
        if (cmp != null) {
            cmp.requestFocusInWindow();
        }
        this.m_tabLog.setSelectedModelObject(obj);
    }

    private void findInStatus(IObject obj) {
        this.setDetailsVisible(true);
        this.m_tabsDetails.setSelectedComponent((Component)((Object)this.m_tabStatus));
        this.m_tabStatus.setSelectedModelObjects(new IObject[]{obj});
    }

    private void findInWarningsAndErrors(IObject obj) {
        this.setDetailsVisible(true);
        this.m_tabsDetails.setSelectedComponent((Component)((Object)this.m_tabWarnings));
        this.m_tabWarnings.setSelectedModelObjects(new IObject[]{obj});
    }

    private void findInStatistics(IObject obj) {
        this.setDetailsVisible(true);
        this.m_tabsDetails.setSelectedComponent((Component)((Object)this.m_tabStatistics));
        this.m_tabStatistics.setSelectedModelObjects(new IObject[]{obj});
    }

    private boolean validateNodeDetailsTab() {
        if (this.m_tabNodeDetails == null) {
            return true;
        }
        if (this.m_bSelectionOccurredDuringDelete) {
            return true;
        }
        boolean brc = this.m_tabNodeDetails.validateData();
        if (!brc) {
            this.m_tabsDetails.setSelectedIndex(0);
        }
        return brc;
    }

    private void removeNodeDetailsTab() {
        if (this.m_tabNodeDetails == null) {
            return;
        }
        this.m_tabsDetails.remove(0);
        this.m_tabNodeDetails.saveSettingsAndCleanUp();
        this.m_tabNodeDetails = null;
    }

    private void addNodeDetailsTab() {
        if (!this.isDetailsVisible()) {
            return;
        }
        if (this.m_tabNodeDetails != null) {
            throw new IllegalStateException("node details panel must be removed before the next one can be added");
        }
        IComplexPersistableObject obj = (IComplexPersistableObject)this.getSelectedObject();
        if (obj != null && obj != this.m_mdlJob.getJob()) {
            IDiagramNodeAdapter adapter = this.m_tabDiagram.getDiagramPanel().getDiagramModel().getAdapter((IObject)obj);
            WAPropertyTab wAPropertyTab = this.m_tabNodeDetails = adapter != null ? adapter.getNodeDetailsPanel() : null;
        }
        if (this.m_tabNodeDetails == null) {
            return;
        }
        this.m_tabsDetails.insertTab(this.m_tabNodeDetails.getName(), null, (Component)this.m_tabNodeDetails, null, 0);
        boolean bEditable = obj.getModel().isEditable() && Workspace.isObjectEditable((SimpleObject)obj);
        this.m_tabNodeDetails.setEditable(bEditable);
        try {
            this.m_tabNodeDetails.populateStore();
            this.m_tabNodeDetails.moveDataToView();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void selectionChanged() {
        Object[] aSelectedObjects = this.m_tabDiagram.getSelectedObjects();
        if (aSelectedObjects.length == 0) {
            this.setSelectedObject((IObject)this.m_mdlJob.getJob());
        } else if (aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof IObject) {
            this.setSelectedObject((IObject)aSelectedObjects[0]);
        } else {
            this.setSelectedObject(null);
        }
        this.updateActions();
        ArrayList<Object> lModelObjects = new ArrayList<Object>();
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            if (!(aSelectedObjects[iObject] instanceof IObject)) continue;
            lModelObjects.add(aSelectedObjects[iObject]);
        }
        IObject[] aModelObjects = lModelObjects.toArray(new IObject[lModelObjects.size()]);
        for (int iTab = 0; iTab < this.m_tabsDetails.getTabCount(); ++iTab) {
            Component tab = this.m_tabsDetails.getComponentAt(iTab);
            if (!(tab instanceof DetailsTab) || tab == this.m_selectionSource) continue;
            ((DetailsTab)((Object)tab)).setSelectedModelObjects(aModelObjects);
        }
    }

    private void createSelectionChangedRunnable() {
        this.m_runLastSelectionChanged = new SelectionChangedRunnable();
        SwingUtilities.invokeLater(this.m_runLastSelectionChanged);
    }

    private void refreshStatus(String sType) {
        String sStatus = "";
        if (sType == "RunStarted" || sType == "ValidateStarted") {
            sStatus = "";
        } else if (sType == "RunAborted") {
            sStatus = bundle.getString("JobEditorPanel.RunStatus.Aborted.txt");
        } else if (sType == "RunStopped") {
            sStatus = bundle.getString("JobEditorPanel.RunStatus.Stopped.txt");
        } else if (sType == "ValidateStopped") {
            sStatus = bundle.getString("JobEditorPanel.ValidateStatus.Stopped.txt");
        } else if (sType == "RunCompleted" || sType == "ValidateCompleted") {
            int iWarnings = this.m_tabWarnings.getWarningCount();
            int iErrors = this.m_tabWarnings.getErrorCount();
            if (iWarnings == 0 && iErrors == 0) {
                sStatus = bundle.getString("JobEditorPanel.RunStatus.Success.txt");
            } else if (iWarnings > 0 && iErrors == 0) {
                sStatus = iWarnings == 1 ? bundle.getString("JobEditorPanel.RunStatus.OneWarningOnly.txt") : bundle.formatString("JobEditorPanel.RunStatus.WarningsOnly.fmt", (Object)iWarnings);
            } else if (iWarnings == 0 && iErrors > 0) {
                sStatus = iErrors == 1 ? bundle.getString("JobEditorPanel.RunStatus.OneErrorOnly.txt") : bundle.formatString("JobEditorPanel.RunStatus.ErrorsOnly.fmt", (Object)iErrors);
            } else if (iWarnings > 1 && iErrors > 1) {
                sStatus = bundle.formatString("JobEditorPanel.RunStatus.WarningsAndErrors.fmt", (Object)iWarnings, (Object)iErrors);
            } else if (iWarnings == 1 && iErrors > 1) {
                sStatus = bundle.formatString("JobEditorPanel.RunStatus.OneWarningManyErrors.fmt", (Object)iErrors);
            } else if (iWarnings > 1 && iErrors == 1) {
                sStatus = bundle.formatString("JobEditorPanel.RunStatus.ManyWarningsOneError.fmt", (Object)iWarnings);
            } else if (iWarnings == 1 && iErrors == 1) {
                sStatus = bundle.getString("JobEditorPanel.RunStatus.OneWarningOneError.txt");
            }
        }
        this.m_barStatus.setText(sStatus);
    }

    public boolean isAddValid(Object[] aObjects) {
        return this.m_tabDiagram.getDiagramPanel().isAddValid(Arrays.asList(aObjects));
    }

    public void addNodes(Object[] aObjects) {
        this.m_tabDiagram.getDiagramPanel().addNodes(null, aObjects);
    }

    @Override
    public WAPanel getPanel() {
        return this;
    }

    @Override
    public String getName() {
        return this.m_mdlJob.getJob().getName();
    }

    @Override
    public void addReference(Object referrer) {
        this.m_lReferences.add(referrer);
        Workspace.getDefaultLogger().debug((Object)("Reference added to " + this + ": " + referrer));
    }

    @Override
    public void removeReference(Object referrer) {
        if (!this.m_lReferences.remove(referrer)) {
            throw new IllegalStateException("Attempt to remove a reference that does not exist: " + referrer);
        }
        Workspace.getDefaultLogger().debug((Object)("Reference removed from " + this + ": " + referrer));
        if (this.m_lReferences.isEmpty()) {
            this.saveSettingsAndCleanUp();
        }
    }

    @Override
    public JToolBar getToolBar() {
        return this.m_barEditor;
    }

    @Override
    public WsAbstractAction[] getSharedActions() {
        return new WsAbstractAction[]{this.m_actSave};
    }

    @Override
    public void addDrillListener(DrillListener lsnr) {
        this.m_lDrillListeners.add(lsnr);
    }

    @Override
    public void removeDrillListener(DrillListener lsnr) {
        this.m_lDrillListeners.remove(lsnr);
    }

    private void fireDrillEvent(DrillableComponent cmpSource, DrillComponent cmpTarget) {
        DrillEvent ev = new DrillEvent(cmpSource, cmpTarget);
        for (int iListener = 0; iListener < this.m_lDrillListeners.size(); ++iListener) {
            DrillListener lsnr = (DrillListener)this.m_lDrillListeners.get(iListener);
            lsnr.drilled(ev);
        }
    }

    public Component getDefaultFocusComponent() {
        return null;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_bActive = bActive;
        this.m_actSaveAsLocal.setActive(bActive);
        this.m_actSaveAsRemote.setActive(bActive);
        this.m_actSaveCopyLocal.setActive(bActive);
        this.m_actSaveCopyRemote.setActive(bActive);
        this.m_actUndo.setActive(bActive);
        this.m_actRedo.setActive(bActive);
        this.m_actDetails.setActive(bActive);
        this.m_actGenerateCode.setActive(bActive);
        this.m_actValidate.setActive(bActive);
        this.m_actRun.setActive(bActive);
        this.m_actStop.setActive(bActive);
        this.m_actStep.setActive(bActive);
        this.m_actContinue.setActive(bActive);
        this.m_actRunTo.setActive(bActive);
        this.m_actRunFrom.setActive(bActive);
        this.m_actRunSelected.setActive(bActive);
        this.m_actFindInCode.setActive(bActive);
        this.m_actFindInLog.setActive(bActive);
        this.m_actFindInStatus.setActive(bActive);
        this.m_actFindInWarningsAndErrors.setActive(bActive);
        this.m_actFindInStatistics.setActive(bActive);
        SubmitType.getInstance().setActive(bActive);
        this.getActiveTab().updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tabDiagram.setEditable(bEditable);
        this.m_tabCode.setEditable(bEditable);
        this.m_tabControlFlow.setEditable(bEditable);
        this.updateActions();
    }

    private void updateActions() {
        int eRunState = this.m_mdlRun.getRunState();
        int eValidateState = this.m_mdlValidate.getValidateState();
        boolean bCheckpointOn = this.m_mdlJob.getJob().isCPRJobCodeNeeded();
        boolean bTransformSelected = this.getSelectedTransform() != null;
        boolean bTransformsSelected = this.getSelectedTransforms() != null && !this.getSelectedTransforms().isEmpty();
        this.m_actRun.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1);
        this.m_actStop.setEnabled(eRunState == 1 || eRunState == 2 || eValidateState == 1);
        this.m_actStep.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && !bCheckpointOn);
        this.m_actContinue.setEnabled(eRunState == 2);
        this.m_actRunTo.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && bTransformSelected && !bCheckpointOn);
        this.m_actRunFrom.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && bTransformSelected && !bCheckpointOn);
        this.m_actRunSelected.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1 && bTransformsSelected && !bCheckpointOn);
        this.m_actValidate.setEnabled((eRunState == 0 || eRunState == 2) && eValidateState != 1);
        boolean bNotStatus = this.getActiveTab() != this.m_tabStatus;
        boolean bNotStatistics = this.getActiveTab() != this.m_tabStatistics;
        this.m_actFindInCode.setEnabled(bTransformSelected && this.m_bShowCodeTab);
        this.m_actFindInLog.setEnabled(bTransformSelected && this.m_bShowLogTab);
        this.m_actFindInStatus.setEnabled(bTransformSelected && bNotStatus);
        this.m_actFindInWarningsAndErrors.setEnabled(bTransformSelected && bNotStatistics);
        this.m_actFindInStatistics.setEnabled(bTransformSelected && bNotStatistics);
        this.m_actGenerateCode.setEnabled(!this.m_mdlJob.getJob().isUsingUserWrittenCode());
        this.updateSaveActions();
    }

    public void setDataChanged(boolean bChanged) {
        super.setDataChanged(bChanged);
        this.updateSaveActions();
    }

    private void updateSaveActions() {
        if (this.m_mdlRun.getRunState() == 0 && this.m_mdlValidate.getValidateState() == 0) {
            if (this.m_tabActive != null) {
                if (this.m_tabActive == this.m_tabDiagram || this.m_tabActive == this.m_tabCode) {
                    this.m_actSave.setEnabled(this.m_tabDiagram.hasDataChanged() || this.m_tabCode.hasDataChanged());
                } else {
                    this.m_actSave.setEnabled(this.m_tabActive.hasDataChanged());
                }
                this.m_actSaveAsLocal.setEnabled(this.m_tabActive == this.m_tabCode && !this.m_mdlJob.getJob().isUsingUserWrittenCode() || this.m_tabActive == this.m_tabLog || this.m_tabActive == this.m_tabOutput);
                this.m_actSaveAsRemote.setEnabled(this.m_tabActive == this.m_tabCode && this.m_mdlJob.getJob().isUsingUserWrittenCode());
                if (this.m_tabActive == this.m_tabCode | this.m_tabActive == this.m_tabLog | this.m_tabActive == this.m_tabOutput) {
                    this.m_actSaveCopyLocal.setEnabled(true);
                    this.m_actSaveCopyRemote.setEnabled(true);
                } else {
                    this.m_actSaveCopyLocal.setEnabled(false);
                    this.m_actSaveCopyRemote.setEnabled(false);
                }
            } else {
                this.m_actSave.setEnabled(false);
                this.m_actSaveAsLocal.setEnabled(false);
                this.m_actSaveAsRemote.setEnabled(false);
                this.m_actSaveCopyLocal.setEnabled(false);
                this.m_actSaveCopyRemote.setEnabled(false);
            }
        } else {
            this.m_actSave.setEnabled(false);
            this.m_actSaveAsLocal.setEnabled(false);
            this.m_actSaveAsRemote.setEnabled(false);
        }
    }

    public boolean validateData() {
        return this.validateNodeDetailsTab();
    }

    public void saveSettingsAndCleanUp() {
        this.m_mgrUndo.discardAllEdits();
        this.m_tabDiagram.removeDebugListener(this.m_lsnrDebugEvents);
        this.m_tabDiagram.saveSettingsAndCleanUp();
        this.m_tabCode.saveSettingsAndCleanUp();
        this.m_tabLog.saveSettingsAndCleanUp();
        this.m_tabOutput.saveSettingsAndCleanUp();
        this.removeNodeDetailsTab();
        this.m_tabStatus.saveSettingsAndCleanUp();
        this.m_tabWarnings.saveSettingsAndCleanUp();
        this.m_tabStatistics.saveSettingsAndCleanUp();
        this.m_tabControlFlow.saveSettingsAndCleanUp();
        this.m_mdlRun.dispose();
        this.m_mdlValidate.dispose();
        this.m_controller.dispose();
        this.m_mdlJob.removeModelListener(this.m_lsnrModel);
        this.setSASAppServer(null);
        try {
            Workspace.getMdFactory().removeMdFactoryListener(this.m_lsnrOMR);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
    }

    private boolean isContextForMainJob(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        return aObjects.length == 1 && aObjects[0] == this.m_mdlJob.getJob();
    }

    private boolean isContextForTransforms(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof ITransform) continue;
            return false;
        }
        return true;
    }

    private List getSelectedTransforms() {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        Object[] aSelectedObjects = provider.getSelectedObjects();
        ArrayList<Object> selectedTransforms = new ArrayList<Object>();
        for (int iSelected = 0; iSelected < aSelectedObjects.length; ++iSelected) {
            if (!(aSelectedObjects[iSelected] instanceof ITransform)) continue;
            selectedTransforms.add(aSelectedObjects[iSelected]);
        }
        return selectedTransforms;
    }

    private ITransform getSelectedTransform() {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        Object[] aSelectedObjects = provider.getSelectedObjects();
        if (aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof ITransform) {
            return (ITransform)aSelectedObjects[0];
        }
        return null;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "ModelController:UnknownChanges") {
                JobEditorPanel.this.updateActions();
            }
            if (JobEditorPanel.this.m_mdlJob.getJob().equals((Object)ev.getModelObject()) && "IUserWrittenCode:activeChanged".equals(ev.getType())) {
                JobEditorPanel.this.m_actGenerateCode.setEnabled(!JobEditorPanel.this.m_mdlJob.getJob().isUsingUserWrittenCode());
            }
        }
    }

    private class OMRListener
    implements MdFactoryListener {
        private OMRListener() {
        }

        public void MdObjectsCreated(MdFactoryEvent ev) throws RemoteException {
        }

        public void MdObjectsDeleted(MdFactoryEvent ev) throws RemoteException {
            if (JobEditorPanel.this.m_mdlJob.isSaving()) {
                return;
            }
            ArrayList<String> lIDs = new ArrayList<String>();
            Map mapObjects = ev.getObjectMap();
            String[] aIDs = mapObjects.keySet().toArray(new String[0]);
            for (int iID = 0; iID < aIDs.length; ++iID) {
                IObject obj = JobEditorPanel.this.m_mdlJob.getObject(aIDs[iID]);
                if (obj == null) continue;
                lIDs.add(aIDs[iID]);
            }
            if (!lIDs.isEmpty()) {
                String[] aModelIDs = new String[lIDs.size()];
                lIDs.toArray(aModelIDs);
                JobEditorPanel.this.removeDeletedObjectsFromModel(aModelIDs);
            }
        }

        public void MdObjectsModified(MdFactoryEvent ev) throws RemoteException {
            if (JobEditorPanel.this.m_mdlJob.isSaving()) {
                return;
            }
            ArrayList<String> lIDs = new ArrayList<String>();
            Map mapObjects = ev.getObjectMap();
            String[] aIDs = mapObjects.keySet().toArray(new String[0]);
            for (int iID = 0; iID < aIDs.length; ++iID) {
                IObject obj = JobEditorPanel.this.m_mdlJob.getObject(aIDs[iID]);
                if (obj == null) continue;
                lIDs.add(aIDs[iID]);
            }
            if (!lIDs.isEmpty()) {
                String[] aModelIDs = new String[lIDs.size()];
                lIDs.toArray(aModelIDs);
                JobEditorPanel.this.reloadChangedModelObjects(aModelIDs);
            }
        }
    }

    private class SelectionListener
    implements WsSelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(WsSelectionChangedEvent ev) {
            JobEditorPanel.this.createSelectionChangedRunnable();
        }
    }

    private class cSplitPane
    extends JSplitPane {
        public cSplitPane(int eOrientation, double resizeWeight) {
            super(eOrientation);
            this.setContinuousLayout(true);
            this.setResizeWeight(resizeWeight);
            this.setBorder(null);
        }

        @Override
        public void updateUI() {
            this.setUI(new cSplitPaneUI());
            this.repaint();
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            boolean bChanged;
            boolean bl = bChanged = JobEditorPanel.this.m_mgrUndo.canUndo() || JobEditorPanel.this.m_tabCode.hasDataChanged();
            if (JobEditorPanel.this.m_tabActive != null && JobEditorPanel.this.m_tabActive != JobEditorPanel.this.m_tabCode) {
                JobEditorPanel.this.m_tabActive.setDataChanged(JobEditorPanel.this.m_mgrUndo.canUndo());
            }
            JobEditorPanel.this.setDataChanged(bChanged);
            JobEditorPanel.this.m_actUndo.setEnabled(JobEditorPanel.this.m_mgrUndo.canUndo());
            JobEditorPanel.this.m_actRedo.setEnabled(JobEditorPanel.this.m_mgrUndo.canRedo());
        }
    }

    private class SaveAction
    extends WsAbstractAction {
        public SaveAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:Save");
        }

        public void actionPerformed(ActionEvent ev) {
            if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabDiagram || JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabCode) {
                JobEditorPanel.this.saveAllTabs();
            } else {
                JobEditorPanel.this.saveCurrentTab();
            }
        }
    }

    private class SaveAsLocalAction
    extends WsAbstractAction {
        public SaveAsLocalAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:SaveAs:Local");
        }

        public void actionPerformed(ActionEvent ev) {
            if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabCode) {
                JobEditorPanel.this.m_tabCode.getCodePane().saveAsLocal();
            } else if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabLog || JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabOutput) {
                ((JobLogTab)JobEditorPanel.this.m_tabActive).saveAs();
            } else {
                throw new UnsupportedOperationException("save as - local is not supported for the active tab: " + JobEditorPanel.this.m_tabActive.getName());
            }
        }
    }

    private class SaveAsRemoteAction
    extends WsAbstractAction {
        public SaveAsRemoteAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:SaveAs:Remote");
        }

        public void actionPerformed(ActionEvent ev) {
            if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabCode) {
                if (JobEditorPanel.this.m_tabCode.getCodePane().saveAs()) {
                    JobEditorPanel.this.saveAllTabs();
                }
            } else {
                throw new UnsupportedOperationException("save as - remote is not supported for the active tab: " + JobEditorPanel.this.m_tabActive.getName());
            }
        }
    }

    private class SaveCopyLocalAction
    extends WsAbstractAction {
        public SaveCopyLocalAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:SaveCopy:Local");
        }

        public void actionPerformed(ActionEvent ev) {
            String initialPath = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("JobEditorPanel.LastLocalFilePath", "");
            FileDialog dlgSaveAs = new FileDialog((Frame)Workspace.getWorkspace(), bundle.getString("JobEditorPanel.CopyTextToLocalFile.txt"), 1);
            dlgSaveAs.setFile("");
            dlgSaveAs.setDirectory(initialPath);
            dlgSaveAs.setVisible(true);
            if (dlgSaveAs.getFile() == null) {
                return;
            }
            String newFileName = dlgSaveAs.getDirectory() + dlgSaveAs.getFile();
            String textToSave = "";
            if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabCode) {
                textToSave = JobEditorPanel.this.m_tabCode.getCodePane().getText();
            } else if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabLog) {
                textToSave = JobEditorPanel.this.m_tabLog.getText();
            } else if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabOutput) {
                textToSave = JobEditorPanel.this.m_tabOutput.getText();
            }
            try {
                FileOutputStream strm = new FileOutputStream(newFileName);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)strm, "UTF-8");
                writer.write(textToSave);
                writer.close();
                Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("JobEditorPanel.LastLocalFilePath", dlgSaveAs.getDirectory());
            }
            catch (IOException ex) {
                MessageUtil.displayMessage((String)bundle.formatString("WsTextPropertyTab.WriteError.fmt.txt", (Object)ex.getMessage()), (int)0);
            }
        }
    }

    private class SaveCopyRemoteAction
    extends WsAbstractAction {
        public SaveCopyRemoteAction() {
            this.setEnabled(false);
            this.setMenuSupportId("File:SaveCopy:Remote");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
            String textToSave = "";
            if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabCode) {
                mapFileTypes.put("SAS Files (*.sas)", "SAS");
                mapFileTypes.put("All Files", "*");
                textToSave = JobEditorPanel.this.m_tabCode.getCodePane().getText();
            } else if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabLog) {
                mapFileTypes.put("SAS Log Files (*.log)", "LOG");
                mapFileTypes.put("All Files", "*");
                textToSave = JobEditorPanel.this.m_tabLog.getText();
            } else if (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabOutput) {
                mapFileTypes.put("SAS Log Files (*.lst)", "LST");
                mapFileTypes.put("All Files", "*");
                textToSave = JobEditorPanel.this.m_tabOutput.getText();
            }
            WsAppServer appServ = null;
            boolean bCreatedOwnAppServer = false;
            try {
                appServ = JobEditorPanel.this.m_mdlJob.getSASAppServer();
                if (appServ == null) {
                    appServ = WsAppServer.createDefaultAppServer();
                    if (appServ == null) {
                        MessageUtil.displayMessage((String)bundle.getString("WsEditorPropertyTab.Error.Message.txt"), (int)0);
                        return;
                    }
                    appServ.open();
                    bCreatedOwnAppServer = true;
                }
                String initialPath = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("JobEditorPanel.LastRemoteFilePath", "");
                String lastFile = "";
                String filename = "";
                List lFiles = appServ.promptForFilenamesWithDirectories(bundle.getString("JobEditorPanel.CopyTextToRemoteFile.txt"), initialPath, mapFileTypes, false, false, true, lastFile);
                if (lFiles != null && lFiles.size() > 0 && lFiles != null && lFiles.size() > 0) {
                    filename = (String)lFiles.get(0);
                }
                if (filename != null && filename.length() > 0) {
                    if (!filename.matches("[^\\s]+\\.[^\\s]+$")) {
                        filename = JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabLog ? filename + ".log" : (JobEditorPanel.this.m_tabActive == JobEditorPanel.this.m_tabOutput ? filename + ".lst" : filename + ".sas");
                    }
                    appServ.writeFile(textToSave, filename);
                    String parentDir = appServ.getParentDirectory(filename);
                    Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("JobEditorPanel.LastRemoteFilePath", parentDir);
                }
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)JobEditorPanel.this.getName(), (int)0);
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            finally {
                if (bCreatedOwnAppServer && appServ != null) {
                    appServ.dispose();
                }
            }
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setEnabled(false);
            this.setMenuSupportId("Common:Undo");
        }

        public void actionPerformed(ActionEvent ev) {
            JobEditorPanel.this.undo();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setEnabled(false);
            this.setMenuSupportId("Common:Redo");
        }

        public void actionPerformed(ActionEvent ev) {
            JobEditorPanel.this.redo();
        }
    }

    private class DetailsAction
    extends WsAbstractToggleAction {
        public DetailsAction() {
            super(bundle, "JobEditorPanel.Details", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("DetailsPanel"));
            this.setMenuSupportId("View:Details");
            this.setSelected(JobEditorPanel.this.isDetailsVisible());
        }

        public void actionPerformed(ActionEvent ev) {
            JobEditorPanel.this.setDetailsVisible(this.isSelected());
        }
    }

    private class GenerateCodeAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public GenerateCodeAction() {
            super(bundle, "JobEditorPanel.GenerateCode", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:GenerateCode"));
            this.setMenuSupportId("Actions:GenerateCode");
        }

        public void actionPerformed(ActionEvent ev) {
            JobEditorPanel.this.m_controller.setCodeNeedingUpdate();
            try {
                JobEditorPanel.this.generateCode();
            }
            catch (CodegenException cge) {
                MessageUtil.displayMessage((String)cge.getLocalizedMessage(), (int)0);
                return;
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                return;
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                return;
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                return;
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                return;
            }
            if (JobEditorPanel.this.m_bShowCodeTab) {
                JobEditorPanel.this.m_tabsMain.setSelectedTab((Component)((Object)JobEditorPanel.this.m_tabCode));
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForMainJob(context);
        }
    }

    private class ValidateAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public ValidateAction() {
            super(bundle, "JobEditorPanel.Validate", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("CheckDatabase"));
            this.setMenuSupportId("Actions:Validate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            CodePane codePane = JobEditorPanel.this.m_tabCode.getCodePane();
            try {
                JobEditorPanel.this.validateCode();
                JobEditorPanel.this.setDetailsVisible(true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            finally {
                Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForMainJob(context);
        }
    }

    private class RunAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public RunAction() {
            super(bundle, "JobEditorPanel.Run", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Run"));
            this.setMenuSupportId("Common:Run");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            CodePane codePane = JobEditorPanel.this.m_tabCode.getCodePane();
            try {
                if (JobEditorPanel.this.getActiveTab() == JobEditorPanel.this.m_tabCode && codePane.isTextSelected()) {
                    JobEditorPanel.this.runSelectedCode();
                } else {
                    JobEditorPanel.this.runJob();
                }
                JobEditorPanel.this.setDetailsVisible(true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            finally {
                Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForMainJob(context);
        }
    }

    private class StopAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public StopAction() {
            super(bundle, "JobEditorPanel.Stop", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Stop"));
            this.setMenuSupportId("Common:Stop");
        }

        public void actionPerformed(ActionEvent e) {
            int stopPrompt = MessageUtil.displayMessage((String)bundle.getString("JobEditorPanel.StopAction.prompt.txt"), (String)bundle.formatString("JobEditorPanel.StopAction.prompt.title.fmt", (Object)JobEditorPanel.this.m_mdlJob.getJob().getName()), (int)3, (int)0);
            if (stopPrompt == 0) {
                if (JobEditorPanel.this.m_mdlValidate.getValidateState() == 1) {
                    JobEditorPanel.this.stopValidate();
                } else {
                    JobEditorPanel.this.stopJob();
                }
                WsAppServer appServer = JobEditorPanel.this.getSASAppServer();
                if (appServer != null) {
                    appServer.dispose();
                    JobEditorPanel.this.setSASAppServer(null);
                }
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForMainJob(context);
        }
    }

    private class StepAction
    extends WsAbstractAction {
        public StepAction() {
            super(bundle, "JobEditorPanel.Step", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Debug:Step"));
            this.setMenuSupportId("Debug:Step");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                JobEditorPanel.this.stepJob();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class ContinueAction
    extends WsAbstractAction {
        public ContinueAction() {
            super(bundle, "JobEditorPanel.Continue", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Debug:Continue"));
            this.setMenuSupportId("Debug:Continue");
        }

        public void actionPerformed(ActionEvent e) {
            JobEditorPanel.this.continueJob();
        }
    }

    private class RunToSelectedTransformation
    extends WsAbstractAction {
        public RunToSelectedTransformation() {
            super(bundle, "JobEditorPanel.RunToSelectedTransformation", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Debug:RunToSelectedTransformation"));
            this.setMenuSupportId("Debug:RunToSelectedTransformation");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JobEditorPanel.this.runTo(JobEditorPanel.this.getSelectedTransform());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class RunFromSelectedTransformation
    extends WsAbstractAction {
        public RunFromSelectedTransformation() {
            super(bundle, "JobEditorPanel.RunFromSelectedTransformation", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Debug:RunFromSelectedTransformation"));
            this.setMenuSupportId("Debug:RunFromSelectedTransformation");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JobEditorPanel.this.runFrom(JobEditorPanel.this.getSelectedTransform());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class RunSelectedTransformations
    extends WsAbstractAction {
        public RunSelectedTransformations() {
            super(bundle, "JobEditorPanel.RunSelectedTransformations", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Debug:RunSelectedTransformations"));
            this.setMenuSupportId("Debug:RunSelectedTransformations");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JobEditorPanel.this.runSelected(JobEditorPanel.this.getSelectedTransforms());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class FindInCodeAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FindInCodeAction() {
            this.setMenuSupportId("Edit:FindIn:Code");
        }

        public void actionPerformed(ActionEvent ev) {
            ITransform transform = JobEditorPanel.this.getSelectedTransform();
            if (transform != null) {
                JobEditorPanel.this.findInCode((IObject)transform);
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForTransforms(context);
        }
    }

    private class FindInLogAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FindInLogAction() {
            this.setMenuSupportId("Edit:FindIn:Log");
        }

        public void actionPerformed(ActionEvent ev) {
            ITransform transform = JobEditorPanel.this.getSelectedTransform();
            if (transform != null) {
                JobEditorPanel.this.findInLog((IObject)transform);
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForTransforms(context);
        }
    }

    private class FindInStatusAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FindInStatusAction() {
            this.setMenuSupportId("Edit:FindIn:Status");
        }

        public void actionPerformed(ActionEvent ev) {
            ITransform transform = JobEditorPanel.this.getSelectedTransform();
            if (transform != null) {
                JobEditorPanel.this.findInStatus((IObject)transform);
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForTransforms(context);
        }
    }

    private class FindInWarningsAndErrorsAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FindInWarningsAndErrorsAction() {
            this.setMenuSupportId("Edit:FindIn:WarningsAndErrors");
        }

        public void actionPerformed(ActionEvent ev) {
            ITransform transform = JobEditorPanel.this.getSelectedTransform();
            if (transform != null) {
                JobEditorPanel.this.findInWarningsAndErrors((IObject)transform);
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForTransforms(context);
        }
    }

    private class FindInStatisticsAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public FindInStatisticsAction() {
            this.setMenuSupportId("Edit:FindIn:Statistics");
        }

        public void actionPerformed(ActionEvent ev) {
            ITransform transform = JobEditorPanel.this.getSelectedTransform();
            if (transform != null) {
                JobEditorPanel.this.findInStatistics((IObject)transform);
            }
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            return JobEditorPanel.this.isContextForTransforms(context);
        }
    }

    private class RunJobModelListener
    implements RunModelListener {
        private boolean m_bOrignallyEditable;
        private boolean m_bFirstTime = true;

        private RunJobModelListener() {
        }

        @Override
        public void modelChanged(RunModelEvent ev) {
            String sType = ev.getType();
            if (sType == "RunStateChanged") {
                JobEditorPanel.this.updateActions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runEventHappened(RunEvent ev) {
            String sType = ev.getType();
            if (sType == "RunStarted") {
                JobEditorPanel.this.refreshStatus(sType);
                if (this.m_bFirstTime) {
                    this.m_bOrignallyEditable = JobEditorPanel.this.m_mdlJob.isEditable();
                    this.m_bFirstTime = false;
                }
                JobEditorPanel.this.m_mdlJob.setEditable(false);
                if (JobEditorPanel.isUserPreferenceToClearLogAndOutput()) {
                    JobEditorPanel.this.m_tabLog.clear();
                    JobEditorPanel.this.m_tabOutput.clear();
                }
            } else if (sType == "SegmentStarted") {
                IObject runObject = ev.getCodeSegment().getModelObject();
                if (runObject != null) {
                    String key = String.valueOf(runObject.hashCode());
                    JobEditorPanel.this.m_mapObjects.put(key, runObject);
                }
            } else if (sType == "SegmentCompleted") {
                RunResults results = ev.getResults();
                JobEditorPanel.this.m_tabLog.appendResults(results);
                JobEditorPanel.this.m_tabOutput.appendResults(results);
            } else if (sType == "RunAborted" || sType == "RunCompleted" || sType == "RunStopped") {
                WsAppServerFailException ex;
                Container myParent = JobEditorPanel.this.getParent();
                if (myParent != null) {
                    myParent.setCursor(Cursor.getPredefinedCursor(3));
                }
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JobEditorPanel.this.m_tabWarnings.updateWarningsAndErrorsText();
                }
                finally {
                    if (myParent != null) {
                        myParent.setCursor(Cursor.getDefaultCursor());
                    }
                    Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
                }
                if (sType == "RunAborted" && (ex = ev.getException()) != null) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    Workspace.getDefaultLogger().error((Object)"Run aborted", (Throwable)ex);
                }
                JobEditorPanel.this.m_mdlJob.setEditable(this.m_bOrignallyEditable);
                JobEditorPanel.this.refreshStatus(sType);
                if (sType == "RunCompleted") {
                    JobEditorPanel.this.refreshJobIfNecessary();
                }
            }
        }
    }

    private class ValidateJobModelListener
    implements ValidateModelListener {
        private boolean m_bOrignallyEditable;
        private boolean m_bFirstTime = true;

        private ValidateJobModelListener() {
        }

        @Override
        public void modelChanged(ValidateModelEvent ev) {
            String sType = ev.getType();
            if (sType == "ValidateStateChanged") {
                JobEditorPanel.this.updateActions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validateEventHappened(ValidateEvent ev) {
            String sType = ev.getType();
            if (sType == "ValidateStarted") {
                JobEditorPanel.this.refreshStatus(sType);
                if (this.m_bFirstTime) {
                    this.m_bOrignallyEditable = JobEditorPanel.this.m_mdlJob.isEditable();
                    this.m_bFirstTime = false;
                }
                JobEditorPanel.this.m_mdlJob.setEditable(false);
                if (JobEditorPanel.isUserPreferenceToClearLogAndOutput()) {
                    JobEditorPanel.this.m_tabLog.clear();
                    JobEditorPanel.this.m_tabOutput.clear();
                }
            } else if (sType == "SegmentStarted") {
                IObject ValidateObject = ev.getCodeSegment().getModelObject();
                if (ValidateObject != null) {
                    String key = String.valueOf(ValidateObject.hashCode());
                    JobEditorPanel.this.m_mapObjects.put(key, ValidateObject);
                }
            } else if (sType == "SegmentCompleted") {
                ValidateResults results = ev.getResults();
                JobEditorPanel.this.m_tabLog.appendResults(results);
                JobEditorPanel.this.m_tabOutput.appendResults(results);
            } else if (sType == "ValidateCompleted" || sType == "ValidateStopped") {
                Container myParent = JobEditorPanel.this.getParent();
                if (myParent != null) {
                    myParent.setCursor(Cursor.getPredefinedCursor(3));
                }
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JobEditorPanel.this.m_tabWarnings.updateWarningsAndErrorsText();
                }
                finally {
                    if (myParent != null) {
                        myParent.setCursor(Cursor.getDefaultCursor());
                    }
                    Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
                }
                JobEditorPanel.this.m_mdlJob.setEditable(this.m_bOrignallyEditable);
                JobEditorPanel.this.refreshStatus(sType);
                if (sType == "ValidateCompleted") {
                    JobEditorPanel.this.refreshJobIfNecessary();
                }
            }
        }
    }

    private class DiagramDrillListener
    implements DrillListener {
        private DiagramDrillListener() {
        }

        @Override
        public void drilled(DrillEvent ev) {
            JobEditorPanel.this.fireDrillEvent(JobEditorPanel.this, ev.getDrillTarget());
        }
    }

    private class DiagramDebugListener
    implements DebugEventListener {
        private DiagramDebugListener() {
        }

        @Override
        public void debugActionTriggered(DebugEvent ev) {
            if (ev.getType().equalsIgnoreCase("RunToSelectedTransform")) {
                try {
                    JobEditorPanel.this.runTo(JobEditorPanel.this.getSelectedTransform());
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException ex2) {
                    Workspace.handleRemoteException((RemoteException)ex2);
                }
                catch (BadServerDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (ServerException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (CodegenException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
            } else if (ev.getType().equalsIgnoreCase("RunFromSelectedTransforms")) {
                try {
                    JobEditorPanel.this.runFrom(JobEditorPanel.this.getSelectedTransform());
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException ex2) {
                    Workspace.handleRemoteException((RemoteException)ex2);
                }
                catch (BadServerDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (ServerException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (CodegenException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
            } else if (ev.getType().equalsIgnoreCase("RunSelectedTransforms")) {
                try {
                    JobEditorPanel.this.runSelected(JobEditorPanel.this.getSelectedTransforms());
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException ex2) {
                    Workspace.handleRemoteException((RemoteException)ex2);
                }
                catch (BadServerDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (ServerException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (CodegenException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
            }
        }
    }

    private class DataChangedListener
    implements PropertyChangeListener {
        private DataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean bChanged = JobEditorPanel.this.m_mgrUndo.canUndo() || JobEditorPanel.this.m_tabCode.hasDataChanged();
            JobEditorPanel.this.setDataChanged(bChanged);
        }
    }

    private class TabSelectionListener
    implements ChangeListener {
        private TabSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            WAPropertyTab tab = ev.getSource() == JobEditorPanel.this.m_tabsMain ? (WAPropertyTab)JobEditorPanel.this.m_tabsMain.getSelectedTab() : (WAPropertyTab)JobEditorPanel.this.m_tabsDetails.getSelectedComponent();
            JobEditorPanel.this.setActiveTab(tab);
            if (tab == JobEditorPanel.this.m_tabDiagram) {
                JobEditorPanel.this.m_tabDiagram.getDiagramToolBar().setVisible(true);
            } else {
                JobEditorPanel.this.m_tabDiagram.getDiagramToolBar().setVisible(false);
            }
        }
    }

    private class ClearRuntimeDetailsListener
    implements ActionListener {
        private ClearRuntimeDetailsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JobEditorPanel.this.m_tabStatus.clear();
            JobEditorPanel.this.m_tabWarnings.clear();
            JobEditorPanel.this.m_tabStatistics.clear();
            JobEditorPanel.this.m_mdlRun.setHasRun(false);
            JobEditorPanel.this.m_tabDiagram.setModeOnTransformNodes(0);
        }
    }

    private class CloseDetailsPanelListener
    implements ActionListener {
        private CloseDetailsPanelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JobEditorPanel.this.setDetailsVisible(false);
        }
    }

    private class MaximizeDetailsPanelListener
    implements ActionListener {
        private MaximizeDetailsPanelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int eNewState = JobEditorPanel.this.getDetailsState() == 2 ? 0 : 2;
            JobEditorPanel.this.setDetailsState(eNewState);
        }
    }

    private class MinimizeDetailsPanelListener
    implements ActionListener {
        private MinimizeDetailsPanelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int eNewState = JobEditorPanel.this.getDetailsState() == 1 ? 0 : 1;
            JobEditorPanel.this.setDetailsState(eNewState);
        }
    }

    private class RuntimeDetailsHyperlinkListener
    implements HyperlinkListener {
        private RuntimeDetailsHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                String[] actionKeys = e.getDescription().split(":");
                String action = actionKeys[0];
                String objectID = actionKeys[1];
                if ("SELECT".equals(action)) {
                    int startIndex = Integer.parseInt(actionKeys[1]);
                    int endIndex = Integer.parseInt(actionKeys[2]);
                    JobEditorPanel.this.m_tabsMain.setSelectedTab((Component)((Object)JobEditorPanel.this.m_tabLog));
                    JobEditorPanel.this.m_tabsMain.validate();
                    JComponent cmp = (JComponent)JobEditorPanel.this.m_tabLog.getDefaultFocusComponent();
                    if (cmp != null) {
                        cmp.requestFocusInWindow();
                    }
                    try {
                        CodeEditorPane editor = JobEditorPanel.this.m_tabLog.getEditorPane();
                        editor.scrollRectToVisible(editor.modelToView(endIndex));
                        editor.setCaretPosition(endIndex);
                        editor.moveCaretPosition(startIndex);
                    }
                    catch (BadLocationException ble) {
                        Workspace.getDefaultLogger().warn((Object)ble.getLocalizedMessage());
                    }
                    catch (IllegalArgumentException iae) {
                        Workspace.getDefaultLogger().warn((Object)iae.getLocalizedMessage());
                    }
                    return;
                }
                IObject obj = (IObject)JobEditorPanel.this.m_mapObjects.get(objectID);
                if (obj == null) {
                    MessageUtil.displayMessage((String)bundle.getString("JobEditorPanel.NodeRemoved.txt"), (String)bundle.getString("JobEditorPanel.NodeRemoved.title.txt"));
                    return;
                }
                if ("SCROLL".equals(action)) {
                    JobEditorPanel.this.findInDiagram(obj);
                } else if ("CODE".equals(action)) {
                    JobEditorPanel.this.findInCode(obj);
                } else if ("LOG".equals(action)) {
                    JobEditorPanel.this.findInLog(obj);
                } else if ("PROPERTIES".equals(action)) {
                    if (obj instanceof IUserWrittenCodeContainer) {
                        IUserWrittenCodeContainer code = (IUserWrittenCodeContainer)obj;
                        obj = code.getOwner();
                    }
                    if (obj instanceof IComplexPersistableObject) {
                        JobEditorPanel.this.m_tabDiagram.showPropertiesDialog((IComplexPersistableObject)obj);
                    }
                } else if ("WARNING".equals(action)) {
                    JobEditorPanel.this.findInWarningsAndErrors(obj);
                } else if ("ERROR".equals(action)) {
                    JobEditorPanel.this.findInWarningsAndErrors(obj);
                } else {
                    throw new UnsupportedOperationException("WarningsAndErrorsTab - illegal action key");
                }
            }
        }
    }

    private class StatusTableMouseListener
    extends MouseAdapter {
        private StatusTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            WsTable statusTable = JobEditorPanel.this.m_tabStatus.getStatusTable();
            int columnSelected = statusTable.getColumnModel().getColumnIndexAtX(e.getX());
            int[] rowsSelected = statusTable.getSelectedRowsFromSelectedCells();
            IObject obj = null;
            StatusTableModel statusModel = (StatusTableModel)((Object)statusTable.getModel());
            if (rowsSelected.length == 1) {
                int modelRowIndex = statusTable.convertRowIndexToModel(rowsSelected[0]);
                obj = (IObject)statusModel.getValueAt(modelRowIndex, 4);
                if (e.getClickCount() == 2) {
                    String details;
                    Object status;
                    if ((columnSelected == 1 || columnSelected == 0) && obj instanceof IComplexPersistableObject) {
                        JobEditorPanel.this.m_tabDiagram.showPropertiesDialog((IComplexPersistableObject)obj);
                    }
                    if (columnSelected == 2 && (StatusTab.STATUS_ERROR.equals(status = statusModel.getValueAt(modelRowIndex, 2)) || StatusTab.STATUS_WARNING.equals(status))) {
                        JobEditorPanel.this.findInWarningsAndErrors(obj);
                    }
                    if (columnSelected == 3 && (details = (String)statusModel.getValueAt(modelRowIndex, 3)) != null && details.length() > 0) {
                        JobEditorPanel.this.m_tabStatus.showDetailView();
                    }
                }
            }
        }
    }

    private class StatisticsTableMouseListener
    extends MouseAdapter {
        private StatisticsTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            WsTable statisticsTable = JobEditorPanel.this.m_tabStatistics.getStatisticsTable();
            int[] rowsSelected = statisticsTable.getSelectedRowsFromSelectedCells();
            IObject obj = null;
            StatisticsTableModel statisticsModel = (StatisticsTableModel)((Object)statisticsTable.getModel());
            if (rowsSelected.length == 1) {
                int modelRowIndex = statisticsTable.convertRowIndexToModel(rowsSelected[0]);
                obj = (IObject)statisticsModel.getValueAt(modelRowIndex, 23);
                if (e.getClickCount() == 2 && obj instanceof IComplexPersistableObject) {
                    JobEditorPanel.this.m_tabDiagram.showPropertiesDialog((IComplexPersistableObject)obj);
                }
            }
        }
    }

    private class RuntimeTableSelectionListener
    implements ListSelectionListener {
        private DetailsTab m_tabDetails;
        private WsTable m_table;
        private int m_iModelIndex;
        private int m_iPreviousRow;

        public RuntimeTableSelectionListener(DetailsTab tab, WsTable table, int modelIndex) {
            this.m_tabDetails = tab;
            this.m_table = table;
            this.m_iModelIndex = modelIndex;
            this.m_iPreviousRow = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (JobEditorPanel.this.m_selectionSource != null) {
                return;
            }
            JobEditorPanel.this.m_selectionSource = this.m_tabDetails;
            try {
                int[] rowsSelected = this.m_table.getSelectedRowsFromSelectedCells();
                IObject obj = null;
                TableModel tableModel = this.m_table.getModel();
                if (rowsSelected.length == 1) {
                    if (this.m_tabDetails.isSelectionInProgress()) {
                        return;
                    }
                    int modelRowIndex = this.m_table.convertRowIndexToModel(rowsSelected[0]);
                    if (modelRowIndex == this.m_iPreviousRow) {
                        return;
                    }
                    this.m_iPreviousRow = modelRowIndex;
                    obj = (IObject)tableModel.getValueAt(modelRowIndex, this.m_iModelIndex);
                    JobEditorPanel.this.findInDiagram(obj);
                } else {
                    this.m_iPreviousRow = -1;
                }
            }
            finally {
                JobEditorPanel.this.m_selectionSource = null;
            }
        }
    }

    private class SaveChangedDataObjectsRunnable
    implements Runnable {
        private SaveChangedDataObjectsRunnable() {
        }

        @Override
        public void run() {
            try {
                JobEditorPanel.this.m_mdlJob.saveChangedDataObjects(Workspace.getMdFactory());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Writing");
            }
        }
    }

    private class RemoveDeletedObjectsFromModelRunnable
    implements Runnable {
        private String[] m_aIDs;

        public RemoveDeletedObjectsFromModelRunnable(String[] aIDs) {
            this.m_aIDs = aIDs;
        }

        @Override
        public void run() {
            JobEditorPanel.this.removeDeletedObjectsFromModel(this.m_aIDs);
        }
    }

    private class ReloadChangedModelObjectsRunnable
    implements Runnable {
        private String[] m_aIDs;

        public ReloadChangedModelObjectsRunnable(String[] aIDs) {
            this.m_aIDs = aIDs;
        }

        @Override
        public void run() {
            JobEditorPanel.this.reloadChangedModelObjects(this.m_aIDs);
        }
    }

    public class cRestartRunOptionsPanel
    extends WAPanel {
        private ButtonGroup m_bgpOptions;
        private JRadioButton m_rbnRunFromBeginning;
        private JRadioButton m_rbnRunFromRestartPoint;
        private WsAbstractToggleAction m_actRunFromBeginning;
        private WsAbstractToggleAction m_actRunFromRestartPoint;
        private int m_iAnswer;
        public static final int RUN_FROM_BEGINNING = 0;
        public static final int RUN_FROM_RESTART = 1;

        public cRestartRunOptionsPanel(String sPendingTransformName) {
            this.initialize(sPendingTransformName);
            this.layoutWidgets();
        }

        protected void initialize(String sPendingTransformName) {
            this.m_actRunFromBeginning = this.createRunFromBeginningAction();
            this.m_actRunFromRestartPoint = this.createRunFromRestartPointAction();
            this.m_rbnRunFromBeginning = WsUIUtilities.createRadioButton((WsAbstractToggleAction)this.m_actRunFromBeginning);
            this.m_rbnRunFromRestartPoint = WsUIUtilities.createRadioButton((WsAbstractToggleAction)this.m_actRunFromRestartPoint);
            this.m_rbnRunFromRestartPoint.setText(bundle.formatString("JobEditorPanel.cRestartRunOptionsAction.RunFromRestartPoint.txt", (Object)sPendingTransformName));
            this.m_rbnRunFromBeginning.setSelected(true);
            this.m_bgpOptions = new ButtonGroup();
            this.m_bgpOptions.add(this.m_rbnRunFromBeginning);
            this.m_bgpOptions.add(this.m_rbnRunFromRestartPoint);
            this.setHelpProduct("wdb");
            this.setHelpTopic("run_restart_win");
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_rbnRunFromBeginning, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add(this.m_rbnRunFromRestartPoint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        }

        public int getAnswer() {
            return this.m_iAnswer;
        }

        protected WsAbstractToggleAction createRunFromRestartPointAction() {
            return new cRunFromRestartPointAction();
        }

        protected WsAbstractToggleAction createRunFromBeginningAction() {
            return new cRunFromBeginningAction();
        }

        private class cRunFromRestartPointAction
        extends WsAbstractToggleAction {
            public cRunFromRestartPointAction() {
                super(bundle, "JobEditorPanel.cRestartRunOptionsAction.RunFromRestartPoint", 0);
            }

            public void actionPerformed(ActionEvent e) {
                cRestartRunOptionsPanel.this.m_iAnswer = 1;
            }
        }

        private class cRunFromBeginningAction
        extends WsAbstractToggleAction {
            public cRunFromBeginningAction() {
                super(bundle, "JobEditorPanel.cRestartRunOptionsAction.RunFromBeginning", 0);
            }

            public void actionPerformed(ActionEvent e) {
                cRestartRunOptionsPanel.this.m_iAnswer = 0;
            }
        }
    }

    private class SelectionChangedRunnable
    implements Runnable {
        private Object m_rememberedSelectionSource;
        private boolean m_bOccurredDuringDelete;

        public SelectionChangedRunnable() {
            this.m_rememberedSelectionSource = JobEditorPanel.this.m_selectionSource;
            this.m_bOccurredDuringDelete = JobEditorPanel.this.m_tabDiagram.isDeleting();
        }

        @Override
        public void run() {
            if (JobEditorPanel.this.m_runLastSelectionChanged == this) {
                JobEditorPanel.this.m_runLastSelectionChanged = null;
                JobEditorPanel.this.m_selectionSource = this.m_rememberedSelectionSource;
                JobEditorPanel.this.m_bSelectionOccurredDuringDelete = this.m_bOccurredDuringDelete;
                try {
                    JobEditorPanel.this.selectionChanged();
                }
                finally {
                    JobEditorPanel.this.m_selectionSource = null;
                    JobEditorPanel.this.m_bSelectionOccurredDuringDelete = false;
                }
            }
        }
    }

    private class cSplitPaneDivider
    extends BasicSplitPaneDivider {
        public cSplitPaneDivider(BasicSplitPaneUI ui) {
            super(ui);
        }

        @Override
        public void processMouseMotionEvent(MouseEvent e) {
            if (e.getID() == 506 && !JobEditorPanel.this.m_bIgnoreDividerLocationEvents) {
                JobEditorPanel.this.setDetailsState(0);
            }
            super.processMouseMotionEvent(e);
        }
    }

    private class cSplitPaneUI
    extends BasicSplitPaneUI {
        private cSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new cSplitPaneDivider(this);
        }
    }
}

