/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.TextColumnHeader;
import com.sas.wadmin.efi2.TextColumnModel;
import com.sas.wadmin.efi2.TextColumnModelEvent;
import com.sas.wadmin.efi2.TextColumnModelListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class TextColumnHeaderUI
extends ComponentUI {
    private static final double TICK_FACTOR = 0.375;
    private static final double FIVE_TICK_FACTOR = 0.625;
    private static final double TEN_TICK_FACTOR = 0.625;
    private static Cursor s_curBegin = Cursor.getPredefinedCursor(11);
    private static Cursor s_curEnd = Cursor.getPredefinedCursor(10);
    protected TextColumnHeader m_header;
    protected TextColumnModel m_mdl;
    protected MouseInputListener m_lsnrMouse;
    protected TextColumnModelListener m_lsnrModel;

    public static ComponentUI createUI(JComponent h) {
        return new TextColumnHeaderUI();
    }

    @Override
    public void installUI(JComponent cmp) {
        this.m_header = (TextColumnHeader)cmp;
        this.m_mdl = this.m_header.getModel();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.m_header, "TableHeader.background", "TableHeader.foreground");
        this.m_header.setOpaque(true);
        this.m_header.setFont(this.m_header.getTextComponent().getFont());
        FontMetrics fm = this.m_header.getFontMetrics(this.m_header.getFont());
        int cyFont = fm.getHeight();
        this.m_header.setTickHeight((int)((double)cyFont * 0.375));
        this.m_header.setFiveTickHeight((int)((double)cyFont * 0.625));
        this.m_header.setTenTickHeight((int)((double)cyFont * 0.625));
    }

    protected void installListeners() {
        this.m_lsnrMouse = this.createMouseInputListener();
        this.m_header.addMouseListener(this.m_lsnrMouse);
        this.m_header.addMouseMotionListener(this.m_lsnrMouse);
        this.m_lsnrModel = this.createTextColumnModelListener();
        this.m_mdl.addModelListener(this.m_lsnrModel);
    }

    protected MouseInputListener createMouseInputListener() {
        return new cMouseInputHandler();
    }

    protected TextColumnModelListener createTextColumnModelListener() {
        return new cTextColumnModelListener();
    }

    protected void installKeyboardActions() {
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.m_header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.m_header.removeMouseListener(this.m_lsnrMouse);
        this.m_header.removeMouseMotionListener(this.m_lsnrMouse);
        this.m_lsnrMouse = null;
        this.m_mdl.removeModelListener(this.m_lsnrModel);
        this.m_lsnrModel = null;
    }

    protected void uninstallKeyboardActions() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int xTick;
        g.setColor(this.m_header.getForeground());
        g.setFont(this.m_header.getFont());
        FontMetrics fmHeader = g.getFontMetrics();
        int cxSpace = this.getTickSpace();
        Rectangle rBounds = this.m_header.getBounds();
        int yBottom = rBounds.y + rBounds.height - 1;
        int yTick = yBottom - this.m_header.getTickHeight();
        int cxTick = cxSpace;
        for (xTick = 0; xTick < rBounds.width; xTick += cxTick) {
            g.drawLine(xTick, yTick, xTick, yBottom);
        }
        yTick = yBottom - this.m_header.getFiveTickHeight();
        for (xTick = cxTick *= 5; xTick < rBounds.width; xTick += cxTick) {
            g.drawLine(xTick, yTick, xTick, yBottom);
        }
        yTick = yBottom - this.m_header.getTenTickHeight();
        int yLabel = yTick - this.m_header.getLabelTickGap() - fmHeader.getDescent();
        int iChar = 10;
        for (int xTick2 = cxTick *= 2; xTick2 < rBounds.width; xTick2 += cxTick) {
            g.drawLine(xTick2, yTick, xTick2, yBottom);
            String sLabel = Integer.toString(iChar);
            int xLabel = xTick2 - fmHeader.stringWidth(sLabel) / 2;
            g.drawString(sLabel, xLabel, yLabel);
            iChar += 10;
        }
        g.setColor(SystemColor.controlShadow);
        for (int iColumn = 0; iColumn < this.m_mdl.getColumnCount(); ++iColumn) {
            int xBegin = (this.m_mdl.getColumnBegin(iColumn) - 1) * cxSpace + 1;
            int xEnd = this.m_mdl.getColumnEnd(iColumn) * cxSpace - 1;
            int nLines = (cxSpace + 1) / 2;
            int y = yBottom - 3;
            for (int iLine = 0; iLine < nLines; ++iLine) {
                g.drawLine(xBegin, y - iLine, xBegin + 3 - iLine, y - iLine);
                g.drawLine(xEnd, y - iLine, xEnd - 3 + iLine, y - iLine);
            }
            g.drawLine(xBegin, yBottom - 1, xEnd, yBottom - 1);
            g.drawLine(xBegin, yBottom - 2, xEnd, yBottom - 2);
        }
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(0, yBottom, rBounds.width - 1, yBottom);
    }

    private int getTickSpace() {
        FontMetrics fmText = this.m_header.getFontMetrics(this.m_header.getTextComponent().getFont());
        return fmText.charWidth('W');
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.m_header.getFontMetrics(this.m_header.getFont());
        int cyCmp = this.m_header.getLabelGap() + fm.getHeight() + this.m_header.getLabelTickGap() + this.m_header.getTenTickHeight();
        return new Dimension(this.m_header.getTextComponent().getPreferredSize().width, cyCmp);
    }

    protected class cMouseInputHandler
    extends MouseInputAdapter {
        protected int m_iColumn;
        protected int m_position;
        protected int m_ePosition;
        protected int m_minPosition;
        protected int m_maxPosition;
        protected boolean m_bDragBoth;
        protected int m_eDrag;
        protected static final int POSITION_BEGIN = 0;
        protected static final int POSITION_COLUMN = 1;
        protected static final int POSITION_END = 2;
        protected static final int POSITION_GAP = 3;
        protected static final int DRAG_NONE = 0;
        protected static final int DRAG_BEGIN = 1;
        protected static final int DRAG_END = 2;
        protected static final int DRAG_BOTH = 3;
        protected static final int DRAG_UNKNOWN = 4;

        protected cMouseInputHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TextColumnHeaderUI.this.m_header.isEditable()) {
                return;
            }
            if (TextColumnHeaderUI.this.m_header.isOverlappingColumns()) {
                return;
            }
            this.updatePositionValues(e);
            this.updateCursor();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!TextColumnHeaderUI.this.m_header.isEditable()) {
                return;
            }
            if (TextColumnHeaderUI.this.m_header.isOverlappingColumns()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.updatePositionValues(e);
                if (this.m_bDragBoth) {
                    if (this.m_ePosition == 0) {
                        --this.m_iColumn;
                    }
                    this.m_minPosition = TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn);
                    this.m_position = TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn);
                    this.m_maxPosition = TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn + 1) - 1;
                    this.m_eDrag = 3;
                } else {
                    switch (this.m_ePosition) {
                        case 0: {
                            this.m_eDrag = 1;
                            this.m_minPosition = this.m_iColumn == 0 ? 1 : TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn - 1) + 1;
                            this.m_maxPosition = TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn);
                            break;
                        }
                        case 2: {
                            this.m_eDrag = 2;
                            this.m_minPosition = TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn);
                            this.m_maxPosition = this.m_iColumn >= TextColumnHeaderUI.this.m_mdl.getColumnCount() - 1 ? Integer.MAX_VALUE : TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn + 1) - 1;
                            break;
                        }
                        case 1: {
                            this.m_position = this.getRoundedPositionAt(e.getX());
                            int begin = TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn);
                            int end = TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn);
                            TextColumnHeaderUI.this.m_mdl.updateColumn(this.m_iColumn, begin, this.m_position);
                            TextColumnHeaderUI.this.m_mdl.insertColumn(this.m_iColumn + 1, this.m_position + 1, end);
                            this.m_eDrag = 3;
                            this.m_minPosition = begin;
                            this.m_maxPosition = end - 1;
                            this.setCursor(11);
                            break;
                        }
                        case 3: {
                            this.m_eDrag = 4;
                            this.m_position = this.getRoundedPositionAt(e.getX());
                            this.m_minPosition = this.m_iColumn == 0 ? 1 : TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn - 1) + 1;
                            this.m_maxPosition = this.m_iColumn >= TextColumnHeaderUI.this.m_mdl.getColumnCount() ? Integer.MAX_VALUE : TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn) - 1;
                        }
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.m_eDrag == 0) {
                return;
            }
            int position = Math.min(Math.max(this.getPositionAt(e.getX()), this.m_minPosition), this.m_maxPosition);
            if (this.m_eDrag == 3) {
                position = Math.min(Math.max(this.getRoundedPositionAt(e.getX()), this.m_minPosition), this.m_maxPosition);
                if (position != this.m_position) {
                    TextColumnHeaderUI.this.m_mdl.updateColumnEnd(this.m_iColumn, position);
                    TextColumnHeaderUI.this.m_mdl.updateColumnBegin(this.m_iColumn + 1, position + 1);
                    this.m_position = position;
                }
                this.setCursor(11);
            } else if (this.m_eDrag == 4) {
                if (this.getRoundedPositionAt(e.getX()) != this.m_position) {
                    if (position <= this.m_position) {
                        TextColumnHeaderUI.this.m_mdl.insertColumn(this.m_iColumn, position, this.m_position);
                        this.m_eDrag = 1;
                        this.m_maxPosition = this.m_position;
                        this.setCursor(s_curBegin);
                    } else {
                        TextColumnHeaderUI.this.m_mdl.insertColumn(this.m_iColumn, this.m_position + 1, position);
                        this.m_eDrag = 2;
                        this.m_minPosition = this.m_position;
                        this.setCursor(s_curEnd);
                    }
                    this.m_position = position;
                }
            } else if (this.m_eDrag == 1) {
                if (position != this.m_position) {
                    this.m_position = position;
                    TextColumnHeaderUI.this.m_mdl.updateColumnBegin(this.m_iColumn, position);
                }
                this.setCursor(s_curBegin);
            } else {
                if (position != this.m_position) {
                    this.m_position = position;
                    TextColumnHeaderUI.this.m_mdl.updateColumnEnd(this.m_iColumn, position);
                }
                this.setCursor(s_curEnd);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.m_eDrag == 0) {
                return;
            }
            if (this.m_eDrag == 4) {
                TextColumnHeaderUI.this.m_mdl.insertColumn(this.m_iColumn, this.m_minPosition, Math.max(1, this.m_position));
            }
            this.m_eDrag = 0;
            this.updatePositionValues(e);
            this.updateCursor();
        }

        private void updatePositionValues(MouseEvent e) {
            this.m_position = this.getPositionAt(e.getX());
            this.m_ePosition = 3;
            int begin = 0;
            int end = 0;
            this.m_iColumn = 0;
            while (this.m_iColumn < TextColumnHeaderUI.this.m_mdl.getColumnCount()) {
                begin = TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn);
                end = TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn);
                if (this.m_position < begin) break;
                if (begin < this.m_position && this.m_position < end) {
                    this.m_ePosition = 1;
                    break;
                }
                if (begin == this.m_position && end == this.m_position) {
                    if (this.getRoundedPositionAt(e.getX()) == end) {
                        this.m_ePosition = 2;
                        break;
                    }
                    this.m_ePosition = 0;
                    break;
                }
                if (begin == this.m_position) {
                    this.m_ePosition = 0;
                    break;
                }
                if (end == this.m_position) {
                    this.m_ePosition = 2;
                    break;
                }
                ++this.m_iColumn;
            }
            this.m_bDragBoth = false;
            if ((e.getModifiers() & 1) != 0) {
                if (this.m_ePosition == 0 && this.m_iColumn != 0 && TextColumnHeaderUI.this.m_mdl.getColumnEnd(this.m_iColumn - 1) + 1 == begin) {
                    this.m_bDragBoth = true;
                } else if (this.m_ePosition == 2 && this.m_iColumn != TextColumnHeaderUI.this.m_mdl.getColumnCount() - 1 && end + 1 == TextColumnHeaderUI.this.m_mdl.getColumnBegin(this.m_iColumn + 1)) {
                    this.m_bDragBoth = true;
                }
            }
        }

        private int getPositionAt(int x) {
            int cxSpace = TextColumnHeaderUI.this.getTickSpace();
            return (x - 1) / cxSpace + 1;
        }

        private int getRoundedPositionAt(int x) {
            int cxSpace = TextColumnHeaderUI.this.getTickSpace();
            return (x + cxSpace / 2) / cxSpace;
        }

        private void updateCursor() {
            if (this.m_bDragBoth) {
                this.setCursor(11);
            } else {
                switch (this.m_ePosition) {
                    case 0: {
                        this.setCursor(s_curBegin);
                        break;
                    }
                    case 2: {
                        this.setCursor(s_curEnd);
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.setCursor(0);
                    }
                }
            }
        }

        private void setCursor(int type) {
            this.setCursor(Cursor.getPredefinedCursor(type));
        }

        private void setCursor(Cursor cursor) {
            TextColumnHeaderUI.this.m_header.setCursor(cursor);
        }
    }

    protected class cTextColumnModelListener
    implements TextColumnModelListener {
        protected cTextColumnModelListener() {
        }

        @Override
        public void textColumnInserted(TextColumnModelEvent e) {
            this.repaintColumn(e.getBegin(), e.getEnd());
        }

        @Override
        public void textColumnUpdated(TextColumnModelEvent e) {
            this.repaintColumn(e.getOldBegin(), e.getOldEnd());
            this.repaintColumn(e.getNewBegin(), e.getNewEnd());
        }

        @Override
        public void textColumnDeleted(TextColumnModelEvent e) {
            this.repaintColumn(e.getBegin(), e.getEnd());
        }

        private void repaintColumn(int begin, int end) {
            int cxSpace = TextColumnHeaderUI.this.getTickSpace();
            int x = (begin - 1) * cxSpace;
            int y = TextColumnHeaderUI.this.m_header.getHeight() - cxSpace;
            int w = (end - begin + 1) * cxSpace;
            TextColumnHeaderUI.this.m_header.repaint(x, y, w, cxSpace);
        }
    }
}

