/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.TextColumnModel;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextColumnHeader
extends JComponent
implements DocumentListener,
PropertyChangeListener {
    private static final String uiClassID = "TextColumnHeaderUI";
    private JTextComponent m_txt;
    private int m_cyTick;
    private int m_cyFiveTick;
    private int m_cyTenTick;
    private int m_cyLabelTickGap;
    private int m_cyLabelGap;
    private boolean m_bEditable;
    private boolean m_bOverlapping;
    private TextColumnModel m_mdl;
    private ListSelectionModel m_mdlSelection;

    public TextColumnHeader(JTextComponent txt) {
        this.setTextComponent(txt);
        txt.addPropertyChangeListener(this);
        txt.getDocument().addDocumentListener(this);
        this.setModel(this.createModel());
        this.setSelectionModel(this.createSelectionModel());
        this.setEditable(true);
        FontMetrics fm = this.getFontMetrics(txt.getFont());
        if (fm.charWidth('i') != fm.charWidth('W')) {
            throw new UnsupportedOperationException("TextColumnHeader requires that the text area use a monospaced font");
        }
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.wadmin.efi2.TextColumnHeaderUI");
        }
        this.setUI(UIManager.getUI(this));
    }

    private TextColumnModel createModel() {
        return new TextColumnModel();
    }

    private ListSelectionModel createSelectionModel() {
        DefaultListSelectionModel mdl = new DefaultListSelectionModel();
        mdl.setSelectionMode(2);
        return mdl;
    }

    public void setTextComponent(JTextComponent txt) {
        this.m_txt = txt;
    }

    public JTextComponent getTextComponent() {
        return this.m_txt;
    }

    public void setModel(TextColumnModel mdl) {
        this.m_mdl = mdl;
    }

    public TextColumnModel getModel() {
        return this.m_mdl;
    }

    public void setSelectionModel(ListSelectionModel mdlSelection) {
        this.m_mdlSelection = mdlSelection;
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_mdlSelection;
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setOverlapColumns(boolean bOverlapping) {
        this.m_bOverlapping = bOverlapping;
    }

    public boolean isOverlappingColumns() {
        return this.m_bOverlapping;
    }

    public void setTickHeight(int cyTick) {
        this.m_cyTick = cyTick;
    }

    public int getTickHeight() {
        return this.m_cyTick;
    }

    public void setFiveTickHeight(int cyTick) {
        this.m_cyFiveTick = cyTick;
    }

    public int getFiveTickHeight() {
        return this.m_cyFiveTick;
    }

    public void setTenTickHeight(int cyTick) {
        this.m_cyTenTick = cyTick;
    }

    public int getTenTickHeight() {
        return this.m_cyTenTick;
    }

    public void setLabelTickGap(int cyLabelTickGap) {
        this.m_cyLabelTickGap = cyLabelTickGap;
    }

    public int getLabelTickGap() {
        return this.m_cyLabelTickGap;
    }

    public void setLabelGap(int cyLabelGap) {
        this.m_cyLabelGap = cyLabelGap;
    }

    public int getLabelGap() {
        return this.m_cyLabelGap;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateUI();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateUI();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            if (evt.getOldValue() instanceof Document) {
                ((Document)evt.getOldValue()).removeDocumentListener(this);
            }
            if (evt.getNewValue() instanceof Document) {
                Document doc = (Document)evt.getNewValue();
                doc.addDocumentListener(this);
            }
        }
    }
}

