/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.TextArea;
import com.sas.wadmin.efi2.TextColumnHeader;
import com.sas.wadmin.efi2.TextColumnModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class RawDataPanel2
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(RawDataPanel2.class);
    private WsAbstractAction m_actRefresh;
    private JLabel m_lblStartLine;
    private WAIntTextField m_txtStartLine;
    private JLabel m_lblNumberOfLines;
    private WAIntTextField m_txtNumberOfLines;
    private JButton m_btnRefresh;
    private TextArea m_txtData;
    private JScrollPane m_scrData;
    private IExternalTable m_mdlTable;
    private static final int DEFAULT_ROWS = 10;

    public RawDataPanel2(IExternalTable model) {
        this(model, 10);
    }

    public RawDataPanel2(IExternalTable model, int nRows) {
        this.m_mdlTable = model;
        this.initialize(nRows);
    }

    protected void initialize(int nRows) {
        this.setHelpTopic("view_file");
        this.setHelpProduct("wdb");
        this.m_actRefresh = new cRefreshAction();
        this.m_btnRefresh = new JButton((Action)this.m_actRefresh);
        this.m_txtStartLine = new WAIntTextField();
        this.m_txtNumberOfLines = new WAIntTextField();
        this.m_txtStartLine.setColumns(4);
        this.m_txtNumberOfLines.setColumns(4);
        this.m_txtStartLine.setMinimumSize(this.m_txtStartLine.getPreferredSize());
        this.m_txtNumberOfLines.setMinimumSize(this.m_txtNumberOfLines.getPreferredSize());
        this.m_txtStartLine.setValue(1);
        this.m_txtNumberOfLines.setValue(10);
        this.m_txtStartLine.setAction((Action)this.m_actRefresh);
        this.m_txtNumberOfLines.setAction((Action)this.m_actRefresh);
        this.m_lblStartLine = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtStartLine, (WAdminResource)bundle, (String)"RawDataPanel.Label.StartLine");
        this.m_lblNumberOfLines = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfLines, (WAdminResource)bundle, (String)"RawDataPanel.Label.NumberOfLines");
        this.m_txtData = new TextArea(nRows, 60);
        this.m_txtData.setEditable(false);
        this.m_scrData = new JScrollPane((Component)((Object)this.m_txtData));
        this.m_txtData.configureEnclosingScrollPane();
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrData);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblStartLine, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtStartLine, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_lblNumberOfLines, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.m_txtNumberOfLines, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnRefresh, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_scrData, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this.m_mdlTable.isDelimited() && !this.m_mdlTable.isFixedWidth()) {
            MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.CannotViewUserWrittenFile.txt"), (int)2);
            this.m_actRefresh.setEnabled(false);
            this.m_txtNumberOfLines.setEnabled(false);
            this.m_txtStartLine.setEnabled(false);
            return;
        }
        this.setListeningForChanges(false);
        this.loadFile(false);
        if (this.m_mdlTable.isFixedWidth()) {
            this.loadTextColumnModel();
        }
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    public void updateComponents() {
        boolean bEnabled = this.m_mdlTable.getFile().getServer() == null && (this.m_mdlTable.isDelimited() || this.m_mdlTable.isFixedWidth());
        this.m_actRefresh.setEnabled(bEnabled);
        this.m_txtNumberOfLines.setEnabled(bEnabled);
        this.m_txtStartLine.setEnabled(bEnabled);
    }

    public void clear() {
        this.m_txtData.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(boolean user) throws MdException, RemoteException {
        this.m_txtData.setText("");
        Object rio = null;
        Object textStream = null;
        String tempFileName = "TempRef";
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer appServer = WsAppServer.createAppServer((String)this.m_mdlTable.getFile().getServer().getID());
            if (appServer == null) {
                return;
            }
            appServer.open();
            String sEncoding = this.m_mdlTable.getFile().getInfileEncodingOptions();
            String sOptions = !sEncoding.equals("") ? "encoding=" + sEncoding : "";
            int startLine = this.m_txtStartLine.getValue2();
            int numberOfLines = this.m_txtNumberOfLines.getValue2();
            this.m_mdlTable.getFile().setLogicalFilename(appServer);
            String[] lines = appServer.readLinesFromFile(startLine, numberOfLines, this.m_mdlTable.getFile().getLogicalFilename(), sOptions);
            for (int iLine = 0; iLine < lines.length - 1; ++iLine) {
                this.m_txtData.append(lines[iLine]);
                this.m_txtData.append("\n");
            }
            if (lines.length > 0) {
                this.m_txtData.append(lines[lines.length - 1]);
            }
            this.m_txtData.setCaretPosition(0);
            this.m_txtData.getRowHeader().setRowOffset(startLine);
            if (user && lines.length < numberOfLines) {
                MessageUtil.displayMessage((String)bundle.formatString("RawDataPanel.Warning.Lines.fmt.txt", (Object)new Integer(appServer.getNumberOfLinesReadFromFile())), (int)2);
            }
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WAIntTextField.IllegalIntegerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            try {
                if (textStream != null) {
                    textStream.Close();
                }
                if (rio != null) {
                    rio.DeassignFileref(tempFileName);
                }
            }
            catch (GenericError e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    private void loadTextColumnModel() {
        TextColumnModel mdl = this.getTextColumnHeader().getModel();
        IColumn[] lColumns = this.m_mdlTable.getColumns();
        for (int iColumn = 0; iColumn < lColumns.length; ++iColumn) {
            IColumn oColumn = lColumns[iColumn];
            int begin = oColumn.getBeginPosition();
            int end = oColumn.getEndPosition();
            if (1 > begin || begin > end) continue;
            mdl.insertColumn(iColumn, begin, end);
        }
    }

    public TextColumnHeader getTextColumnHeader() {
        return this.m_txtData.getColumnHeader();
    }

    private class cRefreshAction
    extends WsAbstractAction {
        public cRefreshAction() {
            super(bundle, "RawDataPanel.Action.Refresh", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (RawDataPanel2.this.m_txtStartLine.getValue() < 1) {
                MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.InvalidStartRowValue.txt"), (int)0);
                RawDataPanel2.this.m_txtStartLine.requestFocus();
                return;
            }
            if (RawDataPanel2.this.m_txtNumberOfLines.getValue() < 1) {
                MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.InvalidNumRowValue.txt"), (int)0);
                RawDataPanel2.this.m_txtNumberOfLines.requestFocus();
                return;
            }
            try {
                RawDataPanel2.this.loadFile(true);
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

