/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.TextArea;
import com.sas.wadmin.efi2.TextColumnHeader;
import com.sas.wadmin.efi2.TextColumnModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class RawDataPanel
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(RawDataPanel.class);
    private WsAbstractAction m_actRefresh;
    private JLabel m_lblStartLine;
    private WAIntTextField m_txtStartLine;
    private JLabel m_lblNumberOfLines;
    private WAIntTextField m_txtNumberOfLines;
    private JButton m_btnRefresh;
    private TextArea m_txtData;
    private JScrollPane m_scrData;
    private ExternalTableDataModel m_mdlTable;
    private static final int DEFAULT_ROWS = 10;

    public RawDataPanel(ExternalTableDataModel model) {
        this(model, 10);
    }

    public RawDataPanel(ExternalTableDataModel model, int nRows) {
        this.m_mdlTable = model;
        this.initialize(nRows);
    }

    protected void initialize(int nRows) {
        this.setHelpTopic("view_file");
        this.setHelpProduct("wdb");
        this.m_actRefresh = new cRefreshAction();
        this.m_btnRefresh = new JButton((Action)this.m_actRefresh);
        this.m_txtStartLine = new WAIntTextField();
        this.m_txtNumberOfLines = new WAIntTextField();
        this.m_txtStartLine.setColumns(4);
        this.m_txtNumberOfLines.setColumns(4);
        this.m_txtStartLine.setMinimumSize(this.m_txtStartLine.getPreferredSize());
        this.m_txtNumberOfLines.setMinimumSize(this.m_txtNumberOfLines.getPreferredSize());
        this.m_txtStartLine.setValue(1);
        this.m_txtNumberOfLines.setValue(10);
        this.m_txtStartLine.setAction((Action)this.m_actRefresh);
        this.m_txtNumberOfLines.setAction((Action)this.m_actRefresh);
        this.m_lblStartLine = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtStartLine, (WAdminResource)bundle, (String)"RawDataPanel.Label.StartLine");
        this.m_lblNumberOfLines = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfLines, (WAdminResource)bundle, (String)"RawDataPanel.Label.NumberOfLines");
        this.m_txtData = new TextArea(nRows, 60);
        this.m_txtData.setEditable(false);
        this.m_scrData = new JScrollPane((Component)((Object)this.m_txtData));
        this.m_txtData.configureEnclosingScrollPane();
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrData);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblStartLine, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtStartLine, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_lblNumberOfLines, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.m_txtNumberOfLines, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnRefresh, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_scrData, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (ExternalTableDataModel.isLegacyEFIObject((ExternalTable)this.m_mdlTable.getExternalTable())) {
            MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.CannotViewOldStyleExternalFiles.txt"), (int)2);
            this.m_actRefresh.setEnabled(false);
            this.m_txtNumberOfLines.setEnabled(false);
            this.m_txtStartLine.setEnabled(false);
            return;
        }
        if (this.m_mdlTable.isUserWritten()) {
            MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.CannotViewUserWrittenFile.txt"), (int)2);
            this.m_actRefresh.setEnabled(false);
            this.m_txtNumberOfLines.setEnabled(false);
            this.m_txtStartLine.setEnabled(false);
            return;
        }
        this.setListeningForChanges(false);
        this.loadFile(false);
        if (this.m_mdlTable.isFixedWidth()) {
            this.loadTextColumnModel();
        }
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    public void updateComponents() {
        this.m_actRefresh.setEnabled(!this.m_mdlTable.isUserWritten());
        this.m_txtNumberOfLines.setEnabled(!this.m_mdlTable.isUserWritten());
        this.m_txtStartLine.setEnabled(!this.m_mdlTable.isUserWritten());
    }

    public void clear() {
        this.m_txtData.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(boolean user) throws MdException, RemoteException {
        this.m_txtData.setText("");
        Object rio = null;
        Object textStream = null;
        String tempFileName = "TempRef";
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer appServer = this.m_mdlTable.getAppServer();
            if (appServer == null) {
                return;
            }
            appServer.open();
            String sEncoding = this.m_mdlTable.getInfileEncodingTextQuoted();
            String sOptions = !sEncoding.equals("") ? "encoding=" + sEncoding : "";
            String accessMethod = this.m_mdlTable.getAccessMethodNickName();
            String fileName = this.m_mdlTable.getLogicalFilename();
            String tName = "";
            String dsString = " data work._ETL_Temp; \n length fname $200.; \n fname = \"" + fileName + "\"; \nrun;";
            MVAResultSet myTable = null;
            try {
                appServer.submitSASCode(dsString);
                dsString = "select fname from work._ETL_Temp";
                myTable = appServer.submitSQLStatement(dsString);
                myTable.next();
                tName = myTable.getString(1).trim();
                myTable.close();
            }
            catch (SQLException sQLException) {
            }
            catch (WsAppServerCodeException wsAppServerCodeException) {
            }
            catch (WsAppServerFailException wsAppServerFailException) {
                // empty catch block
            }
            if (this.m_mdlTable.isHttpAccessMethod()) {
                fileName = this.m_mdlTable.getHttpFilePath(fileName);
            }
            sOptions = sOptions + this.m_mdlTable.getAccessMethodOptions("_temp");
            String opts = this.m_mdlTable.getInfileOptionsText();
            if (opts != null && opts.length() > 0) {
                sOptions = sOptions + " " + opts;
            }
            int startLine = this.m_txtStartLine.getValue2();
            int numberOfLines = this.m_txtNumberOfLines.getValue2();
            String[] lines = appServer.readLinesFromFile(startLine, numberOfLines, tName, sOptions, accessMethod);
            for (int iLine = 0; iLine < lines.length - 1; ++iLine) {
                this.m_txtData.append(lines[iLine]);
                this.m_txtData.append("\n");
            }
            if (lines.length > 0) {
                this.m_txtData.append(lines[lines.length - 1]);
            }
            this.m_txtData.setCaretPosition(0);
            this.m_txtData.getRowHeader().setRowOffset(startLine);
            if (user && lines.length < numberOfLines) {
                MessageUtil.displayMessage((String)bundle.formatString("RawDataPanel.Warning.Lines.fmt.txt", (Object)new Integer(appServer.getNumberOfLinesReadFromFile())), (int)2);
            }
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WAIntTextField.IllegalIntegerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            try {
                if (textStream != null) {
                    textStream.Close();
                }
                if (rio != null) {
                    rio.DeassignFileref(tempFileName);
                }
            }
            catch (GenericError e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    private void loadTextColumnModel() throws MdException, RemoteException {
        TextColumnModel mdl = this.getTextColumnHeader().getModel();
        AssociationList lColumns = this.m_mdlTable.getExternalTable().getColumns();
        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
            Column oColumn = (Column)lColumns.get(iColumn);
            int begin = oColumn.getBeginPosition();
            int end = oColumn.getEndPosition();
            if (1 > begin || begin > end) continue;
            mdl.insertColumn(iColumn, begin, end);
        }
    }

    public TextColumnHeader getTextColumnHeader() {
        return this.m_txtData.getColumnHeader();
    }

    private class cRefreshAction
    extends WsAbstractAction {
        public cRefreshAction() {
            super(bundle, "RawDataPanel.Action.Refresh", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (RawDataPanel.this.m_txtStartLine.getValue() < 1) {
                MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.InvalidStartRowValue.txt"), (int)0);
                RawDataPanel.this.m_txtStartLine.requestFocus();
                return;
            }
            if (RawDataPanel.this.m_txtNumberOfLines.getValue() < 1) {
                MessageUtil.displayMessage((String)bundle.getString("RawDataPanel.Error.InvalidNumRowValue.txt"), (int)0);
                RawDataPanel.this.m_txtNumberOfLines.requestFocus();
                return;
            }
            try {
                RawDataPanel.this.loadFile(true);
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

