/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.ColumnDefinitionsPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.ProcessedDataPanelFactory;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.ViewDataScrollPane;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ProcessedDataPanel
extends ViewDataPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ProcessedDataPanel.class);
    private ColumnDefinitionsPanel m_cdf;
    private WAPanel m_headerPanel;
    private WAIntTextField m_txtStartLine;
    private WAIntTextField m_txtNumberOfLines;
    private WsEditorPropertyTab m_sourceTab;
    private WsLogPropertyTab m_logTab;
    private WsAbstractAction m_actRefresh;
    private ExternalTableDataModel m_mdlTable;
    private int m_modelNumberOfRecords;
    private int m_modelStartLine;
    private boolean m_bCreateView = true;

    public ProcessedDataPanel(ExternalTableDataModel model, ColumnDefinitionsPanel cdf) {
        this.m_mdlTable = model;
        this.m_cdf = cdf;
        this.initialize();
    }

    protected void initialize() {
        this.setToolBarShowing(false);
        this.m_actRefresh = new RefreshAction();
        this.m_txtStartLine = new WAIntTextField();
        this.m_txtStartLine.setColumns(4);
        this.m_txtStartLine.setMinimumSize(this.m_txtStartLine.getPreferredSize());
        this.m_txtStartLine.setAction((Action)this.m_actRefresh);
        this.m_txtNumberOfLines = new WAIntTextField();
        this.m_txtNumberOfLines.setColumns(4);
        this.m_txtNumberOfLines.setMinimumSize(this.m_txtNumberOfLines.getPreferredSize());
        this.m_txtNumberOfLines.setAction((Action)this.m_actRefresh);
        this.m_headerPanel = this.createHeaderPanel();
        this.setBackground(SystemColor.controlLtHighlight);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_headerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void layoutWidgets() {
        this.removeAll();
        this.add((Component)this.m_headerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getFactory().getDefaultSearchToolArea(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new ViewDataScrollPane((Component)((Object)this.getFactory().getDefaultTable()), 22, 30), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
    }

    protected WAPanel createHeaderPanel() {
        return new HeaderPanel();
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        super.populateStore();
        this.m_mdlTable.populateStore();
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void superMoveDataToView() throws MdException, RemoteException {
        super.moveDataToView();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_headerPanel.setEnabled(enabled);
    }

    @Override
    protected ViewDataAbstractFactory createFactory() {
        return new ProcessedDataPanelFactory(this.m_mdlTable.getExternalTable(), this.m_mdlTable);
    }

    public void setLogTab(WsLogPropertyTab logTab) {
        this.m_logTab = logTab;
    }

    public void setSourceTab(WsEditorPropertyTab sourceTab) {
        this.m_sourceTab = sourceTab;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    protected void updateComponents() {
        this.m_txtNumberOfLines.setEnabled(!this.m_mdlTable.isInfileOverriden());
        this.m_txtStartLine.setEnabled(!this.m_mdlTable.isInfileOverriden());
        this.m_txtStartLine.setValue(this.m_mdlTable.getStartRecord());
        int numberObsFromModel = this.m_mdlTable.getNumberObservations();
        if (numberObsFromModel != 0) {
            this.m_txtNumberOfLines.setValue(Math.min(numberObsFromModel, 10));
        } else {
            this.m_txtNumberOfLines.setValue(10);
        }
    }

    @Override
    protected void onFetchComplete() {
        super.onFetchComplete();
        try {
            this.m_mdlTable.setStartRecord(this.m_modelStartLine);
            this.m_mdlTable.setNumberObservations(this.m_modelNumberOfRecords);
            this.m_mdlTable.setCreateView(this.m_bCreateView);
            this.m_logTab.clear();
            WsAppServer appserver = ((MetadataConnectionManager)this.getFactory().getDefaultConnectionManager()).getAppServer();
            LogListHolder llh = appserver.getLog();
            if (llh != null) {
                this.m_logTab.appendText(llh);
            }
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected class RefreshAction
    extends WsAbstractAction {
        public RefreshAction() {
            super(bundle, "ProcessedDataPanel.Action.Refresh", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            block12: {
                try {
                    int tabStartLine = ProcessedDataPanel.this.m_txtStartLine.getValue();
                    if (tabStartLine <= 0) {
                        MessageUtil.displayMessage((String)bundle.getString("ProcessedDataPanel.Error.InvalidStartRowValue.txt"), (int)0);
                        ProcessedDataPanel.this.m_txtStartLine.requestFocus();
                        return;
                    }
                    int tabNumberOfRecords = ProcessedDataPanel.this.m_txtNumberOfLines.getValue();
                    if (tabNumberOfRecords <= 0) {
                        MessageUtil.displayMessage((String)bundle.getString("ProcessedDataPanel.Error.InvalidNumRowValue.txt"), (int)0);
                        ProcessedDataPanel.this.m_txtNumberOfLines.requestFocus();
                        return;
                    }
                    try {
                        ProcessedDataPanel.this.m_modelStartLine = ProcessedDataPanel.this.m_mdlTable.getStartRecord();
                        ProcessedDataPanel.this.m_modelNumberOfRecords = ProcessedDataPanel.this.m_mdlTable.getNumberObservations();
                        ProcessedDataPanel.this.m_bCreateView = ProcessedDataPanel.this.m_mdlTable.isCreateView();
                        ProcessedDataPanel.this.m_cdf.setStorePopulated(false);
                        ProcessedDataPanel.this.m_cdf.populateStore();
                        if (ProcessedDataPanel.this.m_cdf.getColumnCount() == 0) {
                            MessageUtil.displayMessage((String)bundle.getString("ProcessedDataPanel.Error.NoColumns.txt"), (int)0);
                            return;
                        }
                        if (!ProcessedDataPanel.this.m_cdf.validateData()) {
                            return;
                        }
                        ProcessedDataPanel.this.m_mdlTable.setStartRecord(tabStartLine);
                        ProcessedDataPanel.this.m_mdlTable.setNumberObservations(tabNumberOfRecords);
                        ProcessedDataPanel.this.m_mdlTable.setCreateView(false);
                        ProcessedDataPanel.this.m_cdf.moveDataToStore();
                        ProcessedDataPanel.this.m_sourceTab.clear();
                        ProcessedDataPanel.this.m_sourceTab.setText(ProcessedDataPanel.this.m_mdlTable.getDataStep("").toString());
                        if (ProcessedDataPanel.this.getFactory() != null && ProcessedDataPanel.this.getFactory().hasDefaultModel()) {
                            ProcessedDataPanel.this.getFactory().getDefaultModel().fetchData();
                            break block12;
                        }
                        ProcessedDataPanel.this.superMoveDataToView();
                    }
                    catch (MdException me) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)me);
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                        try {
                            ProcessedDataPanel.this.m_mdlTable.setStartRecord(ProcessedDataPanel.this.m_modelStartLine);
                            ProcessedDataPanel.this.m_mdlTable.setNumberObservations(ProcessedDataPanel.this.m_modelNumberOfRecords);
                            ProcessedDataPanel.this.m_mdlTable.setCreateView(ProcessedDataPanel.this.m_bCreateView);
                        }
                        catch (MdException me2) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)me2, (String)"Writing");
                        }
                    }
                    catch (ViewDataException ex) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                        MessageUtil.displayMessage((String)bundle.formatString("ProcessedDataPanel.Error.FetchData.txt", (Object)ex.getMessage()), (int)0);
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }
    }

    protected class HeaderPanel
    extends WAPanel {
        HeaderPanel() {
            this.layoutWidgets();
        }

        protected void layoutWidgets() {
            JLabel lblStartLine = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)ProcessedDataPanel.this.m_txtStartLine, (WAdminResource)bundle, (String)"ProcessedDataPanel.Label.StartLine");
            JLabel lblNumberOfLines = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)ProcessedDataPanel.this.m_txtNumberOfLines, (WAdminResource)bundle, (String)"ProcessedDataPanel.Label.NumberOfLines");
            this.setLayout(new GridBagLayout());
            this.add(lblStartLine, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)ProcessedDataPanel.this.m_txtStartLine, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add(lblNumberOfLines, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.add((Component)ProcessedDataPanel.this.m_txtNumberOfLines, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add(new JButton((Action)ProcessedDataPanel.this.m_actRefresh), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        }

        public void setEnabled(boolean enabled) {
            ProcessedDataPanel.this.m_txtStartLine.setEnabled(enabled);
            ProcessedDataPanel.this.m_txtNumberOfLines.setEnabled(enabled);
            ProcessedDataPanel.this.m_actRefresh.setEnabled(enabled);
        }
    }
}

