/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.editor.LogListViewer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.efi2.COB2SASRunResultFileStructure;
import com.sas.wadmin.efi2.COB2SASRunReviewPanel;
import com.sas.wadmin.efi2.COBOL2SAS;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.ExternalFormatFileUtil;
import com.sas.workspace.visuals.SASLogDialog;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportCobolCopyBookPanel
extends WsDescriptionWizardTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ImportCobolCopyBookPanel.class);
    private static final String IMPORT_DIRECTORY_KEY = "ImportCobolCopyBookPanel.ImportDirectory";
    private static final String COPYBOOK_LIST_KEY = "ImportCobolCopyBookPanel.COBOLCopybooks";
    private static final String COPYBOOK_DIRECTORY_KEY = "ImportCobolCopyBookPanel.CopybookDirectory";
    private static final String OPERATING_SYSTEM_KEY = "ImportCobolCopyBookPanel.OperatingSystemKey";
    private static final String SAS_OPTIONS_KEY = "ImportCobolCopyBookPanel.SASOptions";
    private static final String COB2SASPATH_KEY = "ImportCobolCopyBookPanel.COB2SASPath";
    private static final int IMPORT_DIRECTORY_MAX = 8;
    private static final int COPYBOOK_LIST_MAX = 100;
    private static final int SAS_OPTIONS_MAX = 8;
    private static final int COB2SASPATH_MAX = 8;
    private static final String R2WIN = "r2win";
    private static final String R2MVS = "r2mvs";
    private static final String R2UNX = "r2unx";
    private static final String SASOptionsDebug = "options mlogic mprint symbolgen notes source source2 linesize=75 compress=no ";
    private static final String SASOptionsStandard = "options notes nosource nosource2 linesize=75 compress=no ";
    private static final String StandardCOB2SASLocation = "!sasroot\\core\\sample\\r2cob1.sas";
    private WsAppServerPanel m_pnlAppServer;
    private JLabel m_lblOS;
    private JRadioButton m_rbnWindows;
    private JRadioButton m_rbnMVS;
    private JRadioButton m_rbnUnix;
    private WsAbstractAction m_actCobolCopybookFileBrowse;
    private WsAbstractAction m_actImportDirectory;
    private WsAbstractAction m_actAdvancedOptions;
    private WsAbstractAction m_actEditCopybook;
    private WsAbstractAction m_actAddCopybook;
    private WsAbstractAction m_actRemoveCopybook;
    private JLabel m_lblCopyBookList;
    private JList m_lstCopyBookFiles;
    private JScrollPane m_spCopyBooks;
    private DefaultListModel m_lmCopyBooks;
    private JButton m_btnCopyBooksSelect;
    private JButton m_btnAddCopybook;
    private JButton m_btnEditCopybook;
    private JButton m_btnRemoveCopybook;
    private JLabel m_lblImportDirectory;
    private WAComboBox m_cmbImportDirectory;
    private JButton m_btnImportDirectory;
    private WAComboBox m_cmbSASOptions;
    private WAComboBox m_cmbCOB2SASPath;
    private JButton m_btnAdvancedOptions;
    private List m_lFileNames;
    private String m_SASOptions;
    private String m_COB2SASPath;
    private WsAppServer m_wsAppServer;
    private MdObjectStore m_store;

    public ImportCobolCopyBookPanel() {
        this.initialize();
    }

    public ImportCobolCopyBookPanel(String sDescription) {
        super(sDescription);
        this.initialize();
    }

    public void initialize() {
        try {
            int VS = 10;
            this.setHelpProduct("wdb");
            this.setHelpTopic("cobol_copybook_import");
            this.m_store = Workspace.getMdFactory().createObjectStore(null, "WsAppServerPanel");
            this.m_pnlAppServer = new WsAppServerPanel();
            this.m_pnlAppServer.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("ImportCobolCopyBookPanel.TitledBorder.ApplicationServer.txt")));
            this.m_pnlAppServer.setUpdateDefault(false);
            this.m_lblOS = new JLabel(bundle.getString("ImportCobolCopyBookPanel.Label.OS.txt"));
            this.m_rbnWindows = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportCobolCopyBookPanel.RadioButton.Windows", (int)1);
            this.m_rbnMVS = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportCobolCopyBookPanel.RadioButton.MVS", (int)1);
            this.m_rbnUnix = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportCobolCopyBookPanel.RadioButton.UNIX", (int)1);
            this.m_rbnWindows.setSelected(true);
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.m_rbnWindows);
            grp.add(this.m_rbnMVS);
            grp.add(this.m_rbnUnix);
            this.m_actCobolCopybookFileBrowse = new cCobolCopybookFileBrowseAction();
            this.m_actImportDirectory = new cImportDirectoryBrowseAction();
            this.m_actAdvancedOptions = new cAdvancedOptionsAction();
            this.m_actAddCopybook = new cAddCopybook();
            this.m_actEditCopybook = new cEditCopybook();
            this.m_actRemoveCopybook = new cRemoveCopybook();
            this.m_btnCopyBooksSelect = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actCobolCopybookFileBrowse);
            this.m_btnAddCopybook = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAddCopybook);
            this.m_btnEditCopybook = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actEditCopybook);
            this.m_btnRemoveCopybook = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actRemoveCopybook);
            this.m_lmCopyBooks = new DefaultListModel();
            this.m_lstCopyBookFiles = new JList(this.m_lmCopyBooks);
            cCopybookListSelectionAdapter lsnrSelection = new cCopybookListSelectionAdapter();
            this.m_lstCopyBookFiles.addListSelectionListener(lsnrSelection);
            this.m_spCopyBooks = new JScrollPane(this.m_lstCopyBookFiles);
            this.m_spCopyBooks.setPreferredSize(new Dimension(400, 200));
            this.m_lblCopyBookList = WsUIUtilities.createLabelForComponent((JComponent)this.m_lstCopyBookFiles, (String)bundle.getString("ImportCobolCopyBookPanel.Label.ReadCopyBooks.txt"));
            this.m_lblCopyBookList.setToolTipText(bundle.getString("ImportCobolCopyBookPanel.Label.ReadCopyBooks.ToolTip.txt"));
            this.m_lstCopyBookFiles.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
            this.m_lstCopyBookFiles.getActionMap().put("delete", (Action)this.m_actRemoveCopybook);
            this.m_cmbImportDirectory = new WAComboBox();
            this.m_cmbImportDirectory.setEditable(true);
            this.m_lblImportDirectory = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbImportDirectory, (WAdminResource)bundle, (String)"ImportCobolCopyBookPanel.Label.ImportDirectory");
            this.m_btnImportDirectory = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actImportDirectory);
            this.m_btnAdvancedOptions = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAdvancedOptions);
            this.m_cmbSASOptions = new WAComboBox();
            this.m_cmbCOB2SASPath = new WAComboBox();
            this.setLayout(new GridBagLayout());
            int mainColumnWidth = 5;
            int x = 0;
            int y = 0;
            int w = 2 + mainColumnWidth;
            int h = 1;
            double wx = 1.0;
            double wy = 0.0;
            int anchor = 17;
            int fill = 2;
            JSeparator sep = new JSeparator(0);
            WATextArea m_txtDescription = new WATextArea();
            m_txtDescription.setColumns(30);
            m_txtDescription.setBehavior(1);
            m_txtDescription.setText(bundle.getString("ImportCobolCopyBookPanel.Description.txt"));
            m_txtDescription.setAutosize(true);
            this.add((Component)m_txtDescription, new GridBagConstraints(x, y, w, h, wx, wy, anchor, fill, new Insets(0, 0, 0, 0), 0, 0));
            this.add(sep, new GridBagConstraints(x, y += h, w, h, wx, wy, anchor, fill, new Insets(10, 0, 10, 0), 0, 1));
            this.add((Component)this.m_pnlAppServer, new GridBagConstraints(x, y += h, w, h, wx, wy, anchor, fill, new Insets(5, 0, 0, 0), 0, 0));
            w = 1;
            this.add(this.m_lblOS, new GridBagConstraints(x, y += h, w, h, wx, wy, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            this.add(this.m_rbnWindows, new GridBagConstraints(++x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            this.add(this.m_rbnMVS, new GridBagConstraints(++x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            this.add(this.m_rbnUnix, new GridBagConstraints(++x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            x = 0;
            wx = 0.0;
            this.add(this.m_lblCopyBookList, new GridBagConstraints(x, y += h, w, h, wx, wy, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            anchor = 18;
            fill = 1;
            x += w;
            w = mainColumnWidth;
            h = 4;
            wx = 1.0;
            wy = 1.0;
            this.add(this.m_spCopyBooks, new GridBagConstraints(x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            x += w;
            w = 1;
            h = 1;
            wx = 0.0;
            wy = 0.0;
            anchor = 18;
            fill = 2;
            this.add(this.m_btnCopyBooksSelect, new GridBagConstraints(x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            this.add(this.m_btnAddCopybook, new GridBagConstraints(x, ++y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            this.add(this.m_btnEditCopybook, new GridBagConstraints(x, ++y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            this.add(this.m_btnRemoveCopybook, new GridBagConstraints(x, ++y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            x = 0;
            anchor = 17;
            this.add(this.m_lblImportDirectory, new GridBagConstraints(x, ++y, w, h, wx, wy, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            x += w;
            w = mainColumnWidth;
            wx = 1.0;
            this.add((Component)this.m_cmbImportDirectory, new GridBagConstraints(x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            x += w;
            w = 1;
            wx = 0.0;
            this.add(this.m_btnImportDirectory, new GridBagConstraints(x, y, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            this.add(this.m_btnAdvancedOptions, new GridBagConstraints(x, y += h, w, h, wx, wy, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_pnlAppServer.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_cmbImportDirectory.loadItems(IMPORT_DIRECTORY_KEY, 8);
        this.m_cmbSASOptions.loadItems(SAS_OPTIONS_KEY, 8);
        this.m_cmbCOB2SASPath.loadItems(COB2SASPATH_KEY, 8);
        this.loadCopybooksList();
        this.loadDefaultOptionsAndDefaultPath();
        this.updateActions();
        this.setRadioButtonSelection();
        this.m_pnlAppServer.moveDataToView();
    }

    public void moveDataToStore() {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(OPERATING_SYSTEM_KEY, this.getOperatingSystemSelected());
        this.m_cmbImportDirectory.saveItems(IMPORT_DIRECTORY_KEY, 8);
        this.m_cmbSASOptions.saveItems(SAS_OPTIONS_KEY, 8);
        this.m_cmbCOB2SASPath.saveItems(COB2SASPATH_KEY, 8);
        this.saveCopybooksList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateData() {
        boolean bValidated;
        block13: {
            bValidated = true;
            if (this.m_lmCopyBooks.isEmpty()) {
                MessageUtil.displayMessage((String)bundle.getString("ImportCobolCopyBookPanel.Error.NoCopybookSelected.txt"), (int)0);
                this.m_btnCopyBooksSelect.requestFocus();
                return false;
            }
            String importDir = (String)this.m_cmbImportDirectory.getSelectedItem();
            if (importDir == null || importDir.length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ImportCobolCopyBookPanel.Error.NoImportDirectorySelected.txt"), (int)0);
                return false;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_pnlAppServer.getAppServer().doesFileExist(this.m_COB2SASPath);
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                String msgString = bundle.formatString("ImportCobolCopyBookPanel.Error.NoCOB2SAS.fmt.txt", (Object)this.m_COB2SASPath);
                int choice = MessageUtil.displayMessage((String)msgString, (int)2, (int)0);
                if (choice == 0) {
                    bValidated = true;
                    break block13;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.m_wsAppServer = this.m_pnlAppServer.getAppServer();
        this.m_wsAppServer.close();
        try {
            bValidated = this.runCOB2SAS();
        }
        catch (WsAppServerFailException wsfe) {
            MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (WsAppServerCodeException wsce) {
            this.showSASLogDialog(wsce.getLocalizedMessage());
            return false;
        }
        return bValidated;
    }

    public void saveSettingsAndCleanUp() {
        try {
            super.saveSettingsAndCleanUp();
            if (this.m_wsAppServer != null) {
                this.m_wsAppServer.dispose();
            }
            if (this.m_pnlAppServer != null) {
                this.m_pnlAppServer.saveSettingsAndCleanUp();
            }
            this.m_pnlAppServer = null;
            this.m_wsAppServer = null;
            this.m_store.dispose();
            Workspace.getMdFactory().dumpDetailHashMap();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public WAComboBox getCmbSASOptions() {
        return this.m_cmbSASOptions;
    }

    public String getCOB2SASPath() {
        return this.m_COB2SASPath;
    }

    public String getSASOptions() {
        return this.m_SASOptions;
    }

    public void setSASOptions(String options) {
        this.m_SASOptions = options;
    }

    public void setCOB2SASPath(String path) {
        this.m_COB2SASPath = path;
    }

    public void loadCopybooksList() {
        String sItem;
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        for (int iItem = 0; iItem < 100 && (sItem = appDefaults.getPropertyString(COPYBOOK_LIST_KEY + iItem, "")).length() != 0; ++iItem) {
            this.m_lmCopyBooks.addElement(sItem);
        }
    }

    public void saveCopybooksList() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        for (int list = 0; list < this.m_lmCopyBooks.size() && list < 100; ++list) {
            Object item = this.m_lmCopyBooks.get(list);
            appDefaults.setPropertyString(COPYBOOK_LIST_KEY + list, item.toString());
        }
        for (int iItem = this.m_lmCopyBooks.size(); iItem < 100; ++iItem) {
            appDefaults.removeProperty(COPYBOOK_LIST_KEY + iItem);
        }
    }

    private void loadDefaultOptionsAndDefaultPath() {
        if (this.m_cmbSASOptions.getIndexOf((Object)SASOptionsDebug) < 0) {
            this.m_cmbSASOptions.addItem((Object)SASOptionsDebug);
        }
        if (this.m_cmbSASOptions.getIndexOf((Object)SASOptionsStandard) < 0) {
            this.m_cmbSASOptions.addItem((Object)SASOptionsStandard);
        }
        if (this.m_cmbCOB2SASPath.getIndexOf((Object)StandardCOB2SASLocation) < 0) {
            this.m_cmbCOB2SASPath.addItem((Object)StandardCOB2SASLocation);
        }
        this.m_SASOptions = (String)this.m_cmbSASOptions.getSelectedItem();
        this.m_COB2SASPath = (String)this.m_cmbCOB2SASPath.getSelectedItem();
    }

    public static String getCob2sasDirectory(String cob2sasPath) {
        int location = cob2sasPath.toLowerCase().indexOf("r2cob1.sas");
        if (location < 0) {
            location = cob2sasPath.toLowerCase().indexOf("(");
        }
        if (location > 0) {
            return cob2sasPath.substring(0, location);
        }
        return cob2sasPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCOB2SAS() throws WsAppServerFailException, WsAppServerCodeException {
        boolean bValidated = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            COBOL2SAS cob2sas = new COBOL2SAS(this.m_wsAppServer);
            this.setupCOB2SASParameters(cob2sas);
            cob2sas.submitCOB2SASCode(this.m_lmCopyBooks);
            cob2sas.sortAndSummarize();
            this.m_lFileNames = cob2sas.getFilenamesFromSummaryDataset();
            bValidated = this.showCOB2SASRunResultFilePanel(cob2sas);
        }
        catch (SQLException se) {
            se.printStackTrace();
            MessageUtil.displayMessage((String)se.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        return bValidated;
    }

    public void setupCOB2SASParameters(COBOL2SAS cob2sas) {
        cob2sas.setEFFDirectory((String)this.m_cmbImportDirectory.getSelectedItem());
        cob2sas.setOperatingSystem(this.getOperatingSystemSelected());
        cob2sas.setSASOptions(this.m_SASOptions);
        cob2sas.setCOB2SASLocation(ImportCobolCopyBookPanel.getCob2sasDirectory(this.m_COB2SASPath));
    }

    private String getOperatingSystemSelected() {
        if (this.m_rbnWindows.isSelected()) {
            return R2WIN;
        }
        if (this.m_rbnMVS.isSelected()) {
            return R2MVS;
        }
        if (this.m_rbnUnix.isSelected()) {
            return R2UNX;
        }
        return "";
    }

    private void updateActions() {
        int[] selection = this.m_lstCopyBookFiles.getSelectedIndices();
        if (selection.length != 1) {
            this.m_btnEditCopybook.setEnabled(false);
        } else {
            this.m_btnEditCopybook.setEnabled(true);
        }
        if (selection.length < 1) {
            this.m_btnRemoveCopybook.setEnabled(false);
        } else {
            this.m_btnRemoveCopybook.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean showCOB2SASRunResultFilePanel(COBOL2SAS cob2sas) throws WsAppServerFailException, WsAppServerCodeException {
        boolean returnValue = true;
        COB2SASRunReviewPanel pnl = new COB2SASRunReviewPanel();
        pnl.setCOB2SASReviewValues(this.m_lFileNames);
        String sReviewDialogTitle = bundle.getString("ImportCobolCopyBookPanel.Dialog.COB2SASReview.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sReviewDialogTitle, true, (WAPanel)pnl);
        dlg.setMainPanel((WAPanel)pnl);
        dlg.setResizable(true);
        dlg.setHelpProduct("wdb");
        dlg.setHelpTopic("cobol_copybook_import_review");
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                cob2sas.writeOutCSVFiles(this.m_lFileNames);
                try {
                    this.writeFileMetadataObjects();
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Writing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                String sasLogFile = pnl.getSASLogFile();
                if (sasLogFile == null || sasLogFile.length() == 0) return returnValue;
                if (sasLogFile.toLowerCase().lastIndexOf(".log") == -1) {
                    StringBuffer sbFilename = new StringBuffer(sasLogFile);
                    sasLogFile = sbFilename.append(".log").toString();
                }
                returnValue = this.writeSASLogFile(sasLogFile);
                return returnValue;
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (dlg.getReturnValue() != 2) return returnValue;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileMetadataObjects() throws MdException, RemoteException {
        MdObjectStore storeLocal = Workspace.getMdFactory().createObjectStore(null, "COBOL2SAS");
        try {
            String reposID = Workspace.getWorkspace().getDefaultRepositoryId();
            ArrayList<File> fileMetadataObjects = new ArrayList<File>(this.m_lFileNames.size());
            ExternalFormatFileUtil effUtil = new ExternalFormatFileUtil(storeLocal, reposID);
            String cobolCopyBookFile = "";
            File fFile = null;
            File file = null;
            for (int fileNum = 0; fileNum < this.m_lFileNames.size(); ++fileNum) {
                String copyBookName = ((COB2SASRunResultFileStructure)this.m_lFileNames.get(fileNum)).getSourceFile();
                fFile = cobolCopyBookFile.equals(copyBookName) ? file : null;
                cobolCopyBookFile = copyBookName;
                String cobolFormatFile = ((COB2SASRunResultFileStructure)this.m_lFileNames.get(fileNum)).getCSVFilePath();
                file = effUtil.buildCobolFormatFileMd(fFile, cobolFormatFile, cobolCopyBookFile, (DeployedComponent)this.m_wsAppServer.getServerContext());
                fileMetadataObjects.add(file);
            }
            storeLocal.updatedMetadataAll();
        }
        finally {
            storeLocal.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeSASLogFile(String SASLogFilename) {
        boolean bValidated = true;
        LogListViewer logView = null;
        try {
            logView = new LogListViewer((Frame)Workspace.getWorkspace(), 1, this.m_wsAppServer.getLog(), Workspace.getWorkspace().getCodeEditorDefaults());
            boolean fileExists = new java.io.File(SASLogFilename).exists();
            if (fileExists) {
                String msgOverwriteFile = bundle.formatString("ImportCobolCopyBookPanel.FileOverwrite.txt", (Object)SASLogFilename);
                int choice = MessageUtil.displayMessage((String)msgOverwriteFile, (int)2, (int)0);
                if (choice == 0) {
                    logView.saveFile(SASLogFilename);
                } else {
                    String logFilename = this.promptForSASLogFile(bundle.getString("WsSASLogFile.BrowseSASLogFile.Title.txt"), SASLogFilename);
                    if (logFilename != null) {
                        this.writeSASLogFile(logFilename);
                    }
                }
            } else {
                logView.saveFile(SASLogFilename);
            }
        }
        catch (IOException ioe) {
            MessageUtil.displayMessage((String)ioe.getLocalizedMessage(), (String)bundle.getString("ImportCobolCopyBookPanel.ErrorWritingLog.title.txt"), (int)0);
            boolean bl = false;
            return bl;
        }
        catch (WsAppServerFailException wsfe) {
            MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (logView != null) {
                logView.cleanup();
            }
            logView = null;
        }
        return bValidated;
    }

    public void setRadioButtonSelection() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String osName = appDefaults.getPropertyString(OPERATING_SYSTEM_KEY, "");
        if (osName.length() == 0 || osName.compareTo(R2WIN) == 0) {
            this.m_rbnWindows.setSelected(true);
        } else if (osName.compareTo(R2MVS) == 0) {
            this.m_rbnMVS.setSelected(true);
        } else if (osName.compareTo(R2UNX) == 0) {
            this.m_rbnUnix.setSelected(true);
        }
    }

    protected void showSASLogDialog(String message) {
        int choice = MessageUtil.displayMessage((String)message, (int)0, (int)0);
        if (choice == 0) {
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("ImportCobolCopyBookPanel.SASLog.Title.txt"), true, this.m_wsAppServer);
            dlg.show();
        }
    }

    protected String promptForSASLogFile(String title, String currPath) {
        java.io.File file = null;
        String strFile = currPath;
        JFileChooser chooser = new JFileChooser(strFile);
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(0);
        int retValue = chooser.showOpenDialog(chooser);
        if (retValue == 0) {
            file = chooser.getSelectedFile();
        }
        if (file == null) {
            return null;
        }
        strFile = file.toString();
        return strFile;
    }

    private class cCobolCopybookFileBrowseAction
    extends WsAbstractAction {
        public cCobolCopybookFileBrowseAction() {
            super(bundle, "ImportCobolCopyBookPanel.Action.CobolCopybookFileBrowse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String selectedFile;
                ImportCobolCopyBookPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().getOperatingSystem().equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)bundle.getString("ImportCobolCopyBookPanel.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("ImportCobolCopyBookPanel.AllFileTypes.txt"), "*");
                WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
                String sName = appDefaults.getPropertyString(ImportCobolCopyBookPanel.COPYBOOK_DIRECTORY_KEY, "");
                if (sName == null) {
                    sName = "";
                }
                List lFiles = ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().promptForFilenames(bundle.getString("ImportCobolCopyBookPanel.RemoteFileSelector.Title.txt"), "", mapFileTypes);
                for (int i = 0; lFiles != null && i < lFiles.size(); ++i) {
                    if (lFiles.get(i) == null || ((String)lFiles.get(i)).length() <= 0) continue;
                    if (!ImportCobolCopyBookPanel.this.m_lmCopyBooks.contains(lFiles.get(i))) {
                        ImportCobolCopyBookPanel.this.m_lmCopyBooks.addElement(lFiles.get(i));
                    }
                    if (ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.getSelectedIndex() >= 0) continue;
                    ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.setSelectedIndex(0);
                }
                if (lFiles != null && lFiles.size() > 0 && (selectedFile = (String)lFiles.get(lFiles.size() - 1)) != null) {
                    appDefaults.setPropertyString(ImportCobolCopyBookPanel.COPYBOOK_DIRECTORY_KEY, selectedFile);
                }
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            finally {
                ImportCobolCopyBookPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class cImportDirectoryBrowseAction
    extends WsAbstractAction {
        public cImportDirectoryBrowseAction() {
            super(bundle, "ImportCobolCopyBookPanel.Action.ImportDirectoryBrowse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String directory;
                ImportCobolCopyBookPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().getOperatingSystem().equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)bundle.getString("ImportCobolCopyBookPanel.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("ImportCobolCopyBookPanel.AllFileTypes.txt"), "*");
                String sName = (String)ImportCobolCopyBookPanel.this.m_cmbImportDirectory.getSelectedItem();
                if (sName == null) {
                    sName = "";
                }
                if ((directory = ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().promptForDirectory(bundle.getString("ImportCobolCopyBookPanel.RemoteDirectorySelector.Title.txt"), sName, mapFileTypes)) != null && directory.length() > 0) {
                    if (((DefaultComboBoxModel)ImportCobolCopyBookPanel.this.m_cmbImportDirectory.getModel()).getIndexOf(directory) < 0) {
                        ImportCobolCopyBookPanel.this.m_cmbImportDirectory.addItem((Object)directory);
                    }
                    ImportCobolCopyBookPanel.this.m_cmbImportDirectory.setSelectedItem((Object)directory);
                }
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            finally {
                ImportCobolCopyBookPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class cAdvancedOptionsAction
    extends WsAbstractAction {
        public cAdvancedOptionsAction() {
            super(bundle, "ImportCobolCopyBookPanel.Action.AdvancedOptions", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            AdvancedOptionsPanel panel = new AdvancedOptionsPanel();
            String sAdvancedOptionsDialogTitle = bundle.getString("ImportCobolCopyBookPanel.Dialog.AdvancedOptions.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sAdvancedOptionsDialogTitle, true, (WAPanel)panel);
            dlg.setResizable(true);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                // empty if block
            }
        }
    }

    private class cAddCopybook
    extends WsAbstractAction {
        public cAddCopybook() {
            super(bundle, "ImportCobolCopyBookPanel.Action.AddCopybook", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            CopybookFileTab pnl = new CopybookFileTab("ImportCobolCopyBookPanel.Label.AddCopybook");
            String sAddCopybookTitle = bundle.getString("ImportCobolCopyBookPanel.AddCopybook.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sAddCopybookTitle, true, (WAPanel)pnl);
            dlg.setMainPanel((WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpButtonVisible(false);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                ImportCobolCopyBookPanel.this.m_lmCopyBooks.addElement(pnl.getFilename());
                if (ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.getSelectedIndex() < 0) {
                    ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.setSelectedIndex(0);
                }
            }
        }
    }

    private class cEditCopybook
    extends WsAbstractAction {
        public cEditCopybook() {
            super(bundle, "ImportCobolCopyBookPanel.Action.EditCopybook", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            int index = ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.getSelectedIndex();
            CopybookFileTab pnl = new CopybookFileTab("ImportCobolCopyBookPanel.Label.EditCopybook");
            pnl.setFilename((String)ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.getSelectedValue());
            String sEditCopybookTitle = bundle.getString("ImportCobolCopyBookPanel.EditCopybook.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sEditCopybookTitle, true, (WAPanel)pnl);
            dlg.setMainPanel((WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpButtonVisible(false);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                ImportCobolCopyBookPanel.this.m_lmCopyBooks.setElementAt(pnl.getFilename(), index);
            }
        }
    }

    private class cRemoveCopybook
    extends WsAbstractAction {
        public cRemoveCopybook() {
            super(bundle, "ImportCobolCopyBookPanel.Action.RemoveCopybook", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices = ImportCobolCopyBookPanel.this.m_lstCopyBookFiles.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                ImportCobolCopyBookPanel.this.m_lmCopyBooks.removeElementAt(indices[i] - i);
            }
        }
    }

    private class cCopybookListSelectionAdapter
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            ImportCobolCopyBookPanel.this.updateActions();
        }
    }

    public class CopybookFileTab
    extends WAPropertyTab {
        private JLabel m_lblFilename;
        private WATextField m_tfFilename;
        private String m_sLabelProperty;

        public CopybookFileTab(String sLblProperty) {
            this.m_sLabelProperty = sLblProperty;
            this.initialize();
        }

        protected void initialize() {
            this.m_tfFilename = new WATextField();
            this.m_lblFilename = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_tfFilename, (WAdminResource)bundle, (String)this.m_sLabelProperty);
            this.m_lblFilename.setLabelFor((Component)this.m_tfFilename);
            this.setLayout(new GridBagLayout());
            this.add(this.m_lblFilename, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.m_tfFilename, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 250, 0));
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void moveDataToView() {
            this.setListeningForChanges(false);
            this.setListeningForChanges(true);
        }

        public void moveDataToStore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateData() {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().doesFileExist(this.m_tfFilename.getText());
            }
            catch (WsAppServerFailException wsfe) {
                MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                String msgString = bundle.formatString("ImportCobolCopyBookPanel.Error.FileNotFound.fmt.txt", (Object)this.m_tfFilename.getText());
                int choice = MessageUtil.displayMessage((String)msgString, (int)2, (int)0);
                if (choice == 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            return true;
        }

        public String getFilename() {
            return this.m_tfFilename.getText();
        }

        public void setFilename(String tfFilename) {
            this.m_tfFilename.setText(tfFilename);
        }
    }

    private class AdvancedOptionsPanel
    extends WAPanel {
        private JLabel m_lblSASOptions;
        private JLabel m_lblCOB2SASPath;
        private JButton m_btnCOB2SASPath;
        private WsAbstractAction m_actCOB2SASPath;

        public AdvancedOptionsPanel() {
            this.setHelpProduct("wdb");
            this.setHelpTopic("cobol_copybook_import_adv");
            this.initialize();
        }

        protected void initialize() {
            int VS = 10;
            this.m_actCOB2SASPath = new cCOB2SASPathAction();
            ImportCobolCopyBookPanel.this.m_cmbSASOptions.setEditable(true);
            this.m_lblSASOptions = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)ImportCobolCopyBookPanel.this.m_cmbSASOptions, (WAdminResource)bundle, (String)"ImportCobolCopyBookPanel.Label.SASOptions");
            ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath.setEditable(true);
            this.m_lblCOB2SASPath = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath, (WAdminResource)bundle, (String)"ImportCobolCopyBookPanel.Label.COB2SASPath");
            this.m_btnCOB2SASPath = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actCOB2SASPath);
            this.setLayout(new GridBagLayout());
            int anchor = 17;
            int fill = 2;
            this.add(this.m_lblSASOptions, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, anchor, fill, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)ImportCobolCopyBookPanel.this.m_cmbSASOptions, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, anchor, fill, new Insets(0, 5, 0, 0), 0, 0));
            this.add(this.m_lblCOB2SASPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, anchor, fill, new Insets(VS, 0, 0, 0), 0, 0));
            this.add((Component)ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
            this.add(this.m_btnCOB2SASPath, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, anchor, fill, new Insets(VS, 5, 0, 0), 0, 0));
        }

        public void populateStore() {
        }

        public void moveDataToView() {
        }

        public void moveDataToStore() {
            ImportCobolCopyBookPanel.this.setSASOptions((String)ImportCobolCopyBookPanel.this.m_cmbSASOptions.getSelectedItem());
            ImportCobolCopyBookPanel.this.setCOB2SASPath((String)ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath.getSelectedItem());
        }

        public boolean validateData() {
            return true;
        }

        public void onParentCancel() {
            ImportCobolCopyBookPanel.this.m_cmbSASOptions.setSelectedItem((Object)ImportCobolCopyBookPanel.this.getSASOptions());
            ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath.setSelectedItem((Object)ImportCobolCopyBookPanel.this.getCOB2SASPath());
        }

        private class cCOB2SASPathAction
        extends WsAbstractAction {
            public cCOB2SASPathAction() {
                super(bundle, "ImportCobolCopyBookPanel.Action.COB2SASFileBrowse", false, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    String strFile;
                    String sName;
                    LinkedHashMap<String, String> mapFileTypes;
                    block11: {
                        AdvancedOptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        mapFileTypes = new LinkedHashMap<String, String>();
                        mapFileTypes.put(bundle.getString("ImportCobolCopyBookPanel.COB2SASFileType.txt"), "*");
                        sName = (String)ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath.getSelectedItem();
                        if (sName == null) {
                            sName = "";
                        }
                        strFile = null;
                        if (!ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().getOperatingSystem().equalsIgnoreCase("OS")) break block11;
                        MessageUtil.displayMessage((String)bundle.getString("ImportCobolCopyBookPanel.Error.UnableToBrowse.txt"), (int)0);
                        return;
                    }
                    try {
                        strFile = ImportCobolCopyBookPanel.this.m_pnlAppServer.getAppServer().promptForFilename(bundle.getString("ImportCobolCopyBookPanel.r2cob1FileSelector.Title.txt"), sName, mapFileTypes);
                    }
                    catch (WsAppServerFailException wsfe) {
                        MessageUtil.displayMessage((String)wsfe.getLocalizedMessage(), (int)0);
                    }
                    if (strFile != null && strFile.length() != 0) {
                        ImportCobolCopyBookPanel.this.m_cmbCOB2SASPath.setSelectedItem((Object)strFile);
                    }
                }
                catch (GenericError ge) {
                    MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
                }
                finally {
                    AdvancedOptionsPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

