/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.iom.SAS.IFormatService;
import com.sas.iom.SAS.IFormatServicePackage.IFType;
import com.sas.iom.SAS.IFormatServicePackage.InvalidID;
import com.sas.iom.SAS.IFormatServicePackage.WrongType;
import com.sas.iom.SASIOMDefs.BooleanSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHolder;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.GuessingColumnModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsColumnMetadataUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GuessingColumnFormats {
    private static WAdminResource bundle = WAdminResource.getBundle(GuessingColumnFormats.class);
    private ExternalTableDataModel m_mdlTable;
    private IFormatService m_formatService;
    private LongSeqHolder m_informatIds;
    private GuessingColumnModel m_columnModel;
    private FormatInfo[] m_formats = new FormatInfo[]{new FormatInfo("best", 78), new FormatInfo("comma", 78), new FormatInfo("datetime", 68), new FormatInfo("date", 68), new FormatInfo("mmddyy", 68), new FormatInfo("ddmmyy", 68), new FormatInfo("yymmdd", 68), new FormatInfo("time", 68)};

    public GuessingColumnFormats(ExternalTableDataModel model, GuessingColumnModel columnModel) {
        this.m_mdlTable = model;
        this.m_columnModel = columnModel;
        this.m_informatIds = new LongSeqHolder();
    }

    public GuessingColumnModel getColumnFormats(List values) throws GenericError, WsAppServerFailException {
        int columnIndex;
        int[] columnWidths = new int[this.m_columnModel.getColumnCount()];
        for (int columnIndex2 = 0; columnIndex2 < this.m_columnModel.getColumnCount(); ++columnIndex2) {
            columnWidths[columnIndex2] = this.m_columnModel.getColumn(columnIndex2).getWidth();
        }
        int[] decimalWidths = new int[this.m_columnModel.getColumnCount()];
        for (int columnIndex3 = 0; columnIndex3 < this.m_columnModel.getColumnCount(); ++columnIndex3) {
            decimalWidths[columnIndex3] = this.m_columnModel.getColumn(columnIndex3).getDecimalWidth();
        }
        String[][] data = this.recordsToArray(values, this.m_columnModel.getColumnCount());
        WsAppServer appServer = this.m_mdlTable.getAppServer();
        if (appServer == null) {
            return this.m_columnModel;
        }
        this.m_formatService = appServer.getFormatService();
        for (columnIndex = 0; columnIndex < this.m_columnModel.getColumnCount(); ++columnIndex) {
            if (columnWidths[columnIndex] != 0) continue;
            this.m_columnModel.getColumn(columnIndex).setInformat("");
            this.m_columnModel.getColumn(columnIndex).setFormat("");
            this.m_columnModel.getColumn(columnIndex).setType(WsColumnMetadataUtil.getViewCharacterType());
            this.m_columnModel.getColumn(columnIndex).setSASType(WsColumnMetadataUtil.getDataCharacterType());
            this.m_columnModel.getColumn(columnIndex).setLength(1);
        }
        this.loadInformats();
        for (int formatIndex = 0; formatIndex < this.m_formats.length; ++formatIndex) {
            GuessingColumnModel.GuessingColumn[] matchingColumns = this.matchInformat(data, this.m_formats[formatIndex].getName(), this.m_formats[formatIndex].getId(), columnWidths, decimalWidths);
            for (int columnIndex4 = 0; columnIndex4 < matchingColumns.length; ++columnIndex4) {
                if (matchingColumns[columnIndex4].getLength() > 0) continue;
                if (this.m_formats[formatIndex].isNumeric() && matchingColumns[columnIndex4].getWidth() <= 32) {
                    this.assignNumericFormat(matchingColumns[columnIndex4], this.m_formats[formatIndex].getName());
                    continue;
                }
                if (this.m_formats[formatIndex].isNumeric()) {
                    this.assignCharacterFormat(matchingColumns[columnIndex4], "$");
                    continue;
                }
                if (!this.m_formats[formatIndex].isDateTime()) continue;
                this.assignDateFormat(matchingColumns[columnIndex4], this.m_formats[formatIndex].getName());
            }
        }
        for (columnIndex = 0; columnIndex < this.m_columnModel.getColumnCount(); ++columnIndex) {
            if (this.m_columnModel.getColumn(columnIndex).getLength() != 0) continue;
            this.assignCharacterFormat(this.m_columnModel.getColumn(columnIndex), "$");
        }
        this.unloadInformats();
        return this.m_columnModel;
    }

    public String[][] recordsToArray(List values, int columnCount) {
        ArrayList<String> missingValues = new ArrayList<String>();
        String specialMissingCharacters = this.m_mdlTable.getMissingValuesSpecial();
        for (int charIndex = 0; charIndex < specialMissingCharacters.length(); ++charIndex) {
            missingValues.add(specialMissingCharacters.substring(charIndex, charIndex + 1));
        }
        String[][] array = new String[values.size()][columnCount];
        for (int rowIndex = 0; rowIndex < values.size(); ++rowIndex) {
            int columnIndex;
            ArrayList row = (ArrayList)values.get(rowIndex);
            if (row == null) {
                for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    array[rowIndex][columnIndex] = "";
                }
                continue;
            }
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                String value;
                array[rowIndex][columnIndex] = columnIndex >= row.size() ? "" : ((value = (String)row.get(columnIndex)) == null ? "" : (this.isMissing(value, missingValues) ? "." + value : value));
            }
        }
        return array;
    }

    public void loadInformats() throws GenericError {
        String[] informatNames = new String[this.m_formats.length];
        for (int formatIndex = 0; formatIndex < this.m_formats.length; ++formatIndex) {
            informatNames[formatIndex] = this.m_formats[formatIndex].getName();
        }
        Object[] informatTypes = new IFType[this.m_formats.length];
        Arrays.fill(informatTypes, IFType.IFTypeInformat);
        StringSeqHolder failureMessages = new StringSeqHolder();
        this.m_formatService.Load((IFType[])informatTypes, informatNames, this.m_informatIds, failureMessages);
        for (int messageIndex = 0; messageIndex < failureMessages.value.length; ++messageIndex) {
            System.err.println(failureMessages.value[messageIndex]);
        }
        for (int formatIndex = 0; formatIndex < this.m_informatIds.value.length; ++formatIndex) {
            this.m_formats[formatIndex].setId(this.m_informatIds.value[formatIndex]);
        }
    }

    public GuessingColumnModel.GuessingColumn[] matchInformat(String[][] data, String format, int formatId, int[] columnWidths, int[] decimalWidths) throws GenericError {
        Object[] formatNames = new String[this.m_columnModel.getColumnCount()];
        Object[] informatTypes = new IFType[this.m_columnModel.getColumnCount()];
        Arrays.fill(informatTypes, IFType.IFTypeInformat);
        int[] ids = new int[this.m_columnModel.getColumnCount()];
        VariableArray2dOfDoubleHolder informattedValues = new VariableArray2dOfDoubleHolder();
        VariableArray2dOfOctetHolder missingValues = new VariableArray2dOfOctetHolder();
        LongSeqHolder exceptionRows = new LongSeqHolder();
        LongSeqHolder exceptionColumns = new LongSeqHolder();
        BooleanSeqHolder exceptionError = new BooleanSeqHolder();
        StringSeqHolder exceptionMessages = new StringSeqHolder();
        Arrays.fill(formatNames, format);
        Arrays.fill(ids, formatId);
        LongSeqHolder formatIds = new LongSeqHolder(ids);
        try {
            this.m_formatService.InformatNumericValues(formatIds.value, columnWidths, decimalWidths, data, informattedValues, missingValues, exceptionRows, exceptionColumns, exceptionError, exceptionMessages);
        }
        catch (InvalidID e) {
            e.printStackTrace();
        }
        catch (WrongType e) {
            e.printStackTrace();
        }
        ArrayList<GuessingColumnModel.GuessingColumn> matchingColumns = new ArrayList<GuessingColumnModel.GuessingColumn>();
        for (int columnIndex = 0; columnIndex < this.m_columnModel.getColumnCount(); ++columnIndex) {
            if (Arrays.binarySearch(exceptionColumns.value, columnIndex) >= 0) continue;
            matchingColumns.add(this.m_columnModel.getColumn(columnIndex));
        }
        return matchingColumns.toArray(new GuessingColumnModel.GuessingColumn[0]);
    }

    public void unloadInformats() throws GenericError {
        try {
            if (this.m_informatIds != null && this.m_informatIds.value != null && this.m_informatIds.value.length > 0) {
                this.m_formatService.Unload(this.m_informatIds.value);
            }
        }
        catch (InvalidID e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
    }

    public boolean isMissing(String value, List list) {
        for (int index = 0; index < list.size(); ++index) {
            String missingValue = (String)list.get(index);
            if (!missingValue.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public void assignNumericFormat(GuessingColumnModel.GuessingColumn column, String format) {
        String defaultNumericInformat = this.m_mdlTable.getDefaultNumericInformat();
        String defaultNumericFormat = this.m_mdlTable.getDefaultNumericFormat();
        if (defaultNumericInformat != null && defaultNumericInformat.equalsIgnoreCase(bundle.getString("AutoColumnsPanel.Common.None.txt"))) {
            defaultNumericInformat = "";
        }
        if (defaultNumericFormat != null && defaultNumericFormat.equalsIgnoreCase(bundle.getString("AutoColumnsPanel.Common.None.txt"))) {
            defaultNumericFormat = "";
        }
        if (defaultNumericInformat != null && defaultNumericInformat.length() > 0) {
            defaultNumericInformat = defaultNumericInformat.replaceAll("[.]$", "");
        }
        if (defaultNumericFormat != null && defaultNumericFormat.length() > 0) {
            defaultNumericFormat = defaultNumericFormat.replaceAll("[.]$", "");
        }
        String suffix = ".";
        if (column.getDecimalWidth() != 0) {
            suffix = suffix + column.getDecimalWidth();
        }
        if (defaultNumericInformat != null && defaultNumericInformat.length() > 0) {
            if (defaultNumericInformat.equalsIgnoreCase("W.D")) {
                column.setInformat(column.getWidth() + suffix);
            } else {
                column.setInformat(defaultNumericInformat + column.getWidth() + suffix);
            }
        } else if (format.equalsIgnoreCase("BEST")) {
            column.setInformat(column.getWidth() + suffix);
        } else {
            column.setInformat(format + column.getWidth() + suffix);
        }
        if (defaultNumericFormat != null && defaultNumericFormat.length() > 0) {
            if (defaultNumericFormat.equalsIgnoreCase("W.D")) {
                column.setFormat(column.getWidth() + suffix);
            } else {
                column.setFormat(defaultNumericFormat + column.getWidth() + suffix);
            }
        } else if (format.equalsIgnoreCase("BEST")) {
            column.setFormat(column.getWidth() + suffix);
        } else {
            column.setFormat(format + column.getWidth() + suffix);
        }
        column.setType(WsColumnMetadataUtil.getViewNumericType());
        column.setSASType(WsColumnMetadataUtil.getDataNumericType());
        column.setLength(8);
    }

    public void assignDateFormat(GuessingColumnModel.GuessingColumn column, String format) {
        String suffix = ".";
        if (column.getDecimalWidth() != 0) {
            suffix = suffix + column.getDecimalWidth();
        }
        column.setInformat(format + column.getWidth() + suffix);
        column.setFormat(format + column.getWidth() + suffix);
        column.setType(WsColumnMetadataUtil.getViewNumericType());
        column.setSASType(WsColumnMetadataUtil.getDataNumericType());
        column.setLength(8);
    }

    public void assignCharacterFormat(GuessingColumnModel.GuessingColumn column, String format) {
        String defaultCharacterInformat = this.m_mdlTable.getDefaultCharacterInformat();
        String defaultCharacterFormat = this.m_mdlTable.getDefaultCharacterFormat();
        if (defaultCharacterInformat != null && defaultCharacterInformat.equalsIgnoreCase(bundle.getString("AutoColumnsPanel.Common.None.txt"))) {
            defaultCharacterInformat = "";
        }
        if (defaultCharacterFormat != null && defaultCharacterFormat.equalsIgnoreCase(bundle.getString("AutoColumnsPanel.Common.None.txt"))) {
            defaultCharacterFormat = "";
        }
        if (defaultCharacterInformat != null && defaultCharacterInformat.length() > 0) {
            defaultCharacterInformat = defaultCharacterInformat.replaceAll("[.]$", "");
        }
        if (defaultCharacterFormat != null && defaultCharacterFormat.length() > 0) {
            defaultCharacterFormat = defaultCharacterFormat.replaceAll("[.]$", "");
        }
        if (defaultCharacterInformat != null && defaultCharacterInformat.length() > 0) {
            column.setInformat(defaultCharacterInformat + column.getWidth() + ".");
        } else {
            column.setInformat(format + column.getWidth() + ".");
        }
        if (defaultCharacterFormat != null && defaultCharacterFormat.length() > 0) {
            column.setFormat(defaultCharacterFormat + column.getWidth() + ".");
        } else {
            column.setFormat(format + column.getWidth() + ".");
        }
        column.setType(WsColumnMetadataUtil.getViewCharacterType());
        column.setSASType(WsColumnMetadataUtil.getDataCharacterType());
        column.setLength(column.getWidth());
    }

    private static class FormatInfo {
        public static final int CHARACTER = 67;
        public static final int NUMERIC = 78;
        public static final int DATETIME = 68;
        private String m_name;
        private int m_id;
        private int m_type;

        public FormatInfo(String name, int type) {
            this.m_name = name;
            this.m_type = type;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public int getId() {
            return this.m_id;
        }

        public void setId(int id) {
            this.m_id = id;
        }

        public int getType() {
            return this.m_type;
        }

        public void setType(int type) {
            this.m_type = type;
        }

        public boolean isCharacter() {
            return this.m_type == 67;
        }

        public boolean isNumeric() {
            return this.m_type == 78;
        }

        public boolean isDateTime() {
            return this.m_type == 68;
        }
    }
}

