/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.efi2.AccessMethodPanel;
import com.sas.wadmin.efi2.ExternalFileLocationPanel2;
import com.sas.wadmin.efi2.ExternalFileQuotingPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ExternalFileTab2
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ExternalFileTab2.class);
    private ExternalFileLocationPanel2 m_pnlLocation;
    private WsAppServerPanel m_pnlAppServer;
    private AccessMethodPanel m_pnlAccessMethod;
    private ExternalFileQuotingPanel m_pnlAdvancedFile;
    private IExternalTable m_mdlTable;
    private IStructuredExternalFile m_mdlFile;

    public ExternalFileTab2(IExternalTable mdlTable) {
        this.setName(bundle.getString("ExternalFileTab2.Title.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("external_file_location_tab");
        this.initialize(mdlTable);
    }

    private void initialize(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.m_mdlFile = mdlTable.getFile();
        this.m_pnlLocation = new ExternalFileLocationPanel2(mdlTable);
        this.m_pnlAppServer = new WsAppServerPanel();
        this.m_pnlAppServer.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("ExternalFileTab.TitledBorder.ApplicationServer.txt")));
        this.m_pnlAppServer.setUpdateDefault(false);
        this.m_pnlAccessMethod = new AccessMethodPanel(mdlTable);
        this.m_pnlAccessMethod.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ExternalFileTab.TitledBorder.AccessMethod.txt")));
        try {
            this.m_pnlAccessMethod.setObjectStore(Workspace.getMdFactory().createObjectStore());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.m_pnlAdvancedFile = new ExternalFileQuotingPanel(mdlTable);
        this.m_pnlAdvancedFile.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ExternalFileTab.TitledBorder.FileQuotingMethod.txt")));
        this.listenForDataChangesTo(this.m_pnlLocation);
        this.listenForDataChangesTo((WAPanel)this.m_pnlAppServer);
        this.listenForDataChangesTo(this.m_pnlAccessMethod);
        this.listenForDataChangesTo(this.m_pnlAdvancedFile);
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlLocation), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlAppServer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlAccessMethod), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlAdvancedFile), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_pnlAppServer.populateStore();
        this.m_pnlAccessMethod.populateStore();
        this.m_pnlAdvancedFile.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        IServer mdoServer = this.m_mdlFile.getServer();
        if (mdoServer != null) {
            this.m_pnlAppServer.setSelectedServerFQID(mdoServer.getID());
        }
        this.m_pnlLocation.moveDataToView();
        this.m_pnlAppServer.moveDataToView();
        this.m_pnlAccessMethod.moveDataToView();
        this.m_pnlAdvancedFile.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_pnlLocation.moveDataToStore();
        this.m_pnlAccessMethod.moveDataToStore();
        this.m_pnlAdvancedFile.moveDataToStore();
        this.setDataChanged(false);
    }

    public boolean validateData() {
        if (!this.m_pnlAppServer.validateData()) {
            return false;
        }
        try {
            this.m_pnlAppServer.moveDataToStore();
            String serverId = this.m_pnlAppServer.getSelectedServerFQID();
            IModel model = this.m_mdlTable.getModel();
            IServer server = (IServer)model.getObject(serverId);
            if (server == null) {
                this.m_mdlFile.setServer(model.getObjectFactory().createServer(serverId));
            } else {
                this.m_mdlFile.setServer(server);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.m_pnlAdvancedFile.validateData() && this.m_pnlAccessMethod.validateData() && this.m_pnlLocation.validateData();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlLocation.setEditable(bEditable);
        this.m_pnlAppServer.setEditable(bEditable);
        this.m_pnlAccessMethod.setEditable(bEditable);
        this.m_pnlAdvancedFile.setEditable(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlLocation.saveSettingsAndCleanUp();
        this.m_pnlAppServer.saveSettingsAndCleanUp();
        this.m_pnlAccessMethod.saveSettingsAndCleanUp();
        try {
            MdObjectStore store = this.m_pnlAccessMethod.getObjectStore();
            if (store != null) {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        this.m_pnlAdvancedFile.saveSettingsAndCleanUp();
    }
}

