/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.other.IFTPServer;
import com.sas.etl.models.other.IHTTPServer;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ExternalFileQuotingPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExternalFileQuotingPanel.class);
    private static final String DEFAULT = "DEFAULT";
    private static final String FTP = "FTP";
    private static final String URL = "URL";
    private JRadioButton m_rbnDefaultQuoting;
    private JRadioButton m_rbnDoubleQuoting;
    private JRadioButton m_rbnNoQuoting;
    private IExternalTable m_mdlTable;
    private IStructuredExternalFile m_mdlFile;
    private ItemListener m_lsnrButtons;
    private IModelListener m_lsnrModel;
    private boolean m_editable;

    public ExternalFileQuotingPanel(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.m_mdlFile = this.m_mdlTable.getFile();
        this.setHelpProduct("wdb");
        this.setHelpTopic("advanced_quoting_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_rbnDefaultQuoting = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedFileQuotingTab.RadioButton.DefaultQuoting");
        this.m_rbnDoubleQuoting = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedFileQuotingTab.RadioButton.DoubleQuoting");
        this.m_rbnNoQuoting = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedFileQuotingTab.RadioButton.NoQuoting");
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbnDefaultQuoting);
        grp.add(this.m_rbnDoubleQuoting);
        grp.add(this.m_rbnNoQuoting);
        this.m_lsnrButtons = new cItemListener();
        this.m_lsnrModel = new ModelListener();
        this.m_rbnDefaultQuoting.addItemListener(this.m_lsnrButtons);
        this.m_rbnDoubleQuoting.addItemListener(this.m_lsnrButtons);
        this.m_rbnNoQuoting.addItemListener(this.m_lsnrButtons);
        this.m_mdlTable.getModel().addModelListener(this.m_lsnrModel);
        this.listenForDataChangesTo(this.m_rbnDefaultQuoting);
        this.listenForDataChangesTo(this.m_rbnDoubleQuoting);
        this.listenForDataChangesTo(this.m_rbnNoQuoting);
        this.setLayout(new GridBagLayout());
        this.add(this.m_rbnDefaultQuoting, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_rbnDoubleQuoting, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_rbnNoQuoting, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_mdlFile.isNoQuoteFilename()) {
            this.m_rbnNoQuoting.setSelected(true);
        } else if (this.m_mdlFile.isDoubleQuoteFilename()) {
            this.m_rbnDoubleQuoting.setSelected(true);
        } else {
            this.m_rbnDefaultQuoting.setSelected(true);
        }
        if (this.m_editable) {
            if (this.m_mdlTable.getFile().getServer() == null) {
                this.setupButtons(DEFAULT);
            } else if (this.m_mdlTable.getFile().getServer() instanceof IFTPServer) {
                this.setupButtons(FTP);
            } else if (this.m_mdlTable.getFile().getServer() instanceof IHTTPServer) {
                this.setupButtons(URL);
            } else {
                this.setupButtons(DEFAULT);
            }
        }
        this.setListeningForChanges(true);
    }

    public void setupButtons(String accessMethod) {
        boolean ftp = false;
        boolean url = false;
        if (accessMethod.equals(FTP)) {
            ftp = true;
        } else if (accessMethod.equals(URL)) {
            url = true;
        }
        this.m_rbnDefaultQuoting.setEnabled(!url);
        if (ftp || url) {
            this.m_rbnNoQuoting.setEnabled(false);
        } else {
            this.m_rbnNoQuoting.setEnabled(true);
        }
        this.m_rbnDoubleQuoting.setEnabled(!url);
        if (url) {
            this.m_rbnDefaultQuoting.setSelected(true);
        }
        if (ftp && this.m_rbnNoQuoting.isSelected()) {
            this.m_rbnDefaultQuoting.setSelected(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_editable = bEditable;
        this.m_rbnDefaultQuoting.setEnabled(bEditable);
        this.m_rbnNoQuoting.setEnabled(bEditable);
        this.m_rbnDoubleQuoting.setEnabled(bEditable);
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent e) {
            JRadioButton rbn = (JRadioButton)e.getItemSelectable();
            boolean bEnabled = rbn.isSelected() && ExternalFileQuotingPanel.this.isEditable();
            ExternalFileQuotingPanel.this.m_mdlTable.getModel().startCompoundUndoable();
            try {
                if (rbn == ExternalFileQuotingPanel.this.m_rbnDefaultQuoting && bEnabled) {
                    ExternalFileQuotingPanel.this.m_mdlFile.setNoQuoteFilename(false);
                    ExternalFileQuotingPanel.this.m_mdlFile.setDoubleQuoteFilename(false);
                } else if (rbn == ExternalFileQuotingPanel.this.m_rbnDoubleQuoting && bEnabled) {
                    ExternalFileQuotingPanel.this.m_mdlFile.setNoQuoteFilename(false);
                    ExternalFileQuotingPanel.this.m_mdlFile.setDoubleQuoteFilename(true);
                } else if (rbn == ExternalFileQuotingPanel.this.m_rbnNoQuoting && bEnabled) {
                    ExternalFileQuotingPanel.this.m_mdlFile.setNoQuoteFilename(true);
                    ExternalFileQuotingPanel.this.m_mdlFile.setDoubleQuoteFilename(false);
                }
            }
            finally {
                ExternalFileQuotingPanel.this.m_mdlTable.getModel().endCompoundUndoable();
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (type.equals("ExternalTable:NoQuoteFilenameChanged") || type.equals("ExternalTable:DoubleQuoteFilenameChanged")) {
                if (ExternalFileQuotingPanel.this.m_mdlFile.isNoQuoteFilename()) {
                    ExternalFileQuotingPanel.this.m_rbnNoQuoting.setSelected(true);
                } else if (ExternalFileQuotingPanel.this.m_mdlFile.isDoubleQuoteFilename()) {
                    ExternalFileQuotingPanel.this.m_rbnDoubleQuoting.setSelected(true);
                } else {
                    ExternalFileQuotingPanel.this.m_rbnDefaultQuoting.setSelected(true);
                }
            } else if (type.equals("IFile:ServerChanged") && ExternalFileQuotingPanel.this.m_editable) {
                if (ExternalFileQuotingPanel.this.m_mdlTable.getFile().getServer() == null) {
                    ExternalFileQuotingPanel.this.setupButtons(ExternalFileQuotingPanel.DEFAULT);
                } else if (ExternalFileQuotingPanel.this.m_mdlTable.getFile().getServer() instanceof IFTPServer) {
                    ExternalFileQuotingPanel.this.setupButtons(ExternalFileQuotingPanel.FTP);
                } else if (ExternalFileQuotingPanel.this.m_mdlTable.getFile().getServer() instanceof IHTTPServer) {
                    ExternalFileQuotingPanel.this.setupButtons(ExternalFileQuotingPanel.URL);
                } else {
                    ExternalFileQuotingPanel.this.setupButtons(ExternalFileQuotingPanel.DEFAULT);
                }
            }
        }
    }
}

