/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IDelimitedExternalFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.AdvancedExternalFileParametersPanel2;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.apache.commons.configuration.ConfigurationException;

public class DelimitedExternalTablePanel2
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(DelimitedExternalTablePanel2.class);
    private IExternalTable m_mdlTable;
    private IDelimitedExternalFile m_mdlDelimited;
    private boolean m_bSelectedNewFile;
    private JLabel m_lblDisabled;
    private JLabel m_lblSpaceHolder;
    private JCheckBox m_ckbBlank;
    private JCheckBox m_ckbComma;
    private JCheckBox m_ckbSemicolon;
    private JCheckBox m_ckbTab;
    private JCheckBox m_ckbOthers;
    private JTextField m_txtOthers;
    private JPanel m_pnlDelimiters;
    private JCheckBox m_ckbConsecutiveDelimiters;
    private JCheckBox m_ckbMultipleRowsPerRecord;
    private WAIntTextField m_txtNumberOfColumnsPerRow;
    private JLabel m_lblNumberOfColumnsPerRow;
    private JPanel m_pnlMultipleRowsPerRecord;
    private JRadioButton m_rbnReadNextRecord;
    private JRadioButton m_rbnSetToMissing;
    private JPanel m_pnlMissingValues;
    private JLabel m_lblRecordLength;
    private WAIntTextField m_txtRecordLength;
    private JPanel m_pnlRecordLength;
    private JButton m_btnAdvanced;
    private WsAbstractAction m_actAdvanced;
    private ItemListener m_lsnrCommon;
    private ActionListener m_lsnrFocusMover;
    private IModelListener m_lsnrModel;
    private ItemListener m_lsnrCheckbox;

    public DelimitedExternalTablePanel2(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.m_mdlDelimited = (IDelimitedExternalFile)this.m_mdlTable.getFile();
        this.m_bSelectedNewFile = false;
        this.setHelpProduct("wdb");
        this.setHelpTopic("delimiters_parameters");
        this.initialize();
    }

    protected void initialize() {
        this.m_lblDisabled = new JLabel(bundle.getString("DelimitedExternalTablePanel.Label.Disabled.txt"));
        this.m_lblDisabled.setFont(this.m_lblDisabled.getFont().deriveFont(1));
        this.m_lblDisabled.setVisible(false);
        this.m_lblSpaceHolder = new JLabel(" ");
        this.m_lsnrCommon = new cCommonListener();
        this.m_lsnrFocusMover = new cFocusMover();
        this.m_lsnrModel = new ModelListener();
        this.m_lsnrCheckbox = new cCheckboxListener();
        this.createDelimitersPanel();
        this.createMultipleRowsPerRecordPanel();
        this.createMissingValuesPanel();
        this.createLogicalRecordLengthPanel();
        this.m_ckbConsecutiveDelimiters = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.ConsecutiveDelimiters");
        this.listenForDataChangesTo(this.m_ckbConsecutiveDelimiters);
        this.m_ckbConsecutiveDelimiters.addItemListener(this.m_lsnrCheckbox);
        this.m_actAdvanced = new cAdvancedAction();
        this.m_btnAdvanced = new JButton((Action)this.m_actAdvanced);
        this.m_mdlTable.getModel().addModelListener(this.m_lsnrModel);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDisabled, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_pnlDelimiters, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbConsecutiveDelimiters, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_pnlMultipleRowsPerRecord, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_pnlMissingValues, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_pnlRecordLength, new GridBagConstraints(1, 5, 3, 1, 1.0, 0.0, 17, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add(this.m_lblSpaceHolder, new GridBagConstraints(1, 6, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 7, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_btnAdvanced, new GridBagConstraints(3, 8, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void createDelimitersPanel() {
        this.m_ckbBlank = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Blank");
        this.m_ckbComma = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Comma");
        this.m_ckbSemicolon = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Semicolon");
        this.m_ckbTab = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Tab");
        this.m_ckbOthers = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Others");
        this.m_ckbOthers.addItemListener(this.m_lsnrCommon);
        this.m_ckbOthers.addActionListener(this.m_lsnrFocusMover);
        this.m_ckbBlank.addItemListener(this.m_lsnrCheckbox);
        this.m_ckbComma.addItemListener(this.m_lsnrCheckbox);
        this.m_ckbSemicolon.addItemListener(this.m_lsnrCheckbox);
        this.m_ckbTab.addItemListener(this.m_lsnrCheckbox);
        this.m_ckbOthers.addItemListener(this.m_lsnrCheckbox);
        this.m_txtOthers = new WATextField(4);
        this.m_txtOthers.setToolTipText(bundle.getString("DelimitedExternalTablePanel.TextField.Others.tip"));
        this.listenForDataChangesTo(this.m_ckbBlank);
        this.listenForDataChangesTo(this.m_ckbComma);
        this.listenForDataChangesTo(this.m_ckbSemicolon);
        this.listenForDataChangesTo(this.m_ckbTab);
        this.listenForDataChangesTo(this.m_ckbOthers);
        this.listenForDataChangesTo(this.m_txtOthers);
        this.m_pnlDelimiters = new JPanel(new GridBagLayout());
        this.m_pnlDelimiters.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("DelimitedExternalTablePanel.BorderTitle.Delimiters.txt")));
        this.m_pnlDelimiters.add((Component)this.m_ckbBlank, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbComma, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbSemicolon, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbTab, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbOthers, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_txtOthers, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void createMultipleRowsPerRecordPanel() {
        this.m_ckbMultipleRowsPerRecord = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.MultipleRowsPerRecord");
        this.m_ckbMultipleRowsPerRecord.addItemListener(this.m_lsnrCommon);
        this.m_ckbMultipleRowsPerRecord.addActionListener(this.m_lsnrFocusMover);
        this.m_ckbMultipleRowsPerRecord.addItemListener(this.m_lsnrCheckbox);
        this.m_txtNumberOfColumnsPerRow = new WAIntTextField();
        this.m_txtNumberOfColumnsPerRow.setValue(1);
        this.m_txtNumberOfColumnsPerRow.setColumns(4);
        this.m_txtNumberOfColumnsPerRow.setEnabled(false);
        this.m_txtNumberOfColumnsPerRow.setEditable(false);
        this.m_lblNumberOfColumnsPerRow = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfColumnsPerRow, (WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Label.NumberOfColumnsPerRow");
        this.m_lblNumberOfColumnsPerRow.setEnabled(false);
        this.listenForDataChangesTo(this.m_ckbMultipleRowsPerRecord);
        this.listenForDataChangesTo((JTextComponent)this.m_txtNumberOfColumnsPerRow);
        this.m_pnlMultipleRowsPerRecord = new JPanel(new GridBagLayout());
        this.m_pnlMultipleRowsPerRecord.add((Component)this.m_ckbMultipleRowsPerRecord, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createMissingValuesPanel() {
        this.m_rbnReadNextRecord = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Radiobutton.ReadNextFileRecord");
        this.m_rbnSetToMissing = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Radiobutton.SetRemainingValuesToMissing");
        this.listenForDataChangesTo(this.m_rbnReadNextRecord);
        this.listenForDataChangesTo(this.m_rbnSetToMissing);
        this.m_rbnReadNextRecord.addItemListener(this.m_lsnrCheckbox);
        this.m_rbnSetToMissing.addItemListener(this.m_lsnrCheckbox);
        ButtonGroup grpMissingValues = new ButtonGroup();
        grpMissingValues.add(this.m_rbnReadNextRecord);
        grpMissingValues.add(this.m_rbnSetToMissing);
        this.m_pnlMissingValues = new JPanel(new GridBagLayout());
        this.m_pnlMissingValues.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("DelimitedExternalTablePanel.BorderTitle.MissingValues.txt")));
        this.m_pnlMissingValues.add((Component)this.m_rbnSetToMissing, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlMissingValues.add((Component)this.m_rbnReadNextRecord, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createLogicalRecordLengthPanel() {
        this.m_txtRecordLength = new WAIntTextField();
        this.m_txtRecordLength.setColumns(5);
        this.m_lblRecordLength = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtRecordLength, (WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Label.RecordLength");
        this.listenForDataChangesTo((JTextComponent)this.m_txtRecordLength);
        this.m_pnlRecordLength = new JPanel(new GridBagLayout());
        this.m_pnlRecordLength.add((Component)this.m_lblRecordLength, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlRecordLength.add((Component)this.m_txtRecordLength, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.loadDelimiters(true);
        this.m_ckbConsecutiveDelimiters.setSelected(this.m_mdlDelimited.isConsecutiveDelimiterSkippingEnabled());
        this.m_ckbMultipleRowsPerRecord.setSelected(this.m_mdlDelimited.isMultipleRecordsPerLineEnabled());
        if (!this.m_mdlDelimited.isRecordWrappingEnabled()) {
            this.m_rbnSetToMissing.setSelected(true);
        } else {
            this.m_rbnReadNextRecord.setSelected(true);
        }
        if (this.m_mdlDelimited.getRecordLength() > 0 && !this.m_bSelectedNewFile) {
            this.m_txtRecordLength.setValue(this.m_mdlDelimited.getRecordLength());
        } else if (this.m_mdlDelimited.getServer() == null && this.doesFileExist()) {
            this.m_txtRecordLength.setValue(Math.min(Math.max(ExternalTableDataModel.getDefaultLogicalRecordLength(), this.getRecordLengthGuess()), ExternalTableDataModel.getMaximumLogicalRecordLength()));
        } else {
            this.m_txtRecordLength.setValue(ExternalTableDataModel.getDefaultLogicalRecordLength());
        }
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.saveDelimiters();
        this.loadDelimiters(true);
        this.m_mdlDelimited.setRecordLength(this.m_txtRecordLength.getValue());
        this.m_bSelectedNewFile = false;
        this.setDataChanged(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public boolean validateData() {
        int response;
        if (this.m_ckbOthers.isSelected() && this.m_txtOthers.getText().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.OtherDelimiters.txt"), (int)0);
            this.m_txtOthers.requestFocus();
            return false;
        }
        if (this.m_ckbOthers.isSelected() && this.hasDuplicateDelimiters() && (response = MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Warning.DuplicateDelimiters.txt"), (int)2, (int)2)) != 0) {
            this.m_txtOthers.requestFocus();
            return false;
        }
        if (!(this.m_ckbBlank.isSelected() || this.m_ckbComma.isSelected() || this.m_ckbSemicolon.isSelected() || this.m_ckbTab.isSelected() || this.m_ckbOthers.isSelected())) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.AtLeastOneDelimiter.txt"), (int)0);
            this.m_ckbBlank.requestFocus();
            return false;
        }
        if (this.m_ckbMultipleRowsPerRecord.isSelected() && this.m_rbnSetToMissing.isSelected()) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.NumberOfColumnsPerRowMissover.txt"), (int)0);
            this.m_rbnReadNextRecord.requestFocus();
            return false;
        }
        if (this.m_txtRecordLength.getText().length() > 0) {
            if (this.m_txtRecordLength.getValue() <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.InvalidRecordLength.txt"), (int)0);
                this.m_txtRecordLength.requestFocus();
                return false;
            }
            if (this.m_txtRecordLength.getValue() > ExternalTableDataModel.getMaximumLogicalRecordLength()) {
                MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.RecordLengthTooLarge.txt"), (int)0);
                this.m_txtRecordLength.requestFocus();
                return false;
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        boolean bEnabled = this.isEditable() && !this.m_mdlDelimited.getInfileOverrideFlag();
        this.m_ckbBlank.setEnabled(bEnabled);
        this.m_ckbComma.setEnabled(bEnabled);
        this.m_ckbSemicolon.setEnabled(bEnabled);
        this.m_ckbTab.setEnabled(bEnabled);
        this.m_ckbOthers.setEnabled(bEnabled);
        this.m_txtOthers.setEditable(bEnabled && this.m_ckbOthers.isSelected());
        this.m_txtOthers.setEnabled(!this.m_mdlDelimited.getInfileOverrideFlag() && this.m_ckbOthers.isSelected());
        this.m_ckbConsecutiveDelimiters.setEnabled(bEnabled);
        this.m_ckbMultipleRowsPerRecord.setEnabled(this.isEditable());
        this.m_rbnReadNextRecord.setEnabled(bEnabled && !this.m_ckbMultipleRowsPerRecord.isSelected());
        this.m_rbnSetToMissing.setEnabled(bEnabled && !this.m_ckbMultipleRowsPerRecord.isSelected());
        this.m_lblRecordLength.setEnabled(!this.m_mdlDelimited.getInfileOverrideFlag());
        this.m_txtRecordLength.setEditable(bEnabled);
        this.m_txtRecordLength.setEnabled(!this.m_mdlDelimited.getInfileOverrideFlag());
        this.m_lblDisabled.setVisible(this.m_mdlDelimited.getInfileOverrideFlag());
        this.m_lblSpaceHolder.setVisible(!this.m_mdlDelimited.getInfileOverrideFlag());
    }

    private String removeDuplicates(String delimiters) {
        StringBuffer newDelimiters = new StringBuffer();
        for (int charIndex = 0; charIndex < delimiters.length(); ++charIndex) {
            if (newDelimiters.indexOf(String.valueOf(delimiters.charAt(charIndex))) != -1) continue;
            newDelimiters.append(delimiters.charAt(charIndex));
        }
        return newDelimiters.toString();
    }

    private boolean hasDuplicateDelimiters() {
        StringBuffer processedDelimiters = new StringBuffer();
        if (this.m_ckbBlank.isSelected()) {
            processedDelimiters.append(' ');
        }
        if (this.m_ckbComma.isSelected()) {
            processedDelimiters.append(',');
        }
        if (this.m_ckbSemicolon.isSelected()) {
            processedDelimiters.append(';');
        }
        if (this.m_ckbTab.isSelected()) {
            processedDelimiters.append('\t');
        }
        String others = this.m_txtOthers.getText();
        for (int charIndex = 0; charIndex < others.length(); ++charIndex) {
            if (processedDelimiters.indexOf(String.valueOf(others.charAt(charIndex))) != -1) {
                return true;
            }
            processedDelimiters.append(others.charAt(charIndex));
        }
        return false;
    }

    private void loadDelimiters(boolean bOthers) {
        StringBuffer sbDelimiters = new StringBuffer(this.m_mdlDelimited.getDelimiters());
        this.m_ckbBlank.setSelected(sbDelimiters.indexOf(" ") != -1);
        this.m_ckbComma.setSelected(sbDelimiters.indexOf(",") != -1);
        this.m_ckbSemicolon.setSelected(sbDelimiters.indexOf(";") != -1);
        this.m_ckbTab.setSelected(sbDelimiters.indexOf("\t") != -1);
        sbDelimiters = new StringBuffer(sbDelimiters.toString().replaceAll("[ ,;\t]", ""));
        if (bOthers) {
            if (sbDelimiters.length() > 0) {
                this.m_ckbOthers.setSelected(true);
                this.m_txtOthers.setText(this.removeDuplicates(sbDelimiters.toString()));
            } else {
                this.m_ckbOthers.setSelected(false);
            }
        }
    }

    private void saveDelimiters() {
        StringBuffer sbDelimiters = new StringBuffer();
        if (this.m_ckbBlank.isSelected()) {
            sbDelimiters.append(' ');
        }
        if (this.m_ckbComma.isSelected()) {
            sbDelimiters.append(',');
        }
        if (this.m_ckbSemicolon.isSelected()) {
            sbDelimiters.append(';');
        }
        if (this.m_ckbTab.isSelected()) {
            sbDelimiters.append('\t');
        }
        if (this.m_ckbOthers.isSelected()) {
            String others = this.m_txtOthers.getText();
            for (int charIndex = 0; charIndex < others.length(); ++charIndex) {
                if (sbDelimiters.indexOf(String.valueOf(others.charAt(charIndex))) != -1) continue;
                sbDelimiters.append(others.charAt(charIndex));
            }
        }
        this.m_mdlDelimited.setDelimiters(sbDelimiters.toString());
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyString("DelimitedExternalTablePanel.Delimiters", sbDelimiters.toString());
    }

    private boolean doesFileExist() {
        try {
            WsAppServer appServer = WsAppServer.createAppServer((String)this.m_mdlDelimited.getServer().getID());
            if (appServer != null) {
                return appServer.doesFileExist(this.m_mdlTable.getAccessMethodFileName(this.m_mdlDelimited.getFileName()), this.m_mdlTable.getAccessMethodNickName(), this.m_mdlTable.getAccessMethodOptions("_temp"), this.m_mdlTable.getAccessMethodPreCode("_temp"));
            }
        }
        catch (BadServerDefinitionException ex) {
            return false;
        }
        catch (ConfigurationException ex) {
            return false;
        }
        catch (CodegenException ex) {
            return false;
        }
        catch (WsAppServerFailException ex) {
            return false;
        }
        catch (GenericError e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRecordLengthGuess() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow().setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer appServer = WsAppServer.createAppServer((String)this.m_mdlDelimited.getServer().getID());
            if (appServer == null) {
                int n = 0;
                return n;
            }
            String sEncoding = this.m_mdlTable.getInfileEncodingTextQuoted();
            String sOptions = !sEncoding.equals("") ? "encoding=" + sEncoding : "";
            String[] lines = appServer.readLinesFromFile(1, 100, this.m_mdlDelimited.getFileName(), sOptions);
            int iMax = 0;
            for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
                iMax = Math.max(iMax, lines[lineIndex].length());
            }
            int n = iMax;
            return n;
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        finally {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow().setCursor(Cursor.getDefaultCursor());
        }
        return 0;
    }

    private class cCommonListener
    implements ItemListener {
        private cCommonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean bEnabled;
            JToggleButton tbn = (JToggleButton)e.getItemSelectable();
            boolean bl = bEnabled = tbn.isSelected() && DelimitedExternalTablePanel2.this.isEditable();
            if (tbn == DelimitedExternalTablePanel2.this.m_ckbOthers) {
                DelimitedExternalTablePanel2.this.m_txtOthers.setEditable(bEnabled && !DelimitedExternalTablePanel2.this.m_mdlDelimited.getInfileOverrideFlag());
                DelimitedExternalTablePanel2.this.m_txtOthers.setEnabled(bEnabled && !DelimitedExternalTablePanel2.this.m_mdlDelimited.getInfileOverrideFlag());
            }
        }
    }

    private class cFocusMover
    implements ActionListener {
        private cFocusMover() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DelimitedExternalTablePanel2.this.m_ckbOthers && DelimitedExternalTablePanel2.this.m_ckbOthers.isSelected()) {
                DelimitedExternalTablePanel2.this.m_txtOthers.requestFocus();
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (type.equals("ExternalTable:DelimitersChanged")) {
                DelimitedExternalTablePanel2.this.loadDelimiters(false);
            } else if (!type.equals("ExternalTable:DelimiterQuotingChanged")) {
                if (type.equals("ExternalTable:ConsecutiveDelimiterSkippingChanged")) {
                    DelimitedExternalTablePanel2.this.m_ckbConsecutiveDelimiters.setSelected(DelimitedExternalTablePanel2.this.m_mdlDelimited.isConsecutiveDelimiterSkippingEnabled());
                } else if (type.equals("ExternalTable:MultipleRecordsPerLineChanged")) {
                    DelimitedExternalTablePanel2.this.m_ckbMultipleRowsPerRecord.setSelected(DelimitedExternalTablePanel2.this.m_mdlDelimited.isMultipleRecordsPerLineEnabled());
                } else if (type.equals("ExternalTable:RecordWrappingChanged")) {
                    DelimitedExternalTablePanel2.this.m_rbnReadNextRecord.setSelected(DelimitedExternalTablePanel2.this.m_mdlDelimited.isRecordWrappingEnabled());
                    DelimitedExternalTablePanel2.this.m_rbnSetToMissing.setSelected(!DelimitedExternalTablePanel2.this.m_mdlDelimited.isRecordWrappingEnabled());
                } else if (type.equals("ExternalTable:RecordLengthChanged")) {
                    DelimitedExternalTablePanel2.this.m_txtRecordLength.setText("" + DelimitedExternalTablePanel2.this.m_mdlDelimited.getRecordLength());
                } else if (type.equals("IFile:FileNameChanged")) {
                    DelimitedExternalTablePanel2.this.m_bSelectedNewFile = true;
                }
            }
        }
    }

    private class cCheckboxListener
    implements ItemListener {
        private cCheckboxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!DelimitedExternalTablePanel2.this.isEditable()) {
                return;
            }
            JToggleButton ckb = (JToggleButton)e.getItemSelectable();
            boolean bEnabled = ckb.isSelected();
            if (ckb == DelimitedExternalTablePanel2.this.m_ckbBlank) {
                String sCurrent = DelimitedExternalTablePanel2.this.m_mdlDelimited.getDelimiters();
                if (bEnabled) {
                    if (sCurrent.indexOf(32) == -1) {
                        DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent + " ");
                    }
                } else {
                    DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent.replaceAll(" ", ""));
                }
            } else if (ckb == DelimitedExternalTablePanel2.this.m_ckbComma) {
                String sCurrent = DelimitedExternalTablePanel2.this.m_mdlDelimited.getDelimiters();
                if (bEnabled) {
                    if (sCurrent.indexOf(44) == -1) {
                        DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent + ",");
                    }
                } else {
                    DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent.replaceAll(",", ""));
                }
            } else if (ckb == DelimitedExternalTablePanel2.this.m_ckbSemicolon) {
                String sCurrent = DelimitedExternalTablePanel2.this.m_mdlDelimited.getDelimiters();
                if (bEnabled) {
                    if (sCurrent.indexOf(59) == -1) {
                        DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent + ";");
                    }
                } else {
                    DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent.replaceAll(";", ""));
                }
            } else if (ckb == DelimitedExternalTablePanel2.this.m_ckbTab) {
                String sCurrent = DelimitedExternalTablePanel2.this.m_mdlDelimited.getDelimiters();
                if (bEnabled) {
                    if (sCurrent.indexOf(9) == -1) {
                        DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent + "\t");
                    }
                } else {
                    DelimitedExternalTablePanel2.this.m_mdlDelimited.setDelimiters(sCurrent.replaceAll("\t", ""));
                }
            } else if (ckb == DelimitedExternalTablePanel2.this.m_ckbConsecutiveDelimiters) {
                DelimitedExternalTablePanel2.this.m_mdlDelimited.setConsecutiveDelimiterSkippingEnabled(bEnabled);
            } else if (ckb == DelimitedExternalTablePanel2.this.m_ckbMultipleRowsPerRecord) {
                DelimitedExternalTablePanel2.this.m_mdlTable.getModel().startCompoundUndoable();
                try {
                    DelimitedExternalTablePanel2.this.m_mdlDelimited.setMultipleRecordsPerLineEnabled(bEnabled);
                    if (bEnabled) {
                        DelimitedExternalTablePanel2.this.m_rbnReadNextRecord.setSelected(true);
                        DelimitedExternalTablePanel2.this.m_rbnSetToMissing.setSelected(false);
                    }
                    DelimitedExternalTablePanel2.this.updateComponents();
                }
                finally {
                    DelimitedExternalTablePanel2.this.m_mdlTable.getModel().endCompoundUndoable();
                }
            } else if (ckb == DelimitedExternalTablePanel2.this.m_rbnReadNextRecord && bEnabled) {
                DelimitedExternalTablePanel2.this.m_mdlDelimited.setRecordWrappingEnabled(bEnabled);
            } else if (ckb == DelimitedExternalTablePanel2.this.m_rbnSetToMissing && bEnabled) {
                DelimitedExternalTablePanel2.this.m_mdlDelimited.setRecordWrappingEnabled(!bEnabled);
            }
        }
    }

    private class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "DelimitedExternalTablePanel.Action.Advanced", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!DelimitedExternalTablePanel2.this.validateData()) {
                return;
            }
            try {
                DelimitedExternalTablePanel2.this.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            ModelUIUtilities.showDialog((IObject)DelimitedExternalTablePanel2.this.m_mdlTable, bundle.getString("DelimitedExternalTablePanel.AdvancedDialog.Title.txt"), new AdvancedExternalFileParametersPanel2(DelimitedExternalTablePanel2.this.m_mdlTable));
            DelimitedExternalTablePanel2.this.updateComponents();
        }
    }
}

