/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IDelimitedExternalFile;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsCodeFragmentPane;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.text.DecimalFormatSymbols;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AdvancedExternalFileParametersPanel2
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(AdvancedExternalFileParametersPanel2.class);
    private IExternalTable m_mdlTable;
    private IStructuredExternalFile m_mdlFile;
    private JRadioButton m_rbnSpecialColumnNamesNone;
    private JRadioButton m_rbnSpecialColumnNamesCaseSensitive;
    private JRadioButton m_rbnSpecialColumnNamesSpecialCharacters;
    private JPanel m_pnlSpecialColumnNames;
    private JLabel m_lblNumeric;
    private WAIntTextField m_txtNumeric;
    private char m_defaultMissingValueNumericDelimiter = (char)32;
    private char[] m_missingValuesNumericDelimArray = new char[]{' '};
    private JLabel m_lblSpecial;
    private WAComboBox m_cmbSpecial;
    private JLabel m_lblStartRecord;
    private WAIntTextField m_txtStartRecord;
    private JLabel m_lblNumberOfRecords;
    private WAIntTextField m_txtNumberOfRecords;
    private JCheckBox m_ckbCreateView;
    private JLabel m_lblEncoding;
    private WATextField m_txtEncoding;
    private WsAbstractAction m_actDisplay;
    private JButton m_btnDisplay;
    private JLabel m_lblAppendOptions;
    private WATextArea m_txtAppendOptions;
    private JScrollPane m_scrAppendOptions;
    private JCheckBox m_ckbOverride;
    private WATextArea m_txtOverride;
    private JScrollPane m_scrOverride;
    private JLabel m_lblOverrideDelimiter;
    private WATextField m_txtOverrideDelimiter;
    private IModelListener m_lsnrModel;
    private ItemListener m_lsnrState;

    public AdvancedExternalFileParametersPanel2(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.m_mdlFile = mdlTable.getFile();
        this.setHelpProduct("wdb");
        this.setHelpTopic("advanced_file_parameters");
        this.initialize();
    }

    protected void initialize() {
        this.m_lsnrModel = new ModelListener();
        this.m_lsnrState = new cStateListener();
        this.createSpecialColumnNamesPanel();
        this.m_txtNumeric = new WAIntTextField();
        this.m_txtNumeric.setColumns(6);
        this.m_txtNumeric.setDocument((Document)((Object)new IntDelimDocument(this.getMissingValuesNumericDelimiters())));
        this.m_lblNumeric = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumeric, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.Numeric");
        Object[] saValues = new String[]{"", "_", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        this.m_cmbSpecial = new WAComboBox(saValues);
        this.m_cmbSpecial.setEditable(true);
        this.m_cmbSpecial.addItemListener(this.m_lsnrState);
        this.m_lblSpecial = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbSpecial, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.Special");
        JPanel pnlMissingValues = new JPanel(new GridBagLayout());
        pnlMissingValues.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AdvancedExternalFileParametersPanel.BorderTitle.MissingValues.txt")));
        pnlMissingValues.add((Component)this.m_lblNumeric, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlMissingValues.add((Component)this.m_txtNumeric, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        pnlMissingValues.add((Component)this.m_lblSpecial, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlMissingValues.add((Component)this.m_cmbSpecial, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.m_txtStartRecord = new WAIntTextField();
        this.m_txtStartRecord.setColumns(6);
        this.m_lblStartRecord = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtStartRecord, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.StartRecord");
        this.m_txtNumberOfRecords = new WAIntTextField();
        this.m_txtNumberOfRecords.setColumns(6);
        this.m_lblNumberOfRecords = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfRecords, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.NumberOfRecords");
        JPanel pnlInputLines = new JPanel(new GridBagLayout());
        pnlInputLines.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AdvancedExternalFileParametersPanel.BorderTitle.ExternalFileRecords.txt")));
        pnlInputLines.add((Component)this.m_lblStartRecord, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlInputLines.add((Component)this.m_txtStartRecord, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        pnlInputLines.add((Component)this.m_lblNumberOfRecords, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlInputLines.add((Component)this.m_txtNumberOfRecords, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.m_ckbCreateView = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.CheckBox.CreateView");
        this.m_ckbCreateView.addItemListener(this.m_lsnrState);
        this.m_txtEncoding = new WATextField(10);
        this.m_lblEncoding = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtEncoding, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.Encoding");
        this.m_actDisplay = new cDisplayAction();
        this.m_btnDisplay = new JButton((Action)this.m_actDisplay);
        this.m_txtOverrideDelimiter = new WATextField();
        this.m_txtOverrideDelimiter.setColumns(8);
        this.m_lblOverrideDelimiter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtOverrideDelimiter, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.OverrideDelimiter");
        JPanel pnlDelimiterLines = new JPanel(new GridBagLayout());
        pnlDelimiterLines.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AdvancedExternalFileParametersPanel.BorderTitle.DelimitedFileSettings.txt")));
        pnlDelimiterLines.add((Component)this.m_lblOverrideDelimiter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlDelimiterLines.add((Component)this.m_txtOverrideDelimiter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.m_txtAppendOptions = new cTextArea(2, 40);
        Font fnt = this.m_txtAppendOptions.getFont();
        this.m_txtAppendOptions.setFont(new Font("monospaced", fnt.getStyle(), fnt.getSize()));
        this.m_scrAppendOptions = new JScrollPane((Component)this.m_txtAppendOptions);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrAppendOptions);
        this.m_lblAppendOptions = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtAppendOptions, (WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Label.AppendOptions");
        this.m_txtOverride = new cTextArea(4, 40);
        fnt = this.m_txtAppendOptions.getFont();
        this.m_txtOverride.setFont(new Font("monospaced", fnt.getStyle(), fnt.getSize()));
        this.m_scrOverride = new JScrollPane((Component)this.m_txtOverride);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrOverride);
        this.m_ckbOverride = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.CheckBox.OverrideStatement", (int)5);
        this.m_ckbOverride.addItemListener(this.m_lsnrState);
        this.m_ckbOverride.addActionListener(new cFocusMover());
        this.setLayout(new GridBagLayout());
        this.add(pnlMissingValues, new GridBagConstraints(0, 2, 2, 2, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_pnlSpecialColumnNames, new GridBagConstraints(2, 2, 2, 3, 0.5, 0.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_ckbCreateView, new GridBagConstraints(0, 4, 2, 1, 0.5, 0.0, 17, 0, new Insets(10, -2, 0, 0), 0, 0));
        this.add(pnlInputLines, new GridBagConstraints(0, 6, 2, 2, 0.5, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(pnlDelimiterLines, new GridBagConstraints(2, 6, 2, 2, 0.5, 0.0, 11, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_lblEncoding, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 10, 0, 0), 0, 0));
        this.add((Component)this.m_txtEncoding, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 5, 0, 0), 0, 0));
        this.add(this.m_btnDisplay, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 2, 0, 0), 0, 0));
        this.add(this.m_lblAppendOptions, new GridBagConstraints(0, 10, 4, 1, 1.0, 0.0, 17, 0, new Insets(15, 2, 0, 0), 0, 0));
        this.add(this.m_scrAppendOptions, new GridBagConstraints(0, 11, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 0, 0), 0, 0));
        this.add(this.m_ckbOverride, new GridBagConstraints(0, 12, 4, 1, 1.0, 0.0, 17, 0, new Insets(15, -2, 0, 0), 0, 0));
        this.add(this.m_scrOverride, new GridBagConstraints(0, 13, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.listenForDataChangesTo((JTextComponent)this.m_txtNumeric);
        this.listenForDataChangesTo((JComboBox)this.m_cmbSpecial);
        this.listenForDataChangesTo((JTextComponent)this.m_txtStartRecord);
        this.listenForDataChangesTo((JTextComponent)this.m_txtNumberOfRecords);
        this.listenForDataChangesTo(this.m_ckbCreateView);
        this.listenForDataChangesTo((JTextComponent)this.m_txtEncoding);
        this.listenForDataChangesTo((JTextComponent)this.m_txtAppendOptions);
        this.listenForDataChangesTo((JTextComponent)this.m_txtOverride);
        this.listenForDataChangesTo(this.m_ckbOverride);
        this.listenForDataChangesTo((JTextComponent)this.m_txtOverrideDelimiter);
        this.m_mdlTable.getModel().addModelListener(this.m_lsnrModel);
    }

    private void createSpecialColumnNamesPanel() {
        this.m_rbnSpecialColumnNamesNone = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Radiobutton.SpecialColumnNames.None");
        this.m_rbnSpecialColumnNamesCaseSensitive = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Radiobutton.SpecialColumnNames.CaseSensitive");
        this.m_rbnSpecialColumnNamesSpecialCharacters = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AdvancedExternalFileParametersPanel.Radiobutton.SpecialColumnNames.SpecialCharacters");
        this.listenForDataChangesTo(this.m_rbnSpecialColumnNamesNone);
        this.listenForDataChangesTo(this.m_rbnSpecialColumnNamesCaseSensitive);
        this.listenForDataChangesTo(this.m_rbnSpecialColumnNamesSpecialCharacters);
        this.m_rbnSpecialColumnNamesNone.addItemListener(this.m_lsnrState);
        this.m_rbnSpecialColumnNamesCaseSensitive.addItemListener(this.m_lsnrState);
        this.m_rbnSpecialColumnNamesSpecialCharacters.addItemListener(this.m_lsnrState);
        ButtonGroup grpMissingValues = new ButtonGroup();
        grpMissingValues.add(this.m_rbnSpecialColumnNamesNone);
        grpMissingValues.add(this.m_rbnSpecialColumnNamesCaseSensitive);
        grpMissingValues.add(this.m_rbnSpecialColumnNamesSpecialCharacters);
        this.m_pnlSpecialColumnNames = new JPanel(new GridBagLayout());
        this.m_pnlSpecialColumnNames.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AdvancedExternalFileParametersPanel.BorderTitle.SpecialColumnNames.txt")));
        this.m_pnlSpecialColumnNames.add((Component)this.m_rbnSpecialColumnNamesNone, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlSpecialColumnNames.add((Component)this.m_rbnSpecialColumnNamesCaseSensitive, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlSpecialColumnNames.add((Component)this.m_rbnSpecialColumnNamesSpecialCharacters, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_mdlTable.isSpecialCharacters()) {
            this.m_rbnSpecialColumnNamesSpecialCharacters.setSelected(true);
        } else if (this.m_mdlTable.isCaseSensitive()) {
            this.m_rbnSpecialColumnNamesCaseSensitive.setSelected(true);
        } else {
            this.m_rbnSpecialColumnNamesNone.setSelected(true);
        }
        this.m_txtNumeric.setText(this.m_mdlFile.getNumericMissingValue());
        this.m_cmbSpecial.setSelectedItem((Object)this.m_mdlFile.getSpecialMissingValue());
        this.m_ckbCreateView.setSelected(this.m_mdlTable.isView());
        this.m_txtStartRecord.setText(this.m_mdlFile.getStartingRecordNumber());
        this.m_txtNumberOfRecords.setText(this.m_mdlFile.getNumberOfRecords());
        this.m_txtEncoding.setText(this.m_mdlFile.getInfileEncodingOptions());
        this.m_txtAppendOptions.setText(this.m_mdlFile.getAdditionalInfileOptions());
        this.m_ckbOverride.setSelected(this.m_mdlFile.getInfileOverrideFlag());
        this.m_txtOverride.setText(this.m_mdlFile.getInfileOverrideText());
        if (this.m_mdlTable.isDelimited()) {
            this.m_txtOverrideDelimiter.setText(((IDelimitedExternalFile)this.m_mdlFile).getOverrideDelimiter());
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_mdlFile.setNumericMissingValue(this.m_txtNumeric.getText());
        this.m_mdlFile.setStartingRecordNumber(this.m_txtStartRecord.getText());
        this.m_mdlFile.setNumberOfRecords(this.m_txtNumberOfRecords.getText());
        String sEncoding = this.m_txtEncoding.getText();
        this.m_mdlFile.setInfileEncodingOptions(sEncoding);
        String sOptions = this.m_txtAppendOptions.getText();
        this.m_mdlFile.setAdditionalInfileOptions(sOptions);
        this.m_mdlFile.setInfileOverrideText(this.m_txtOverride.getText());
        if (this.m_mdlTable.isDelimited()) {
            ((IDelimitedExternalFile)this.m_mdlFile).setOverrideDelimiter(this.m_txtOverrideDelimiter.getText());
        }
        this.setDataChanged(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public boolean validateData() {
        int startRecord = this.m_txtStartRecord.getValue();
        if (startRecord < 0) {
            MessageUtil.displayMessage((String)bundle.getString("AdvancedExternalFileParametersPanel.Error.MissingStartRecord.txt"), (int)0);
            this.m_txtStartRecord.requestFocus();
            return false;
        }
        if (startRecord == 0) {
            MessageUtil.displayMessage((String)bundle.getString("AdvancedExternalFileParametersPanel.Error.ZeroStartRecord.txt"), (int)0);
            this.m_txtStartRecord.requestFocus();
            return false;
        }
        if (this.m_txtOverride.isEditable() && !this.checkLineLengths(this.m_txtOverride.getText().split("\\n"), bundle.getString("AdvancedExternalFileParametersPanel.InfileOverrideLocationDesc.txt"))) {
            return false;
        }
        if (this.m_txtAppendOptions.isEditable() && !this.checkLineLengths(this.m_txtAppendOptions.getText().split("\\n"), bundle.getString("AdvancedExternalFileParametersPanel.AppendLocationDesc.txt"))) {
            return false;
        }
        if (this.m_txtEncoding.isEditable() && !this.checkLineLengths(this.m_txtEncoding.getText().split("\\n"), bundle.getString("AdvancedExternalFileParametersPanel.EncodeOptionsLocationDesc.txt"))) {
            return false;
        }
        return !this.m_txtOverrideDelimiter.isEditable() || this.checkLineLengths(this.m_txtOverrideDelimiter.getText().split("\\n"), bundle.getString("AdvancedExternalFileParametersPanel.OverrideDelimiterLocationDesc.txt"));
    }

    private boolean checkLineLengths(String[] lines, String location) {
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 255 || 1 != SASCodeGeneration.displayLineLengthMessage((String)lines[i], (int)(i + 1), (String)location)) continue;
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        this.m_txtNumeric.setEditable(this.isEditable());
        this.m_cmbSpecial.setEnabled(this.isEditable());
        this.m_ckbCreateView.setEnabled(this.isEditable());
        this.m_rbnSpecialColumnNamesNone.setEnabled(this.isEditable());
        this.m_rbnSpecialColumnNamesCaseSensitive.setEnabled(this.isEditable());
        this.m_rbnSpecialColumnNamesSpecialCharacters.setEnabled(this.isEditable());
        this.m_txtStartRecord.setEditable(this.isEditable() && !this.m_ckbOverride.isSelected());
        this.m_txtNumberOfRecords.setEditable(this.isEditable() && !this.m_ckbOverride.isSelected());
        this.m_txtEncoding.setEditable(this.isEditable() && !this.m_ckbOverride.isSelected());
        this.m_actDisplay.setEnabled(!this.m_ckbOverride.isSelected());
        this.m_txtAppendOptions.setEditable(this.isEditable() && !this.m_ckbOverride.isSelected());
        this.m_ckbOverride.setEnabled(this.isEditable());
        this.m_txtOverride.setEditable(this.isEditable() && this.m_ckbOverride.isSelected());
        this.m_txtOverrideDelimiter.setEditable(this.isEditable() && this.m_mdlTable.isDelimited());
    }

    public char getDefaultMissingValuesNumericDelimiter() {
        return this.m_defaultMissingValueNumericDelimiter;
    }

    public void setDefaultMissingValuesNumericDelimiter(char delim) {
        this.m_defaultMissingValueNumericDelimiter = delim;
    }

    public char[] getMissingValuesNumericDelimiters() {
        return this.m_missingValuesNumericDelimArray;
    }

    public void setMissingValuesNumericDelimiters(char[] delimArray) {
        this.m_missingValuesNumericDelimArray = delimArray;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (type.equals("ExternalTable:CaseSensitiveColumnNamesChanged") || type.equals("ExternalTable:SpecialCharactersInColumnNamesChanged")) {
                if (AdvancedExternalFileParametersPanel2.this.m_mdlTable.isSpecialCharacters() && AdvancedExternalFileParametersPanel2.this.m_mdlTable.isCaseSensitive()) {
                    AdvancedExternalFileParametersPanel2.this.m_rbnSpecialColumnNamesSpecialCharacters.setSelected(true);
                } else if (AdvancedExternalFileParametersPanel2.this.m_mdlTable.isCaseSensitive()) {
                    AdvancedExternalFileParametersPanel2.this.m_rbnSpecialColumnNamesCaseSensitive.setSelected(true);
                } else {
                    AdvancedExternalFileParametersPanel2.this.m_rbnSpecialColumnNamesNone.setSelected(true);
                }
            } else if (type.equals("ExternalTable:StartingRecordChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_txtStartRecord.setText(AdvancedExternalFileParametersPanel2.this.m_mdlFile.getStartingRecordNumber());
            } else if (type.equals("ExternalTable:NumberOfRecordsChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_txtNumberOfRecords.setText(AdvancedExternalFileParametersPanel2.this.m_mdlFile.getNumberOfRecords());
            } else if (type.equals("ExternalTable:InfileOverrideChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_ckbOverride.setSelected(AdvancedExternalFileParametersPanel2.this.m_mdlFile.getInfileOverrideFlag());
            } else if (type.equals("BaseExternalTable:CreateViewChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_ckbCreateView.setSelected(AdvancedExternalFileParametersPanel2.this.m_mdlFile.isView());
            } else if (type.equals("ExternalTable:MissingSpecialValueChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_cmbSpecial.setSelectedItem((Object)AdvancedExternalFileParametersPanel2.this.m_mdlFile.getSpecialMissingValue());
            } else if (type.equals("ExternalTable:MissingNumericValueChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_txtNumeric.setText(AdvancedExternalFileParametersPanel2.this.m_mdlFile.getNumericMissingValue());
            } else if (type.equals("ExternalTable:AdditionalInfileOptionsChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_txtAppendOptions.setText(AdvancedExternalFileParametersPanel2.this.m_mdlFile.getAdditionalInfileOptions());
            } else if (type.equals("ExternalTable:InfileEncodingChanged")) {
                AdvancedExternalFileParametersPanel2.this.m_txtEncoding.setText(AdvancedExternalFileParametersPanel2.this.m_mdlFile.getInfileEncodingOptions());
            }
        }
    }

    private class cStateListener
    implements ItemListener {
        private cStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() == AdvancedExternalFileParametersPanel2.this.m_cmbSpecial) {
                AdvancedExternalFileParametersPanel2.this.m_mdlFile.setSpecialMissingValue((String)AdvancedExternalFileParametersPanel2.this.m_cmbSpecial.getSelectedItem());
            } else {
                boolean bEnabled;
                JToggleButton ckb = (JToggleButton)e.getItemSelectable();
                boolean bl = bEnabled = ckb.isSelected() && AdvancedExternalFileParametersPanel2.this.isEditable();
                if (ckb == AdvancedExternalFileParametersPanel2.this.m_rbnSpecialColumnNamesNone && bEnabled) {
                    AdvancedExternalFileParametersPanel2.this.m_mdlTable.getModel().startCompoundUndoable();
                    try {
                        AdvancedExternalFileParametersPanel2.this.m_mdlFile.setCaseSensitive(false);
                        AdvancedExternalFileParametersPanel2.this.m_mdlFile.setSpecialCharacters(false);
                    }
                    finally {
                        AdvancedExternalFileParametersPanel2.this.m_mdlTable.getModel().endCompoundUndoable();
                    }
                } else if (ckb == AdvancedExternalFileParametersPanel2.this.m_rbnSpecialColumnNamesCaseSensitive && bEnabled) {
                    AdvancedExternalFileParametersPanel2.this.m_mdlTable.getModel().startCompoundUndoable();
                    try {
                        AdvancedExternalFileParametersPanel2.this.m_mdlFile.setCaseSensitive(true);
                        AdvancedExternalFileParametersPanel2.this.m_mdlFile.setSpecialCharacters(false);
                    }
                    finally {
                        AdvancedExternalFileParametersPanel2.this.m_mdlTable.getModel().endCompoundUndoable();
                    }
                } else if (ckb == AdvancedExternalFileParametersPanel2.this.m_rbnSpecialColumnNamesSpecialCharacters && bEnabled) {
                    AdvancedExternalFileParametersPanel2.this.m_mdlTable.getModel().startCompoundUndoable();
                    try {
                        AdvancedExternalFileParametersPanel2.this.m_mdlFile.setCaseSensitive(true);
                        AdvancedExternalFileParametersPanel2.this.m_mdlFile.setSpecialCharacters(true);
                    }
                    finally {
                        AdvancedExternalFileParametersPanel2.this.m_mdlTable.getModel().endCompoundUndoable();
                    }
                } else if (ckb == AdvancedExternalFileParametersPanel2.this.m_ckbCreateView) {
                    AdvancedExternalFileParametersPanel2.this.m_mdlFile.setView(bEnabled);
                } else if (ckb == AdvancedExternalFileParametersPanel2.this.m_ckbOverride) {
                    AdvancedExternalFileParametersPanel2.this.m_mdlFile.setInfileOverrideFlag(bEnabled);
                    AdvancedExternalFileParametersPanel2.this.updateComponents();
                }
            }
        }
    }

    protected static class IntDelimDocument
    extends WsLimitedPlainDocument {
        private boolean m_bAllowNegative;
        private static final char NEGATIVE_SIGN = new DecimalFormatSymbols().getMinusSign();
        private char[] m_delimArray;

        public IntDelimDocument(char[] delimArray) {
            this.m_delimArray = delimArray;
        }

        public void setAllowNegatives(boolean allowNegative) {
            this.m_bAllowNegative = allowNegative;
        }

        public boolean getAllowNegatives() {
            return this.m_bAllowNegative;
        }

        public void insertString(int iText, String sText, AttributeSet a) throws BadLocationException {
            if (sText == null || sText.length() == 0) {
                return;
            }
            if (this.m_bAllowNegative && this.getText(0, this.getLength()).indexOf(NEGATIVE_SIGN) == -1 && sText.indexOf(NEGATIVE_SIGN) == 0 && iText == 0) {
                super.insertString(0, String.valueOf(NEGATIVE_SIGN), a);
                this.insertString(1, sText.substring(1), a);
                return;
            }
            if (this.getText(0, this.getLength()).indexOf(NEGATIVE_SIGN) >= 0 && iText == 0) {
                if (s_msgDisplayer != null) {
                    s_msgDisplayer.displayMessage(bundle.getString("Common.InsertBeforeNegativeSignErrorMessage.txt"));
                    this.m_bMessage = true;
                }
                return;
            }
            char[] caSource = sText.toCharArray();
            char[] caResult = new char[caSource.length];
            boolean bError = false;
            int iResult = 0;
            for (int iSource = 0; iSource < caSource.length; ++iSource) {
                if (Character.isDigit(caSource[iSource]) || this.isDelim(caSource[iSource])) {
                    caResult[iResult++] = caSource[iSource];
                    continue;
                }
                bError = true;
            }
            if (bError) {
                if (s_msgDisplayer != null) {
                    String sMessage = bundle.getString("Common.NumericCharactersOnlyErrorMessage.txt");
                    s_msgDisplayer.displayMessage(sMessage);
                    this.m_bMessage = true;
                }
            } else if (this.m_bMessage) {
                s_msgDisplayer.displayMessage("");
                this.m_bMessage = false;
            }
            super.insertString(iText, new String(caResult, 0, iResult), a);
        }

        private boolean isDelim(char ch) {
            boolean bDelim = false;
            for (int index = 0; index < this.m_delimArray.length; ++index) {
                char delim = this.m_delimArray[index];
                if (delim != ch) continue;
                bDelim = true;
                break;
            }
            return bDelim;
        }
    }

    private class cDisplayAction
    extends WsAbstractAction {
        public cDisplayAction() {
            super(bundle, "AdvancedExternalFileParametersPanel.Action.Display", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!AdvancedExternalFileParametersPanel2.this.validateData()) {
                return;
            }
            try {
                AdvancedExternalFileParametersPanel2.this.moveDataToStore();
                String sOptions = AdvancedExternalFileParametersPanel2.this.m_txtAppendOptions.getText();
                AdvancedExternalFileParametersPanel2.this.m_mdlFile.setAdditionalInfileOptions(sOptions);
                WsCodeFragmentPane codePane = new WsCodeFragmentPane(bundle.getString("AdvancedExternalFileParametersPanel.InfileStatement.Description.txt"), 7);
                codePane.setText(AdvancedExternalFileParametersPanel2.this.m_mdlTable.getInfileStatement());
                WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("AdvancedExternalFileParametersPanel.InfileStatement.Title.txt"), true);
                dialog.setMainPanel((WAPanel)codePane);
                dialog.setEditable(false);
                dialog.setOKButtonVisible(true);
                dialog.setCancelButtonVisible(false);
                dialog.setApplyButtonVisible(false);
                dialog.setHelpButtonVisible(false);
                dialog.setResizable(true);
                dialog.show();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                ex.printStackTrace();
            }
        }
    }

    private class cTextArea
    extends WATextArea {
        public cTextArea(int nRows, int nColumns) {
            super(nRows, nColumns);
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
            if (this.getBackground() instanceof UIResource) {
                Color clrBackground = bEditable ? UIManager.getColor("TextField.background") : UIManager.getColor("TextField.inactiveBackground");
                this.setBackground(clrBackground);
            }
        }
    }

    private class cFocusMover
    implements ActionListener {
        private cFocusMover() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AdvancedExternalFileParametersPanel2.this.m_ckbOverride.isSelected()) {
                AdvancedExternalFileParametersPanel2.this.m_txtOverride.requestFocus();
            }
        }
    }
}

